/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run.multiplatform;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.MultipleRunLocationsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.run.multiplatform.KotlinMultiplatformRunLocationsProviderKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/run/multiplatform/KotlinMultiplatformRunLocationsProvider;", "Lcom/intellij/execution/actions/MultipleRunLocationsProvider;", "()V", "getAlternativeLocations", "", "Lcom/intellij/execution/Location;", "originalLocation", "getLocationDisplayName", "", "locationCreatedFrom", "kotlin.base.code-insight"})
public final class KotlinMultiplatformRunLocationsProvider
extends MultipleRunLocationsProvider {
    @Nullable
    public String getLocationDisplayName(@NotNull Location<?> locationCreatedFrom, @NotNull Location<?> originalLocation) {
        Module module2 = locationCreatedFrom.getModule();
        if (module2 == null) {
            return null;
        }
        Module module3 = module2;
        String name2 = KotlinMultiplatformRunLocationsProviderKt.access$compactedGradleProjectId(module3);
        return "[" + name2 + "]";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Location<?>> getAlternativeLocations(@NotNull Location<?> originalLocation) {
        void $this$mapTo$iv$iv;
        Module module2 = originalLocation.getModule();
        if (module2 == null) {
            return CollectionsKt.emptyList();
        }
        Module originalModule = module2;
        if (KotlinFacetUtils.isNewMultiPlatformModule(originalModule)) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = originalLocation.getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        ModuleFileIndex fileIndex2 = ModuleRootManager.getInstance((Module)originalModule).getFileIndex();
        KotlinSourceRootType kotlinSourceRootType = KotlinProjectStructureUtils.getKotlinSourceRootType((FileIndex)fileIndex2, virtualFile2);
        if (kotlinSourceRootType == null) {
            return CollectionsKt.emptyList();
        }
        KotlinSourceRootType sourceType = kotlinSourceRootType;
        Iterable $this$map$iv = KotlinMultiplatformRunLocationsProviderKt.access$modulesToRunFrom(originalModule, sourceType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module module3 = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PsiLocation(originalLocation.getProject(), (Module)it, originalLocation.getPsiElement()));
        }
        return (List)destination$iv$iv;
    }
}

