/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetector;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.run.KotlinFE10MainFunctionDetector;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinFE10MainFunctionDetector;", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector;", "()V", "hasAnnotationWithExactNumberOfArguments", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "number", "", "isMain", "configuration", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector$Configuration;", "isParameterNumberSuitsForMain", "parametersCount", "isTopLevel", "kotlin.jvm"})
public final class KotlinFE10MainFunctionDetector
implements KotlinMainFunctionDetector {
    @Override
    public boolean isMain(@NotNull KtNamedFunction function2, @NotNull KotlinMainFunctionDetector.Configuration configuration2) {
        if (function2.isLocal()) {
            return false;
        }
        int parametersCount = function2.getValueParameters().size();
        if (function2.getReceiverTypeReference() != null) {
            ++parametersCount;
        }
        if (!this.isParameterNumberSuitsForMain(parametersCount, function2.isTopLevel())) {
            return false;
        }
        if (!function2.getTypeParameters().isEmpty()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)"main", (Object)function2.getName()) && !this.hasAnnotationWithExactNumberOfArguments(function2, 1)) {
            return false;
        }
        if (configuration2.getCheckJvmStaticAnnotation() && !function2.isTopLevel() && !this.hasAnnotationWithExactNumberOfArguments(function2, 0)) {
            return false;
        }
        LanguageVersionSettings languageVersionSettings2 = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)function2);
        MainFunctionDetector mainFunctionDetector2 = new MainFunctionDetector(languageVersionSettings2, (Function1)isMain.mainFunctionDetector.1.INSTANCE);
        return MainFunctionDetector.isMain$default((MainFunctionDetector)mainFunctionDetector2, (KtNamedFunction)function2, (boolean)configuration2.getCheckJvmStaticAnnotation(), (boolean)false, (int)4, null);
    }

    private final boolean isParameterNumberSuitsForMain(int parametersCount, boolean isTopLevel2) {
        return switch (parametersCount) {
            case 1 -> true;
            case 0 -> isTopLevel2;
            default -> false;
        };
    }

    private final boolean hasAnnotationWithExactNumberOfArguments(KtNamedFunction function2, int number2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = function2.getAnnotationEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    if (!(it.getValueArguments().size() == number2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

