/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.KotlinResourceRootTypeKt;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.idea.util.SafeAnalysisUtils;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a\"\u0010\u0013\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015\u001a\u0010\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\b*\u00020\u0003\u00a8\u0006\u0018"}, d2={"collectSuitableDestinationSourceRoots", "", "module", "Lcom/intellij/openapi/module/Module;", "result", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getKotlinAwareDestinationSourceRoots", "", "project", "Lcom/intellij/openapi/project/Project;", "getSuitableDestinationSourceRoots", "isForGeneratedSources", "", "sourceFolder", "Lcom/intellij/openapi/roots/SourceFolder;", "isOutsideKotlinAwareSourceRoot", "psiFile", "Lcom/intellij/psi/PsiFile;", "isOutsideSourceRootSet", "sourceRootTypes", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "collectKotlinAwareDestinationSourceRoots", "kotlin.idea"})
public final class ProjectRootUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VirtualFile> getKotlinAwareDestinationSourceRoots(@NotNull Project project) {
        void $this$flatMapTo$iv$iv;
        Module[] $this$flatMap$iv = ModuleManager.Companion.getInstance(project).getModules();
        boolean $i$f$flatMap = false;
        Module[] moduleArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[j];
            boolean bl = false;
            Iterable list$iv$iv = ProjectRootUtilsKt.collectKotlinAwareDestinationSourceRoots((Module)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<VirtualFile> collectKotlinAwareDestinationSourceRoots(@NotNull Module $this$collectKotlinAwareDestinationSourceRoots) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])ProjectUtil.getRootManager((Module)$this$collectKotlinAwareDestinationSourceRoots).getContentEntries()), (Function1)collectKotlinAwareDestinationSourceRoots.1.INSTANCE), (Function1)collectKotlinAwareDestinationSourceRoots.2.INSTANCE), (Function1)collectKotlinAwareDestinationSourceRoots.3.INSTANCE));
    }

    public static final boolean isOutsideSourceRootSet(@Nullable PsiFile psiFile2, @NotNull Set<? extends JpsModuleSourceRootType<?>> sourceRootTypes) {
        if (psiFile2 == null || psiFile2 instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file2 = virtualFile;
        if (file2.getFileSystem() instanceof NonPhysicalFileSystem) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiFile2.getProject()).getFileIndex();
        return !projectFileIndex.isUnderSourceRootOfType(file2, sourceRootTypes) && !projectFileIndex.isInLibrary(file2);
    }

    public static final boolean isOutsideKotlinAwareSourceRoot(@Nullable PsiFile psiFile2) {
        return ProjectRootUtilsKt.isOutsideSourceRootSet(psiFile2, SafeAnalysisUtils.getKOTLIN_AWARE_SOURCE_ROOT_TYPES());
    }

    @NotNull
    public static final List<VirtualFile> getSuitableDestinationSourceRoots(@NotNull Project project) {
        ArrayList roots2 = new ArrayList();
        for (Module module2 : ModuleManager.Companion.getInstance(project).getModules()) {
            ProjectRootUtilsKt.collectSuitableDestinationSourceRoots(module2, roots2);
        }
        return roots2;
    }

    @NotNull
    public static final List<VirtualFile> getSuitableDestinationSourceRoots(@NotNull Module module2) {
        ArrayList roots2 = new ArrayList();
        ProjectRootUtilsKt.collectSuitableDestinationSourceRoots(module2, roots2);
        return roots2;
    }

    public static final void collectSuitableDestinationSourceRoots(@NotNull Module module2, @NotNull List<VirtualFile> result2) {
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module2).getContentEntries()) {
            for (SourceFolder sourceFolder : entry.getSourceFolders(SafeAnalysisUtils.getKOTLIN_AWARE_SOURCE_ROOT_TYPES())) {
                if (ProjectRootUtilsKt.isForGeneratedSources(sourceFolder)) continue;
                ContainerUtil.addIfNotNull((Collection)result2, (Object)sourceFolder.getFile());
            }
        }
    }

    public static final boolean isForGeneratedSources(@NotNull SourceFolder sourceFolder) {
        JavaSourceRootProperties properties2 = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(SafeAnalysisUtils.getKOTLIN_AWARE_SOURCE_ROOT_TYPES());
        JavaResourceRootProperties javaResourceProperties = (JavaResourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.RESOURCES);
        JavaResourceRootProperties kotlinResourceProperties = (JavaResourceRootProperties)sourceFolder.getJpsElement().getProperties(KotlinResourceRootTypeKt.getALL_KOTLIN_RESOURCE_ROOT_TYPES());
        return properties2 != null && properties2.isForGeneratedSources() || javaResourceProperties != null && javaResourceProperties.isForGeneratedSources() || kotlinResourceProperties != null && kotlinResourceProperties.isForGeneratedSources();
    }
}

