/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;

public abstract class KotlinDestinationFolderComboBox
extends DestinationFolderComboBox {
    protected boolean sourceRootsInTargetDirOnly() {
        return false;
    }

    @NotNull
    protected List<VirtualFile> getSourceRoots(Project project, PsiDirectory initialTargetDirectory) {
        Module module2;
        if (this.sourceRootsInTargetDirOnly() && (module2 = ModuleUtilCore.findModuleForFile((VirtualFile)initialTargetDirectory.getVirtualFile(), (Project)project)) != null) {
            List<VirtualFile> moduleSourceRoots = ProjectRootUtilsKt.collectKotlinAwareDestinationSourceRoots(module2);
            return ContainerUtil.filter(moduleSourceRoots, root -> KotlinDestinationFolderComboBox.targetDirIsInRoot(initialTargetDirectory, root));
        }
        return ProjectRootUtilsKt.getKotlinAwareDestinationSourceRoots(project);
    }

    private static boolean targetDirIsInRoot(PsiDirectory targetDir, VirtualFile root) {
        return targetDir.getVirtualFile().getPath().startsWith(root.getPath());
    }
}

