/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinResolveSnapshotProvider;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinResolveSnapshotProvider;", "Lcom/intellij/refactoring/rename/ResolveSnapshotProvider;", "()V", "createSnapshot", "Lcom/intellij/refactoring/rename/ResolveSnapshotProvider$ResolveSnapshot;", "scope", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
public final class KotlinResolveSnapshotProvider
extends ResolveSnapshotProvider {
    @NotNull
    public ResolveSnapshotProvider.ResolveSnapshot createSnapshot(@NotNull PsiElement scope2) {
        return new ResolveSnapshotProvider.ResolveSnapshot(scope2){
            @NotNull
            private final Project project;
            @NotNull
            private final Document document;
            @NotNull
            private final HashMap<SmartPsiElementPointer<?>, PropertyDescriptor> refExpressionToDescriptor;
            {
                this.project = $scope.getProject();
                Document document = PsiDocumentManager.getInstance((Project)this.project).getDocument($scope.getContainingFile());
                Intrinsics.checkNotNull((Object)document);
                this.document = document;
                this.refExpressionToDescriptor = new HashMap();
                $scope.accept((PsiElementVisitor)new KtTreeVisitorVoid(this){
                    final /* synthetic */ createSnapshot.1 this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                        if (KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)expression2)) != null) {
                            super.visitSimpleNameExpression(expression2);
                            return;
                        }
                        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)expression2));
                        if (declarationDescriptor == null) {
                            return;
                        }
                        DeclarationDescriptor targetDescriptor = declarationDescriptor;
                        if (!(targetDescriptor instanceof PropertyDescriptor)) {
                            return;
                        }
                        ((Map)createSnapshot.1.access$getRefExpressionToDescriptor$p(this.this$0)).put(PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)expression2)), targetDescriptor);
                    }
                });
            }

            public void apply(@NotNull String name2) {
                PsiDocumentManager.getInstance((Project)this.project).commitDocument(this.document);
                ArrayList<E> elementsToShorten = new ArrayList<E>();
                for (Map.Entry<K, V> entry : ((Map)this.refExpressionToDescriptor).entrySet()) {
                    PsiElement psiElement2;
                    Object object;
                    PsiElement refExpr;
                    SmartPsiElementPointer refExprPointer = (SmartPsiElementPointer)entry.getKey();
                    PropertyDescriptor targetDescriptor = (PropertyDescriptor)entry.getValue();
                    if (refExprPointer.getElement() == null || !Intrinsics.areEqual((Object)refExpr.getText(), (Object)name2)) continue;
                    DeclarationDescriptor containingDescriptor = targetDescriptor.getContainingDeclaration();
                    if (containingDescriptor instanceof ClassDescriptor) {
                        object = KotlinRefactoringUtilKt.explicateAsTextForReceiver(containingDescriptor) + "." + targetDescriptor.getName().asString();
                    } else {
                        object = ImportsUtils.getImportableFqName((DeclarationDescriptor)targetDescriptor);
                        if (object == null || (object = object.asString()) == null) continue;
                    }
                    Object qualifiedRefText = object;
                    KtExpression qualifiedRefExpr = new KtPsiFactory(this.project, false, 2, null).createExpression((String)qualifiedRefText);
                    Collection collection = elementsToShorten;
                    PsiElement $this$replaced$iv = refExpr;
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)qualifiedRefExpr))) {
                        psiElement2 = (PsiElement)qualifiedRefExpr;
                    } else {
                        PsiElement result$iv = $this$replaced$iv.replace((PsiElement)qualifiedRefExpr);
                        if (result$iv instanceof KtExpression) {
                            psiElement2 = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement2 = (PsiElement)ktExpression;
                        }
                    }
                    PsiElement psiElement3 = psiElement2;
                    collection.add(psiElement3);
                }
                ShortenReferences.process$default(new ShortenReferences((Function1<? super KtElement, ShortenReferences.Options>)((Function1)createSnapshot.apply.1.INSTANCE)), elementsToShorten, null, false, 6, null);
            }

            public static final /* synthetic */ HashMap access$getRefExpressionToDescriptor$p(createSnapshot.1 $this) {
                return $this.refExpressionToDescriptor;
            }
        };
    }
}

