/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.AutomaticVariableRenamerKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0012\u0010\u0011\u001a\f0\u0005\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\u0012\u0010\u0014\u001a\f0\u0005\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\u0012\u0010\u0015\u001a\f0\u0005\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fH\u0002R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticVariableRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "klass", "Lcom/intellij/psi/PsiNamedElement;", "newClassName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "(Lcom/intellij/psi/PsiNamedElement;Ljava/lang/String;Ljava/util/Collection;)V", "toUnpluralize", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lkotlin/collections/ArrayList;", "canonicalNameToName", "canonicalName", "element", "entityName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getDialogDescription", "getDialogTitle", "nameToCanonicalName", "name", "variableKind", "Lcom/intellij/psi/codeStyle/VariableKind;", "codeStyleManager", "Lcom/intellij/psi/codeStyle/JavaCodeStyleManager;", "ktElement", "Companion", "kotlin.idea"})
public final class AutomaticVariableRenamer
extends AutomaticRenamer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<KtNamedDeclaration> toUnpluralize = new ArrayList();
    @NotNull
    private static final Logger LOG = Logger.getInstance(AutomaticVariableRenamer.class);

    public AutomaticVariableRenamer(@NotNull PsiNamedElement klass2, @NotNull String newClassName, @NotNull Collection<? extends UsageInfo> usages2) {
        String string2 = klass2.getName();
        Intrinsics.checkNotNull((Object)string2);
        String oldClassName = KotlinPsiModificationUtils.unquoteKotlinIdentifier(string2);
        String newClassNameUnquoted = KotlinPsiModificationUtils.unquoteKotlinIdentifier(newClassName);
        for (UsageInfo usageInfo : usages2) {
            DeclarationDescriptor descriptor2;
            String variableName;
            KtCallableDeclaration parameterOrVariable;
            PsiElement usageElement;
            if (usageInfo.getElement() == null) continue;
            Class[] classArray = new Class[]{KtVariableDeclaration.class, KtParameter.class};
            if ((KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)usageElement, (Class[])classArray) == null || parameterOrVariable.getName() == null || StringsKt.equals((String)variableName, (String)newClassNameUnquoted, (boolean)true) || !StringUtil.containsIgnoreCase((String)variableName, (String)oldClassName) || ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)parameterOrVariable, null, 1, null) == null) continue;
            KotlinType type2 = ((VariableDescriptor)descriptor2).getType();
            if (AutomaticVariableRenamerKt.access$isCollectionLikeOf(type2, klass2)) {
                this.toUnpluralize.add((KtNamedDeclaration)parameterOrVariable);
            }
            this.myElements.add(parameterOrVariable);
        }
        this.suggestAllNames(oldClassName, newClassNameUnquoted);
    }

    @NotNull
    public String getDialogTitle() {
        return JavaRefactoringBundle.message((String)"rename.variables.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getDialogDescription() {
        return JavaRefactoringBundle.message((String)"title.rename.variables.with.the.following.names.to", (Object[])new Object[0]);
    }

    @NotNull
    public String entityName() {
        return JavaRefactoringBundle.message((String)"entity.name.variable", (Object[])new Object[0]);
    }

    @NotNull
    protected String nameToCanonicalName(@NotNull String name2, @NotNull PsiNamedElement element3) {
        String propertyName;
        if (!(element3 instanceof KtNamedDeclaration)) {
            return name2;
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)((KtNamedDeclaration)element3).getProject());
        VariableKind kind2 = this.variableKind(codeStyleManager, (KtNamedDeclaration)element3);
        String string2 = propertyName = kind2 != null ? codeStyleManager.variableNameToPropertyName(name2, kind2) : name2;
        if (this.toUnpluralize.contains(element3)) {
            String singular = StringUtil.unpluralize((String)propertyName);
            if (singular != null) {
                return singular;
            }
            this.toUnpluralize.remove(element3);
        }
        return propertyName;
    }

    @NotNull
    protected String canonicalNameToName(@NotNull String canonicalName, @NotNull PsiNamedElement element3) {
        if (!(element3 instanceof KtNamedDeclaration)) {
            return canonicalName;
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)((KtNamedDeclaration)element3).getProject());
        VariableKind kind2 = this.variableKind(codeStyleManager, (KtNamedDeclaration)element3);
        String varName = kind2 != null ? codeStyleManager.propertyNameToVariableName(canonicalName, kind2) : canonicalName;
        return this.toUnpluralize.contains(element3) ? StringUtil.pluralize((String)varName) : varName;
    }

    private final VariableKind variableKind(JavaCodeStyleManager codeStyleManager, KtNamedDeclaration ktElement) {
        PsiVariable psiVariable;
        Object v0;
        block3: {
            if (ktElement instanceof KtProperty && ((KtProperty)ktElement).isTopLevel() && !ktElement.hasModifier(KtTokens.CONST_KEYWORD)) {
                return null;
            }
            if (KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)ktElement)) instanceof KtObjectDeclaration) {
                return null;
            }
            Iterable $this$firstIsInstanceOrNull$iv = LightClassUtilsKt.toLightElements((KtElement)((KtElement)ktElement));
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof PsiVariable)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PsiVariable psiVariable2 = psiVariable = (PsiVariable)v0;
        return psiVariable2 != null ? codeStyleManager.getVariableKind(psiVariable2) : null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticVariableRenamer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

