/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\f0\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J\u0012\u0010\n\u001a\f0\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J\u0012\u0010\u000b\u001a\f0\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticInheritorRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "newName", "", "(Lorg/jetbrains/kotlin/psi/KtClass;Ljava/lang/String;)V", "entityName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getDialogDescription", "getDialogTitle", "kotlin.idea"})
public final class AutomaticInheritorRenamer
extends AutomaticRenamer {
    public AutomaticInheritorRenamer(@NotNull KtClass klass2, @NotNull String newName2) {
        KtLightClass lightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)klass2));
        if (lightClass != null) {
            for (PsiClass inheritorLightClass : ClassInheritorsSearch.search((PsiClass)((PsiClass)lightClass), (boolean)true).findAll()) {
                PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)inheritorLightClass));
                PsiNamedElement psiNamedElement = psiElement2 instanceof PsiNamedElement ? (PsiNamedElement)psiElement2 : null;
                if ((psiNamedElement != null ? psiNamedElement.getName() : null) == null) continue;
                PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)inheritorLightClass));
                Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type com.intellij.psi.PsiNamedElement");
                this.myElements.add((PsiNamedElement)psiElement3);
            }
        }
        this.suggestAllNames(klass2.getName(), newName2);
    }

    @NotNull
    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.inheritors.title");
    }

    @NotNull
    public String getDialogDescription() {
        return JavaRefactoringBundle.message((String)"rename.inheritors.with.the.following.names.to.title", (Object[])new Object[0]);
    }

    @NotNull
    public String entityName() {
        return JavaRefactoringBundle.message((String)"entity.name.inheritor", (Object[])new Object[0]);
    }
}

