/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTarget;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/KotlinMoveTargetForCompanion;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/KotlinMoveTarget;", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "getTargetClass", "()Lorg/jetbrains/kotlin/psi/KtClass;", "targetContainerFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getTargetContainerFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "targetFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTargetFileOrDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getOrCreateTargetPsi", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "originalPsi", "Lcom/intellij/psi/PsiElement;", "getTargetPsiIfExists", "verify", "", "file", "Lcom/intellij/psi/PsiFile;", "kotlin.idea"})
public final class KotlinMoveTargetForCompanion
implements KotlinMoveTarget {
    @NotNull
    private final KtClass targetClass;
    @NotNull
    private final FqName targetContainerFqName;
    @NotNull
    private final VirtualFile targetFileOrDir;

    public KotlinMoveTargetForCompanion(@NotNull KtClass targetClass) {
        this.targetClass = targetClass;
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)CollectionsKt.firstOrNull((List)this.targetClass.getCompanionObjects());
        if (ktObjectDeclaration == null || (ktObjectDeclaration = ktObjectDeclaration.getFqName()) == null) {
            FqName fqName2 = this.targetClass.getFqName();
            Intrinsics.checkNotNull((Object)fqName2);
            ktObjectDeclaration = fqName2.child(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
        }
        this.targetContainerFqName = ktObjectDeclaration;
        this.targetFileOrDir = this.targetClass.getContainingKtFile().getVirtualFile();
    }

    @NotNull
    public final KtClass getTargetClass() {
        return this.targetClass;
    }

    @Override
    @NotNull
    public FqName getTargetContainerFqName() {
        return this.targetContainerFqName;
    }

    @Override
    @NotNull
    public VirtualFile getTargetFileOrDir() {
        return this.targetFileOrDir;
    }

    @NotNull
    public KtObjectDeclaration getOrCreateTargetPsi(@NotNull PsiElement originalPsi) {
        return PsiModificationUtilsKt.getOrCreateCompanionObject(this.targetClass);
    }

    @Nullable
    public KtObjectDeclaration getTargetPsiIfExists(@NotNull PsiElement originalPsi) {
        return (KtObjectDeclaration)CollectionsKt.firstOrNull((List)this.targetClass.getCompanionObjects());
    }

    @Override
    @Nullable
    public String verify(@NotNull PsiFile file2) {
        return null;
    }
}

