/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.changePackage;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonMoveClassesOrPackagesUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.changePackage.KotlinChangePackageRefactoring;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/PackageDirectoryMismatchInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ChangePackageFix", "MoveFileToPackageFix", "kotlin.idea"})
public final class PackageDirectoryMismatchInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return VisitorWrappersKt.packageDirectiveVisitor((Function1)((Function1)new Function1<KtPackageDirective, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtPackageDirective directive) {
                TextRange textRange;
                FqName fqNameWithImplicitPrefix;
                KtFile file2 = directive.getContainingKtFile();
                if (file2.getTextLength() == 0 || KotlinRefactoringUtilKt.isInjectedFragment((PsiFile)file2) || PackageUtilsKt.packageMatchesDirectoryOrImplicit(file2)) {
                    return;
                }
                List fixes = new ArrayList<E>();
                String qualifiedName2 = directive.getQualifiedName();
                String dirName = ((CharSequence)qualifiedName2).length() == 0 ? KotlinBundle.message("fix.move.file.to.package.dir.name.text", new Object[0]) : "'" + StringsKt.replace$default((String)qualifiedName2, (char)'.', (char)'/', (boolean)false, (int)4, null) + "'";
                ((Collection)fixes).add(new MoveFileToPackageFix(dirName));
                FqName fqNameByDirectory = PackageUtilsKt.getFqNameByDirectory((PsiFile)file2);
                if (fqNameByDirectory.isRoot()) {
                    ((Collection)fixes).add(new ChangePackageFix(KotlinBundle.message("fix.move.file.to.package.dir.name.text", new Object[0]), fqNameByDirectory));
                } else if (KotlinRefactoringUtilKt.hasIdentifiersOnly(fqNameByDirectory)) {
                    ((Collection)fixes).add(new ChangePackageFix("'" + fqNameByDirectory.asString() + "'", fqNameByDirectory));
                }
                PsiDirectory psiDirectory = file2.getParent();
                Object object = fqNameWithImplicitPrefix = psiDirectory != null ? PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory) : null;
                if (fqNameWithImplicitPrefix != null && !Intrinsics.areEqual((Object)fqNameWithImplicitPrefix, (Object)fqNameByDirectory)) {
                    ((Collection)fixes).add(new ChangePackageFix("'" + fqNameWithImplicitPrefix.asString() + "'", fqNameWithImplicitPrefix));
                }
                if (directive.getTextLength() != 0) {
                    textRange = directive.getTextRange();
                } else {
                    KtDeclaration ktDeclaration = (KtDeclaration)CollectionsKt.firstOrNull((List)file2.getDeclarations());
                    if (ktDeclaration != null) {
                        KtDeclaration it = ktDeclaration;
                        boolean bl = false;
                        textRange = TextRange.from((int)PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)), (int)1);
                    } else {
                        textRange = null;
                    }
                }
                TextRange textRange2 = textRange;
                Collection $this$toTypedArray$iv = fixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                this.$holder.registerProblem((PsiElement)file2, textRange2, KotlinBundle.message("text.package.directive.dont.match.file.location", new Object[0]), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        }));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/PackageDirectoryMismatchInspection$MoveFileToPackageFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "dirName", "", "(Ljava/lang/String;)V", "getDirName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "startInWriteAction", "", "kotlin.idea"})
    private static final class MoveFileToPackageFix
    implements LocalQuickFix {
        @NotNull
        private final String dirName;

        public MoveFileToPackageFix(@NotNull String dirName) {
            this.dirName = dirName;
        }

        @NotNull
        public final String getDirName() {
            return this.dirName;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("fix.move.file.to.package.family", new Object[0]);
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.dirName};
            return KotlinBundle.message("fix.move.file.to.package.text", objectArray);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtFile ktFile = psiElement2 instanceof KtFile ? (KtFile)psiElement2 : null;
            if (ktFile == null) {
                return;
            }
            KtFile file2 = ktFile;
            KtPackageDirective ktPackageDirective = file2.getPackageDirective();
            if (ktPackageDirective == null) {
                return;
            }
            KtPackageDirective directive = ktPackageDirective;
            Object object = GenericPsiUtils.getModule((PsiElement)file2);
            if (object == null || (object = PackageUtilsKt.findExistingNonGeneratedKotlinSourceRootFiles(object)) == null) {
                object = ProjectRootUtilsKt.getSuitableDestinationSourceRoots(project);
            }
            Object sourceRoots = object;
            PackageWrapper packageWrapper = new PackageWrapper(PsiManager.getInstance((Project)project), directive.getQualifiedName());
            PsiFile fileToMove = directive.getContainingFile();
            VirtualFile virtualFile = (VirtualFile)CollectionsKt.singleOrNull((List)sourceRoots);
            if (virtualFile == null && (virtualFile = CommonMoveClassesOrPackagesUtil.chooseSourceRoot((PackageWrapper)packageWrapper, (List)sourceRoots, (PsiDirectory)fileToMove.getContainingDirectory())) == null) {
                return;
            }
            VirtualFile chosenRoot = virtualFile;
            AutocreatingSingleSourceRootMoveDestination targetDirFactory = new AutocreatingSingleSourceRootMoveDestination(packageWrapper, chosenRoot);
            String string2 = targetDirFactory.verify(fileToMove);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                Messages.showMessageDialog((Project)project, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            boolean $i$f$runWriteAction = false;
            PsiDirectory psiDirectory = (PsiDirectory)ApplicationManager.getApplication().runWriteAction(new Computable(targetDirFactory, fileToMove){
                final /* synthetic */ AutocreatingSingleSourceRootMoveDestination $targetDirFactory$inlined;
                final /* synthetic */ PsiFile $fileToMove$inlined;
                {
                    this.$targetDirFactory$inlined = autocreatingSingleSourceRootMoveDestination;
                    this.$fileToMove$inlined = psiFile2;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.$targetDirFactory$inlined.getTargetDirectory(this.$fileToMove$inlined);
                }
            });
            if (psiDirectory == null) {
                return;
            }
            PsiDirectory targetDirectory = psiDirectory;
            String string3 = RefactoringMessageUtil.checkCanCreateFile((PsiDirectory)targetDirectory, (String)file2.getName());
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                Messages.showMessageDialog((Project)project, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            boolean $i$f$runWriteAction2 = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(file2, targetDirectory){
                final /* synthetic */ KtFile $file$inlined;
                final /* synthetic */ PsiDirectory $targetDirectory$inlined;
                {
                    this.$file$inlined = ktFile;
                    this.$targetDirectory$inlined = psiDirectory;
                }

                public final T compute() {
                    boolean bl = false;
                    MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)((PsiFile)this.$file$inlined), (PsiDirectory)this.$targetDirectory$inlined);
                    return (T)Unit.INSTANCE;
                }
            });
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/PackageDirectoryMismatchInspection$ChangePackageFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "packageName", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getPackageName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "getFamilyName", "getName", "kotlin.idea"})
    private static final class ChangePackageFix
    implements LocalQuickFix {
        @NotNull
        private final String packageName;
        @NotNull
        private final FqName packageFqName;

        public ChangePackageFix(@NotNull String packageName2, @NotNull FqName packageFqName) {
            this.packageName = packageName2;
            this.packageFqName = packageFqName;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("fix.change.package.family", new Object[0]);
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.packageName};
            return KotlinBundle.message("fix.change.package.text", objectArray);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtFile ktFile = psiElement2 instanceof KtFile ? (KtFile)psiElement2 : null;
            if (ktFile == null) {
                return;
            }
            KtFile file2 = ktFile;
            new KotlinChangePackageRefactoring(file2).run(this.packageFqName);
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            PsiElement psiElement2 = previewDescriptor.getPsiElement();
            KtFile ktFile = psiElement2 instanceof KtFile ? (KtFile)psiElement2 : null;
            if (ktFile == null) {
                return IntentionPreviewInfo.EMPTY;
            }
            KtFile file2 = ktFile;
            KtPackageDirective ktPackageDirective = file2.getPackageDirective();
            if (ktPackageDirective == null) {
                return IntentionPreviewInfo.EMPTY;
            }
            KtPackageDirective packageDirective = ktPackageDirective;
            packageDirective.setFqName(this.packageFqName);
            return IntentionPreviewInfo.DIFF;
        }
    }
}

