/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractClass;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.SeparateFileWrapper;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ExtractSuperRefactoring;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.KotlinExtractSuperclassHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ui.KotlinExtractSuperDialogBase;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\u0016J+\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J0\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u001f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\u00042\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u001fH\u0016\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractSuperHandlerBase;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "Lcom/intellij/refactoring/lang/ElementsHandler;", "isExtractInterface", "", "(Z)V", "checkClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "editor", "Lcom/intellij/openapi/editor/Editor;", "checkConflicts", "originalClass", "dialog", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperDialogBase;", "createDialog", "targetParent", "Lcom/intellij/psi/PsiElement;", "doInvoke", "", "getErrorMessage", "", "getErrorMessage$kotlin_idea", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isEnabledOnElements", "([Lcom/intellij/psi/PsiElement;)Z", "selectElements", "kotlin.idea"})
public abstract class KotlinExtractSuperHandlerBase
implements RefactoringActionHandler,
ElementsHandler {
    private final boolean isExtractInterface;

    public KotlinExtractSuperHandlerBase(boolean isExtractInterface) {
        this.isExtractInterface = isExtractInterface;
    }

    public boolean isEnabledOnElements(@NotNull PsiElement[] elements2) {
        return ArraysKt.singleOrNull((Object[])elements2) instanceof KtClassOrObject;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2, @Nullable DataContext dataContext) {
        PsiElement element3;
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElement psiElement2 = file2.findElementAt(offset2);
        if (psiElement2 == null) {
            return;
        }
        PsiElement $this$getNonStrictParentOfType$iv = element3 = psiElement2;
        boolean $i$f$getNonStrictParentOfType = false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject klass2 = ktClassOrObject;
        if (!this.checkClass(klass2, editor2)) {
            return;
        }
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.selectElements(klass2, editor2);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        PsiElement psiElement2;
        Editor editor2;
        block6: {
            block5: {
                if (dataContext == null) {
                    return;
                }
                editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                psiElement2 = PsiTreeUtil.findCommonParent((PsiElement[])Arrays.copyOf(elements2, elements2.length));
                if (psiElement2 == null) break block5;
                PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
                boolean $i$f$getNonStrictParentOfType = false;
                psiElement2 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
                if (psiElement2 != null) break block6;
            }
            return;
        }
        PsiElement klass2 = psiElement2;
        if (!this.checkClass((KtClassOrObject)klass2, editor2)) {
            return;
        }
        this.selectElements((KtClassOrObject)klass2, editor2);
    }

    private final boolean checkClass(KtClassOrObject klass2, Editor editor2) {
        Project project = klass2.getProject();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)((PsiElement)klass2))) {
            return false;
        }
        String string2 = this.getErrorMessage$kotlin_idea(klass2);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)RefactoringBundle.getCannotRefactorMessage((String)it), (String)KotlinExtractSuperclassHandler.INSTANCE.getREFACTORING_NAME(), (String)"refactoring.extractSuperclass");
            return false;
        }
        return true;
    }

    private final void doInvoke(KtClassOrObject klass2, PsiElement targetParent) {
        KotlinRefactoringUtilKt.showWithTransaction((DialogWrapper)this.createDialog(klass2, targetParent));
    }

    private final void selectElements(KtClassOrObject klass2, Editor editor2) {
        List containers = CollectionsKt.plus((Collection)KotlinRefactoringUtilKt.getExtractionContainers((PsiElement)klass2, true, true), (Object)((Object)new SeparateFileWrapper((PsiManager)klass2.getManager())));
        if (editor2 == null) {
            this.doInvoke(klass2, (PsiElement)CollectionsKt.first((List)containers));
            return;
        }
        KotlinRefactoringUtilKt.chooseContainerElementIfNecessary(containers, editor2, CollectionsKt.first((List)containers) instanceof KtFile ? KotlinBundle.message("text.select.target.file", new Object[0]) : KotlinBundle.message("text.select.target.code.block.file", new Object[0]), true, (Function1)new Function1<NavigatablePsiElement, Unit>(this, klass2){
            final /* synthetic */ KotlinExtractSuperHandlerBase this$0;
            final /* synthetic */ KtClassOrObject $klass;
            {
                this.this$0 = $receiver;
                this.$klass = $klass;
                super(1);
            }

            public final void invoke(@NotNull NavigatablePsiElement it) {
                NavigatablePsiElement navigatablePsiElement;
                if (it instanceof SeparateFileWrapper) {
                    PsiDirectory psiDirectory = this.$klass.getContainingFile().getParent();
                    Intrinsics.checkNotNull((Object)psiDirectory);
                    navigatablePsiElement = (NavigatablePsiElement)psiDirectory;
                } else {
                    navigatablePsiElement = it;
                }
                KotlinExtractSuperHandlerBase.access$doInvoke(this.this$0, this.$klass, (PsiElement)navigatablePsiElement);
            }
        });
    }

    protected final boolean checkConflicts(@NotNull KtClassOrObject originalClass, @NotNull KotlinExtractSuperDialogBase dialog2) {
        MultiMap<PsiElement, String> conflicts2 = ExtractSuperRefactoring.Companion.collectConflicts(originalClass, dialog2.getSelectedMembers(), dialog2.getSelectedTargetParent(), dialog2.getExtractedSuperName(), this.isExtractInterface);
        return ExtractSuperClassUtil.showConflicts((DialogWrapper)((DialogWrapper)dialog2), conflicts2, (Project)originalClass.getProject());
    }

    @Nullable
    public String getErrorMessage$kotlin_idea(@NotNull KtClassOrObject klass2) {
        return ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)klass2) ? KotlinBundle.message("error.text.extraction.from.expect.class.is.not.yet.supported", new Object[0]) : (LightClassUtilsKt.toLightClass((KtClassOrObject)klass2) == null ? KotlinBundle.message("error.text.extraction.from.non.jvm.class.is.not.yet.supported", new Object[0]) : null);
    }

    @NotNull
    protected abstract KotlinExtractSuperDialogBase createDialog(@NotNull KtClassOrObject var1, @NotNull PsiElement var2);

    public static final /* synthetic */ void access$doInvoke(KotlinExtractSuperHandlerBase $this, KtClassOrObject klass2, PsiElement targetParent) {
        $this.doInvoke(klass2, targetParent);
    }
}

