/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInliner.UsageReplacementStrategy;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractCrossLanguageInlineHandler;
import org.jetbrains.kotlin.idea.refactoring.inline.J2KInlineCache;
import org.jetbrains.kotlin.idea.refactoring.inline.JavaToKotlinInlineHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineRefactoringFUSCollector;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/JavaToKotlinInlineHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractCrossLanguageInlineHandler;", "()V", "performInline", "", "usage", "Lcom/intellij/usageView/UsageInfo;", "referenced", "Lcom/intellij/psi/PsiElement;", "prepareReference", "Lcom/intellij/util/containers/MultiMap;", "", "reference", "Lcom/intellij/psi/PsiReference;", "Companion", "kotlin.idea"})
public final class JavaToKotlinInlineHandler
extends AbstractCrossLanguageInlineHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG = Logger.getInstance(JavaToKotlinInlineHandler.class);

    @Override
    @NotNull
    public MultiMap<PsiElement, String> prepareReference(@NotNull PsiReference reference2, @NotNull PsiElement referenced) {
        String string2;
        PsiElement referenceElement = reference2.getElement();
        if (Intrinsics.areEqual((Object)referenceElement.getLanguage(), (Object)KotlinLanguage.INSTANCE)) {
            KotlinInlineRefactoringFUSCollector.Companion.log(referenced, (Language)KotlinLanguage.INSTANCE, true);
        }
        PsiMember psiMember = JavaToKotlinInlineHandlerKt.access$getJavaMemberToInline(referenced);
        if (psiMember == null) {
            return super.prepareReference(reference2, referenced);
        }
        PsiMember javaMemberToInline = psiMember;
        String string3 = JavaToKotlinInlineHandlerKt.access$validate(javaMemberToInline, referenceElement);
        if (string3 != null) {
            String error2 = string3;
            boolean bl = false;
            return AbstractCrossLanguageInlineHandler.Companion.createMultiMapWithSingleConflict(referenceElement, error2);
        }
        try {
            UsageReplacementStrategy strategy = J2KInlineCache.Companion.findOrCreateUsageReplacementStrategy$kotlin_idea(javaMemberToInline, referenceElement);
            string2 = strategy == null ? KotlinBundle.message("failed.to.create.a.wrapper.for.inlining.to.kotlin", new Object[0]) : null;
        }
        catch (IllegalStateException e) {
            LOG.error((Throwable)e);
            string2 = e.getMessage();
        }
        string3 = string2;
        if (string3 != null) {
            String error3 = string3;
            boolean bl = false;
            return AbstractCrossLanguageInlineHandler.Companion.createMultiMapWithSingleConflict(referenceElement, error3);
        }
        return MultiMap.empty();
    }

    @Override
    public void performInline(@NotNull UsageInfo usage, @NotNull PsiElement referenced) {
        block2: {
            KtReferenceExpression ktReferenceExpression = JavaToKotlinInlineHandlerKt.access$unwrapUsage(usage);
            if (ktReferenceExpression == null) {
                boolean bl = false;
                LOG.error("Kotlin usage in " + usage + " not found (element " + usage.getElement());
                return;
            }
            KtReferenceExpression unwrappedUsage = ktReferenceExpression;
            KtReferenceExpression unwrappedElement = JavaToKotlinInlineHandlerKt.access$unwrapElement(unwrappedUsage, referenced);
            UsageReplacementStrategy usageReplacementStrategy = J2KInlineCache.Companion.findUsageReplacementStrategy(referenced, false);
            if (usageReplacementStrategy == null) {
                boolean bl = false;
                LOG.error("Can't find strategy for " + Reflection.getOrCreateKotlinClass(unwrappedElement.getClass()) + " (" + JavaPsiUtils.getKotlinFqName((PsiElement)unwrappedElement) + ") => " + unwrappedElement.getText());
                return;
            }
            UsageReplacementStrategy replacementStrategy = usageReplacementStrategy;
            Function0<KtElement> function0 = replacementStrategy.createReplacer(unwrappedElement);
            if (function0 == null) break block2;
            KtElement cfr_ignored_0 = (KtElement)function0.invoke();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/JavaToKotlinInlineHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

