/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.copy;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.FqNameUtils;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationDialog;
import org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationsHandler;
import org.jetbrains.kotlin.idea.refactoring.move.AutocreatingPsiDirectoryWrapper;
import org.jetbrains.kotlin.idea.refactoring.move.AutocreatingPsiDirectoryWrapperKt;
import org.jetbrains.kotlin.idea.refactoring.move.ContainerChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.move.ContainerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinDirectoryMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveConflictChecker;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.UserDataProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 G2\u00020\u0001:\u0005GHIJKB\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010\u0011J%\u0010\u0012\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000fJ<\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u001c`\u001dH\u0002J(\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001fj\b\u0012\u0004\u0012\u00020\u001c` 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\rH\u0016J'\u0010$\u001a\u00020\"2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010'J'\u0010(\u001a\u00020\"2\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0\f2\b\u0010+\u001a\u0004\u0018\u00010&H\u0002\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00100\u001a\u000201H\u0002J0\u00102\u001a\u00020/2\u0006\u00103\u001a\u0002012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u00020\nH\u0002J\"\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u00105\u001a\u00020\u00152\u0006\u00104\u001a\u00020&H\u0002J\"\u0010;\u001a\u0004\u0018\u0001012\u0006\u0010<\u001a\u0002012\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u0015H\u0002J%\u0010=\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010>J\u0012\u0010?\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010A\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J-\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u000e\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0\f2\b\u0010+\u001a\u0004\u0018\u00010&H\u0002\u00a2\u0006\u0002\u0010FR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler;", "Lcom/intellij/refactoring/copy/CopyHandlerDelegateBase;", "()V", "copyFilesHandler", "Lcom/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler;", "getCopyFilesHandler", "()Lcom/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler;", "copyFilesHandler$delegate", "Lkotlin/Lazy;", "canCopy", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "fromUpdate", "([Lcom/intellij/psi/PsiElement;Z)Z", "canCopyDeclarations", "([Lcom/intellij/psi/PsiElement;)Z", "canCopyFiles", "collectConflicts", "Lcom/intellij/util/containers/MultiMap;", "", "sourceData", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$SourceData;", "targetData", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$TargetData;", "internalUsages", "Ljava/util/HashSet;", "Lcom/intellij/usageView/UsageInfo;", "Lkotlin/collections/HashSet;", "collectInternalUsages", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "doClone", "", "element", "doCopy", "defaultTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "([Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiDirectory;)V", "doCopyFiles", "filesToCopy", "Lcom/intellij/psi/PsiFileSystemItem;", "initialTargetDirectory", "([Lcom/intellij/psi/PsiFileSystemItem;Lcom/intellij/psi/PsiDirectory;)V", "doRefactor", "doRefactoringOnElement", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$RefactoringResult;", "targetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "doRefactoringOnFile", "fileToCopy", "targetDirectory", "targetFileName", "isSingleDeclarationInFile", "getFilePolicy", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$ExistingFilePolicy;", "existingFile", "Lcom/intellij/psi/PsiFile;", "getOrCreateTargetFile", "originalFile", "getSourceFiles", "([Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiFileSystemItem;", "getTargetDataForUX", "getTargetDataForUnitTest", "getTargetFileName", "trackedCopyFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceFiles", "([Lcom/intellij/psi/PsiFileSystemItem;Lcom/intellij/psi/PsiDirectory;)Ljava/util/Set;", "Companion", "ExistingFilePolicy", "RefactoringResult", "SourceData", "TargetData", "kotlin.idea"})
public final class CopyKotlinDeclarationsHandler
extends CopyHandlerDelegateBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy copyFilesHandler$delegate = LazyKt.lazy((Function0)copyFilesHandler.2.INSTANCE);
    @NotNull
    private static final UserDataProperty<? super Project, String> newName$delegate = new UserDataProperty(Key.create((String)"NEW_NAME"));

    private final CopyFilesOrDirectoriesHandler getCopyFilesHandler() {
        Lazy lazy = this.copyFilesHandler$delegate;
        return (CopyFilesOrDirectoriesHandler)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final PsiFileSystemItem[] getSourceFiles(PsiElement[] elements2) {
        void $this$mapTo$iv$iv;
        PsiElement[] $this$map$iv = elements2;
        boolean $i$f$map = false;
        PsiElement[] psiElementArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            PsiFileSystemItem psiFileSystemItem;
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiFile psiFile2 = it.getContainingFile();
            if (psiFile2 != null) {
                psiFileSystemItem = (PsiFileSystemItem)psiFile2;
            } else {
                psiFileSystemItem = it instanceof PsiFileSystemItem ? (PsiFileSystemItem)it : null;
                if (psiFileSystemItem == null) {
                    return null;
                }
            }
            collection.add(psiFileSystemItem);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiFileSystemItem[0]);
    }

    private final boolean canCopyFiles(PsiElement[] elements2, boolean fromUpdate) {
        boolean bl;
        PsiFileSystemItem[] sourceFiles2;
        block3: {
            PsiFileSystemItem[] psiFileSystemItemArray = this.getSourceFiles(elements2);
            if (psiFileSystemItemArray == null) {
                return false;
            }
            PsiFileSystemItem[] $this$any$iv = sourceFiles2 = psiFileSystemItemArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                PsiFileSystemItem element$iv;
                PsiFileSystemItem it = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!(it instanceof KtFile)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (!bl) {
            return false;
        }
        return this.getCopyFilesHandler().canCopy((PsiElement[])sourceFiles2, fromUpdate);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canCopyDeclarations(PsiElement[] elements2) {
        void $this$distinctBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        PsiFile psiFile2 = elements2;
        boolean $i$f$flatMap = false;
        void var6_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[j];
            boolean bl = false;
            Collection $this$ifEmpty$iv = CopyKotlinDeclarationsHandler.Companion.getDeclarationsToCopy((PsiElement)it);
            boolean $i$f$ifEmpty = false;
            if ($this$ifEmpty$iv.isEmpty()) {
                boolean bl2 = false;
                return false;
            }
            Iterable list$iv$iv = (List)$this$ifEmpty$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<PsiFile> set$iv = new HashSet<PsiFile>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            KtElement it = (KtElement)e$iv;
            boolean bl = false;
            PsiFile key$iv = it.getContainingFile();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        KtElement ktElement = (KtElement)CollectionsKt.singleOrNull((List)list$iv);
        if (ktElement == null || (psiFile2 = ktElement.getContainingFile()) == null) {
            return false;
        }
        PsiFile containingFile = psiFile2;
        return ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)containingFile) != null;
    }

    public boolean canCopy(@NotNull PsiElement[] elements2, boolean fromUpdate) {
        return this.canCopyDeclarations(elements2) || this.canCopyFiles(elements2, fromUpdate);
    }

    private final KtFile getOrCreateTargetFile(KtFile originalFile, PsiDirectory targetDirectory, String targetFileName) {
        PsiFile existingFile = targetDirectory.findFile(targetFileName);
        if (Intrinsics.areEqual((Object)existingFile, (Object)originalFile)) {
            return null;
        }
        if (existingFile != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getFilePolicy(existingFile, targetFileName, targetDirectory).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean $i$f$runWriteAction = false;
                    ApplicationManager.getApplication().runWriteAction(new Computable(existingFile){
                        final /* synthetic */ PsiFile $existingFile$inlined;
                        {
                            this.$existingFile$inlined = psiFile2;
                        }

                        public final T compute() {
                            boolean bl = false;
                            this.$existingFile$inlined.delete();
                            return (T)Unit.INSTANCE;
                        }
                    });
                    break;
                }
                case 3: {
                    return null;
                }
            }
        }
        boolean $i$f$runWriteAction = false;
        return (KtFile)ApplicationManager.getApplication().runWriteAction(new Computable(existingFile, targetFileName, targetDirectory){
            final /* synthetic */ PsiFile $existingFile$inlined;
            final /* synthetic */ String $targetFileName$inlined;
            final /* synthetic */ PsiDirectory $targetDirectory$inlined;
            {
                this.$existingFile$inlined = psiFile2;
                this.$targetFileName$inlined = string2;
                this.$targetDirectory$inlined = psiDirectory;
            }

            public final T compute() {
                KtFile ktFile;
                boolean bl = false;
                if (this.$existingFile$inlined != null && this.$existingFile$inlined.isValid()) {
                    Intrinsics.checkNotNull((Object)this.$existingFile$inlined, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    ktFile = (KtFile)this.$existingFile$inlined;
                } else {
                    ktFile = KotlinRefactoringUtilKt.createKotlinFile$default(this.$targetFileName$inlined, this.$targetDirectory$inlined, null, 4, null);
                }
                return (T)ktFile;
            }
        });
    }

    private final ExistingFilePolicy getFilePolicy(PsiFile existingFile, String targetFileName, PsiDirectory targetDirectory) {
        ExistingFilePolicy existingFilePolicy;
        Object[] objectArray = new Object[]{targetFileName, targetDirectory.getVirtualFile().getPath()};
        String message2 = KotlinBundle.message("text.file.0.already.exists.in.1", objectArray);
        if (!(existingFile instanceof KtFile)) {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return ExistingFilePolicy.OVERWRITE;
            }
            int answer = Messages.showOkCancelDialog((String)message2, (String)CopyKotlinDeclarationsHandler.Companion.getCommandName(), (String)KotlinBundle.message("action.text.overwrite", new Object[0]), (String)KotlinBundle.message("action.text.cancel", new Object[0]), (Icon)Messages.getQuestionIcon());
            existingFilePolicy = answer == 0 ? ExistingFilePolicy.OVERWRITE : ExistingFilePolicy.SKIP;
        } else {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return ExistingFilePolicy.APPEND;
            }
            int answer = Messages.showYesNoCancelDialog((String)message2, (String)CopyKotlinDeclarationsHandler.Companion.getCommandName(), (String)KotlinBundle.message("action.text.append", new Object[0]), (String)KotlinBundle.message("action.text.overwrite", new Object[0]), (String)KotlinBundle.message("action.text.cancel", new Object[0]), (Icon)Messages.getQuestionIcon());
            switch (answer) {
                case 0: {
                    existingFilePolicy = ExistingFilePolicy.APPEND;
                    break;
                }
                case 1: {
                    existingFilePolicy = ExistingFilePolicy.OVERWRITE;
                    break;
                }
                default: {
                    existingFilePolicy = ExistingFilePolicy.SKIP;
                }
            }
        }
        return existingFilePolicy;
    }

    private final TargetData getTargetDataForUnitTest(SourceData sourceData) {
        String newName2;
        SourceData $this$getTargetDataForUnitTest_u24lambda_u247 = sourceData;
        boolean bl = false;
        VirtualFile virtualFile = ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)$this$getTargetDataForUnitTest_u24lambda_u247.getInitialTargetDirectory());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile targetSourceRoot = virtualFile;
        String string2 = Companion.getNewName($this$getTargetDataForUnitTest_u24lambda_u247.getProject());
        if (string2 == null) {
            KtElement ktElement = $this$getTargetDataForUnitTest_u24lambda_u247.getSingleElementToCopy();
            string2 = ktElement != null ? ktElement.getName() : null;
            if (string2 == null) {
                string2 = newName2 = $this$getTargetDataForUnitTest_u24lambda_u247.getOriginalFile().getName();
            }
        }
        if ($this$getTargetDataForUnitTest_u24lambda_u247.getSingleElementToCopy() != null && ((CharSequence)newName2).length() == 0) {
            return null;
        }
        return new TargetData(false, newName2, AutocreatingPsiDirectoryWrapperKt.toDirectoryWrapper($this$getTargetDataForUnitTest_u24lambda_u247.getInitialTargetDirectory()), targetSourceRoot);
    }

    private final TargetData getTargetDataForUX(SourceData sourceData) {
        KtNamedDeclaration singleNamedSourceElement;
        boolean openInEditor = false;
        String newName2 = null;
        AutocreatingPsiDirectoryWrapper targetDirWrapper = null;
        VirtualFile targetSourceRoot = null;
        KtElement ktElement = sourceData.getSingleElementToCopy();
        KtNamedDeclaration ktNamedDeclaration = singleNamedSourceElement = ktElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)ktElement : null;
        if (singleNamedSourceElement != null) {
            dialog = new CopyKotlinDeclarationDialog(singleNamedSourceElement, sourceData.getInitialTargetDirectory(), sourceData.getProject());
            dialog.setTitle(CopyKotlinDeclarationsHandler.Companion.getCommandName());
            if (!dialog.showAndGet()) {
                return null;
            }
            openInEditor = dialog.getOpenInEditor();
            newName2 = dialog.getNewName();
            MoveDestination moveDestination = dialog.getTargetDirectory();
            targetDirWrapper = moveDestination != null ? AutocreatingPsiDirectoryWrapperKt.toDirectoryWrapper(moveDestination) : null;
            targetSourceRoot = dialog.getTargetSourceRoot();
        } else {
            KtFile[] ktFileArray = new KtFile[]{sourceData.getOriginalFile()};
            dialog = new CopyFilesOrDirectoriesDialog((PsiElement[])ktFileArray, sourceData.getInitialTargetDirectory(), sourceData.getProject(), false);
            if (!dialog.showAndGet()) {
                return null;
            }
            openInEditor = dialog.openInEditor();
            newName2 = dialog.getNewName();
            PsiDirectory psiDirectory = dialog.getTargetDirectory();
            targetDirWrapper = psiDirectory != null ? AutocreatingPsiDirectoryWrapperKt.toDirectoryWrapper(psiDirectory) : null;
            PsiDirectory psiDirectory2 = dialog.getTargetDirectory();
            Object object = targetSourceRoot = psiDirectory2 != null ? ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)psiDirectory2) : null;
        }
        if (targetDirWrapper == null) {
            return null;
        }
        if (newName2 == null) {
            return null;
        }
        if (sourceData.getSingleElementToCopy() != null && ((CharSequence)newName2).length() == 0) {
            return null;
        }
        return new TargetData(openInEditor, newName2, targetDirWrapper, targetSourceRoot);
    }

    private final LinkedHashSet<UsageInfo> collectInternalUsages(SourceData sourceData, TargetData targetData) {
        boolean $i$f$runReadAction = false;
        return (LinkedHashSet)ApplicationManager.getApplication().runReadAction(new Computable(targetData, sourceData){
            final /* synthetic */ TargetData $targetData$inlined;
            final /* synthetic */ SourceData $sourceData$inlined;
            {
                this.$targetData$inlined = targetData;
                this.$sourceData$inlined = sourceData;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                void $this$flatMapTo$iv;
                boolean bl = false;
                String targetPackageName = this.$targetData$inlined.getTargetDirWrapper().getPackageName();
                ContainerChangeInfo changeInfo = new ContainerChangeInfo(new ContainerInfo.Package(this.$sourceData$inlined.getOriginalFile().getPackageFqName()), new ContainerInfo.Package(new FqName(targetPackageName)));
                Iterable iterable = this.$sourceData$inlined.getElementsToCopy();
                Collection destination$iv = new LinkedHashSet<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv : $this$flatMapTo$iv) {
                    void $this$filterTo$iv$iv;
                    KtElement elementToCopy = (KtElement)element$iv;
                    boolean bl2 = false;
                    Iterable $this$filter$iv = MoveUtilsKt.getInternalReferencesToUpdateOnPackageNameChange(elementToCopy, changeInfo);
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        UsageInfo it = (UsageInfo)element$iv$iv;
                        boolean bl3 = false;
                        MoveRenameUsageInfo moveRenameUsageInfo = it instanceof MoveRenameUsageInfo ? (MoveRenameUsageInfo)it : null;
                        Object referencedElement = moveRenameUsageInfo != null ? moveRenameUsageInfo.getReferencedElement() : null;
                        if (!(referencedElement == null || !PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)elementToCopy), (PsiElement)referencedElement, (boolean)false, (int)2, null))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable list$iv = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                return (T)((LinkedHashSet)destination$iv);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<VirtualFile> trackedCopyFiles(PsiFileSystemItem[] sourceFiles2, PsiDirectory initialTargetDirectory) {
        if (!this.getCopyFilesHandler().canCopy((PsiElement[])sourceFiles2)) {
            return SetsKt.emptySet();
        }
        var mapper2 = new VirtualFileListener(){
            @NotNull
            private final Set<VirtualFile> filesCopied;
            {
                this.filesCopied = new LinkedHashSet<E>();
            }

            @NotNull
            public final Set<VirtualFile> getFilesCopied() {
                return this.filesCopied;
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                this.filesCopied.add(event.getFile());
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                this.filesCopied.add(event.getFile());
            }
        };
        VirtualFileManager $this$trackedCopyFiles_u24lambda_u2411 = VirtualFileManager.getInstance();
        boolean bl = false;
        try {
            $this$trackedCopyFiles_u24lambda_u2411.addVirtualFileListener(mapper2);
            this.getCopyFilesHandler().doCopy((PsiElement[])sourceFiles2, initialTargetDirectory);
        }
        finally {
            $this$trackedCopyFiles_u24lambda_u2411.removeVirtualFileListener(mapper2);
        }
        return mapper2.getFilesCopied();
    }

    private final void doCopyFiles(PsiFileSystemItem[] filesToCopy, PsiDirectory initialTargetDirectory) {
        if (filesToCopy.length == 0) {
            return;
        }
        Project project = filesToCopy[0].getProject();
        PsiManager psiManager2 = PsiManager.getInstance((Project)project);
        ApplicationUtilsKt.executeCommand$default(project, CopyKotlinDeclarationsHandler.Companion.getCommandName(), null, (Function0)new Function0<Unit>(this, filesToCopy, initialTargetDirectory, psiManager2, project){
            final /* synthetic */ CopyKotlinDeclarationsHandler this$0;
            final /* synthetic */ PsiFileSystemItem[] $filesToCopy;
            final /* synthetic */ PsiDirectory $initialTargetDirectory;
            final /* synthetic */ PsiManager $psiManager;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$filesToCopy = $filesToCopy;
                this.$initialTargetDirectory = $initialTargetDirectory;
                this.$psiManager = $psiManager;
                this.$project = $project;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                Set copiedFiles = CopyKotlinDeclarationsHandler.access$trackedCopyFiles(this.this$0, this.$filesToCopy, this.$initialTargetDirectory);
                Iterable iterable = copiedFiles;
                PsiManager psiManager2 = this.$psiManager;
                Project project = this.$project;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VirtualFile copiedFile = (VirtualFile)element$iv;
                    boolean bl = false;
                    PsiFile psiFile2 = psiManager2.findFile(copiedFile);
                    KtFile targetKtFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
                    if (targetKtFile == null) continue;
                    boolean $i$f$runWriteAction = false;
                    ApplicationManager.getApplication().runWriteAction(new Computable(targetKtFile, project){
                        final /* synthetic */ KtFile $targetKtFile$inlined;
                        final /* synthetic */ Project $project$inlined;
                        {
                            this.$targetKtFile$inlined = ktFile;
                            this.$project$inlined = project;
                        }

                        public final T compute() {
                            boolean bl = false;
                            if (!PackageUtilsKt.packageMatchesDirectoryOrImplicit(this.$targetKtFile$inlined)) {
                                PsiDirectory psiDirectory = this.$targetKtFile$inlined.getContainingDirectory();
                                if (psiDirectory != null && (psiDirectory = PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory)) != null && (psiDirectory = FqNameUtils.quoteIfNeeded((FqName)psiDirectory)) != null) {
                                    PsiDirectory targetDirectoryFqName = psiDirectory;
                                    boolean bl2 = false;
                                    this.$targetKtFile$inlined.setPackageFqName((FqName)targetDirectoryFqName);
                                }
                            }
                            DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests(this.$project$inlined);
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void doCopy(@NotNull PsiElement[] elements2, @Nullable PsiDirectory defaultTargetDirectory) {
        void $this$mapNotNullTo$iv$iv;
        PsiFileSystemItem[] psiFileSystemItemArray;
        if (elements2.length == 0) {
            return;
        }
        if (!this.canCopyDeclarations(elements2) && (psiFileSystemItemArray = this.getSourceFiles(elements2)) != null) {
            PsiFileSystemItem[] it = psiFileSystemItemArray;
            boolean bl = false;
            this.doCopyFiles(it, defaultTargetDirectory);
            return;
        }
        PsiElement[] $this$mapNotNull$iv = elements2;
        boolean $i$f$mapNotNull = false;
        PsiElement[] bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            KtElement it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl2 = false;
            void it = element$iv$iv;
            boolean bl3 = false;
            if (CopyKotlinDeclarationsHandler.Companion.getCopyableElement((PsiElement)it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elementsToCopy = (List)destination$iv$iv;
        if (elementsToCopy.isEmpty()) {
            return;
        }
        KtElement singleElementToCopy = (KtElement)CollectionsKt.singleOrNull((List)elementsToCopy);
        PsiFile psiFile2 = ((KtElement)CollectionsKt.first((List)elementsToCopy)).getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile originalFile = (KtFile)psiFile2;
        PsiDirectory psiDirectory = defaultTargetDirectory;
        if (psiDirectory == null && (psiDirectory = originalFile.getContainingDirectory()) == null) {
            return;
        }
        PsiDirectory initialTargetDirectory = psiDirectory;
        Project project = initialTargetDirectory.getProject();
        SourceData sourceData = new SourceData(project, singleElementToCopy, elementsToCopy, originalFile, initialTargetDirectory);
        boolean $i$f$isUnitTestMode = false;
        TargetData targetData = ApplicationManager.getApplication().isUnitTestMode() ? this.getTargetDataForUnitTest(sourceData) : this.getTargetDataForUX(sourceData);
        if (targetData == null) {
            return;
        }
        LinkedHashSet<UsageInfo> internalUsages = this.collectInternalUsages(sourceData, targetData);
        MoveUtilsKt.markInternalUsages((Collection<? extends UsageInfo>)internalUsages);
        MultiMap<PsiElement, String> conflicts2 = this.collectConflicts(sourceData, targetData, (HashSet<UsageInfo>)internalUsages);
        KotlinRefactoringUtilKt.checkConflictsInteractively$default(project, conflicts2, null, (Function0)new Function0<Unit>(project, internalUsages, this, sourceData, targetData){
            final /* synthetic */ Project $project;
            final /* synthetic */ LinkedHashSet<UsageInfo> $internalUsages;
            final /* synthetic */ CopyKotlinDeclarationsHandler this$0;
            final /* synthetic */ SourceData $sourceData;
            final /* synthetic */ TargetData $targetData;
            {
                this.$project = $project;
                this.$internalUsages = $internalUsages;
                this.this$0 = $receiver;
                this.$sourceData = $sourceData;
                this.$targetData = $targetData;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    ApplicationUtilsKt.executeCommand$default(this.$project, org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationsHandler$Companion.access$getCommandName(CopyKotlinDeclarationsHandler.Companion), null, (Function0)new Function0<Unit>(this.this$0, this.$sourceData, this.$targetData){
                        final /* synthetic */ CopyKotlinDeclarationsHandler this$0;
                        final /* synthetic */ SourceData $sourceData;
                        final /* synthetic */ TargetData $targetData;
                        {
                            this.this$0 = $receiver;
                            this.$sourceData = $sourceData;
                            this.$targetData = $targetData;
                            super(0);
                        }

                        public final void invoke() {
                            CopyKotlinDeclarationsHandler.access$doRefactor(this.this$0, this.$sourceData, this.$targetData);
                        }
                    }, 2, null);
                }
                finally {
                    MoveUtilsKt.cleanUpInternalUsages((Collection<? extends UsageInfo>)this.$internalUsages);
                }
            }
        }, 2, null);
    }

    private final String getTargetFileName(SourceData sourceData, TargetData targetData) {
        return StringsKt.contains$default((CharSequence)targetData.getNewName(), (CharSequence)".", (boolean)false, (int)2, null) ? targetData.getNewName() : targetData.getNewName() + "." + sourceData.getOriginalFile().getVirtualFile().getExtension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void doRefactor(SourceData sourceData, TargetData targetData) {
        Object object;
        RefactoringResult refactoringResult = null;
        try {
            RefactoringResult refactoringResult2;
            KtFile fileToCopy;
            boolean $i$f$runWriteAction = false;
            PsiDirectory targetDirectory = (PsiDirectory)ApplicationManager.getApplication().runWriteAction(new Computable(targetData, sourceData){
                final /* synthetic */ TargetData $targetData$inlined;
                final /* synthetic */ SourceData $sourceData$inlined;
                {
                    this.$targetData$inlined = targetData;
                    this.$sourceData$inlined = sourceData;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.$targetData$inlined.getTargetDirWrapper().getOrCreateDirectory(this.$sourceData$inlined.getInitialTargetDirectory());
                }
            });
            String targetFileName = this.getTargetFileName(sourceData, targetData);
            boolean isSingleDeclarationInFile = sourceData.getSingleElementToCopy() instanceof KtNamedDeclaration && Intrinsics.areEqual((Object)CollectionsKt.singleOrNull((List)sourceData.getOriginalFile().getDeclarations()), (Object)sourceData.getSingleElementToCopy());
            Object object2 = sourceData.getSingleElementToCopy() instanceof KtFile ? (KtFile)sourceData.getSingleElementToCopy() : (fileToCopy = isSingleDeclarationInFile ? sourceData.getOriginalFile() : null);
            if (fileToCopy != null) {
                refactoringResult2 = this.doRefactoringOnFile(fileToCopy, sourceData, targetDirectory, targetFileName, isSingleDeclarationInFile);
            } else {
                KtFile ktFile = this.getOrCreateTargetFile(sourceData.getOriginalFile(), targetDirectory, targetFileName);
                if (ktFile == null) {
                    throw new IncorrectOperationException("Could not create target file.");
                }
                KtFile targetFile = ktFile;
                refactoringResult2 = this.doRefactoringOnElement(sourceData, targetFile);
            }
            refactoringResult = refactoringResult2;
            KtNamedDeclaration ktNamedDeclaration = refactoringResult.getCopiedDeclaration();
            if (ktNamedDeclaration != null) {
                KtNamedDeclaration newDeclaration = ktNamedDeclaration;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)targetData.getNewName(), (Object)newDeclaration.getName())) {
                    Collection selfReferences = ReferencesSearch.search((PsiElement)((PsiElement)newDeclaration), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)newDeclaration))).findAll();
                    boolean $i$f$runWriteAction2 = false;
                    ApplicationManager.getApplication().runWriteAction(new Computable(selfReferences, newDeclaration, targetData){
                        final /* synthetic */ Collection $selfReferences$inlined;
                        final /* synthetic */ KtNamedDeclaration $newDeclaration$inlined;
                        final /* synthetic */ TargetData $targetData$inlined;
                        {
                            this.$selfReferences$inlined = collection;
                            this.$newDeclaration$inlined = ktNamedDeclaration;
                            this.$targetData$inlined = targetData;
                        }

                        public final T compute() {
                            boolean bl = false;
                            Iterable $this$forEach$iv = this.$selfReferences$inlined;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                PsiReference it = (PsiReference)element$iv;
                                boolean bl2 = false;
                                it.handleElementRename(this.$targetData$inlined.getNewName());
                            }
                            this.$newDeclaration$inlined.setName(this.$targetData$inlined.getNewName());
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
            }
            if (targetData.getOpenInEditor()) {
                EditorHelper.openInEditor((PsiElement)((PsiElement)refactoringResult.getTargetFile()));
            }
            if ((object = refactoringResult) == null || (object = ((RefactoringResult)object).getRestoredInternalUsages()) == null) return;
        }
        catch (IncorrectOperationException e) {
            Object object3;
            try {
                Messages.showMessageDialog((Project)sourceData.getProject(), (String)e.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                object3 = refactoringResult;
                if (object3 == null || (object3 = ((RefactoringResult)object3).getRestoredInternalUsages()) == null) return;
            }
            catch (Throwable throwable) {
                Object object4 = refactoringResult;
                if (object4 == null || (object4 = ((RefactoringResult)object4).getRestoredInternalUsages()) == null) throw throwable;
                Object it = object4;
                boolean bl = false;
                MoveUtilsKt.cleanUpInternalUsages((Collection)it);
                throw throwable;
            }
            Object it = object3;
            boolean bl = false;
            MoveUtilsKt.cleanUpInternalUsages((Collection)it);
            return;
        }
        Object it = object;
        boolean bl = false;
        MoveUtilsKt.cleanUpInternalUsages((Collection)it);
        return;
    }

    private final RefactoringResult doRefactoringOnFile(KtFile fileToCopy, SourceData sourceData, PsiDirectory targetDirectory, String targetFileName, boolean isSingleDeclarationInFile) {
        Object object;
        boolean $i$f$runWriteAction = false;
        PsiFile targetFile = (PsiFile)ApplicationManager.getApplication().runWriteAction(new Computable(targetDirectory, targetFileName, fileToCopy, sourceData){
            final /* synthetic */ PsiDirectory $targetDirectory$inlined;
            final /* synthetic */ String $targetFileName$inlined;
            final /* synthetic */ KtFile $fileToCopy$inlined;
            final /* synthetic */ SourceData $sourceData$inlined;
            {
                this.$targetDirectory$inlined = psiDirectory;
                this.$targetFileName$inlined = string2;
                this.$fileToCopy$inlined = ktFile;
                this.$sourceData$inlined = sourceData;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                void var3_3;
                boolean bl = false;
                FqName targetDirectoryFqName = PackageUtilsKt.getFqNameWithImplicitPrefix(this.$targetDirectory$inlined);
                PsiFile copiedFile = this.$targetDirectory$inlined.copyFileFrom(this.$targetFileName$inlined, (PsiFile)this.$fileToCopy$inlined);
                if (copiedFile instanceof KtFile && PackageUtilsKt.packageMatchesDirectoryOrImplicit(this.$fileToCopy$inlined)) {
                    FqName fqName2 = targetDirectoryFqName;
                    if (fqName2 != null && (fqName2 = FqNameUtils.quoteIfNeeded(fqName2)) != null) {
                        FqName it = fqName2;
                        boolean bl2 = false;
                        ((KtFile)copiedFile).setPackageFqName(it);
                    }
                }
                DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests(this.$sourceData$inlined.getProject());
                return var3_3;
            }
        });
        KtNamedDeclaration copiedDeclaration = isSingleDeclarationInFile && targetFile instanceof KtFile ? ((object = CollectionsKt.singleOrNull((List)((KtFile)targetFile).getDeclarations())) instanceof KtNamedDeclaration ? (KtNamedDeclaration)object : null) : null;
        return new RefactoringResult(targetFile, copiedDeclaration, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final RefactoringResult doRefactoringOnElement(SourceData sourceData, KtFile targetFile) {
        void $this$filterIsInstanceTo$iv$iv;
        ArrayList restoredInternalUsages = new ArrayList();
        HashMap oldToNewElementsMapping = new HashMap();
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(sourceData, oldToNewElementsMapping, targetFile, restoredInternalUsages){
            final /* synthetic */ SourceData $sourceData$inlined;
            final /* synthetic */ HashMap $oldToNewElementsMapping$inlined;
            final /* synthetic */ KtFile $targetFile$inlined;
            final /* synthetic */ ArrayList $restoredInternalUsages$inlined;
            {
                this.$sourceData$inlined = sourceData;
                this.$oldToNewElementsMapping$inlined = hashMap;
                this.$targetFile$inlined = ktFile;
                this.$restoredInternalUsages$inlined = arrayList;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                void $this$mapTo$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = this.$sourceData$inlined.getElementsToCopy();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtElement ktElement = (KtElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    PsiElement psiElement2 = this.$targetFile$inlined.add(it.copy());
                    Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                    collection.add((KtNamedDeclaration)psiElement2);
                }
                List newElements2 = (List)destination$iv$iv;
                MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)this.$sourceData$inlined.getElementsToCopy(), (Iterable)newElements2), (Map)this.$oldToNewElementsMapping$inlined);
                ((Map)this.$oldToNewElementsMapping$inlined).put(this.$sourceData$inlined.getOriginalFile(), this.$targetFile$inlined);
                for (PsiElement newElement : this.$oldToNewElementsMapping$inlined.values()) {
                    Collection collection = this.$restoredInternalUsages$inlined;
                    Intrinsics.checkNotNull((Object)newElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                    CollectionsKt.addAll((Collection)collection, (Iterable)MoveUtilsKt.restoreInternalUsages((KtElement)newElement, this.$oldToNewElementsMapping$inlined, true));
                    MoveUtilsKt.postProcessMoveUsages$default(this.$restoredInternalUsages$inlined, this.$oldToNewElementsMapping$inlined, null, 4, null);
                }
                DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests(this.$sourceData$inlined.getProject());
                return (T)Unit.INSTANCE;
            }
        });
        Iterable $this$filterIsInstance$iv = oldToNewElementsMapping.values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KtNamedDeclaration copiedDeclaration = (KtNamedDeclaration)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        return new RefactoringResult((PsiFile)targetFile, copiedDeclaration, restoredInternalUsages);
    }

    private final MultiMap<PsiElement, String> collectConflicts(SourceData sourceData, TargetData targetData, HashSet<UsageInfo> internalUsages) {
        MultiMap multiMap;
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode() && BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
            return MultiMap.empty();
        }
        VirtualFile virtualFile = targetData.getTargetSourceRoot();
        if (virtualFile == null || (virtualFile = PhysicalFileSystemUtilsKt.toPsiDirectory(virtualFile, sourceData.getProject())) == null) {
            return MultiMap.empty();
        }
        VirtualFile targetSourceRootPsi = virtualFile;
        if (!Intrinsics.areEqual((Object)sourceData.getProject(), (Object)sourceData.getOriginalFile().getProject())) {
            return MultiMap.empty();
        }
        MoveConflictChecker conflictChecker2 = new MoveConflictChecker(sourceData.getProject(), sourceData.getElementsToCopy(), new KotlinDirectoryMoveTarget(FqName.ROOT, targetSourceRootPsi.getVirtualFile()), (KtElement)sourceData.getOriginalFile(), null, null, 48, null);
        MultiMap it = multiMap = new MultiMap();
        boolean bl = false;
        conflictChecker2.checkModuleConflictsInDeclarations((Set<UsageInfo>)internalUsages, (MultiMap<PsiElement, String>)it);
        conflictChecker2.checkVisibilityInDeclarations((MultiMap<PsiElement, String>)it);
        return multiMap;
    }

    public void doClone(@NotNull PsiElement element3) {
    }

    public static final /* synthetic */ Set access$trackedCopyFiles(CopyKotlinDeclarationsHandler $this, PsiFileSystemItem[] sourceFiles2, PsiDirectory initialTargetDirectory) {
        return $this.trackedCopyFiles(sourceFiles2, initialTargetDirectory);
    }

    public static final /* synthetic */ void access$doRefactor(CopyKotlinDeclarationsHandler $this, SourceData sourceData, TargetData targetData) {
        $this.doRefactor(sourceData, targetData);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\u00020\u0014H\u0002R\u001e\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR3\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\u00048F@GX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$Companion;", "", "()V", "commandName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getCommandName", "()Ljava/lang/String;", "<set-?>", "newName", "Lcom/intellij/openapi/project/Project;", "getNewName", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/String;", "setNewName", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "newName$delegate", "Lorg/jetbrains/kotlin/psi/UserDataProperty;", "getCopyableElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/psi/PsiElement;", "getDeclarationsToCopy", "", "kotlin.idea"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final String getCommandName() {
            return RefactoringBundle.message((String)"copy.handler.copy.files.directories");
        }

        @Nullable
        public final String getNewName(@NotNull Project $this$newName) {
            return (String)newName$delegate.getValue((UserDataHolder)$this$newName, $$delegatedProperties[0]);
        }

        @TestOnly
        public final void setNewName(@NotNull Project $this$newName, @Nullable String string2) {
            newName$delegate.setValue((UserDataHolder)$this$newName, $$delegatedProperties[0], (Object)string2);
        }

        private final KtElement getCopyableElement(PsiElement $this$getCopyableElement) {
            Object v0;
            block1: {
                Sequence $this$firstOrNull$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)$this$getCopyableElement);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it instanceof KtFile || it instanceof KtNamedDeclaration && ((KtNamedDeclaration)it).getParent() instanceof KtFile)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            Object var2_8 = v0;
            return var2_8 instanceof KtElement ? (KtElement)var2_8 : null;
        }

        /*
         * WARNING - void declaration
         */
        private final List<KtElement> getDeclarationsToCopy(PsiElement $this$getDeclarationsToCopy) {
            List list2;
            KtElement declarationOrFile = this.getCopyableElement($this$getDeclarationsToCopy);
            if (declarationOrFile instanceof KtFile) {
                Collection collection;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = ((KtFile)declarationOrFile).getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtNamedDeclaration)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection $this$ifEmpty$iv = (List)destination$iv$iv;
                boolean $i$f$ifEmpty = false;
                if ($this$ifEmpty$iv.isEmpty()) {
                    boolean bl = false;
                    collection = CollectionsKt.listOf((Object)declarationOrFile);
                } else {
                    void var3_3;
                    collection = var3_3;
                }
                list2 = (List)collection;
            } else {
                list2 = declarationOrFile instanceof KtNamedDeclaration ? CollectionsKt.listOf((Object)declarationOrFile) : CollectionsKt.emptyList();
            }
            return list2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "newName", "getNewName(Lcom/intellij/openapi/project/Project;)Ljava/lang/String;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$ExistingFilePolicy;", "", "(Ljava/lang/String;I)V", "APPEND", "OVERWRITE", "SKIP", "kotlin.idea"})
    public static final class ExistingFilePolicy
    extends Enum<ExistingFilePolicy> {
        public static final /* enum */ ExistingFilePolicy APPEND = new ExistingFilePolicy();
        public static final /* enum */ ExistingFilePolicy OVERWRITE = new ExistingFilePolicy();
        public static final /* enum */ ExistingFilePolicy SKIP = new ExistingFilePolicy();
        private static final /* synthetic */ ExistingFilePolicy[] $VALUES;

        public static ExistingFilePolicy[] values() {
            return (ExistingFilePolicy[])$VALUES.clone();
        }

        public static ExistingFilePolicy valueOf(String value2) {
            return Enum.valueOf(ExistingFilePolicy.class, value2);
        }

        static {
            $VALUES = existingFilePolicyArray = new ExistingFilePolicy[]{ExistingFilePolicy.APPEND, ExistingFilePolicy.OVERWRITE, ExistingFilePolicy.SKIP};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$TargetData;", "", "openInEditor", "", "newName", "", "targetDirWrapper", "Lorg/jetbrains/kotlin/idea/refactoring/move/AutocreatingPsiDirectoryWrapper;", "targetSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(ZLjava/lang/String;Lorg/jetbrains/kotlin/idea/refactoring/move/AutocreatingPsiDirectoryWrapper;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getNewName", "()Ljava/lang/String;", "getOpenInEditor", "()Z", "getTargetDirWrapper", "()Lorg/jetbrains/kotlin/idea/refactoring/move/AutocreatingPsiDirectoryWrapper;", "getTargetSourceRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.idea"})
    private static final class TargetData {
        private final boolean openInEditor;
        @NotNull
        private final String newName;
        @NotNull
        private final AutocreatingPsiDirectoryWrapper targetDirWrapper;
        @Nullable
        private final VirtualFile targetSourceRoot;

        public TargetData(boolean openInEditor, @NotNull String newName2, @NotNull AutocreatingPsiDirectoryWrapper targetDirWrapper, @Nullable VirtualFile targetSourceRoot) {
            this.openInEditor = openInEditor;
            this.newName = newName2;
            this.targetDirWrapper = targetDirWrapper;
            this.targetSourceRoot = targetSourceRoot;
        }

        public final boolean getOpenInEditor() {
            return this.openInEditor;
        }

        @NotNull
        public final String getNewName() {
            return this.newName;
        }

        @NotNull
        public final AutocreatingPsiDirectoryWrapper getTargetDirWrapper() {
            return this.targetDirWrapper;
        }

        @Nullable
        public final VirtualFile getTargetSourceRoot() {
            return this.targetSourceRoot;
        }

        public final boolean component1() {
            return this.openInEditor;
        }

        @NotNull
        public final String component2() {
            return this.newName;
        }

        @NotNull
        public final AutocreatingPsiDirectoryWrapper component3() {
            return this.targetDirWrapper;
        }

        @Nullable
        public final VirtualFile component4() {
            return this.targetSourceRoot;
        }

        @NotNull
        public final TargetData copy(boolean openInEditor, @NotNull String newName2, @NotNull AutocreatingPsiDirectoryWrapper targetDirWrapper, @Nullable VirtualFile targetSourceRoot) {
            return new TargetData(openInEditor, newName2, targetDirWrapper, targetSourceRoot);
        }

        public static /* synthetic */ TargetData copy$default(TargetData targetData, boolean bl, String string2, AutocreatingPsiDirectoryWrapper autocreatingPsiDirectoryWrapper, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                bl = targetData.openInEditor;
            }
            if ((n & 2) != 0) {
                string2 = targetData.newName;
            }
            if ((n & 4) != 0) {
                autocreatingPsiDirectoryWrapper = targetData.targetDirWrapper;
            }
            if ((n & 8) != 0) {
                virtualFile = targetData.targetSourceRoot;
            }
            return targetData.copy(bl, string2, autocreatingPsiDirectoryWrapper, virtualFile);
        }

        @NotNull
        public String toString() {
            return "TargetData(openInEditor=" + this.openInEditor + ", newName=" + this.newName + ", targetDirWrapper=" + this.targetDirWrapper + ", targetSourceRoot=" + this.targetSourceRoot + ")";
        }

        public int hashCode() {
            int n = this.openInEditor ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result2 = n;
            result2 = result2 * 31 + this.newName.hashCode();
            result2 = result2 * 31 + this.targetDirWrapper.hashCode();
            result2 = result2 * 31 + (this.targetSourceRoot == null ? 0 : this.targetSourceRoot.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TargetData)) {
                return false;
            }
            TargetData targetData = (TargetData)other;
            if (this.openInEditor != targetData.openInEditor) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newName, (Object)targetData.newName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.targetDirWrapper, (Object)targetData.targetDirWrapper)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.targetSourceRoot, (Object)targetData.targetSourceRoot);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003JC\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$SourceData;", "", "project", "Lcom/intellij/openapi/project/Project;", "singleElementToCopy", "Lorg/jetbrains/kotlin/psi/KtElement;", "elementsToCopy", "", "originalFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "initialTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/psi/PsiDirectory;)V", "getElementsToCopy", "()Ljava/util/List;", "getInitialTargetDirectory", "()Lcom/intellij/psi/PsiDirectory;", "getOriginalFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSingleElementToCopy", "()Lorg/jetbrains/kotlin/psi/KtElement;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    private static final class SourceData {
        @NotNull
        private final Project project;
        @Nullable
        private final KtElement singleElementToCopy;
        @NotNull
        private final List<KtElement> elementsToCopy;
        @NotNull
        private final KtFile originalFile;
        @NotNull
        private final PsiDirectory initialTargetDirectory;

        public SourceData(@NotNull Project project, @Nullable KtElement singleElementToCopy, @NotNull List<? extends KtElement> elementsToCopy, @NotNull KtFile originalFile, @NotNull PsiDirectory initialTargetDirectory) {
            this.project = project;
            this.singleElementToCopy = singleElementToCopy;
            this.elementsToCopy = elementsToCopy;
            this.originalFile = originalFile;
            this.initialTargetDirectory = initialTargetDirectory;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public final KtElement getSingleElementToCopy() {
            return this.singleElementToCopy;
        }

        @NotNull
        public final List<KtElement> getElementsToCopy() {
            return this.elementsToCopy;
        }

        @NotNull
        public final KtFile getOriginalFile() {
            return this.originalFile;
        }

        @NotNull
        public final PsiDirectory getInitialTargetDirectory() {
            return this.initialTargetDirectory;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @Nullable
        public final KtElement component2() {
            return this.singleElementToCopy;
        }

        @NotNull
        public final List<KtElement> component3() {
            return this.elementsToCopy;
        }

        @NotNull
        public final KtFile component4() {
            return this.originalFile;
        }

        @NotNull
        public final PsiDirectory component5() {
            return this.initialTargetDirectory;
        }

        @NotNull
        public final SourceData copy(@NotNull Project project, @Nullable KtElement singleElementToCopy, @NotNull List<? extends KtElement> elementsToCopy, @NotNull KtFile originalFile, @NotNull PsiDirectory initialTargetDirectory) {
            return new SourceData(project, singleElementToCopy, elementsToCopy, originalFile, initialTargetDirectory);
        }

        public static /* synthetic */ SourceData copy$default(SourceData sourceData, Project project, KtElement ktElement, List list2, KtFile ktFile, PsiDirectory psiDirectory, int n, Object object) {
            if ((n & 1) != 0) {
                project = sourceData.project;
            }
            if ((n & 2) != 0) {
                ktElement = sourceData.singleElementToCopy;
            }
            if ((n & 4) != 0) {
                list2 = sourceData.elementsToCopy;
            }
            if ((n & 8) != 0) {
                ktFile = sourceData.originalFile;
            }
            if ((n & 0x10) != 0) {
                psiDirectory = sourceData.initialTargetDirectory;
            }
            return sourceData.copy(project, ktElement, list2, ktFile, psiDirectory);
        }

        @NotNull
        public String toString() {
            return "SourceData(project=" + this.project + ", singleElementToCopy=" + this.singleElementToCopy + ", elementsToCopy=" + this.elementsToCopy + ", originalFile=" + this.originalFile + ", initialTargetDirectory=" + this.initialTargetDirectory + ")";
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + (this.singleElementToCopy == null ? 0 : this.singleElementToCopy.hashCode());
            result2 = result2 * 31 + ((Object)this.elementsToCopy).hashCode();
            result2 = result2 * 31 + this.originalFile.hashCode();
            result2 = result2 * 31 + this.initialTargetDirectory.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceData)) {
                return false;
            }
            SourceData sourceData = (SourceData)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)sourceData.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.singleElementToCopy, (Object)sourceData.singleElementToCopy)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.elementsToCopy, sourceData.elementsToCopy)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.originalFile, (Object)sourceData.originalFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.initialTargetDirectory, (Object)sourceData.initialTargetDirectory);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$RefactoringResult;", "", "targetFile", "Lcom/intellij/psi/PsiFile;", "copiedDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "restoredInternalUsages", "", "Lcom/intellij/usageView/UsageInfo;", "(Lcom/intellij/psi/PsiFile;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Ljava/util/List;)V", "getCopiedDeclaration", "()Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getRestoredInternalUsages", "()Ljava/util/List;", "getTargetFile", "()Lcom/intellij/psi/PsiFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    private static final class RefactoringResult {
        @NotNull
        private final PsiFile targetFile;
        @Nullable
        private final KtNamedDeclaration copiedDeclaration;
        @Nullable
        private final List<UsageInfo> restoredInternalUsages;

        public RefactoringResult(@NotNull PsiFile targetFile, @Nullable KtNamedDeclaration copiedDeclaration, @Nullable List<? extends UsageInfo> restoredInternalUsages) {
            this.targetFile = targetFile;
            this.copiedDeclaration = copiedDeclaration;
            this.restoredInternalUsages = restoredInternalUsages;
        }

        public /* synthetic */ RefactoringResult(PsiFile psiFile2, KtNamedDeclaration ktNamedDeclaration, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = null;
            }
            this(psiFile2, ktNamedDeclaration, list2);
        }

        @NotNull
        public final PsiFile getTargetFile() {
            return this.targetFile;
        }

        @Nullable
        public final KtNamedDeclaration getCopiedDeclaration() {
            return this.copiedDeclaration;
        }

        @Nullable
        public final List<UsageInfo> getRestoredInternalUsages() {
            return this.restoredInternalUsages;
        }

        @NotNull
        public final PsiFile component1() {
            return this.targetFile;
        }

        @Nullable
        public final KtNamedDeclaration component2() {
            return this.copiedDeclaration;
        }

        @Nullable
        public final List<UsageInfo> component3() {
            return this.restoredInternalUsages;
        }

        @NotNull
        public final RefactoringResult copy(@NotNull PsiFile targetFile, @Nullable KtNamedDeclaration copiedDeclaration, @Nullable List<? extends UsageInfo> restoredInternalUsages) {
            return new RefactoringResult(targetFile, copiedDeclaration, restoredInternalUsages);
        }

        public static /* synthetic */ RefactoringResult copy$default(RefactoringResult refactoringResult, PsiFile psiFile2, KtNamedDeclaration ktNamedDeclaration, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                psiFile2 = refactoringResult.targetFile;
            }
            if ((n & 2) != 0) {
                ktNamedDeclaration = refactoringResult.copiedDeclaration;
            }
            if ((n & 4) != 0) {
                list2 = refactoringResult.restoredInternalUsages;
            }
            return refactoringResult.copy(psiFile2, ktNamedDeclaration, list2);
        }

        @NotNull
        public String toString() {
            return "RefactoringResult(targetFile=" + this.targetFile + ", copiedDeclaration=" + this.copiedDeclaration + ", restoredInternalUsages=" + this.restoredInternalUsages + ")";
        }

        public int hashCode() {
            int result2 = this.targetFile.hashCode();
            result2 = result2 * 31 + (this.copiedDeclaration == null ? 0 : this.copiedDeclaration.hashCode());
            result2 = result2 * 31 + (this.restoredInternalUsages == null ? 0 : ((Object)this.restoredInternalUsages).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RefactoringResult)) {
                return false;
            }
            RefactoringResult refactoringResult = (RefactoringResult)other;
            if (!Intrinsics.areEqual((Object)this.targetFile, (Object)refactoringResult.targetFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.copiedDeclaration, (Object)refactoringResult.copiedDeclaration)) {
                return false;
            }
            return Intrinsics.areEqual(this.restoredInternalUsages, refactoringResult.restoredInternalUsages);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExistingFilePolicy.values().length];
            try {
                nArray[ExistingFilePolicy.APPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExistingFilePolicy.OVERWRITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExistingFilePolicy.SKIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

