/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.CallerUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.MethodCallUsageInfo;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoringKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignatureUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeInfoKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfoKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVar;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinByConventionCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinCallableDefinitionUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinCallerUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinFunctionCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinParameterUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinPropertyCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinWrapperForJavaUsageInfos;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinWrapperForPropertyInheritorsUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinWrapperForPropertyInheritorsUsageKt;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameConflictUtilsKt;
import org.jetbrains.kotlin.idea.util.ExtensionUtils;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fJ\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J-\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010\u001eH\u0002J\u001b\u0010(\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010+\u001a\u00020\u00102\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010&\u001a\u00020\u0012H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0018\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConflictSearcher;", "", "originalInfo", "Lcom/intellij/refactoring/changeSignature/ChangeInfo;", "refUsages", "Lcom/intellij/openapi/util/Ref;", "", "Lcom/intellij/usageView/UsageInfo;", "(Lcom/intellij/refactoring/changeSignature/ChangeInfo;Lcom/intellij/openapi/util/Ref;)V", "changeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeInfo;", "result", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "checkParametersToDelete", "", "callableDeclaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "toRemove", "", "doFindConflicts", "findConflicts", "findConflictsInJavaUsages", "wrapper", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/usages/KotlinWrapperForJavaUsageInfos;", "findInternalExplicitReceiverConflicts", "function", "usages", "originalReceiverInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinParameterInfo;", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;[Lcom/intellij/usageView/UsageInfo;Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinParameterInfo;)V", "findParameterDuplicationInCaller", "caller", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "callerDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findReceiverIntroducingConflicts", "callable", "newReceiverInfo", "findReceiverToParameterInSafeCallsConflicts", "([Lcom/intellij/usageView/UsageInfo;)V", "findReceiverUsages", "findThisLabelConflicts", "getOverriderOrCaller", "Lcom/intellij/psi/PsiMethod;", "usage", "registerConflictIfUsed", "element", "Lcom/intellij/psi/PsiNamedElement;", "scope", "Lcom/intellij/psi/search/LocalSearchScope;", "kotlin.idea"})
public final class KotlinChangeSignatureConflictSearcher {
    @NotNull
    private final ChangeInfo originalInfo;
    @NotNull
    private final Ref<UsageInfo[]> refUsages;
    private KotlinChangeInfo changeInfo;
    @NotNull
    private final MultiMap<PsiElement, String> result;

    public KotlinChangeSignatureConflictSearcher(@NotNull ChangeInfo originalInfo, @NotNull Ref<UsageInfo[]> refUsages) {
        this.originalInfo = originalInfo;
        this.refUsages = refUsages;
        this.result = new MultiMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MultiMap<PsiElement, String> findConflicts() {
        void $this$filterNotTo$iv$iv;
        UsageInfo[] usageInfos;
        UsageInfo[] $this$filterNot$iv = usageInfos = (UsageInfo[])this.refUsages.get();
        boolean $i$f$filterNot = false;
        UsageInfo[] usageInfoArray = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        int n = ((void)$this$filterNotTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterNotTo$iv$iv[j];
            boolean bl = false;
            if (this.getOverriderOrCaller(KotlinWrapperForPropertyInheritorsUsageKt.getUnwrapped((UsageInfo)it)) instanceof KtLightMethod) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List adjustedUsages = (List)destination$iv$iv;
        if (adjustedUsages.size() < usageInfos.length) {
            Collection $this$toTypedArray$iv = adjustedUsages;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.refUsages.set((Object)thisCollection$iv.toArray(new UsageInfo[0]));
        }
        KotlinChangeInfo kotlinChangeInfo = ChangeSignatureUtilsKt.getAsKotlinChangeInfo(this.originalInfo);
        if (kotlinChangeInfo == null) {
            return this.result;
        }
        this.changeInfo = kotlinChangeInfo;
        this.doFindConflicts();
        return this.result;
    }

    /*
     * WARNING - void declaration
     */
    private final void doFindConflicts() {
        KotlinChangeInfo kotlinChangeInfo;
        KotlinChangeInfo kotlinChangeInfo2;
        Object object;
        KotlinMethodDescriptor.Kind kind2;
        LexicalScope lexicalScope;
        DeclarationDescriptor descriptor2;
        PsiElement function2;
        HashSet<String> parameterNames;
        block37: {
            BindingContext bindingContext2;
            block34: {
                ClassId classId;
                block36: {
                    DeclarationDescriptor containingDeclaration2;
                    block35: {
                        parameterNames = new HashSet<String>();
                        KotlinChangeInfo kotlinChangeInfo3 = this.changeInfo;
                        if (kotlinChangeInfo3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
                            kotlinChangeInfo3 = null;
                        }
                        function2 = kotlinChangeInfo3.getMethod();
                        Intrinsics.checkNotNull((Object)function2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                        bindingContext2 = ResolutionUtils.analyze((KtElement)function2, BodyResolveMode.FULL);
                        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)function2);
                        if (declarationDescriptor == null) {
                            KotlinChangeInfo kotlinChangeInfo4 = this.changeInfo;
                            if (kotlinChangeInfo4 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
                                kotlinChangeInfo4 = null;
                            }
                            declarationDescriptor = (DeclarationDescriptor)KotlinChangeInfoKt.getOriginalBaseFunctionDescriptor(kotlinChangeInfo4);
                        }
                        descriptor2 = declarationDescriptor;
                        containingDeclaration2 = descriptor2.getContainingDeclaration();
                        if (!(descriptor2 instanceof ConstructorDescriptor) || !(containingDeclaration2 instanceof ClassDescriptorWithResolutionScopes)) break block34;
                        classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassifierDescriptor)containingDeclaration2));
                        if (classId == null) break block35;
                        ClassId it = classId;
                        boolean bl = false;
                        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)ResolutionUtils.findModuleDescriptor((KtElement)function2), (ClassId)it);
                        ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor instanceof ClassDescriptorWithResolutionScopes ? (ClassDescriptorWithResolutionScopes)classDescriptor : null;
                        classId = classDescriptorWithResolutionScopes;
                        if (classDescriptorWithResolutionScopes != null) break block36;
                    }
                    classId = (ClassDescriptorWithResolutionScopes)containingDeclaration2;
                }
                ClassId classDescriptor = classId;
                lexicalScope = classDescriptor.getScopeForInitializerResolution();
                break block37;
            }
            lexicalScope = function2 instanceof KtFunction ? CallableRefactoringKt.getBodyScope((KtDeclarationWithBody)function2, bindingContext2) : null;
        }
        LexicalScope parametersScope = lexicalScope;
        LexicalScope callableScope = CallableRefactoringKt.getContainingScope(descriptor2);
        KotlinChangeInfo kotlinChangeInfo5 = this.changeInfo;
        if (kotlinChangeInfo5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
            kotlinChangeInfo5 = null;
        }
        if (!(kind2 = KotlinChangeInfoKt.getKind(kotlinChangeInfo5)).isConstructor() && callableScope != null) {
            KotlinChangeInfo kotlinChangeInfo6 = this.changeInfo;
            if (kotlinChangeInfo6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
                kotlinChangeInfo6 = null;
            }
            if (((CharSequence)kotlinChangeInfo6.getNewName()).length() > 0) {
                Collection collection;
                void $this$mapTo$iv$iv;
                KotlinChangeInfo kotlinChangeInfo7 = this.changeInfo;
                if (kotlinChangeInfo7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
                    kotlinChangeInfo7 = null;
                }
                Name newName2 = Name.identifier((String)kotlinChangeInfo7.getNewName());
                Collection<Object> conflicts2 = descriptor2 instanceof FunctionDescriptor ? ScopeUtils.getAllAccessibleFunctions(callableScope, newName2) : ScopeUtils.getAllAccessibleVariables(callableScope, newName2);
                KotlinChangeInfo kotlinChangeInfo8 = this.changeInfo;
                if (kotlinChangeInfo8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
                    kotlinChangeInfo8 = null;
                }
                Object $this$map$iv = kotlinChangeInfo8.getNewParameters();
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((KotlinParameterInfo[])$this$map$iv).length);
                boolean $i$f$mapTo2 = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void item$iv$iv;
                    void var20_35 = item$iv$iv = $this$mapTo$iv$iv[j];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getCurrentTypeInfo().getType());
                }
                List newTypes = (List)destination$iv$iv;
                $this$map$iv = conflicts2.iterator();
                while ($this$map$iv.hasNext()) {
                    void $this$mapTo$iv$iv2;
                    Object[] $this$map$iv2;
                    CallableDescriptor conflict = (CallableDescriptor)$this$map$iv.next();
                    if (conflict == descriptor2) continue;
                    PsiElement conflictElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)conflict));
                    KotlinChangeInfo kotlinChangeInfo9 = this.changeInfo;
                    if (kotlinChangeInfo9 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
                        kotlinChangeInfo9 = null;
                    }
                    if (conflictElement == kotlinChangeInfo9.getMethod()) continue;
                    ReceiverParameterDescriptor receiverParameterDescriptor = conflict.getExtensionReceiverParameter();
                    Iterable $i$f$mapTo2 = conflict.getValueParameters();
                    collection = CollectionsKt.listOfNotNull((Object)(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null));
                    boolean $i$f$map2 = false;
                    void var18_33 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl = false;
                        collection2.add(it.getType());
                    }
                    List candidateTypes = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
                    if (!Intrinsics.areEqual((Object)candidateTypes, (Object)newTypes)) continue;
                    $this$map$iv2 = new Object[]{DescriptorRenderer.SHORT_NAMES_IN_TYPES.render((DeclarationDescriptor)conflict)};
                    this.result.putValue((Object)conflictElement, (Object)KotlinBundle.message("text.function.already.exists", $this$map$iv2));
                    break;
                }
            }
        }
        if ((kotlinChangeInfo2 = this.changeInfo) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
            kotlinChangeInfo2 = null;
        }
        boolean[] parametersToRemove = kotlinChangeInfo2.getParametersToRemove();
        KotlinChangeInfo kotlinChangeInfo10 = this.changeInfo;
        if (kotlinChangeInfo10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
            kotlinChangeInfo10 = null;
        }
        if (kotlinChangeInfo10.getCheckUsedParameters() && function2 instanceof KtCallableDeclaration) {
            this.checkParametersToDelete((KtCallableDeclaration)function2, parametersToRemove);
        }
        if ((kotlinChangeInfo = this.changeInfo) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
            kotlinChangeInfo = null;
        }
        block3: for (KotlinParameterInfo parameter2 : kotlinChangeInfo.getNonReceiverParameters()) {
            KotlinValVar valOrVar = parameter2.getValOrVar();
            String parameterName2 = parameter2.getName();
            if (!parameterNames.add(parameterName2)) {
                object = new Object[]{parameterName2};
                this.result.putValue((Object)function2, (Object)KotlinBundle.message("text.duplicating.parameter", (Object[])object));
            }
            if (parametersScope == null) continue;
            if (kind2 == KotlinMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR && valOrVar != KotlinValVar.None) {
                for (VariableDescriptor property2 : ScopeUtils.getVariablesFromImplicitReceivers(parametersScope, Name.identifier((String)parameterName2))) {
                    PsiElement propertyDeclaration;
                    if (DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)property2)) == null || propertyDeclaration.getParent() instanceof KtParameterList) continue;
                    Object[] $i$f$map2 = new Object[]{parameterName2};
                    this.result.putValue((Object)propertyDeclaration, (Object)KotlinBundle.message("text.duplicating.property", $i$f$map2));
                    continue block3;
                }
                continue;
            }
            if (!(function2 instanceof KtFunction)) continue;
            for (VariableDescriptor variable2 : parametersScope.getContributedVariables(Name.identifier((String)parameterName2), (LookupLocation)NoLookupLocation.FROM_IDE)) {
                if (variable2 instanceof ValueParameterDescriptor) continue;
                PsiElement conflictElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)variable2));
                Object[] $i$f$map2 = new Object[]{parameterName2};
                this.result.putValue((Object)conflictElement, (Object)KotlinBundle.message("text.duplicating.local.variable", $i$f$map2));
            }
        }
        KotlinChangeInfo kotlinChangeInfo11 = this.changeInfo;
        if (kotlinChangeInfo11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
            kotlinChangeInfo11 = null;
        }
        KotlinParameterInfo newReceiverInfo = kotlinChangeInfo11.getReceiverParameterInfo();
        KotlinChangeInfo kotlinChangeInfo12 = this.changeInfo;
        if (kotlinChangeInfo12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
            kotlinChangeInfo12 = null;
        }
        KotlinParameterInfo originalReceiverInfo = kotlinChangeInfo12.getMethodDescriptor().getReceiver();
        if (function2 instanceof KtCallableDeclaration && !Intrinsics.areEqual((Object)newReceiverInfo, (Object)originalReceiverInfo)) {
            this.findReceiverIntroducingConflicts(function2, newReceiverInfo);
            this.findInternalExplicitReceiverConflicts((KtCallableDeclaration)function2, (UsageInfo[])this.refUsages.get(), originalReceiverInfo);
            this.findReceiverToParameterInSafeCallsConflicts((UsageInfo[])this.refUsages.get());
            this.findThisLabelConflicts(this.refUsages, (KtCallableDeclaration)function2);
        }
        for (UsageInfo usageInfo : (UsageInfo[])this.refUsages.get()) {
            UsageInfo usageInfo2 = usageInfo;
            if (usageInfo2 instanceof KotlinWrapperForPropertyInheritorsUsage) {
                KotlinChangeSignatureConflictSearcher.doFindConflicts$processUsageInfo(this, ((KotlinWrapperForPropertyInheritorsUsage)usageInfo).getOriginalUsageInfo());
                continue;
            }
            if (usageInfo2 instanceof KotlinWrapperForJavaUsageInfos) {
                this.findConflictsInJavaUsages((KotlinWrapperForJavaUsageInfos)usageInfo);
                continue;
            }
            if (usageInfo2 instanceof KotlinCallableDefinitionUsage) {
                KtCallableDeclaration declaration2;
                PsiElement psiElement2 = ((KotlinCallableDefinitionUsage)usageInfo).getDeclaration();
                if ((psiElement2 instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement2 : null) == null) continue;
                declaration2 = declaration2;
                KotlinChangeInfo kotlinChangeInfo13 = this.changeInfo;
                if (kotlinChangeInfo13 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
                    kotlinChangeInfo13 = null;
                }
                if (!kotlinChangeInfo13.getCheckUsedParameters()) continue;
                this.checkParametersToDelete(declaration2, parametersToRemove);
                continue;
            }
            KotlinChangeSignatureConflictSearcher.doFindConflicts$processUsageInfo(this, usageInfo);
        }
    }

    private final PsiMethod getOverriderOrCaller(UsageInfo usage) {
        if (usage instanceof OverriderUsageInfo) {
            return ((OverriderUsageInfo)usage).getOverridingMethod();
        }
        if (usage instanceof CallerUsageInfo) {
            PsiElement element3 = ((CallerUsageInfo)usage).getElement();
            return element3 instanceof PsiMethod ? (PsiMethod)element3 : null;
        }
        return null;
    }

    private final void checkParametersToDelete(KtCallableDeclaration callableDeclaration, boolean[] toRemove) {
        boolean hasReceiver;
        LocalSearchScope scope2 = new LocalSearchScope((PsiElement)callableDeclaration);
        List valueParameters2 = callableDeclaration.getValueParameters();
        boolean bl = hasReceiver = valueParameters2.size() != toRemove.length;
        if (hasReceiver && toRemove[0]) {
            this.findReceiverUsages(callableDeclaration);
        }
        Iterator iterator = valueParameters2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i2 = n++;
            KtParameter parameter2 = (KtParameter)iterator.next();
            int index = (hasReceiver ? 1 : 0) + i2;
            if (!toRemove[index]) continue;
            this.registerConflictIfUsed((PsiNamedElement)parameter2, scope2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findReceiverIntroducingConflicts(PsiElement callable2, KotlinParameterInfo newReceiverInfo) {
        block7: {
            PsiElement psiElement2;
            KtPsiFactory psiFactory;
            ArrayList<KtSimpleNameExpression> noReceiverRefs;
            BindingContext originalContext;
            block9: {
                block8: {
                    void $this$forEachDescendantOfType$iv;
                    if (newReceiverInfo == null || !(callable2 instanceof KtNamedFunction) || ((KtNamedFunction)callable2).getBodyExpression() == null) break block7;
                    originalContext = ResolutionUtils.analyzeWithContent((KtDeclaration)callable2);
                    noReceiverRefs = new ArrayList<KtSimpleNameExpression>();
                    PsiElement psiElement3 = callable2;
                    Function1 action$iv = (Function1)new Function1<KtSimpleNameExpression, Unit>(originalContext, noReceiverRefs){
                        final /* synthetic */ BindingContext $originalContext;
                        final /* synthetic */ ArrayList<KtSimpleNameExpression> $noReceiverRefs;
                        {
                            this.$originalContext = $originalContext;
                            this.$noReceiverRefs = $noReceiverRefs;
                            super(1);
                        }

                        public final void invoke(@NotNull KtSimpleNameExpression it) {
                            ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)it), (BindingContext)this.$originalContext);
                            if (resolvedCall2 == null) {
                                return;
                            }
                            ResolvedCall resolvedCall3 = resolvedCall2;
                            if (RenameConflictUtilsKt.noReceivers(resolvedCall3)) {
                                ((Collection)this.$noReceiverRefs).add(it);
                            }
                        }
                    };
                    boolean $i$f$forEachDescendantOfType = false;
                    void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
                    boolean $i$f$forEachDescendantOfType2 = false;
                    $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                        final /* synthetic */ Function1 $action;
                        {
                            this.$action = $action;
                        }

                        public void visitElement(@NotNull PsiElement element3) {
                            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                            PsiElement it = element3;
                            boolean bl = false;
                            super.visitElement(element3);
                            if (element3 instanceof KtSimpleNameExpression) {
                                this.$action.invoke((Object)element3);
                            }
                        }
                    });
                    psiFactory = new KtPsiFactory(((KtNamedFunction)callable2).getProject(), false, 2, null);
                    PsiFile psiFile2 = ((KtNamedFunction)callable2).getContainingFile();
                    Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    KtFile tempFile = KotlinRefactoringUtilKt.createTempCopy$default((KtFile)psiFile2, null, 1, null);
                    psiElement2 = tempFile.findElementAt(((KtNamedFunction)callable2).getTextOffset());
                    if (psiElement2 == null) break block8;
                    PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
                    boolean $i$f$getNonStrictParentOfType = false;
                    psiElement2 = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtNamedFunction.class, (boolean)false);
                    if (psiElement2 != null) break block9;
                }
                return;
            }
            PsiElement functionWithReceiver = psiElement2;
            KtTypeReference receiverTypeRef = psiFactory.createType(KotlinTypeInfoKt.render(newReceiverInfo.getCurrentTypeInfo()));
            TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)functionWithReceiver), (KtTypeReference)receiverTypeRef);
            KtExpression ktExpression = functionWithReceiver.getBodyExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            BindingContext newContext = ResolutionUtils.analyze((KtElement)ktExpression, BodyResolveMode.FULL);
            KtExpression ktExpression2 = ((KtNamedFunction)callable2).getBodyExpression();
            Intrinsics.checkNotNull((Object)ktExpression2);
            int originalOffset = ktExpression2.getTextOffset();
            KtExpression ktExpression3 = functionWithReceiver.getBodyExpression();
            if (ktExpression3 == null) {
                return;
            }
            KtExpression newBody = ktExpression3;
            for (KtSimpleNameExpression originalRef : noReceiverRefs) {
                PsiElement declaration2;
                KtReferenceExpression newRef;
                ResolvedCall newResolvedCall;
                KtReferenceExpression ktReferenceExpression;
                PsiElement psiElement4 = newBody.findElementAt(originalRef.getTextOffset() - originalOffset);
                if (psiElement4 != null) {
                    void $this$getNonStrictParentOfType$iv;
                    PsiElement psiElement5 = psiElement4;
                    boolean $i$f$getNonStrictParentOfType = false;
                    ktReferenceExpression = (KtReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtReferenceExpression.class, (boolean)false);
                } else {
                    ktReferenceExpression = null;
                }
                if ((newResolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)(newRef = ktReferenceExpression)), (BindingContext)newContext)) != null && newResolvedCall.getExtensionReceiver() == null && newResolvedCall.getDispatchReceiver() == null) continue;
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)originalRef), (BindingContext)originalContext);
                Intrinsics.checkNotNull((Object)resolvedCall2);
                CallableDescriptor descriptor2 = resolvedCall2.getCandidateDescriptor();
                PsiElement psiElement6 = declaration2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(((KtNamedFunction)callable2).getProject(), (DeclarationDescriptor)descriptor2);
                String prefix2 = psiElement6 != null ? RefactoringUIUtil.getDescription((PsiElement)psiElement6, (boolean)true) : originalRef.getText();
                Object[] objectArray = new Object[]{StringsKt.capitalize((String)prefix2)};
                this.result.putValue((Object)originalRef, (Object)KotlinBundle.message("text.0.will.no.longer.be.accessible.after.signature.change", objectArray));
            }
        }
    }

    private final void findInternalExplicitReceiverConflicts(KtCallableDeclaration function2, UsageInfo[] usages2, KotlinParameterInfo originalReceiverInfo) {
        if (originalReceiverInfo != null) {
            return;
        }
        boolean isObjectFunction = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)function2)) instanceof KtObjectDeclaration;
        for (UsageInfo usageInfo : usages2) {
            KtElement ktElement;
            KtElement callElement2;
            PsiElement psiElement2;
            if (!(usageInfo instanceof KotlinFunctionCallUsage) && !(usageInfo instanceof KotlinPropertyCallUsage) && !(usageInfo instanceof KotlinByConventionCallUsage) || ((psiElement2 = usageInfo.getElement()) instanceof KtElement ? (KtElement)psiElement2 : null) == null) continue;
            callElement2 = callElement2;
            PsiElement parent2 = callElement2.getParent();
            if (usageInfo instanceof KotlinByConventionCallUsage) {
                ktElement = callElement2;
            } else {
                if (!(parent2 instanceof KtQualifiedExpression) || ((KtQualifiedExpression)parent2).getSelectorExpression() != callElement2 || isObjectFunction) continue;
                ktElement = (KtElement)parent2;
            }
            KtElement elementToReport = ktElement;
            Object[] objectArray = new Object[]{CommonRefactoringUtil.htmlEmphasize((String)elementToReport.getText())};
            String message2 = KotlinBundle.message("text.explicit.receiver.is.already.present.in.call.element.0", objectArray);
            this.result.putValue((Object)callElement2, (Object)message2);
        }
    }

    private final void findReceiverToParameterInSafeCallsConflicts(UsageInfo[] usages2) {
        block7: {
            block6: {
                KotlinParameterInfo originalReceiverInfo;
                KotlinChangeInfo kotlinChangeInfo = this.changeInfo;
                if (kotlinChangeInfo == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
                    kotlinChangeInfo = null;
                }
                if ((originalReceiverInfo = kotlinChangeInfo.getMethodDescriptor().getReceiver()) == null) break block6;
                KotlinChangeInfo kotlinChangeInfo2 = this.changeInfo;
                if (kotlinChangeInfo2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
                    kotlinChangeInfo2 = null;
                }
                if (kotlinChangeInfo2.getNonReceiverParameters().contains(originalReceiverInfo)) break block7;
            }
            return;
        }
        for (UsageInfo usageInfo : usages2) {
            KtElement callElement2;
            KtQualifiedExpression qualifiedExpression;
            if (!(usageInfo instanceof KotlinFunctionCallUsage) && !(usageInfo instanceof KotlinPropertyCallUsage)) continue;
            Object[] objectArray = usageInfo.getElement();
            KtElement ktElement = objectArray instanceof KtElement ? (KtElement)objectArray : null;
            if (ktElement == null || !((qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)(callElement2 = ktElement))) instanceof KtSafeQualifiedExpression)) continue;
            objectArray = new Object[]{CommonRefactoringUtil.htmlEmphasize((String)((KtSafeQualifiedExpression)qualifiedExpression).getText())};
            this.result.putValue((Object)callElement2, (Object)KotlinBundle.message("text.receiver.can.t.be.safely.transformed.to.value.argument", objectArray));
        }
    }

    private final void findThisLabelConflicts(Ref<UsageInfo[]> refUsages, KtCallableDeclaration callable2) {
        KtPsiFactory psiFactory = new KtPsiFactory(callable2.getProject(), false, 2, null);
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            PsiElement thisTargetPsi;
            KtExpression originalExpr;
            Object t;
            String newExprText;
            if (!(usageInfo instanceof KotlinParameterUsage)) continue;
            KotlinParameterUsage kotlinParameterUsage = (KotlinParameterUsage)usageInfo;
            KotlinChangeInfo kotlinChangeInfo = this.changeInfo;
            if (kotlinChangeInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
                kotlinChangeInfo = null;
            }
            if (!StringsKt.startsWith$default((String)(newExprText = kotlinParameterUsage.getReplacementText(kotlinChangeInfo)), (String)"this", (boolean)false, (int)2, null) || ((KotlinParameterUsage)usageInfo).getElement() instanceof KDocName || ((t = ((KotlinParameterUsage)usageInfo).getElement()) instanceof KtExpression ? (KtExpression)t : null) == null) continue;
            originalExpr = originalExpr;
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)originalExpr, BodyResolveMode.FULL);
            LexicalScope scope2 = ScopeUtils.getResolutionScope((PsiElement)originalExpr, bindingContext2, ResolutionUtils.getResolutionFacade((KtElement)originalExpr));
            KtExpression ktExpression = psiFactory.createExpression(newExprText);
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThisExpression");
            KtThisExpression newExpr = (KtThisExpression)ktExpression;
            BindingContext newContext = ExtendedResolutionApiKt.analyzeInContext$default((KtExpression)newExpr, scope2, originalExpr, null, null, null, false, null, null, 252, null);
            KtSimpleNameExpression labelExpr = newExpr.getTargetLabel();
            if (labelExpr != null && newContext.get((ReadOnlySlice)BindingContext.AMBIGUOUS_LABEL_TARGET, (Object)labelExpr) != null) {
                Object[] objectArray = new Object[]{newExprText, labelExpr.getText()};
                this.result.putValue((Object)originalExpr, (Object)KotlinBundle.message("text.parameter.reference.can.t.be.safely.replaced.with.0.since.1.is.ambiguous.in.this.context", objectArray));
                continue;
            }
            DeclarationDescriptor thisTarget = (DeclarationDescriptor)newContext.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)newExpr.getInstanceReference());
            DeclarationDescriptorWithSource declarationDescriptorWithSource = thisTarget instanceof DeclarationDescriptorWithSource ? (DeclarationDescriptorWithSource)thisTarget : null;
            PsiElement psiElement2 = declarationDescriptorWithSource != null && (declarationDescriptorWithSource = declarationDescriptorWithSource.getSource()) != null ? PsiSourceElementKt.getPsi((SourceElement)declarationDescriptorWithSource) : (thisTargetPsi = null);
            if (thisTargetPsi == null || !PsiUtilsKt.isAncestor((PsiElement)((PsiElement)callable2), (PsiElement)thisTargetPsi, (boolean)true)) continue;
            Object[] objectArray = new Object[]{newExprText};
            this.result.putValue((Object)originalExpr, (Object)KotlinBundle.message("text.parameter.reference.can.t.be.safely.replaced.with.0.since.target.function.can.t.be.referenced.in.this.context", objectArray));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findParameterDuplicationInCaller(KtNamedDeclaration caller, DeclarationDescriptor callerDescriptor) {
        void $this$associateByTo$iv$iv;
        List valueParameters2 = KtPsiUtilKt.getValueParameters((KtNamedDeclaration)caller);
        Iterable $this$associateBy$iv = valueParameters2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KtParameter ktParameter = (KtParameter)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getName(), element$iv$iv);
        }
        Map existingParameters = destination$iv$iv;
        String signature2 = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.render(callerDescriptor);
        KotlinChangeInfo kotlinChangeInfo = this.changeInfo;
        if (kotlinChangeInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeInfo");
            kotlinChangeInfo = null;
        }
        for (KotlinParameterInfo parameterInfo : kotlinChangeInfo.getNonReceiverParameters()) {
            KtParameter parameter2;
            String name2;
            if (!parameterInfo.isNewParameter() || (KtParameter)existingParameters.get(name2 = parameterInfo.getName()) == null) continue;
            Object[] objectArray = new Object[]{name2, signature2};
            this.result.putValue((Object)parameter2, (Object)KotlinBundle.message("text.there.is.already.a.parameter", objectArray));
        }
    }

    private final void findConflictsInJavaUsages(KotlinWrapperForJavaUsageInfos wrapper) {
        boolean bl;
        boolean hasDefaultValue;
        boolean[] parametersToRemove;
        UsageInfo[] javaUsageInfos;
        JavaChangeInfo javaChangeInfo;
        KotlinChangeInfo kotlinChangeInfo;
        block7: {
            boolean bl2;
            int n;
            block6: {
                kotlinChangeInfo = wrapper.getKotlinChangeInfo();
                javaChangeInfo = wrapper.getJavaChangeInfo();
                javaUsageInfos = wrapper.getJavaUsageInfos();
                parametersToRemove = javaChangeInfo.toRemoveParm();
                JavaParameterInfo[] $this$any$iv = javaChangeInfo.getNewParameters();
                boolean $i$f$any = false;
                n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    JavaParameterInfo element$iv;
                    JavaParameterInfo it = element$iv = $this$any$iv[j];
                    boolean bl3 = false;
                    CharSequence charSequence2 = it.getDefaultValue();
                    boolean bl4 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2));
                    if (!bl4) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
            hasDefaultValue = bl2;
            KotlinParameterInfo[] $this$any$iv = kotlinChangeInfo.getNewParameters();
            boolean $i$f$any = false;
            int n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                KotlinParameterInfo element$iv;
                KotlinParameterInfo it = element$iv = $this$any$iv[n];
                boolean bl5 = false;
                if (!it.getDefaultValueAsDefaultParameter()) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        boolean hasDefaultParameter = bl;
        for (UsageInfo javaUsage : javaUsageInfos) {
            String string2;
            UsageInfo usageInfo = javaUsage;
            if (usageInfo instanceof OverriderUsageInfo) {
                if (!kotlinChangeInfo.getCheckUsedParameters()) continue;
                PsiMethod javaMethod = ((OverriderUsageInfo)javaUsage).getOverridingMethod();
                PsiMethod baseMethod = ((OverriderUsageInfo)javaUsage).getBaseMethod();
                if (!Intrinsics.areEqual((Object)baseMethod, (Object)javaChangeInfo.getMethod())) continue;
                JavaChangeSignatureUsageProcessor.ConflictSearcher.checkParametersToDelete((PsiMethod)javaMethod, (boolean[])parametersToRemove, this.result);
                continue;
            }
            if (!(usageInfo instanceof MethodCallUsageInfo)) continue;
            if (hasDefaultValue) {
                string2 = KotlinBundle.message("change.signature.conflict.text.kotlin.default.value.in.non.kotlin.files", new Object[0]);
            } else {
                if (!hasDefaultParameter) continue;
                string2 = KotlinBundle.message("change.signature.conflict.text.kotlin.default.parameter.in.non.kotlin.files", new Object[0]);
            }
            String conflictMessage = string2;
            this.result.putValue((Object)((MethodCallUsageInfo)javaUsage).getElement(), (Object)conflictMessage);
        }
    }

    private final void findReceiverUsages(KtCallableDeclaration callableDeclaration) {
        Ref.BooleanRef hasUsage = new Ref.BooleanRef();
        callableDeclaration.accept((PsiElementVisitor)VisitorWrappersKt.referenceExpressionRecursiveVisitor((Function1)((Function1)new Function1<KtReferenceExpression, Unit>(hasUsage, callableDeclaration){
            final /* synthetic */ Ref.BooleanRef $hasUsage;
            final /* synthetic */ KtCallableDeclaration $callableDeclaration;
            {
                this.$hasUsage = $hasUsage;
                this.$callableDeclaration = $callableDeclaration;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtReferenceExpression referenceExpression) {
                List list2;
                if (this.$hasUsage.element) {
                    return;
                }
                BindingContext context2 = ResolutionUtils.analyze((KtElement)referenceExpression, BodyResolveMode.PARTIAL);
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)referenceExpression), (BindingContext)context2);
                if (resolvedCall2 == null) {
                    return;
                }
                ResolvedCall target2 = resolvedCall2;
                if (referenceExpression.getParent() instanceof KtThisExpression) {
                    CallableDescriptor callableDescriptor = target2.getResultingDescriptor();
                    list2 = CollectionsKt.listOfNotNull((Object)(callableDescriptor instanceof ReceiverParameterDescriptor ? (ReceiverParameterDescriptor)callableDescriptor : null));
                } else {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = ResolvedCallUtilKt.getImplicitReceivers((ResolvedCall)target2);
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        DeclarationDescriptor it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        ReceiverValue it = (ReceiverValue)element$iv$iv;
                        boolean bl2 = false;
                        if (ExtensionUtils.getReceiverTargetDescriptor(it, context2) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                }
                List descriptorsToCheck = list2;
                for (DeclarationDescriptor descriptor2 : descriptorsToCheck) {
                    PsiElement declaration2;
                    if (DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$callableDeclaration.getProject(), descriptor2) == null || !Intrinsics.areEqual((Object)declaration2, (Object)this.$callableDeclaration) && !Intrinsics.areEqual((Object)declaration2, (Object)this.$callableDeclaration.getReceiverTypeReference())) continue;
                    this.$hasUsage.element = true;
                    return;
                }
            }
        })));
        if (hasUsage.element) {
            Object[] objectArray = new Object[]{KotlinBundle.message("text.receiver", new Object[0])};
            this.result.putValue((Object)callableDeclaration.getReceiverTypeReference(), (Object)KotlinBundle.message("parameter.used.in.declaration.body.warning", objectArray));
        }
    }

    private final void registerConflictIfUsed(PsiNamedElement element3, LocalSearchScope scope2) {
        if (ReferencesSearch.search((PsiElement)((PsiElement)element3), (SearchScope)((SearchScope)scope2)).findFirst() != null) {
            Object[] objectArray = new Object[]{String.valueOf(element3.getName())};
            this.result.putValue((Object)element3, (Object)KotlinBundle.message("parameter.used.in.declaration.body.warning", objectArray));
        }
    }

    private static final void doFindConflicts$processUsageInfo(KotlinChangeSignatureConflictSearcher this$0, UsageInfo usageInfo) {
        if (usageInfo instanceof KotlinCallerUsage) {
            KtNamedDeclaration namedDeclaration = (KtNamedDeclaration)((KotlinCallerUsage)usageInfo).getElement();
            KtNamedDeclaration ktNamedDeclaration = namedDeclaration;
            if (ktNamedDeclaration == null || (ktNamedDeclaration = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)ktNamedDeclaration, null, 1, null)) == null) {
                return;
            }
            KtNamedDeclaration callerDescriptor = ktNamedDeclaration;
            this$0.findParameterDuplicationInCaller(namedDeclaration, (DeclarationDescriptor)callerDescriptor);
        }
    }
}

