/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.RenderingUtilsKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\bH\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r\u001a\u001e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u001a\u001e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u001a\u0016\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"FUNCTION_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "formatClass", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "formatClassDescriptor", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "formatFunctionDescriptor", "functionDescriptor", "formatJavaOrLightMethod", "method", "Lcom/intellij/psi/PsiMethod;", "formatPsiClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "markAsJava", "", "inCode", "formatPsiMethod", "psiMethod", "showContainingClass", "wrapOrSkip", "s", "kotlin.idea"})
public final class RenderingUtilsKt {
    @NotNull
    private static final DescriptorRenderer FUNCTION_RENDERER = DescriptorRenderer.Companion.withOptions((Function1)FUNCTION_RENDERER.1.INSTANCE);

    @NotNull
    public static final String wrapOrSkip(@NotNull String s, boolean inCode) {
        return inCode ? "<code>" + s + "</code>" : s;
    }

    @NotNull
    public static final String formatClassDescriptor(@NotNull DeclarationDescriptor classDescriptor) {
        return IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.render(classDescriptor);
    }

    @NotNull
    public static final String formatPsiClass(@NotNull PsiClass psiClass, boolean markAsJava, boolean inCode) {
        Object description2 = null;
        String kind2 = psiClass.isInterface() ? "interface " : "class ";
        description2 = kind2 + PsiFormatUtil.formatClass((PsiClass)psiClass, (int)4355);
        description2 = RenderingUtilsKt.wrapOrSkip((String)description2, inCode);
        return markAsJava ? "[Java] " + (String)description2 : description2;
    }

    private static final String formatFunctionDescriptor(DeclarationDescriptor functionDescriptor2) {
        return FUNCTION_RENDERER.render(functionDescriptor2);
    }

    @NotNull
    public static final String formatPsiMethod(@NotNull PsiMethod psiMethod, boolean showContainingClass, boolean inCode) {
        int options2 = 259;
        if (showContainingClass) {
            options2 |= 0x1000;
        }
        String description2 = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options2, (int)2);
        description2 = RenderingUtilsKt.wrapOrSkip(description2, inCode);
        return "[Java] " + description2;
    }

    @NotNull
    public static final String formatJavaOrLightMethod(@NotNull PsiMethod method) {
        PsiElement originalDeclaration = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)method));
        return originalDeclaration instanceof KtDeclaration ? RenderingUtilsKt.formatFunctionDescriptor(ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)originalDeclaration, null, 1, null)) : RenderingUtilsKt.formatPsiMethod(method, false, false);
    }

    @NotNull
    public static final String formatClass(@NotNull KtClassOrObject classOrObject) {
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)classOrObject, null, 1, null);
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        return RenderingUtilsKt.formatClassDescriptor((DeclarationDescriptor)((ClassDescriptor)declarationDescriptor));
    }
}

