/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.ElementRenderingUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.ElementSelectionUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.IntroduceRefactoringException;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilKt;
import org.jetbrains.kotlin.idea.util.ElementKind;
import org.jetbrains.kotlin.idea.util.FindElementUtils;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a2\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a6\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\b\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u001a.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\u0002\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0019\u001a\u00020\b\u001aB\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0014\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u001b0\u001f\u001a4\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u001b0\u001f\u001aL\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0014\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u001b0\u001fH\u0002\u00a8\u0006!"}, d2={"findElement", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startOffset", "", "endOffset", "failOnNoExpression", "", "elementKind", "Lorg/jetbrains/kotlin/idea/util/ElementKind;", "findElementAtRange", "selectionStart", "selectionEnd", "elementKinds", "", "failOnEmptySuggestion", "getExpressionShortText", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getSmartSelectSuggestions", "", "Lcom/intellij/psi/PsiFile;", "offset", "isOriginalOffset", "selectElement", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "callback", "Lkotlin/Function1;", "smartSelectElement", "kotlin.idea"})
public final class ElementSelectionUtilsKt {
    public static final void selectElement(@NotNull Editor editor2, @NotNull KtFile file2, @NotNull ElementKind elementKind, @NotNull Function1<? super PsiElement, Unit> callback2) {
        ElementSelectionUtilsKt.selectElement(editor2, file2, true, CollectionsKt.listOf((Object)((Object)elementKind)), callback2);
    }

    public static final void selectElement(@NotNull Editor editor2, @NotNull KtFile file2, boolean failOnEmptySuggestion, @NotNull Collection<? extends ElementKind> elementKinds, @NotNull Function1<? super PsiElement, Unit> callback2) {
        if (editor2.getSelectionModel().hasSelection()) {
            int selectionStart = editor2.getSelectionModel().getSelectionStart();
            int selectionEnd = editor2.getSelectionModel().getSelectionEnd();
            PsiElement element3 = ElementSelectionUtilsKt.findElementAtRange(file2, selectionStart, selectionEnd, elementKinds, failOnEmptySuggestion);
            callback2.invoke((Object)element3);
        } else {
            int offset2 = editor2.getCaretModel().getOffset();
            ElementSelectionUtilsKt.smartSelectElement(editor2, (PsiFile)file2, offset2, failOnEmptySuggestion, elementKinds, callback2);
        }
    }

    @Nullable
    public static final PsiElement findElementAtRange(@NotNull KtFile file2, int selectionStart, int selectionEnd, @NotNull Collection<? extends ElementKind> elementKinds, boolean failOnEmptySuggestion) {
        Ref.IntRef adjustedStart = new Ref.IntRef();
        adjustedStart.element = selectionStart;
        Ref.IntRef adjustedEnd = new Ref.IntRef();
        adjustedEnd.element = selectionEnd;
        PsiElement psiElement2 = file2.findElementAt(adjustedStart.element);
        Intrinsics.checkNotNull((Object)psiElement2);
        PsiElement firstElement = psiElement2;
        PsiElement psiElement3 = file2.findElementAt(adjustedEnd.element - 1);
        Intrinsics.checkNotNull((Object)psiElement3);
        PsiElement lastElement = psiElement3;
        Class[] classArray = new Class[]{KtLiteralStringTemplateEntry.class, KtEscapeStringTemplateEntry.class};
        if (PsiTreeUtil.getParentOfType((PsiElement)firstElement, (Class[])classArray) == null) {
            classArray = new Class[]{KtLiteralStringTemplateEntry.class, KtEscapeStringTemplateEntry.class};
            if (PsiTreeUtil.getParentOfType((PsiElement)lastElement, (Class[])classArray) == null) {
                PsiElement psiElement4 = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments((PsiElement)firstElement, (boolean)true);
                Intrinsics.checkNotNull((Object)psiElement4);
                firstElement = psiElement4;
                PsiElement psiElement5 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments((PsiElement)lastElement, (boolean)true);
                Intrinsics.checkNotNull((Object)psiElement5);
                lastElement = psiElement5;
                adjustedStart.element = firstElement.getTextRange().getStartOffset();
                adjustedEnd.element = lastElement.getTextRange().getEndOffset();
            }
        }
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)elementKinds), (Function1)((Function1)new Function1<ElementKind, PsiElement>(file2, adjustedStart, adjustedEnd, failOnEmptySuggestion){
            final /* synthetic */ KtFile $file;
            final /* synthetic */ Ref.IntRef $adjustedStart;
            final /* synthetic */ Ref.IntRef $adjustedEnd;
            final /* synthetic */ boolean $failOnEmptySuggestion;
            {
                this.$file = $file;
                this.$adjustedStart = $adjustedStart;
                this.$adjustedEnd = $adjustedEnd;
                this.$failOnEmptySuggestion = $failOnEmptySuggestion;
                super(1);
            }

            @Nullable
            public final PsiElement invoke(@NotNull ElementKind it) {
                return ElementSelectionUtilsKt.access$findElement(this.$file, this.$adjustedStart.element, this.$adjustedEnd.element, this.$failOnEmptySuggestion, it);
            }
        })));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final List<KtElement> getSmartSelectSuggestions(@NotNull PsiFile file, int offset, @NotNull ElementKind elementKind, boolean isOriginalOffset) {
        block28: {
            block26: {
                block27: {
                    if (offset < 0) {
                        return CollectionsKt.emptyList();
                    }
                    v0 = file.findElementAt(offset);
                    if (v0 == null) {
                        return CollectionsKt.emptyList();
                    }
                    element = v0;
                    if (element instanceof PsiWhiteSpace) break block26;
                    if (!isOriginalOffset) break block27;
                    v1 = element.getNode();
                    if (Intrinsics.areEqual((Object)(v1 != null ? v1.getElementType() : null), (Object)KtTokens.RPAR)) break block26;
                }
                if (element instanceof PsiComment) break block26;
                $this$getStrictParentOfType$iv = element;
                $i$f$getStrictParentOfType = false;
                if ((KDoc)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KDoc.class, (boolean)true) == null) break block28;
            }
            return ElementSelectionUtilsKt.getSmartSelectSuggestions(file, offset - 1, elementKind, false);
        }
        elements = new ArrayList<KtElement>();
        while (!(element == null || element instanceof KtBlockExpression && !(((KtBlockExpression)element).getParent() instanceof KtFunctionLiteral) || element instanceof KtNamedFunction || element instanceof KtClassBody)) {
            block30: {
                block29: {
                    addElement = false;
                    keepPrevious = true;
                    if (!(element instanceof KtTypeElement)) break block29;
                    if (elementKind != ElementKind.TYPE_ELEMENT) ** GOTO lbl-1000
                    var8_9 = element;
                    var9_10 = true;
                    branch$iv = getSmartSelectSuggestions.1.INSTANCE;
                    $i$f$getParentOfTypeAndBranch = false;
                    $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch$iv;
                    $i$f$getParentOfType = false;
                    v2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtUserType.class, (boolean)strict$iv);
                    if ((v2 != null ? PsiUtilsKt.getIfChildIsInBranch((PsiElement)v2, (PsiElement)$this$getParentOfTypeAndBranch$iv, (Function1)branch$iv) : null) == null) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = addElement = false;
                    }
                    if (!addElement) {
                        keepPrevious = false;
                    }
                    break block30;
                }
                if (element instanceof KtExpression && !(element instanceof KtStatementExpression)) {
                    v4 = addElement = elementKind == ElementKind.EXPRESSION;
                    if (addElement) {
                        if (element instanceof KtParenthesizedExpression) {
                            addElement = false;
                        } else if (KtPsiUtil.isLabelIdentifierExpression((PsiElement)element)) {
                            addElement = false;
                        } else if (((KtExpression)element).getParent() instanceof KtQualifiedExpression) {
                            v5 = ((KtExpression)element).getParent();
                            Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
                            qualifiedExpression = (KtQualifiedExpression)v5;
                            if (qualifiedExpression.getReceiverExpression() != element) {
                                addElement = false;
                            }
                        } else if (((KtExpression)element).getParent() instanceof KtCallElement || ((KtExpression)element).getParent() instanceof KtThisExpression || PsiTreeUtil.getParentOfType((PsiElement)element, KtSuperExpression.class) != null) {
                            addElement = false;
                        } else if (((KtExpression)element).getParent() instanceof KtOperationExpression) {
                            v6 = ((KtExpression)element).getParent();
                            Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtOperationExpression");
                            operationExpression = (KtOperationExpression)v6;
                            if (operationExpression.getOperationReference() == element) {
                                addElement = false;
                            }
                        }
                        if (addElement && ((expressionType = (bindingContext = ResolutionUtils.analyze((KtElement)element, BodyResolveMode.FULL)).getType((KtExpression)element)) == null || KotlinBuiltIns.isUnit((KotlinType)expressionType))) {
                            addElement = false;
                        }
                    }
                }
            }
            if (addElement) {
                elements.add((KtElement)element);
            }
            if (!keepPrevious) {
                elements.clear();
            }
            element = element.getParent();
        }
        return elements;
    }

    public static /* synthetic */ List getSmartSelectSuggestions$default(PsiFile psiFile2, int n, ElementKind elementKind, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return ElementSelectionUtilsKt.getSmartSelectSuggestions(psiFile2, n, elementKind, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final void smartSelectElement(Editor editor2, PsiFile file2, int offset2, boolean failOnEmptySuggestion, Collection<? extends ElementKind> elementKinds, Function1<? super PsiElement, Unit> callback2) {
        String string2;
        ScopeHighlighter highlighter;
        List elements2;
        block13: {
            block12: {
                block11: {
                    block10: {
                        void $this$flatMapTo$iv$iv;
                        Iterable $this$flatMap$iv = elementKinds;
                        boolean $i$f$flatMap = false;
                        Iterable iterable = $this$flatMap$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$flatMapTo = false;
                        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                            ElementKind it = (ElementKind)((Object)element$iv$iv);
                            boolean bl = false;
                            Iterable list$iv$iv = ElementSelectionUtilsKt.getSmartSelectSuggestions$default(file2, offset2, it, false, 8, null);
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        elements2 = (List)destination$iv$iv;
                        if (elements2.isEmpty()) {
                            if (failOnEmptySuggestion) {
                                throw new IntroduceRefactoringException(KotlinBundle.message("cannot.refactor.not.expression", new Object[0]));
                            }
                            callback2.invoke(null);
                            return;
                        }
                        if (elements2.size() == 1) break block10;
                        boolean $i$f$isUnitTestMode = false;
                        if (!ApplicationManager.getApplication().isUnitTestMode()) break block11;
                    }
                    callback2.invoke(CollectionsKt.first((List)elements2));
                    return;
                }
                highlighter = new ScopeHighlighter(editor2);
                if (elementKinds.size() != 1) break block12;
                switch (WhenMappings.$EnumSwitchMapping$0[elementKinds.iterator().next().ordinal()]) {
                    case 1: {
                        string2 = KotlinBundle.message("popup.title.expressions", new Object[0]);
                        break block13;
                    }
                    case 2: 
                    case 3: {
                        string2 = KotlinBundle.message("popup.title.types", new Object[0]);
                        break block13;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            string2 = KotlinBundle.message("popup.title.elements", new Object[0]);
        }
        String title = string2;
        JBPopupFactory.getInstance().createPopupChooserBuilder(elements2).setItemSelectedCallback(arg_0 -> ElementSelectionUtilsKt.smartSelectElement$lambda$1((Function1)new Function1<KtElement, Unit>(highlighter){
            final /* synthetic */ ScopeHighlighter $highlighter;
            {
                this.$highlighter = $highlighter;
                super(1);
            }

            public final void invoke(KtElement selectedElement) {
                block0: {
                    this.$highlighter.dropHighlight();
                    KtElement ktElement = selectedElement;
                    if (ktElement == null) break block0;
                    KtElement ktElement2 = ktElement;
                    ScopeHighlighter scopeHighlighter = this.$highlighter;
                    KtElement it = ktElement2;
                    boolean bl = false;
                    scopeHighlighter.highlight((PsiElement)it, CollectionsKt.listOf((Object)it));
                }
            }
        }, arg_0)).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @NotNull
            public Component getListCellRendererComponent(@NotNull JList<?> list2, @Nullable Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component component2;
                block3: {
                    Component $this$getListCellRendererComponent_u24lambda_u242 = component2 = super.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                    boolean bl = false;
                    Object object = value2;
                    if (object == null) break block3;
                    Object $this$safeAs$iv = object;
                    boolean $i$f$safeAs = false;
                    Object object2 = $this$safeAs$iv;
                    if (!(object2 instanceof KtElement)) {
                        object2 = null;
                    }
                    if ((object = (KtElement)object2) != null) {
                        Object object3;
                        Object it = object3 = object;
                        boolean bl2 = false;
                        object = it.isValid() ? object3 : null;
                        if (object != null) {
                            it = object;
                            boolean bl3 = false;
                            this.setText(ElementSelectionUtilsKt.getExpressionShortText((KtElement)it));
                        }
                    }
                }
                return component2;
            }
        }).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(arg_0 -> ElementSelectionUtilsKt.smartSelectElement$lambda$2(callback2, arg_0)).addListener(new JBPopupListener(highlighter){
            final /* synthetic */ ScopeHighlighter $highlighter;
            {
                this.$highlighter = $highlighter;
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                this.$highlighter.dropHighlight();
            }
        }).createPopup().showInBestPositionFor(editor2);
    }

    @NlsSafe
    @NotNull
    public static final String getExpressionShortText(@NotNull KtElement element3) {
        String text2 = ((Object)StringsKt.trimStart((CharSequence)ElementRenderingUtilsKt.renderTrimmed(element3))).toString();
        int firstNewLinePos = StringsKt.indexOf$default((CharSequence)text2, (char)'\n', (int)0, (boolean)false, (int)6, null);
        String string2 = text2.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(100, text2.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        Object trimmedText = string2;
        if (((String)trimmedText).length() != text2.length()) {
            trimmedText = (String)trimmedText + " ...";
        }
        return trimmedText;
    }

    private static final PsiElement findElement(KtFile file2, int startOffset, int endOffset2, boolean failOnNoExpression, ElementKind elementKind) {
        Qualifier qualifier2;
        PsiElement element3 = FindElementUtils.findElement((PsiFile)file2, startOffset, endOffset2, elementKind);
        if (element3 == null && elementKind == ElementKind.EXPRESSION) {
            element3 = (PsiElement)IntroduceUtilKt.findExpressionOrStringFragment(file2, startOffset, endOffset2);
        }
        if (element3 instanceof KtExpression && (qualifier2 = (Qualifier)ResolutionUtils.analyze$default((KtElement)element3, null, 1, null).get((ReadOnlySlice)BindingContext.QUALIFIER, (Object)element3)) != null && (!(qualifier2 instanceof ClassQualifier) || ((ClassQualifier)qualifier2).getDescriptor().getKind() != ClassKind.OBJECT)) {
            element3 = null;
        }
        if (element3 == null) {
            if (failOnNoExpression) {
                throw new IntroduceRefactoringException(KotlinBundle.message("cannot.refactor.not.expression", new Object[0]));
            }
            return null;
        }
        return element3;
    }

    private static final void smartSelectElement$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void smartSelectElement$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ PsiElement access$findElement(KtFile file2, int startOffset, int endOffset2, boolean failOnNoExpression, ElementKind elementKind) {
        return ElementSelectionUtilsKt.findElement(file2, startOffset, endOffset2, failOnNoExpression, elementKind);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ElementKind.values().length];
            try {
                nArray[ElementKind.EXPRESSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementKind.TYPE_ELEMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementKind.TYPE_CONSTRUCTOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

