/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.migration;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.CleanupFix;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.intentions.declarations.ConvertMemberToExtensionIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrateExternalExtensionFix;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrateExternalExtensionFix$fixNativeClass$;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002#$B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0002H\u0002J\"\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J#\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0094\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J4\u0010\u001c\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0004\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00132\b\b\u0002\u0010\"\u001a\u00020\u001bH\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/CleanupFix;", "declaration", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)V", "convertNativeAnnotationToJsName", "", "annotations", "Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$JsNativeAnnotations;", "fetchJsNativeAnnotations", "fixAnnotations", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixExtensionMemberDeclaration", "fixNativeClass", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getFamilyName", "", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "appendParameters", "Lorg/jetbrains/kotlin/psi/BuilderByPattern;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "lParenth", "rParenth", "skipLast", "Companion", "JsNativeAnnotations", "kotlin.idea"})
public final class MigrateExternalExtensionFix
extends KotlinQuickFixAction<KtNamedDeclaration>
implements CleanupFix {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MigrateExternalExtensionFix(@NotNull KtNamedDeclaration declaration2) {
        super((PsiElement)declaration2);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("fix.with.asdynamic", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getElement();
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        if (MigrateExternalExtensionFix.Companion.isMemberExtensionDeclaration((PsiElement)declaration2)) {
            this.fixExtensionMemberDeclaration(declaration2, editor2);
        } else if (MigrateExternalExtensionFix.Companion.isMemberDeclaration((PsiElement)declaration2)) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration2));
            if (ktClassOrObject != null) {
                KtClassOrObject p0 = ktClassOrObject;
                boolean bl = false;
                this.fixNativeClass(p0);
            }
        } else if (declaration2 instanceof KtClassOrObject) {
            this.fixNativeClass((KtClassOrObject)declaration2);
        }
    }

    private final void fixNativeClass(KtClassOrObject containingClass) {
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)containingClass.getDeclarations());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)fixNativeClass$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List membersToFix2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence2, (Function1)fixNativeClass.membersToFix.1.INSTANCE), (Function1)((Function1)new Function1<KtCallableDeclaration, Pair<? extends KtCallableDeclaration, ? extends JsNativeAnnotations>>(this){
            final /* synthetic */ MigrateExternalExtensionFix this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Pair<KtCallableDeclaration, JsNativeAnnotations> invoke(@NotNull KtCallableDeclaration it) {
                return TuplesKt.to((Object)it, (Object)MigrateExternalExtensionFix.access$fetchJsNativeAnnotations(this.this$0, (KtNamedDeclaration)it));
            }
        })), (Function1)fixNativeClass.membersToFix.3.INSTANCE));
        Iterable $this$forEach$iv = CollectionsKt.asReversed((List)membersToFix2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            KtCallableDeclaration memberDeclaration = (KtCallableDeclaration)pair.component1();
            JsNativeAnnotations annotations2 = (JsNativeAnnotations)pair.component2();
            if (!(annotations2.getNativeAnnotation() == null || annotations2.isGetter() || annotations2.isSetter() || annotations2.isInvoke())) {
                this.convertNativeAnnotationToJsName((KtNamedDeclaration)memberDeclaration, annotations2);
                annotations2.getNativeAnnotation().delete();
                continue;
            }
            KtCallableDeclaration externalDeclaration = ConvertMemberToExtensionIntention.Companion.convert(memberDeclaration);
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(this, externalDeclaration){
                final /* synthetic */ MigrateExternalExtensionFix this$0;
                final /* synthetic */ KtCallableDeclaration $externalDeclaration$inlined;
                {
                    this.this$0 = migrateExternalExtensionFix;
                    this.$externalDeclaration$inlined = ktCallableDeclaration;
                }

                public final T compute() {
                    boolean bl = false;
                    MigrateExternalExtensionFix.access$fixExtensionMemberDeclaration(this.this$0, (KtNamedDeclaration)this.$externalDeclaration$inlined, null);
                    return (T)Unit.INSTANCE;
                }
            });
        }
        JsNativeAnnotations classAnnotations = this.fetchJsNativeAnnotations((KtNamedDeclaration)containingClass);
        this.fixAnnotations((KtNamedDeclaration)containingClass, classAnnotations, null);
    }

    private final JsNativeAnnotations fetchJsNativeAnnotations(KtNamedDeclaration declaration2) {
        ArrayList<KtAnnotationEntry> nativeAnnotations;
        KtAnnotationEntry nativeAnnotation;
        boolean isInvoke;
        boolean isSetter;
        boolean isGetter;
        block4: {
            isGetter = false;
            isSetter = false;
            isInvoke = false;
            nativeAnnotation = null;
            nativeAnnotations = new ArrayList<KtAnnotationEntry>();
            Object object = declaration2.getModifierList();
            if (object == null || (object = object.getAnnotationEntries()) == null) break block4;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                PredefinedAnnotation[] predefinedAnnotationArray = new PredefinedAnnotation[]{PredefinedAnnotation.NATIVE_GETTER};
                if (MigrateExternalExtensionFix.Companion.isJsAnnotation(it, predefinedAnnotationArray)) {
                    isGetter = true;
                    nativeAnnotations.add(it);
                    continue;
                }
                predefinedAnnotationArray = new PredefinedAnnotation[]{PredefinedAnnotation.NATIVE_SETTER};
                if (MigrateExternalExtensionFix.Companion.isJsAnnotation(it, predefinedAnnotationArray)) {
                    isSetter = true;
                    nativeAnnotations.add(it);
                    continue;
                }
                predefinedAnnotationArray = new PredefinedAnnotation[]{PredefinedAnnotation.NATIVE_INVOKE};
                if (MigrateExternalExtensionFix.Companion.isJsAnnotation(it, predefinedAnnotationArray)) {
                    isInvoke = true;
                    nativeAnnotations.add(it);
                    continue;
                }
                predefinedAnnotationArray = new PredefinedAnnotation[]{PredefinedAnnotation.NATIVE};
                if (!MigrateExternalExtensionFix.Companion.isJsAnnotation(it, predefinedAnnotationArray)) continue;
                nativeAnnotations.add(it);
                nativeAnnotation = it;
            }
        }
        return new JsNativeAnnotations((List<? extends KtAnnotationEntry>)nativeAnnotations, nativeAnnotation, isGetter, isSetter, isInvoke);
    }

    private final void fixExtensionMemberDeclaration(KtNamedDeclaration declaration2, Editor editor2) {
        Name name2 = declaration2.getNameAsSafeName();
        JsNativeAnnotations annotations2 = this.fetchJsNativeAnnotations(declaration2);
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(this, declaration2, annotations2, editor2, name2){
            final /* synthetic */ MigrateExternalExtensionFix this$0;
            final /* synthetic */ KtNamedDeclaration $declaration$inlined;
            final /* synthetic */ JsNativeAnnotations $annotations$inlined;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ Name $name$inlined;
            {
                this.this$0 = migrateExternalExtensionFix;
                this.$declaration$inlined = ktNamedDeclaration;
                this.$annotations$inlined = jsNativeAnnotations;
                this.$editor$inlined = editor2;
                this.$name$inlined = name2;
            }

            public final T compute() {
                boolean bl = false;
                MigrateExternalExtensionFix.access$fixAnnotations(this.this$0, this.$declaration$inlined, this.$annotations$inlined, this.$editor$inlined);
                KtPsiFactory ktPsiFactory = new KtPsiFactory((KtElement)this.$declaration$inlined, false, 2, null);
                KtExpression body2 = CreateByPatternKt.buildExpression$default((KtPsiFactory)ktPsiFactory, (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(this.$annotations$inlined, this.$declaration$inlined, this.this$0, this.$name$inlined){
                    final /* synthetic */ JsNativeAnnotations $annotations;
                    final /* synthetic */ KtNamedDeclaration $declaration;
                    final /* synthetic */ MigrateExternalExtensionFix this$0;
                    final /* synthetic */ Name $name;
                    {
                        this.$annotations = $annotations;
                        this.$declaration = $declaration;
                        this.this$0 = $receiver;
                        this.$name = $name;
                        super(1);
                    }

                    public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                        $this$buildExpression.appendName(Name.identifier((String)"asDynamic"));
                        if (this.$annotations.isGetter()) {
                            $this$buildExpression.appendFixedText("()");
                            if (this.$declaration instanceof KtNamedFunction) {
                                MigrateExternalExtensionFix.appendParameters$default(this.this$0, $this$buildExpression, (KtNamedFunction)this.$declaration, "[", "]", false, 8, null);
                            }
                        } else if (this.$annotations.isSetter()) {
                            $this$buildExpression.appendFixedText("()");
                            if (this.$declaration instanceof KtNamedFunction) {
                                MigrateExternalExtensionFix.access$appendParameters(this.this$0, $this$buildExpression, (KtNamedFunction)this.$declaration, "[", "]", true);
                                Name name2 = ((KtParameter)CollectionsKt.last((List)((KtNamedFunction)this.$declaration).getValueParameters())).getNameAsName();
                                if (name2 != null) {
                                    Name it = name2;
                                    boolean bl = false;
                                    $this$buildExpression.appendFixedText(" = ");
                                    $this$buildExpression.appendName(it);
                                }
                            }
                        } else if (this.$annotations.isInvoke()) {
                            $this$buildExpression.appendFixedText("()");
                            if (this.$declaration instanceof KtNamedFunction) {
                                MigrateExternalExtensionFix.appendParameters$default(this.this$0, $this$buildExpression, (KtNamedFunction)this.$declaration, "(", ")", false, 8, null);
                            }
                        } else {
                            $this$buildExpression.appendFixedText("().");
                            $this$buildExpression.appendName(this.$name);
                            if (this.$declaration instanceof KtNamedFunction) {
                                MigrateExternalExtensionFix.appendParameters$default(this.this$0, $this$buildExpression, (KtNamedFunction)this.$declaration, "(", ")", false, 8, null);
                            }
                        }
                    }
                }), (int)1, null);
                if (this.$declaration$inlined instanceof KtNamedFunction) {
                    KtExpression ktExpression = ((KtNamedFunction)this.$declaration$inlined).getBodyExpression();
                    if (ktExpression != null) {
                        ktExpression.delete();
                    }
                    PsiElement psiElement2 = ((KtNamedFunction)this.$declaration$inlined).getEqualsToken();
                    if (psiElement2 != null) {
                        psiElement2.delete();
                    }
                    if (this.$annotations$inlined.isSetter() || this.$annotations$inlined.isInvoke()) {
                        KtBlockExpression blockBody = KtPsiFactory.createSingleStatementBlock$default((KtPsiFactory)ktPsiFactory, (KtExpression)body2, null, null, (int)6, null);
                        this.$declaration$inlined.add((PsiElement)blockBody);
                    } else {
                        this.$declaration$inlined.add(ktPsiFactory.createEQ());
                        this.$declaration$inlined.add((PsiElement)body2);
                    }
                } else if (this.$declaration$inlined instanceof KtProperty) {
                    KtPropertyAccessor ktPropertyAccessor = ((KtProperty)this.$declaration$inlined).getSetter();
                    if (ktPropertyAccessor != null) {
                        ktPropertyAccessor.delete();
                    }
                    KtPropertyAccessor ktPropertyAccessor2 = ((KtProperty)this.$declaration$inlined).getGetter();
                    if (ktPropertyAccessor2 != null) {
                        ktPropertyAccessor2.delete();
                    }
                    KtPropertyAccessor getter2 = ktPsiFactory.createPropertyGetter(body2);
                    this.$declaration$inlined.add((PsiElement)getter2);
                    if (((KtProperty)this.$declaration$inlined).isVar()) {
                        KtExpression setterBody2 = CreateByPatternKt.buildExpression$default((KtPsiFactory)ktPsiFactory, (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(this.$name$inlined){
                            final /* synthetic */ Name $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                                $this$buildExpression.appendName(Name.identifier((String)"asDynamic"));
                                $this$buildExpression.appendFixedText("().");
                                $this$buildExpression.appendName(this.$name);
                                $this$buildExpression.appendFixedText(" = ");
                                $this$buildExpression.appendName(Name.identifier((String)"value"));
                            }
                        }), (int)1, null);
                        KtProperty setterStubProperty = ktPsiFactory.createProperty("val x: Unit set(value) { Unit }");
                        KtPropertyAccessor ktPropertyAccessor3 = setterStubProperty.getSetter();
                        Intrinsics.checkNotNull((Object)ktPropertyAccessor3);
                        KtBlockExpression ktBlockExpression = ktPropertyAccessor3.getBodyBlockExpression();
                        Intrinsics.checkNotNull((Object)ktBlockExpression);
                        KtBlockExpression block2 = ktBlockExpression;
                        ((KtExpression)CollectionsKt.single((List)block2.getStatements())).replace((PsiElement)setterBody2);
                        KtPropertyAccessor ktPropertyAccessor4 = setterStubProperty.getSetter();
                        Intrinsics.checkNotNull((Object)ktPropertyAccessor4);
                        this.$declaration$inlined.add((PsiElement)ktPropertyAccessor4);
                    }
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    private final void fixAnnotations(KtNamedDeclaration declaration2, JsNativeAnnotations annotations2, Editor editor2) {
        Iterable $this$forEach$iv = annotations2.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
            boolean bl = false;
            it.delete();
        }
        if (declaration2 instanceof KtClassOrObject) {
            declaration2.addModifier(KtTokens.EXTERNAL_KEYWORD);
        } else {
            declaration2.addModifier(KtTokens.INLINE_KEYWORD);
            declaration2.removeModifier(KtTokens.EXTERNAL_KEYWORD);
        }
        if (declaration2 instanceof KtFunction) {
            ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)declaration2, StandardNames.FqNames.suppress, "\"NOTHING_TO_INLINE\"", null, null, 12, null);
        }
        this.convertNativeAnnotationToJsName(declaration2, annotations2);
        if (declaration2 instanceof KtFunction && !((KtFunction)declaration2).hasDeclaredReturnType() && !annotations2.isSetter() && !annotations2.isInvoke() && editor2 != null) {
            SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(editor2, (KtCallableDeclaration)declaration2, (KotlinType)PlatformKt.getBuiltIns((KtElement)declaration2).getUnitType());
        }
    }

    private final void convertNativeAnnotationToJsName(KtNamedDeclaration declaration2, JsNativeAnnotations annotations2) {
        KtAnnotationEntry nativeAnnotation = annotations2.getNativeAnnotation();
        if (nativeAnnotation != null && !((Collection)nativeAnnotation.getValueArguments()).isEmpty()) {
            ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)declaration2, new FqName("JsName"), CollectionsKt.joinToString$default((Iterable)nativeAnnotation.getValueArguments(), null, null, null, (int)0, null, (Function1)convertNativeAnnotationToJsName.1.INSTANCE, (int)31, null), null, null, 12, null);
        }
    }

    private final void appendParameters(BuilderByPattern<KtExpression> $this$appendParameters, KtNamedFunction declaration2, String lParenth, String rParenth, boolean skipLast) {
        $this$appendParameters.appendFixedText(lParenth);
        List it = declaration2.getValueParameters();
        boolean bl = false;
        Iterator iterator = (skipLast ? CollectionsKt.take((Iterable)it, (int)(it.size() - 1)) : it).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Name paramName;
            int index = n++;
            KtParameter param2 = (KtParameter)iterator.next();
            if (param2.getNameAsName() == null) continue;
            boolean bl2 = false;
            if (index > 0) {
                $this$appendParameters.appendFixedText(",");
            }
            $this$appendParameters.appendName(paramName);
        }
        $this$appendParameters.appendFixedText(rParenth);
    }

    static /* synthetic */ void appendParameters$default(MigrateExternalExtensionFix migrateExternalExtensionFix, BuilderByPattern builderByPattern, KtNamedFunction ktNamedFunction, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        migrateExternalExtensionFix.appendParameters((BuilderByPattern<KtExpression>)builderByPattern, ktNamedFunction, string2, string3, bl);
    }

    public static final /* synthetic */ JsNativeAnnotations access$fetchJsNativeAnnotations(MigrateExternalExtensionFix $this, KtNamedDeclaration declaration2) {
        return $this.fetchJsNativeAnnotations(declaration2);
    }

    public static final /* synthetic */ void access$fixExtensionMemberDeclaration(MigrateExternalExtensionFix $this, KtNamedDeclaration declaration2, Editor editor2) {
        $this.fixExtensionMemberDeclaration(declaration2, editor2);
    }

    public static final /* synthetic */ void access$fixAnnotations(MigrateExternalExtensionFix $this, KtNamedDeclaration declaration2, JsNativeAnnotations annotations2, Editor editor2) {
        $this.fixAnnotations(declaration2, annotations2, editor2);
    }

    public static final /* synthetic */ void access$appendParameters(MigrateExternalExtensionFix $this, BuilderByPattern $receiver, KtNamedFunction declaration2, String lParenth, String rParenth, boolean skipLast) {
        $this.appendParameters((BuilderByPattern<KtExpression>)$receiver, declaration2, lParenth, rParenth, skipLast);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003JC\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$JsNativeAnnotations;", "", "annotations", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "nativeAnnotation", "isGetter", "", "isSetter", "isInvoke", "(Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;ZZZ)V", "getAnnotations", "()Ljava/util/List;", "()Z", "getNativeAnnotation", "()Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    private static final class JsNativeAnnotations {
        @NotNull
        private final List<KtAnnotationEntry> annotations;
        @Nullable
        private final KtAnnotationEntry nativeAnnotation;
        private final boolean isGetter;
        private final boolean isSetter;
        private final boolean isInvoke;

        public JsNativeAnnotations(@NotNull List<? extends KtAnnotationEntry> annotations2, @Nullable KtAnnotationEntry nativeAnnotation, boolean isGetter, boolean isSetter, boolean isInvoke) {
            this.annotations = annotations2;
            this.nativeAnnotation = nativeAnnotation;
            this.isGetter = isGetter;
            this.isSetter = isSetter;
            this.isInvoke = isInvoke;
        }

        @NotNull
        public final List<KtAnnotationEntry> getAnnotations() {
            return this.annotations;
        }

        @Nullable
        public final KtAnnotationEntry getNativeAnnotation() {
            return this.nativeAnnotation;
        }

        public final boolean isGetter() {
            return this.isGetter;
        }

        public final boolean isSetter() {
            return this.isSetter;
        }

        public final boolean isInvoke() {
            return this.isInvoke;
        }

        @NotNull
        public final List<KtAnnotationEntry> component1() {
            return this.annotations;
        }

        @Nullable
        public final KtAnnotationEntry component2() {
            return this.nativeAnnotation;
        }

        public final boolean component3() {
            return this.isGetter;
        }

        public final boolean component4() {
            return this.isSetter;
        }

        public final boolean component5() {
            return this.isInvoke;
        }

        @NotNull
        public final JsNativeAnnotations copy(@NotNull List<? extends KtAnnotationEntry> annotations2, @Nullable KtAnnotationEntry nativeAnnotation, boolean isGetter, boolean isSetter, boolean isInvoke) {
            return new JsNativeAnnotations(annotations2, nativeAnnotation, isGetter, isSetter, isInvoke);
        }

        public static /* synthetic */ JsNativeAnnotations copy$default(JsNativeAnnotations jsNativeAnnotations, List list2, KtAnnotationEntry ktAnnotationEntry, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = jsNativeAnnotations.annotations;
            }
            if ((n & 2) != 0) {
                ktAnnotationEntry = jsNativeAnnotations.nativeAnnotation;
            }
            if ((n & 4) != 0) {
                bl = jsNativeAnnotations.isGetter;
            }
            if ((n & 8) != 0) {
                bl2 = jsNativeAnnotations.isSetter;
            }
            if ((n & 0x10) != 0) {
                bl3 = jsNativeAnnotations.isInvoke;
            }
            return jsNativeAnnotations.copy(list2, ktAnnotationEntry, bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "JsNativeAnnotations(annotations=" + this.annotations + ", nativeAnnotation=" + this.nativeAnnotation + ", isGetter=" + this.isGetter + ", isSetter=" + this.isSetter + ", isInvoke=" + this.isInvoke + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.annotations).hashCode();
            result2 = result2 * 31 + (this.nativeAnnotation == null ? 0 : this.nativeAnnotation.hashCode());
            int n = this.isGetter ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            int n2 = this.isSetter ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result2 = result2 * 31 + n2;
            int n3 = this.isInvoke ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result2 = result2 * 31 + n3;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JsNativeAnnotations)) {
                return false;
            }
            JsNativeAnnotations jsNativeAnnotations = (JsNativeAnnotations)other;
            if (!Intrinsics.areEqual(this.annotations, jsNativeAnnotations.annotations)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nativeAnnotation, (Object)jsNativeAnnotations.nativeAnnotation)) {
                return false;
            }
            if (this.isGetter != jsNativeAnnotations.isGetter) {
                return false;
            }
            if (this.isSetter != jsNativeAnnotations.isSetter) {
                return false;
            }
            return this.isInvoke == jsNativeAnnotations.isInvoke;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J%\u0010\f\u001a\u00020\b*\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\f\u0010\u0012\u001a\u00020\b*\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isMemberDeclaration", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "isMemberExtensionDeclaration", "isJsAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "predefinedAnnotations", "", "Lorg/jetbrains/kotlin/js/PredefinedAnnotation;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;[Lorg/jetbrains/kotlin/js/PredefinedAnnotation;)Z", "isJsNativeAnnotation", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isJsAnnotation(KtAnnotationEntry $this$isJsAnnotation, PredefinedAnnotation ... predefinedAnnotations) {
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)$this$isJsAnnotation, BodyResolveMode.PARTIAL);
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)$this$isJsAnnotation);
            if (annotationDescriptor == null) return false;
            PredefinedAnnotation[] $this$any$iv = predefinedAnnotations;
            boolean $i$f$any = false;
            int n = 0;
            int n2 = $this$any$iv.length;
            while (n < n2) {
                PredefinedAnnotation element$iv;
                PredefinedAnnotation it = element$iv = $this$any$iv[n];
                boolean bl = false;
                if (Intrinsics.areEqual((Object)annotationDescriptor.getFqName(), (Object)it.getFqName())) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private final boolean isJsNativeAnnotation(KtAnnotationEntry $this$isJsNativeAnnotation) {
            PredefinedAnnotation[] predefinedAnnotationArray = new PredefinedAnnotation[]{PredefinedAnnotation.NATIVE, PredefinedAnnotation.NATIVE_GETTER, PredefinedAnnotation.NATIVE_SETTER, PredefinedAnnotation.NATIVE_INVOKE};
            return this.isJsAnnotation($this$isJsNativeAnnotation, predefinedAnnotationArray);
        }

        private final boolean isMemberExtensionDeclaration(PsiElement psiElement2) {
            return psiElement2 instanceof KtNamedFunction && ((KtNamedFunction)psiElement2).getReceiverTypeReference() != null || psiElement2 instanceof KtProperty && ((KtProperty)psiElement2).getReceiverTypeReference() != null;
        }

        private final boolean isMemberDeclaration(PsiElement psiElement2) {
            return psiElement2 instanceof KtNamedFunction && ((KtNamedFunction)psiElement2).getReceiverTypeReference() == null || psiElement2 instanceof KtProperty && ((KtProperty)psiElement2).getReceiverTypeReference() == null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            PsiElement e = diagnostic.getPsiElement();
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)ErrorsJs.WRONG_EXTERNAL_DECLARATION)) {
                if (this.isMemberExtensionDeclaration(e)) {
                    void $this$getParentOfType$iv;
                    PsiElement psiElement2 = e;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClassOrObject.class, (boolean)strict$iv) == null) {
                        Intrinsics.checkNotNull((Object)e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                        return new MigrateExternalExtensionFix((KtNamedDeclaration)e);
                    }
                }
            } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.DEPRECATION_ERROR) ? true : Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.DEPRECATION)) {
                boolean bl;
                Object object;
                PsiElement $this$getParentOfType$iv;
                PsiElement strict$iv = e;
                boolean strict$iv2 = false;
                boolean $i$f$getParentOfType = false;
                KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtAnnotationEntry.class, (boolean)strict$iv2);
                boolean bl2 = ktAnnotationEntry != null ? this.isJsNativeAnnotation(ktAnnotationEntry) : false;
                if (bl2) {
                    $this$getParentOfType$iv = e;
                    strict$iv2 = false;
                    $i$f$getParentOfType = false;
                    KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtNamedDeclaration.class, (boolean)strict$iv2);
                    if (ktNamedDeclaration != null) {
                        KtNamedDeclaration it = ktNamedDeclaration;
                        boolean bl3 = false;
                        return new MigrateExternalExtensionFix(it);
                    }
                }
                if ((object = e instanceof KtNamedDeclaration ? (KtNamedDeclaration)e : null) != null && (object = object.getModifierList()) != null && (object = object.getAnnotationEntries()) != null) {
                    boolean bl4;
                    block13: {
                        Iterable $this$any$iv = (Iterable)object;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                                boolean bl5 = false;
                                if (!Companion.isJsNativeAnnotation(it)) continue;
                                bl4 = true;
                                break block13;
                            }
                            bl4 = false;
                        }
                    }
                    bl = bl4;
                } else {
                    bl = false;
                }
                if (bl) {
                    return new MigrateExternalExtensionFix((KtNamedDeclaration)e);
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

