/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.ReplaceInfixOrOperatorCallFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "findArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "expression", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
public final class ReplaceInfixOrOperatorCallFixFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final ReplaceInfixOrOperatorCallFixFactory INSTANCE = new ReplaceInfixOrOperatorCallFixFactory();

    private ReplaceInfixOrOperatorCallFixFactory() {
    }

    private final KtArrayAccessExpression findArrayAccessExpression(PsiElement expression2) {
        KtArrayAccessExpression ktArrayAccessExpression;
        PsiElement $this$safeAs$iv = expression2;
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtArrayAccessExpression)) {
            psiElement2 = null;
        }
        if ((ktArrayAccessExpression = (KtArrayAccessExpression)psiElement2) == null) {
            PsiElement psiElement3 = expression2.getParent();
            if (psiElement3 != null) {
                PsiElement $this$safeAs$iv2 = psiElement3;
                boolean $i$f$safeAs2 = false;
                PsiElement psiElement4 = $this$safeAs$iv2;
                if (!(psiElement4 instanceof KtArrayAccessExpression)) {
                    psiElement4 = null;
                }
                ktArrayAccessExpression = (KtArrayAccessExpression)psiElement4;
            } else {
                ktArrayAccessExpression = null;
            }
        }
        return ktArrayAccessExpression;
    }

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        PsiElement expression2 = diagnostic.getPsiElement();
        KtArrayAccessExpression arrayAccessExpression2 = this.findArrayAccessExpression(expression2);
        if (arrayAccessExpression2 != null && !Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.UNSAFE_IMPLICIT_INVOKE_CALL)) {
            if (arrayAccessExpression2.getArrayExpression() == null) {
                return null;
            }
            return new ReplaceInfixOrOperatorCallFix((KtExpression)arrayAccessExpression2, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)arrayAccessExpression2), null, 4, null);
        }
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtBinaryExpression) {
            ReplaceInfixOrOperatorCallFix replaceInfixOrOperatorCallFix;
            CallableDescriptor callableDescriptor;
            String binaryOperatorName;
            KtExpression left = ((KtBinaryExpression)parent2).getLeft();
            if (left == null || ((KtBinaryExpression)parent2).getRight() == null) {
                return null;
            }
            if (Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.EQ)) {
                return null;
            }
            if (CollectionsKt.contains((Iterable)((Iterable)OperatorConventions.COMPARISON_OPERATIONS), (Object)((KtBinaryExpression)parent2).getOperationToken())) {
                return null;
            }
            if (KtTokens.AUGMENTED_ASSIGNMENTS.contains(((KtBinaryExpression)parent2).getOperationToken()) && left instanceof KtArrayAccessExpression) {
                KtExpression ktExpression = ((KtArrayAccessExpression)left).getArrayExpression();
                if (ktExpression == null || (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)ResolutionUtils.analyze$default((KtElement)left, null, 1, null))) == null) {
                    return null;
                }
                KtExpression type2 = ktExpression;
                if (FunctionUtilsKt.isMap((KotlinType)type2, TypeUtilsKt.getBuiltIns((KotlinType)type2))) {
                    TypeProjection typeProjection = (TypeProjection)CollectionsKt.lastOrNull((List)type2.getArguments());
                    if (!(typeProjection != null && (typeProjection = typeProjection.getType()) != null ? KotlinTypeKt.isNullable((KotlinType)typeProjection) : false)) {
                        return null;
                    }
                }
            }
            String string2 = binaryOperatorName = Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.IDENTIFIER) ? ((KtBinaryExpression)parent2).getOperationReference().getText() : ((callableDescriptor = ResolutionUtils.resolveToCall((KtElement)parent2, BodyResolveMode.FULL)) != null && (callableDescriptor = callableDescriptor.getCandidateDescriptor()) != null && (callableDescriptor = callableDescriptor.getName()) != null ? callableDescriptor.asString() : null);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                replaceInfixOrOperatorCallFix = new ReplaceInfixOrOperatorCallFix((KtExpression)parent2, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)parent2), binaryOperatorName);
            } else {
                replaceInfixOrOperatorCallFix = null;
            }
            return replaceInfixOrOperatorCallFix;
        }
        if (parent2 instanceof KtCallExpression) {
            if (((KtCallExpression)parent2).getCalleeExpression() == null || ((KtCallExpression)parent2).getValueArgumentList() == null) {
                return null;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = ResolutionUtils.resolveToCall((KtElement)parent2, BodyResolveMode.FULL);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            if (!UtilsKt.canBeReplacedWithInvokeCall(resolvedCall3) || ResolvedCallUtilKt.getImplicitReceiverValue(resolvedCall3) != null) {
                return null;
            }
            return new ReplaceInfixOrOperatorCallFix((KtExpression)parent2, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)parent2), null, 4, null);
        }
        return null;
    }
}

