/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveWrongOptInAnnotationRetentionFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "RemoveForbiddenOptInRetentionFix", "kotlin.idea"})
public final class RemoveWrongOptInAnnotationRetentionFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final RemoveWrongOptInAnnotationRetentionFactory INSTANCE = new RemoveWrongOptInAnnotationRetentionFactory();

    private RemoveWrongOptInAnnotationRetentionFactory() {
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        if (!Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.OPT_IN_MARKER_WITH_WRONG_RETENTION)) {
            return CollectionsKt.emptyList();
        }
        PsiElement $this$safeAs$iv = diagnostic.getPsiElement();
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtAnnotationEntry)) {
            psiElement2 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)psiElement2;
        if (ktAnnotationEntry == null) {
            return CollectionsKt.emptyList();
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        return CollectionsKt.listOf((Object)new RemoveForbiddenOptInRetentionFix(annotationEntry2));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveWrongOptInAnnotationRetentionFactory$RemoveForbiddenOptInRetentionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
    private static final class RemoveForbiddenOptInRetentionFix
    extends KotlinQuickFixAction<KtAnnotationEntry> {
        public RemoveForbiddenOptInRetentionFix(@NotNull KtAnnotationEntry annotationEntry2) {
            super((PsiElement)annotationEntry2);
        }

        @NotNull
        public String getText() {
            return KotlinBundle.message("fix.opt_in.remove.forbidden.retention", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
            block0: {
                KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
                if (ktAnnotationEntry == null) break block0;
                ktAnnotationEntry.delete();
            }
        }
    }
}

