/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

class QuickFixBranchUtil {
    private QuickFixBranchUtil() {
    }

    @Nullable
    static KotlinType findLowerBoundOfOverriddenCallablesReturnTypes(@NotNull CallableDescriptor descriptor2) {
        KotlinType matchingReturnType = null;
        for (CallableDescriptor overriddenDescriptor : descriptor2.getOverriddenDescriptors()) {
            KotlinType overriddenReturnType = overriddenDescriptor.getReturnType();
            if (overriddenReturnType == null) {
                return null;
            }
            if (matchingReturnType == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(overriddenReturnType, matchingReturnType)) {
                matchingReturnType = overriddenReturnType;
                continue;
            }
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(matchingReturnType, overriddenReturnType)) continue;
            return null;
        }
        return matchingReturnType;
    }

    private static boolean equalOrLastInBlock(KtExpression block2, KtExpression expression2) {
        if (block2 == expression2) {
            return true;
        }
        return block2 instanceof KtBlockExpression && expression2.getParent() == block2 && PsiTreeUtil.getNextSiblingOfType((PsiElement)expression2, KtExpression.class) == null;
    }

    @Nullable
    static KtIfExpression getParentIfForBranch(@Nullable KtExpression expression2) {
        KtIfExpression ifExpression2 = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtIfExpression.class, (boolean)true);
        if (ifExpression2 == null) {
            return null;
        }
        if (QuickFixBranchUtil.equalOrLastInBlock(ifExpression2.getThen(), expression2) || QuickFixBranchUtil.equalOrLastInBlock(ifExpression2.getElse(), expression2)) {
            return ifExpression2;
        }
        return null;
    }

    @Nullable
    private static KtWhenExpression getParentWhenForBranch(@Nullable KtExpression expression2) {
        KtWhenEntry whenEntry = (KtWhenEntry)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtWhenEntry.class, (boolean)true);
        if (whenEntry == null) {
            return null;
        }
        KtExpression whenEntryExpression = whenEntry.getExpression();
        if (whenEntryExpression == null) {
            return null;
        }
        if (!QuickFixBranchUtil.equalOrLastInBlock(whenEntryExpression, expression2)) {
            return null;
        }
        return (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)whenEntry, KtWhenExpression.class, (boolean)true);
    }

    @Nullable
    private static KtExpression getParentForBranch(@Nullable KtExpression expression2) {
        KtIfExpression parent2 = QuickFixBranchUtil.getParentIfForBranch(expression2);
        if (parent2 != null) {
            return parent2;
        }
        return QuickFixBranchUtil.getParentWhenForBranch(expression2);
    }

    static boolean canEvaluateTo(KtExpression parent2, KtExpression child2) {
        if (parent2 == null || child2 == null) {
            return false;
        }
        while (parent2 != child2) {
            PsiElement childParent = child2.getParent();
            if (childParent instanceof KtParenthesizedExpression) {
                child2 = (KtExpression)childParent;
                continue;
            }
            if (childParent instanceof KtDotQualifiedExpression && (child2 instanceof KtCallExpression || child2 instanceof KtDotQualifiedExpression)) {
                child2 = (KtExpression)childParent;
                continue;
            }
            if ((child2 = QuickFixBranchUtil.getParentForBranch(child2)) != null) continue;
            return false;
        }
        return true;
    }

    static boolean canFunctionOrGetterReturnExpression(@NotNull KtDeclaration functionOrGetter, @NotNull KtExpression expression2) {
        if (functionOrGetter instanceof KtFunctionLiteral) {
            PsiElement[] children2;
            int length;
            KtBlockExpression functionLiteralBody = ((KtFunctionLiteral)functionOrGetter).getBodyExpression();
            PsiElement returnedElement = null;
            if (functionLiteralBody != null && (length = (children2 = functionLiteralBody.getChildren()).length) > 0) {
                returnedElement = children2[length - 1];
            }
            return returnedElement instanceof KtExpression && QuickFixBranchUtil.canEvaluateTo((KtExpression)returnedElement, expression2);
        }
        if (functionOrGetter instanceof KtDeclarationWithInitializer && QuickFixBranchUtil.canEvaluateTo(((KtDeclarationWithInitializer)functionOrGetter).getInitializer(), expression2)) {
            return true;
        }
        KtReturnExpression returnExpression2 = (KtReturnExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtReturnExpression.class);
        return returnExpression2 != null && QuickFixBranchUtil.canEvaluateTo(returnExpression2.getReturnedExpression(), expression2);
    }
}

