/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.RemoveAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.MoveOptInRequirementFromGetterToPropertyFix;
import org.jetbrains.kotlin.idea.quickfix.MoveOptInRequirementFromValueParameterToPropertyFix;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInAnnotationWrongTargetFixesFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class OptInAnnotationWrongTargetFixesFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final OptInAnnotationWrongTargetFixesFactory INSTANCE = new OptInAnnotationWrongTargetFixesFactory();

    private OptInAnnotationWrongTargetFixesFactory() {
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        FqName annotationFqName;
        if (!Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.OPT_IN_MARKER_ON_WRONG_TARGET)) {
            return CollectionsKt.emptyList();
        }
        PsiElement $this$safeAs$iv = diagnostic.getPsiElement();
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtAnnotationEntry)) {
            psiElement2 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)psiElement2;
        if (ktAnnotationEntry == null) {
            return CollectionsKt.emptyList();
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = annotationEntry2.getUseSiteTarget();
        AnnotationUseSiteTarget annotationUseSiteTarget = ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null;
        Class[] classArray = new Class[]{KtProperty.class, KtParameter.class};
        PsiElement psiElement3 = PsiUtilsKt.getParentOfTypes((PsiElement)((PsiElement)annotationEntry2), (boolean)true, (Class[])classArray);
        if (psiElement3 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement annotatedElement = psiElement3;
        List result2 = new ArrayList();
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)annotationEntry2, BodyResolveMode.PARTIAL);
        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)annotationEntry2);
        Object object = annotationFqName = annotationDescriptor != null ? annotationDescriptor.getFqName() : null;
        if (annotationFqName != null) {
            if (annotatedElement instanceof KtParameter && annotationUseSiteTarget != AnnotationUseSiteTarget.PROPERTY) {
                result2.add(new MoveOptInRequirementFromValueParameterToPropertyFix(annotationEntry2, PsiUtilsKt.createSmartPointer((PsiElement)annotatedElement), annotationFqName, null, 8, null));
            } else if (annotatedElement instanceof KtProperty && (PropertyTranslatorKt.hasCustomGetter((KtProperty)((KtProperty)annotatedElement)) || annotationUseSiteTarget == AnnotationUseSiteTarget.PROPERTY_GETTER)) {
                result2.add(new MoveOptInRequirementFromGetterToPropertyFix(annotationEntry2, PsiUtilsKt.createSmartPointer((PsiElement)annotatedElement), annotationFqName, null, 8, null));
            }
        }
        result2.addAll((Collection)RemoveAnnotationFix.Companion.createActions(diagnostic));
        return result2;
    }
}

