/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BI\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J#\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0094\u0002J\"\u0010\"\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\f\u0010#\u001a\u00020\n*\u00020\u0005H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/NumberConversionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "fromType", "Lorg/jetbrains/kotlin/types/KotlinType;", "toType", "disableIfAvailable", "Lcom/intellij/codeInsight/intention/IntentionAction;", "enableNullableType", "", "intentionText", "Lkotlin/Function1;", "", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lcom/intellij/codeInsight/intention/IntentionAction;ZLkotlin/jvm/functions/Function1;)V", "fromChar", "fromFloatOrDouble", "fromInt", "fromNullable", "isConversionAvailable", "toByteOrShort", "toChar", "toInt", "typePresentation", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "isNumberType", "kotlin.idea"})
public final class NumberConversionFix
extends KotlinQuickFixAction<KtExpression> {
    @Nullable
    private final IntentionAction disableIfAvailable;
    private final boolean enableNullableType;
    @NotNull
    private final Function1<String, String> intentionText;
    private final boolean isConversionAvailable;
    @NotNull
    private final String typePresentation;
    private final boolean fromInt;
    private final boolean fromChar;
    private final boolean fromFloatOrDouble;
    private final boolean fromNullable;
    private final boolean toChar;
    private final boolean toInt;
    private final boolean toByteOrShort;

    public NumberConversionFix(@NotNull KtExpression element3, @NotNull KotlinType fromType, @NotNull KotlinType toType, @Nullable IntentionAction disableIfAvailable, boolean enableNullableType, @NotNull Function1<? super String, String> intentionText) {
        super((PsiElement)element3);
        this.disableIfAvailable = disableIfAvailable;
        this.enableNullableType = enableNullableType;
        this.intentionText = intentionText;
        this.isConversionAvailable = !Intrinsics.areEqual((Object)fromType, (Object)toType) && this.isNumberType(fromType) && this.isNumberType(toType);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.renderType(TypeUtilsKt.makeNotNullable((KotlinType)toType));
        this.fromInt = TypeUtilsKt.isInt((KotlinType)fromType);
        this.fromChar = TypeUtilsKt.isChar((KotlinType)fromType);
        this.fromFloatOrDouble = TypeUtilsKt.isFloat((KotlinType)fromType) || TypeUtilsKt.isDouble((KotlinType)fromType);
        this.fromNullable = KotlinTypeKt.isNullable((KotlinType)fromType);
        this.toChar = TypeUtilsKt.isChar((KotlinType)toType);
        this.toInt = TypeUtilsKt.isInt((KotlinType)toType);
        this.toByteOrShort = TypeUtilsKt.isByte((KotlinType)toType) || TypeUtilsKt.isShort((KotlinType)toType);
    }

    public /* synthetic */ NumberConversionFix(KtExpression ktExpression, KotlinType kotlinType, KotlinType kotlinType2, IntentionAction intentionAction, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            intentionAction = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            function1 = 1.INSTANCE;
        }
        this(ktExpression, kotlinType, kotlinType2, intentionAction, bl, (Function1<? super String, String>)function1);
    }

    private final boolean isNumberType(KotlinType $this$isNumberType) {
        KotlinType type2 = this.enableNullableType ? TypeUtilsKt.makeNotNullable((KotlinType)$this$isNumberType) : $this$isNumberType;
        return TypeUtilsKt.isSignedOrUnsignedNumberType((KotlinType)type2);
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        IntentionAction intentionAction = this.disableIfAvailable;
        return !(intentionAction != null ? intentionAction.isAvailable(project, editor2, (PsiFile)file2) : false) && this.isConversionAvailable;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("insert.number.conversion", new Object[0]);
    }

    @NotNull
    public String getText() {
        return (String)this.intentionText.invoke((Object)this.typePresentation);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        block14: {
            PsiElement psiElement2;
            KtExpression ktExpression;
            KtExpression ktExpression2 = (KtExpression)this.getElement();
            if (ktExpression2 == null) {
                return;
            }
            KtExpression element3 = ktExpression2;
            KtPsiFactory psiFactory = new KtPsiFactory((KtElement)file2, false, 2, null);
            ApiVersion apiVersion2 = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)element3).getApiVersion();
            String dot = this.fromNullable ? "?." : ".";
            if (this.fromChar && apiVersion2.compareTo(ApiVersion.KOTLIN_1_5) >= 0) {
                if (this.toInt) {
                    var9_8 = new Object[]{element3};
                    ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0" + dot + "code"), (Object[])var9_8, (boolean)false, (int)4, null);
                } else {
                    var9_8 = new Object[]{element3, this.typePresentation};
                    ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0" + dot + "code" + dot + "to$1()"), (Object[])var9_8, (boolean)false, (int)4, null);
                }
            } else if (!this.fromInt && this.toChar && apiVersion2.compareTo(ApiVersion.KOTLIN_1_5) >= 0) {
                var9_8 = new Object[]{element3};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0" + dot + "toInt()" + dot + "toChar()"), (Object[])var9_8, (boolean)false, (int)4, null);
            } else if (this.fromFloatOrDouble && this.toByteOrShort && apiVersion2.compareTo(ApiVersion.KOTLIN_1_3) >= 0) {
                var9_8 = new Object[]{element3, this.typePresentation};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0" + dot + "toInt()" + dot + "to$1()"), (Object[])var9_8, (boolean)false, (int)4, null);
            } else {
                var9_8 = new Object[]{element3, this.typePresentation};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0" + dot + "to$1()"), (Object[])var9_8, (boolean)false, (int)4, null);
            }
            KtExpression expressionToInsert = ktExpression;
            PsiElement $this$replaced$iv = (PsiElement)element3;
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)expressionToInsert))) {
                psiElement2 = (PsiElement)expressionToInsert;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)expressionToInsert);
                if (result$iv instanceof KtExpression) {
                    psiElement2 = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement2 = (PsiElement)ktExpression3;
                }
            }
            KtExpression newExpression2 = (KtExpression)psiElement2;
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block14;
            editor3.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)newExpression2)));
        }
    }
}

