/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.inplace.MyLookupExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactoryWithDelegate;
import org.jetbrains.kotlin.idea.references.KtReferenceKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJF\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00072\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0017j\b\u0012\u0004\u0012\u00020\n`\u0018H\u0002J\b\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J#\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u001cH\u0096\u0002J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "element", "platformClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "possibleClasses", "", "(Lorg/jetbrains/kotlin/psi/KtReferenceExpression;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/Collection;)V", "OTHER_USAGE", "", "PRIMARY_USAGE", "buildAndShowTemplate", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "replacedElements", "Lcom/intellij/psi/PsiElement;", "options", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getFamilyName", "getText", "invoke", "Lorg/jetbrains/kotlin/psi/KtFile;", "replaceUsagesWithFirstClass", "", "usages", "Lorg/jetbrains/kotlin/psi/KtUserType;", "Companion", "kotlin.idea"})
public final class MapPlatformClassToKotlinFix
extends KotlinQuickFixAction<KtReferenceExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassDescriptor platformClass;
    @NotNull
    private final Collection<ClassDescriptor> possibleClasses;
    @NotNull
    private final String PRIMARY_USAGE;
    @NotNull
    private final String OTHER_USAGE;

    public MapPlatformClassToKotlinFix(@NotNull KtReferenceExpression element3, @NotNull ClassDescriptor platformClass, @NotNull Collection<? extends ClassDescriptor> possibleClasses) {
        super((PsiElement)element3);
        this.platformClass = platformClass;
        this.possibleClasses = possibleClasses;
        this.PRIMARY_USAGE = "PrimaryUsage";
        this.OTHER_USAGE = "OtherUsage";
    }

    @NotNull
    public String getText() {
        String string2;
        String platformClassQualifiedName = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType((KotlinType)this.platformClass.getDefaultType());
        ClassDescriptor singleClass = (ClassDescriptor)CollectionsKt.singleOrNull((Iterable)this.possibleClasses);
        if (singleClass != null) {
            Object[] objectArray = new Object[]{platformClassQualifiedName, DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType((KotlinType)singleClass.getDefaultType())};
            string2 = KotlinBundle.message("change.all.usages.of.0.in.this.file.to.1", objectArray);
        } else {
            Object[] objectArray = new Object[]{platformClassQualifiedName};
            string2 = KotlinBundle.message("change.all.usages.of.0.in.this.file.to.a.kotlin.class", objectArray);
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("change.to.kotlin.class", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        Iterator $this$analyzeWithContent$iv$iv;
        KtDeclarationContainer $this$analyzeWithContent$iv = (KtDeclarationContainer)file2;
        boolean $i$f$analyzeWithContent = false;
        KtDeclarationContainer ktDeclarationContainer = $this$analyzeWithContent$iv;
        ResolutionFacade resolutionFacade$iv$iv = ResolutionUtils.getResolutionFacade((KtElement)$this$analyzeWithContent$iv);
        boolean $i$f$analyzeWithContent2 = false;
        BindingContext bindingContext2 = ResolutionFacade.analyzeWithAllCompilerChecks$default(resolutionFacade$iv$iv, (KtElement)$this$analyzeWithContent$iv$iv, null, 2, null).getBindingContext();
        ArrayList<KtImportDirective> imports2 = new ArrayList<KtImportDirective>();
        ArrayList<KtUserType> usages2 = new ArrayList<KtUserType>();
        for (Diagnostic diagnostic : bindingContext2.getDiagnostics()) {
            KtReferenceExpression refExpr;
            if (diagnostic.getFactory() != Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN || MapPlatformClassToKotlinFix.Companion.getImportOrUsageFromDiagnostic(diagnostic) == null || !Intrinsics.areEqual((Object)MapPlatformClassToKotlinFix.Companion.resolveToClass(refExpr, bindingContext2), (Object)this.platformClass)) continue;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)refExpr;
            boolean $i$f$getStrictParentOfType = false;
            KtImportDirective ktImportDirective = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtImportDirective.class, (boolean)true);
            if (ktImportDirective != null) {
                imports2.add(ktImportDirective);
                continue;
            }
            PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)refExpr;
            boolean $i$f$getStrictParentOfType2 = false;
            KtUserType ktUserType2 = (KtUserType)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtUserType.class, (boolean)true);
            if (ktUserType2 == null) continue;
            usages2.add(ktUserType2);
        }
        Iterable $this$forEach$iv = imports2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtImportDirective it = (KtImportDirective)element$iv;
            boolean bl = false;
            it.delete();
        }
        if (usages2.isEmpty()) {
            return;
        }
        List<PsiElement> replacedElements = this.replaceUsagesWithFirstClass(project, (List<? extends KtUserType>)usages2);
        if (this.possibleClasses.size() > 1 && editor2 != null) {
            LinkedHashSet<String> possibleTypes2 = new LinkedHashSet<String>();
            for (ClassDescriptor klass2 : this.possibleClasses) {
                possibleTypes2.add(klass2.getName().asString());
            }
            this.buildAndShowTemplate(project, editor2, (PsiFile)file2, (Collection<? extends PsiElement>)replacedElements, possibleTypes2);
        }
    }

    private final List<PsiElement> replaceUsagesWithFirstClass(Project project, List<? extends KtUserType> usages2) {
        ClassDescriptor replacementClass = (ClassDescriptor)CollectionsKt.first((Iterable)this.possibleClasses);
        String replacementClassName = replacementClass.getName().asString();
        ArrayList<PsiElement> replacedElements = new ArrayList<PsiElement>();
        for (KtUserType ktUserType2 : usages2) {
            KtTypeElement replacementTypeElement;
            KtTypeArgumentList typeArguments2 = ktUserType2.getTypeArgumentList();
            Object object = typeArguments2;
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            Object typeArgumentsString = object;
            KtTypeReference replacementType = new KtPsiFactory(project, false, 2, null).createType(replacementClassName + (String)typeArgumentsString);
            Intrinsics.checkNotNull((Object)replacementType.getTypeElement());
            PsiElement replacedElement = ktUserType2.replace((PsiElement)replacementTypeElement);
            PsiElement replacedExpression = replacedElement.getFirstChild();
            boolean bl = replacedExpression instanceof KtSimpleNameExpression;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            replacedElements.add(replacedExpression);
        }
        return replacedElements;
    }

    private final void buildAndShowTemplate(Project project, Editor editor2, PsiFile file2, Collection<? extends PsiElement> replacedElements, LinkedHashSet<String> options2) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
        PsiElement primaryReplacedExpression = replacedElements.iterator().next();
        CaretModel caretModel = editor2.getCaretModel();
        int oldOffset = caretModel.getOffset();
        caretModel.moveToOffset(file2.getNode().getStartOffset());
        TemplateBuilderImpl builder2 = new TemplateBuilderImpl((PsiElement)file2);
        MyLookupExpression expression2 = new MyLookupExpression(primaryReplacedExpression.getText(), options2, null, null, false, KotlinBundle.message("choose.an.appropriate.kotlin.class", new Object[0]));
        builder2.replaceElement(primaryReplacedExpression, this.PRIMARY_USAGE, (Expression)expression2, true);
        for (PsiElement psiElement2 : replacedElements) {
            if (psiElement2 == primaryReplacedExpression) continue;
            builder2.replaceElement(psiElement2, this.OTHER_USAGE, this.PRIMARY_USAGE, false);
        }
        TemplateManager.getInstance((Project)project).startTemplate(editor2, builder2.buildInlineTemplate(), (TemplateEditingListener)new TemplateEditingAdapter(caretModel, oldOffset){
            final /* synthetic */ CaretModel $caretModel;
            final /* synthetic */ int $oldOffset;
            {
                this.$caretModel = $caretModel;
                this.$oldOffset = $oldOffset;
            }

            public void templateFinished(@NotNull Template template2, boolean brokenOff) {
                this.$caretModel.moveToOffset(this.$oldOffset);
            }
        });
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactoryWithDelegate;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "Lorg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix$Companion$Data;", "()V", "createFix", "Lcom/intellij/codeInsight/intention/IntentionAction;", "originalElement", "data", "extractFixData", "element", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getElementOfInterest", "getImportOrUsageFromDiagnostic", "resolveToClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "referenceExpression", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Data", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactoryWithDelegate<KtReferenceExpression, Data> {
        private Companion() {
            super(null, 1, null);
        }

        @Override
        @Nullable
        public KtReferenceExpression getElementOfInterest(@NotNull Diagnostic diagnostic) {
            return this.getImportOrUsageFromDiagnostic(diagnostic);
        }

        @Override
        @Nullable
        public Data extractFixData(@NotNull KtReferenceExpression element3, @NotNull Diagnostic diagnostic) {
            BindingContext context2 = ResolutionUtils.analyze((KtElement)element3, BodyResolveMode.PARTIAL);
            ClassDescriptor classDescriptor = this.resolveToClass(element3, context2);
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor platformClass = classDescriptor;
            Collection possibleClasses = (Collection)((DiagnosticWithParameters1)Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN.cast((UnboundDiagnostic)diagnostic)).getA();
            return new Data(platformClass, possibleClasses);
        }

        @Override
        @NotNull
        protected IntentionAction createFix(@NotNull KtReferenceExpression originalElement, @NotNull Data data2) {
            return new MapPlatformClassToKotlinFix(originalElement, data2.getPlatformClass(), data2.getPossibleClasses());
        }

        private final ClassDescriptor resolveToClass(KtReferenceExpression referenceExpression, BindingContext context2) {
            Object v0;
            block1: {
                Iterable $this$firstIsInstanceOrNull$iv = KtReferenceKt.resolveToDescriptors(ReferenceUtilsKt.getMainReference((KtReferenceExpression)referenceExpression), context2);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof ClassDescriptor)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final KtReferenceExpression getImportOrUsageFromDiagnostic(Diagnostic diagnostic) {
            KtReferenceExpression ktReferenceExpression;
            PsiElement $this$getNonStrictParentOfType$iv = diagnostic.getPsiElement();
            boolean $i$f$getNonStrictParentOfType = false;
            KtImportDirective ktImportDirective = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtImportDirective.class, (boolean)false);
            if (ktImportDirective != null) {
                KtElement ktElement;
                KtExpression ktExpression = ktImportDirective.getImportedReference();
                Object object = ktElement = ktExpression != null ? KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression)) : null;
                ktReferenceExpression = ktElement instanceof KtReferenceExpression ? (KtReferenceExpression)ktElement : null;
            } else {
                PsiElement $this$getNonStrictParentOfType$iv2 = diagnostic.getPsiElement();
                boolean $i$f$getNonStrictParentOfType2 = false;
                KtUserType ktUserType2 = (KtUserType)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv2, KtUserType.class, (boolean)false);
                if (ktUserType2 == null) {
                    return null;
                }
                ktReferenceExpression = (KtReferenceExpression)ktUserType2.getReferenceExpression();
            }
            return ktReferenceExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix$Companion$Data;", "", "platformClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "possibleClasses", "", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/Collection;)V", "getPlatformClass", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getPossibleClasses", "()Ljava/util/Collection;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
        public static final class Data {
            @NotNull
            private final ClassDescriptor platformClass;
            @NotNull
            private final Collection<ClassDescriptor> possibleClasses;

            public Data(@NotNull ClassDescriptor platformClass, @NotNull Collection<? extends ClassDescriptor> possibleClasses) {
                this.platformClass = platformClass;
                this.possibleClasses = possibleClasses;
            }

            @NotNull
            public final ClassDescriptor getPlatformClass() {
                return this.platformClass;
            }

            @NotNull
            public final Collection<ClassDescriptor> getPossibleClasses() {
                return this.possibleClasses;
            }

            @NotNull
            public final ClassDescriptor component1() {
                return this.platformClass;
            }

            @NotNull
            public final Collection<ClassDescriptor> component2() {
                return this.possibleClasses;
            }

            @NotNull
            public final Data copy(@NotNull ClassDescriptor platformClass, @NotNull Collection<? extends ClassDescriptor> possibleClasses) {
                return new Data(platformClass, possibleClasses);
            }

            public static /* synthetic */ Data copy$default(Data data2, ClassDescriptor classDescriptor, Collection collection, int n, Object object) {
                if ((n & 1) != 0) {
                    classDescriptor = data2.platformClass;
                }
                if ((n & 2) != 0) {
                    collection = data2.possibleClasses;
                }
                return data2.copy(classDescriptor, collection);
            }

            @NotNull
            public String toString() {
                return "Data(platformClass=" + this.platformClass + ", possibleClasses=" + this.possibleClasses + ")";
            }

            public int hashCode() {
                int result2 = this.platformClass.hashCode();
                result2 = result2 * 31 + ((Object)this.possibleClasses).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Data)) {
                    return false;
                }
                Data data2 = (Data)other;
                if (!Intrinsics.areEqual((Object)this.platformClass, (Object)data2.platformClass)) {
                    return false;
                }
                return Intrinsics.areEqual(this.possibleClasses, data2.possibleClasses);
            }
        }
    }
}

