/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.overrideImplement.GenerateMembersHandler;
import org.jetbrains.kotlin.idea.core.overrideImplement.ImplementMembersHandler;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObject;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ConflictingJvmDeclarationsData;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0094\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakePrivateAndOverrideMemberFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "propertyOrParameter", "memberToOverride", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/OverrideMemberChooserObject;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/idea/core/overrideImplement/OverrideMemberChooserObject;)V", "makePrivate", "", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "AccidentalOverrideFactory", "kotlin.idea"})
public final class MakePrivateAndOverrideMemberFix
extends KotlinQuickFixAction<KtDeclaration> {
    @NotNull
    private final OverrideMemberChooserObject memberToOverride;
    private final boolean makePrivate;

    public MakePrivateAndOverrideMemberFix(@NotNull KtDeclaration propertyOrParameter, @NotNull OverrideMemberChooserObject memberToOverride) {
        super((PsiElement)propertyOrParameter);
        this.memberToOverride = memberToOverride;
        this.makePrivate = !propertyOrParameter.hasModifier(KtTokens.PRIVATE_KEYWORD);
    }

    @NotNull
    public String getText() {
        Object object;
        CallableMemberDescriptor descriptor2 = this.memberToOverride.getDescriptor();
        Object[] objectArray = descriptor2.getContainingDeclaration();
        ClassDescriptor classDescriptor = objectArray instanceof ClassDescriptor ? (ClassDescriptor)objectArray : null;
        boolean implement = (classDescriptor != null ? classDescriptor.getKind() : null) == ClassKind.INTERFACE;
        String name2 = descriptor2.getName().asString();
        if (this.makePrivate) {
            objectArray = new Object[]{implement ? KotlinBundle.message("text.implements", new Object[0]) : KotlinBundle.message("text.overrides", new Object[0]), name2};
            object = KotlinBundle.message("make.private.and.0.1", objectArray);
        } else {
            object = (implement ? KotlinBundle.message("highlighter.text.implements", new Object[0]) : KotlinBundle.message("highlighter.text.overrides", new Object[0])) + " '" + name2 + "'";
        }
        return object;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        if (editor2 == null) {
            return;
        }
        KtDeclaration ktDeclaration = (KtDeclaration)this.getElement();
        if (ktDeclaration == null) {
            return;
        }
        KtDeclaration element3 = ktDeclaration;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)element3);
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject containingClassOrObject = ktClassOrObject;
        if (this.makePrivate) {
            element3.addModifier(KtTokens.PRIVATE_KEYWORD);
        }
        GenerateMembersHandler.Companion.generateMembers(editor2, containingClassOrObject, CollectionsKt.listOf((Object)this.memberToOverride), false);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakePrivateAndOverrideMemberFix$AccidentalOverrideFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "implementMembersHandler", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/ImplementMembersHandler;", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class AccidentalOverrideFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final AccidentalOverrideFactory INSTANCE = new AccidentalOverrideFactory();
        @NotNull
        private static final ImplementMembersHandler implementMembersHandler = new ImplementMembersHandler();

        private AccidentalOverrideFactory() {
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtModifierListOwner> createAction(@NotNull Diagnostic diagnostic) {
            Object v6;
            KtDeclaration element3;
            block10: {
                DiagnosticWithParameters1 casted = (DiagnosticWithParameters1)ErrorsJvm.ACCIDENTAL_OVERRIDE.cast((UnboundDiagnostic)diagnostic);
                PsiElement psiElement2 = casted.getPsiElement();
                KtDeclaration ktDeclaration = psiElement2 instanceof KtDeclaration ? (KtDeclaration)psiElement2 : null;
                if (ktDeclaration == null) {
                    return null;
                }
                element3 = ktDeclaration;
                if (!(element3 instanceof KtProperty) && !(element3 instanceof KtParameter)) {
                    return null;
                }
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)element3);
                if (ktClassOrObject == null) {
                    return null;
                }
                KtClassOrObject containingClassOrObject = ktClassOrObject;
                String memberNameToOverride = ((ConflictingJvmDeclarationsData)casted.getA()).getSignature().getName();
                DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor(element3);
                CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
                if (callableDescriptor == null || (callableDescriptor = callableDescriptor.getReturnType()) == null) {
                    return null;
                }
                CallableDescriptor returnType2 = callableDescriptor;
                boolean isGetter = JvmAbi.isGetterName((String)memberNameToOverride);
                boolean isSetter = JvmAbi.isSetterName((String)memberNameToOverride);
                Iterable $this$firstOrNull$iv = implementMembersHandler.collectMembersToGenerate(containingClassOrObject);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    OverrideMemberChooserObject it = (OverrideMemberChooserObject)element$iv;
                    boolean bl2 = false;
                    CallableMemberDescriptor descriptor2 = it.getDescriptor();
                    if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)memberNameToOverride)) {
                        bl = false;
                    } else {
                        KotlinType kotlinType = descriptor2.getReturnType();
                        if (kotlinType == null || (kotlinType = TypeUtilsKt.makeNotNullable((KotlinType)kotlinType)) == null) {
                            bl = false;
                        } else {
                            ValueParameterDescriptor valueParameterDescriptor;
                            KotlinType accessorReturnType = kotlinType;
                            List params2 = descriptor2.getValueParameters();
                            bl = isGetter && params2.isEmpty() && Intrinsics.areEqual((Object)accessorReturnType, (Object)returnType2) || isSetter && Intrinsics.areEqual((Object)((valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.singleOrNull((List)params2)) != null && (valueParameterDescriptor = valueParameterDescriptor.getType()) != null ? TypeUtilsKt.makeNotNullable((KotlinType)valueParameterDescriptor) : null), (Object)returnType2) && TypeUtilsKt.isUnit((KotlinType)accessorReturnType);
                        }
                    }
                    if (!bl) continue;
                    v6 = element$iv;
                    break block10;
                }
                v6 = null;
            }
            OverrideMemberChooserObject overrideMemberChooserObject = v6;
            if (overrideMemberChooserObject == null) {
                return null;
            }
            OverrideMemberChooserObject memberToOverride = overrideMemberChooserObject;
            return new MakePrivateAndOverrideMemberFix(element3, memberToOverride);
        }
    }
}

