/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.intentions.AddJvmStaticIntention;
import org.jetbrains.kotlin.idea.intentions.MoveMemberToCompanionObjectIntention;
import org.jetbrains.kotlin.idea.quickfix.MakeMemberStaticFix;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeMemberStaticFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declaration", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
public final class MakeMemberStaticFix
extends KotlinQuickFixAction<KtNamedDeclaration> {
    @NotNull
    private final KtNamedDeclaration declaration;

    public MakeMemberStaticFix(@NotNull KtNamedDeclaration declaration2) {
        super((PsiElement)declaration2);
        this.declaration = declaration2;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)this.declaration));
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject containingClass = ktClassOrObject;
        if (containingClass instanceof KtClass) {
            MoveMemberToCompanionObjectIntention moveMemberToCompanionObjectIntention = new MoveMemberToCompanionObjectIntention();
            Triple<MultiMap<PsiElement, String>, List<UsageInfo>, List<UsageInfo>> triple = moveMemberToCompanionObjectIntention.retrieveConflictsAndUsages(project, editor2, this.declaration, (KtClass)containingClass);
            if (triple == null) {
                return;
            }
            Triple<MultiMap<PsiElement, String>, List<UsageInfo>, List<UsageInfo>> triple2 = triple;
            MultiMap conflicts2 = (MultiMap)triple2.component1();
            List externalUsages = (List)triple2.component2();
            List outerInstanceUsages = (List)triple2.component3();
            KotlinRefactoringUtilKt.checkConflictsInteractively$default(project, conflicts2, null, (Function0)new Function0<Unit>(project, moveMemberToCompanionObjectIntention, this, (List<? extends UsageInfo>)externalUsages, (List<? extends UsageInfo>)outerInstanceUsages, editor2){
                final /* synthetic */ Project $project;
                final /* synthetic */ MoveMemberToCompanionObjectIntention $moveMemberToCompanionObjectIntention;
                final /* synthetic */ MakeMemberStaticFix this$0;
                final /* synthetic */ List<UsageInfo> $externalUsages;
                final /* synthetic */ List<UsageInfo> $outerInstanceUsages;
                final /* synthetic */ Editor $editor;
                {
                    this.$project = $project;
                    this.$moveMemberToCompanionObjectIntention = $moveMemberToCompanionObjectIntention;
                    this.this$0 = $receiver;
                    this.$externalUsages = $externalUsages;
                    this.$outerInstanceUsages = $outerInstanceUsages;
                    this.$editor = $editor;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        Ref.ObjectRef movedDeclaration = new Ref.ObjectRef();
                        ApplicationManagerEx.getApplicationEx().runWriteActionWithNonCancellableProgressInDispatchThread(KotlinBundle.message("moving.to.companion.object", new Object[0]), this.$project, null, arg_0 -> invoke.1.invoke$lambda$0((Function1)new Function1<ProgressIndicator, Unit>((Ref.ObjectRef<KtNamedDeclaration>)movedDeclaration, this.$moveMemberToCompanionObjectIntention, this.this$0, this.$externalUsages, this.$outerInstanceUsages, this.$editor){
                            final /* synthetic */ Ref.ObjectRef<KtNamedDeclaration> $movedDeclaration;
                            final /* synthetic */ MoveMemberToCompanionObjectIntention $moveMemberToCompanionObjectIntention;
                            final /* synthetic */ MakeMemberStaticFix this$0;
                            final /* synthetic */ List<UsageInfo> $externalUsages;
                            final /* synthetic */ List<UsageInfo> $outerInstanceUsages;
                            final /* synthetic */ Editor $editor;
                            {
                                this.$movedDeclaration = $movedDeclaration;
                                this.$moveMemberToCompanionObjectIntention = $moveMemberToCompanionObjectIntention;
                                this.this$0 = $receiver;
                                this.$externalUsages = $externalUsages;
                                this.$outerInstanceUsages = $outerInstanceUsages;
                                this.$editor = $editor;
                                super(1);
                            }

                            public final void invoke(ProgressIndicator it) {
                                this.$movedDeclaration.element = this.$moveMemberToCompanionObjectIntention.doMove(it, MakeMemberStaticFix.access$getDeclaration$p(this.this$0), this.$externalUsages, this.$outerInstanceUsages, this.$editor);
                            }
                        }, arg_0));
                        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)movedDeclaration.element;
                        if (ktNamedDeclaration == null) break block0;
                        KtNamedDeclaration ktNamedDeclaration2 = ktNamedDeclaration;
                        Editor editor2 = this.$editor;
                        KtNamedDeclaration it = ktNamedDeclaration2;
                        boolean bl = false;
                        MakeMemberStaticFix.access$invoke$makeStaticAndReformat(editor2, it);
                    }
                }

                private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                    $tmp0.invoke(p0);
                }
            }, 2, null);
        } else {
            MakeMemberStaticFix.invoke$makeStaticAndReformat(editor2, this.declaration);
        }
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[1];
        String string2 = this.declaration.getName();
        if (string2 == null) {
            string2 = "";
        }
        objectArray[0] = string2;
        return KotlinBundle.message("make.member.static.quickfix", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    private static final void invoke$makeStaticAndReformat(Editor $editor, KtNamedDeclaration declaration2) {
        AddJvmStaticIntention makeStaticIntention = new AddJvmStaticIntention();
        if (makeStaticIntention.applicabilityRange(declaration2) != null) {
            new AddJvmStaticIntention().applyTo(declaration2, $editor);
        }
        CodeStyleManager.getInstance((Project)declaration2.getProject()).reformat((PsiElement)declaration2, true);
    }

    public static final /* synthetic */ KtNamedDeclaration access$getDeclaration$p(MakeMemberStaticFix $this) {
        return $this.declaration;
    }

    public static final /* synthetic */ void access$invoke$makeStaticAndReformat(Editor $editor, KtNamedDeclaration declaration2) {
        MakeMemberStaticFix.invoke$makeStaticAndReformat($editor, declaration2);
    }
}

