/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertStringToCharLiteralFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "element", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class ConvertStringToCharLiteralFix
extends KotlinQuickFixAction<KtStringTemplateExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ConvertStringToCharLiteralFix(@NotNull KtStringTemplateExpression element3) {
        super((PsiElement)element3);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("convert.string.to.character.literal", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)this.getElement();
        if (ktStringTemplateExpression == null) {
            return;
        }
        KtStringTemplateExpression stringTemplate = ktStringTemplateExpression;
        KtStringTemplateEntry ktStringTemplateEntry = ConvertStringToCharLiteralFix.Companion.getApplicableEntry(stringTemplate);
        if (ktStringTemplateEntry == null) {
            return;
        }
        KtStringTemplateEntry stringTemplateEntry = ktStringTemplateEntry;
        stringTemplate.replace((PsiElement)ConvertStringToCharLiteralFix.Companion.charLiteral(stringTemplateEntry));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\f\u0010\u000b\u001a\u00020\f*\u00020\u0004H\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertStringToCharLiteralFix$Companion;", "", "()V", "applicableEntry", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "getApplicableEntry", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "isApplicable", "", "stringTemplate", "charLiteral", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isApplicable(@NotNull KtStringTemplateExpression stringTemplate) {
            KtStringTemplateEntry ktStringTemplateEntry = this.getApplicableEntry(stringTemplate);
            if (ktStringTemplateEntry == null) {
                return false;
            }
            KtStringTemplateEntry stringTemplateEntry = ktStringTemplateEntry;
            KtExpression ktExpression = this.charLiteral(stringTemplateEntry);
            KtConstantExpression ktConstantExpression = ktExpression instanceof KtConstantExpression ? (KtConstantExpression)ktExpression : null;
            if (ktConstantExpression == null) {
                return false;
            }
            KtConstantExpression charLiteral = ktConstantExpression;
            BindingContext context2 = ExtendedResolutionApiKt.analyzeAsReplacement$default((KtExpression)charLiteral, (KtExpression)stringTemplate, ResolutionUtils.analyze((KtElement)stringTemplate, BodyResolveMode.PARTIAL), null, null, null, 28, null);
            return ConstantExpressionEvaluator.Companion.getConstant((KtExpression)charLiteral, context2) != null;
        }

        private final KtStringTemplateEntry getApplicableEntry(KtStringTemplateExpression $this$applicableEntry) {
            Object object = ArraysKt.singleOrNull((Object[])$this$applicableEntry.getEntries());
            KtStringTemplateEntry it = (KtStringTemplateEntry)object;
            boolean bl = false;
            return (KtStringTemplateEntry)(it instanceof KtLiteralStringTemplateEntry || it instanceof KtEscapeStringTemplateEntry ? object : null);
        }

        private final KtExpression charLiteral(KtStringTemplateEntry $this$charLiteral) {
            String text2 = StringsKt.replace$default((String)StringsKt.replace$default((String)$this$charLiteral.getText(), (String)"'", (String)"\\'", (boolean)false, (int)4, null), (String)"\\\"", (String)"\"", (boolean)false, (int)4, null);
            return new KtPsiFactory((KtElement)$this$charLiteral, false, 2, null).createExpression("'" + text2 + "'");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

