/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFixFE10;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.QuickFixUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddSuspendModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixFE10;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "declarationName", "", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Ljava/lang/String;)V", "getText", "Companion", "UnresolvedReferenceFactory", "kotlin.idea"})
public final class AddSuspendModifierFix
extends AddModifierFixFE10 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String declarationName;

    public AddSuspendModifierFix(@NotNull KtModifierListOwner element3, @Nullable String declarationName) {
        super(element3, KtTokens.SUSPEND_KEYWORD);
        this.declarationName = declarationName;
    }

    @Override
    @NotNull
    public String getText() {
        String string2;
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
        if (ktModifierListOwner instanceof KtNamedFunction) {
            if (this.declarationName != null) {
                Object[] objectArray = new Object[]{this.declarationName};
                string2 = KotlinBundle.message("fix.add.suspend.modifier.function", objectArray);
            } else {
                string2 = KotlinBundle.message("fix.add.suspend.modifier.function.generic", new Object[0]);
            }
        } else if (ktModifierListOwner instanceof KtTypeReference) {
            if (this.declarationName != null) {
                Object[] objectArray = new Object[]{this.declarationName};
                string2 = KotlinBundle.message("fix.add.suspend.modifier.receiver", objectArray);
            } else {
                string2 = KotlinBundle.message("fix.add.suspend.modifier.receiver.generic", new Object[0]);
            }
        } else {
            string2 = super.getText();
        }
        return string2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddSuspendModifierFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtElement ktElement = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
            if (ktElement == null) {
                return null;
            }
            KtElement element3 = ktElement;
            KtNamedFunction ktNamedFunction = QuickFixUtilsKt.containingFunction(element3);
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function2 = ktNamedFunction;
            String string2 = function2.getName();
            if (string2 == null) {
                return null;
            }
            String functionName = string2;
            return new AddSuspendModifierFix((KtModifierListOwner)function2, functionName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddSuspendModifierFix$UnresolvedReferenceFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "suspendExtensionNames", "", "", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class UnresolvedReferenceFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final UnresolvedReferenceFactory INSTANCE = new UnresolvedReferenceFactory();
        @NotNull
        private static final Set<String> suspendExtensionNames;

        private UnresolvedReferenceFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtNameReferenceExpression ktNameReferenceExpression = psiElement2 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)psiElement2 : null;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            KtNameReferenceExpression refExpr = ktNameReferenceExpression;
            if (!suspendExtensionNames.contains(refExpr.getReferencedName())) {
                return null;
            }
            PsiElement psiElement3 = refExpr.getParent();
            KtCallExpression ktCallExpression = psiElement3 instanceof KtCallExpression ? (KtCallExpression)psiElement3 : null;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression callParent = ktCallExpression;
            PsiElement psiElement4 = callParent.getParent();
            KtQualifiedExpression ktQualifiedExpression = psiElement4 instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement4 : null;
            if (ktQualifiedExpression == null) {
                return null;
            }
            KtQualifiedExpression qualifiedGrandParent = ktQualifiedExpression;
            if (callParent != qualifiedGrandParent.getSelectorExpression() || refExpr != callParent.getCalleeExpression()) {
                return null;
            }
            KtExpression ktExpression = qualifiedGrandParent.getReceiverExpression();
            KtNameReferenceExpression ktNameReferenceExpression2 = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
            if (ktNameReferenceExpression2 == null) {
                return null;
            }
            KtNameReferenceExpression receiver2 = ktNameReferenceExpression2;
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)receiver2, null, 1, null);
            CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
            ValueDescriptor valueDescriptor = callableDescriptor instanceof ValueDescriptor ? (ValueDescriptor)callableDescriptor : null;
            if (valueDescriptor == null) {
                return null;
            }
            ValueDescriptor receiverDescriptor = valueDescriptor;
            if (!FunctionTypesKt.isFunctionType((KotlinType)receiverDescriptor.getType())) {
                return null;
            }
            PsiElement psiElement5 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)receiverDescriptor));
            KtCallableDeclaration ktCallableDeclaration = psiElement5 instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement5 : null;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration declaration2 = ktCallableDeclaration;
            if (declaration2 instanceof KtFunction) {
                return null;
            }
            KtTypeReference ktTypeReference = declaration2.getTypeReference();
            if (ktTypeReference == null) {
                return null;
            }
            KtTypeReference variableTypeReference = ktTypeReference;
            return new AddSuspendModifierFix((KtModifierListOwner)variableTypeReference, declaration2.getName());
        }

        static {
            Object[] objectArray = new String[]{"startCoroutine", "createCoroutine"};
            suspendExtensionNames = SetsKt.setOf((Object[])objectArray);
        }
    }
}

