/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationTargetFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "Companion", "kotlin.idea"})
public final class AddAnnotationTargetFix
extends KotlinQuickFixAction<KtAnnotationEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AddAnnotationTargetFix(@NotNull KtAnnotationEntry annotationEntry2) {
        super((PsiElement)annotationEntry2);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("fix.add.annotation.target", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        ClassDescriptor annotationClassDescriptor;
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        Pair pair = AddAnnotationTargetFix.Companion.toAnnotationClass(annotationEntry2);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        KtClass annotationClass = (KtClass)pair2.component1();
        List requiredAnnotationTargets = AddAnnotationTargetFixKt.access$getRequiredAnnotationTargets(annotationEntry2, annotationClass, annotationClassDescriptor = (ClassDescriptor)pair2.component2(), project);
        if (requiredAnnotationTargets.isEmpty()) {
            return;
        }
        ExpectActualUtilKt.runOnExpectAndAllActuals$default((KtDeclaration)annotationClass, false, true, (Function1)new Function1<KtDeclaration, Unit>(annotationEntry2, (List<? extends KotlinTarget>)requiredAnnotationTargets){
            final /* synthetic */ KtAnnotationEntry $annotationEntry;
            final /* synthetic */ List<KotlinTarget> $requiredAnnotationTargets;
            {
                this.$annotationEntry = $annotationEntry;
                this.$requiredAnnotationTargets = $requiredAnnotationTargets;
                super(1);
            }

            public final void invoke(@NotNull KtDeclaration it) {
                KtDeclaration $this$safeAs$iv = it;
                boolean $i$f$safeAs = false;
                KtDeclaration ktDeclaration = $this$safeAs$iv;
                if (!(ktDeclaration instanceof KtClass)) {
                    ktDeclaration = null;
                }
                KtClass ktClass = (KtClass)ktDeclaration;
                if (ktClass == null) {
                    return;
                }
                KtClass ktClass2 = ktClass;
                KtPsiFactory psiFactory = new KtPsiFactory((KtElement)this.$annotationEntry, false, 2, null);
                List<KotlinTarget> list2 = this.$requiredAnnotationTargets;
                boolean $i$f$runWriteAction = false;
                ApplicationManager.getApplication().runWriteAction(new Computable(ktClass2, list2, psiFactory){
                    final /* synthetic */ KtClass $ktClass$inlined;
                    final /* synthetic */ List $requiredAnnotationTargets$inlined;
                    final /* synthetic */ KtPsiFactory $psiFactory$inlined;
                    {
                        this.$ktClass$inlined = ktClass;
                        this.$requiredAnnotationTargets$inlined = list2;
                        this.$psiFactory$inlined = ktPsiFactory;
                    }

                    public final T compute() {
                        boolean bl = false;
                        AddAnnotationTargetFixKt.access$addAnnotationTargets(this.$ktClass$inlined, this.$requiredAnnotationTargets$inlined, this.$psiFactory$inlined);
                        return (T)Unit.INSTANCE;
                    }
                });
            }
        }, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t*\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "toAnnotationClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtClass;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        private final Pair<KtClass, ClassDescriptor> toAnnotationClass(KtAnnotationEntry $this$toAnnotationClass) {
            Object object;
            ClassDescriptor annotationTypeDescriptor;
            block6: {
                block5: {
                    KtClass ktClass;
                    BindingContext context2 = ResolutionUtils.analyze((KtElement)$this$toAnnotationClass, BodyResolveMode.PARTIAL);
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)$this$toAnnotationClass);
                    if (annotationDescriptor == null) {
                        return null;
                    }
                    AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                    ClassifierDescriptor classifierDescriptor = annotationDescriptor2.getType().getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    if (classDescriptor == null) {
                        return null;
                    }
                    annotationTypeDescriptor = classDescriptor;
                    PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)annotationTypeDescriptor));
                    object = psiElement2 instanceof KtClass ? (KtClass)psiElement2 : null;
                    if (object == null) break block5;
                    KtClass it = ktClass = object;
                    boolean bl = false;
                    object = it.isAnnotation() && it.isWritable() ? ktClass : null;
                    if (object != null) break block6;
                }
                return null;
            }
            KtClass annotationClass = object;
            return TuplesKt.to((Object)annotationClass, (Object)annotationTypeDescriptor);
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtAnnotationEntry> createAction(@NotNull Diagnostic diagnostic) {
            ClassDescriptor annotationClassDescriptor;
            if (!Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.WRONG_ANNOTATION_TARGET) && !Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET)) {
                return null;
            }
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtAnnotationEntry ktAnnotationEntry = psiElement2 instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement2 : null;
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry entry = ktAnnotationEntry;
            Pair<KtClass, ClassDescriptor> pair = this.toAnnotationClass(entry);
            if (pair == null) {
                return null;
            }
            Pair<KtClass, ClassDescriptor> pair2 = pair;
            KtClass annotationClass = (KtClass)pair2.component1();
            if (AddAnnotationTargetFixKt.access$getRequiredAnnotationTargets(entry, annotationClass, annotationClassDescriptor = (ClassDescriptor)pair2.component2(), entry.getProject()).isEmpty()) {
                return null;
            }
            return new AddAnnotationTargetFix(entry);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

