/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.presentation;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.presentation.KotlinDefaultNamedDeclarationPresentation;
import org.jetbrains.kotlin.idea.presentation.KotlinFunctionPresentation;
import org.jetbrains.kotlin.idea.presentation.KtJvmNameAnnotatedFilePresentation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/presentation/KtJvmNameAnnotationPresenter;", "Lcom/intellij/navigation/ItemPresentationProvider;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "()V", "getDeclarationPresentation", "Lcom/intellij/navigation/ItemPresentation;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "annotationEntry", "getPresentation", "kotlin.idea"})
public final class KtJvmNameAnnotationPresenter
implements ItemPresentationProvider<KtAnnotationEntry> {
    @Nullable
    public ItemPresentation getPresentation(@NotNull KtAnnotationEntry annotationEntry2) {
        ItemPresentation itemPresentation;
        Name name2 = annotationEntry2.getShortName();
        if (!Intrinsics.areEqual((Object)(name2 != null ? name2.asString() : null), (Object)JvmFileClassUtil.INSTANCE.getJVM_NAME_SHORT())) {
            return null;
        }
        PsiElement grandParent = annotationEntry2.getParent().getParent();
        if (grandParent instanceof KtFile) {
            itemPresentation = new KtJvmNameAnnotatedFilePresentation(annotationEntry2);
        } else if (grandParent instanceof KtFunction) {
            itemPresentation = (ItemPresentation)new KotlinFunctionPresentation((KtFunction)grandParent, JvmFileClassUtil.INSTANCE.getLiteralStringFromAnnotation(annotationEntry2));
        } else if (grandParent instanceof KtNamedDeclaration) {
            itemPresentation = this.getDeclarationPresentation((KtNamedDeclaration)grandParent, annotationEntry2);
        } else if (grandParent instanceof KtPropertyAccessor) {
            PsiElement $this$parentOfType_u24default$iv = grandParent;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtProperty.class, (boolean)true);
            if (ktProperty == null) {
                return null;
            }
            KtProperty property2 = ktProperty;
            itemPresentation = this.getDeclarationPresentation((KtNamedDeclaration)property2, annotationEntry2);
        } else {
            itemPresentation = null;
        }
        return itemPresentation;
    }

    private final ItemPresentation getDeclarationPresentation(KtNamedDeclaration declaration2, KtAnnotationEntry annotationEntry2) {
        return (ItemPresentation)new KotlinDefaultNamedDeclarationPresentation(declaration2, annotationEntry2){
            final /* synthetic */ KtAnnotationEntry $annotationEntry;
            {
                this.$annotationEntry = $annotationEntry;
                super($declaration);
            }

            @Nullable
            public String getPresentableText() {
                return JvmFileClassUtil.INSTANCE.getLiteralStringFromAnnotation(this.$annotationEntry);
            }
        };
    }
}

