/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.migration;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationProfileKt;

public class CodeInspectionAction
extends BaseAnalysisAction {
    private GlobalInspectionContextImpl myGlobalInspectionContext;
    private InspectionProfileImpl myExternalProfile;

    public CodeInspectionAction(@Nls String title, @Nls String analysisNoon) {
        super(title, analysisNoon);
    }

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope2) {
        try {
            this.runInspections(project, scope2);
        }
        finally {
            this.myGlobalInspectionContext = null;
            this.myExternalProfile = null;
        }
    }

    private void runInspections(Project project, AnalysisScope scope2) {
        scope2.setSearchInLibraries(false);
        FileDocumentManager.getInstance().saveAllDocuments();
        GlobalInspectionContextImpl inspectionContext = this.getGlobalInspectionContext(project);
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        this.myExternalProfile = KotlinMigrationProfileKt.createMigrationProfile(managerEx, null, null);
        inspectionContext.setExternalProfile(this.myExternalProfile);
        inspectionContext.setCurrentScope(scope2);
        inspectionContext.doInspections(scope2);
    }

    private GlobalInspectionContextImpl getGlobalInspectionContext(Project project) {
        if (this.myGlobalInspectionContext == null) {
            this.myGlobalInspectionContext = ((InspectionManagerEx)InspectionManager.getInstance((Project)project)).createNewGlobalContext(false);
        }
        return this.myGlobalInspectionContext;
    }

    @NonNls
    protected String getHelpTopic() {
        return "reference.dialogs.inspection.scope";
    }

    protected void canceled() {
        super.canceled();
        this.myGlobalInspectionContext = null;
    }
}

