/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.idea.base.codeInsight.tooling.IdePlatformKindToolingKt;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.inspections.KotlinMavenPluginPhaseInspectionKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\f\r\u000e\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "getStaticDescription", "", "AddExecutionLocalFix", "AddJavaExecutionsLocalFix", "ConfigurePluginExecutionLocalFix", "FixAddStdlibLocalFix", "FixExecutionPhaseLocalFix", "Holder", "kotlin.maven"})
public final class KotlinMavenPluginPhaseInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public KotlinMavenPluginPhaseInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @NotNull
    public String getStaticDescription() {
        return KotlinMavenBundle.message("inspection.description", new Object[0]);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        if (domFileElement == null || holder == null) {
            return;
        }
        v0 = domFileElement.getModule();
        if (v0 == null) {
            return;
        }
        module = v0;
        manager = MavenProjectsManager.getInstance((Project)module.getProject());
        v1 = manager.findProject(module);
        if (v1 == null) {
            return;
        }
        mavenProject = v1;
        v2 = PomFile.Companion.forFileOrNull(domFileElement.getFile());
        if (v2 == null) {
            return;
        }
        pom = v2;
        hasJavaFiles = KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(module);
        var9_8 = mavenProject.getPlugins();
        $i$f$filter = false;
        var11_12 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (MavenPlugin)element$iv$iv;
            $i$a$-filter-KotlinMavenPluginPhaseInspection$checkFileElement$executions$1 = false;
            if (!KotlinMavenPluginPhaseInspectionKt.access$isKotlinMavenPlugin(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (MavenPlugin)element$iv$iv;
            $i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2 = false;
            list$iv$iv = it.getExecutions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        executions = (List)destination$iv$iv;
        $i$f$flatMap = executions;
        destination$iv = new HashSet<E>();
        $i$f$flatMapTo = false;
        for (T element$iv : $this$flatMapTo$iv) {
            it = (MavenPlugin.Execution)element$iv;
            $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1 = false;
            list$iv = it.getGoals();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        allGoalsSet = (Set)destination$iv;
        hasJvmExecution = allGoalsSet.contains("compile") != false || allGoalsSet.contains("test-compile") != false;
        hasJsExecution = allGoalsSet.contains("js") != false || allGoalsSet.contains("test-js") != false;
        pomKotlinPlugins = pom.findKotlinPlugins();
        for (MavenDomPlugin kotlinPlugin : pomKotlinPlugins) {
            if (!allGoalsSet.contains("compile") && !allGoalsSet.contains("js")) {
                if (hasJavaFiles) {
                    $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1 = new AddExecutionLocalFix[]{new AddExecutionLocalFix(domFileElement.getFile(), module, kotlinPlugin, "compile")};
                    v3 = $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1;
                } else {
                    $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1 = new AddExecutionLocalFix[]{new AddExecutionLocalFix(domFileElement.getFile(), module, kotlinPlugin, "compile"), new AddExecutionLocalFix(domFileElement.getFile(), module, kotlinPlugin, "js")};
                    v3 = $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1;
                }
                fixes /* !! */  = v3;
                holder.createProblem(kotlinPlugin.getArtifactId().createStableCopy(), HighlightSeverity.WARNING, KotlinMavenBundle.message("inspection.no.executions", new Object[0]), (LocalQuickFix[])Arrays.copyOf(fixes /* !! */ , fixes /* !! */ .length));
                continue;
            }
            if (hasJavaFiles) {
                fixes /* !! */  = new String[]{"compile"};
                fixes /* !! */  = KotlinMavenPluginPhaseInspectionKt.access$notAtPhase(pom.findExecutions(kotlinPlugin, fixes /* !! */ ), "process-sources");
                $i$f$forEach = false;
                $i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2 = $this$forEach$iv.iterator();
                while ($i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2.hasNext()) {
                    block31: {
                        element$iv = $i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2.next();
                        badExecution = (MavenDomPluginExecution)element$iv;
                        $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$1 = false;
                        javacPlugin /* !! */  = mavenProject.findPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
                        $this$firstOrNull$iv = (LocalQuickFix[])pom.getDomModel().getBuild().getPlugins().getPlugins();
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (MavenDomPlugin)element$iv;
                            $i$a$-firstOrNull-KotlinMavenPluginPhaseInspection$checkFileElement$1$existingJavac$1 = false;
                            v4 = Intrinsics.areEqual((Object)it.getGroupId().getStringValue(), (Object)"org.apache.maven.plugins") && Intrinsics.areEqual((Object)it.getArtifactId().getStringValue(), (Object)"maven-compiler-plugin");
                            if (!v4) continue;
                            v5 = element$iv;
                            break block31;
                        }
                        v5 = null;
                    }
                    if ((existingJavac = (MavenDomPlugin)v5) != null && pom.isPluginAfter(existingJavac, kotlinPlugin) && !pom.isExecutionEnabled(javacPlugin /* !! */ , "default-compile") && !pom.isExecutionEnabled(javacPlugin /* !! */ , "default-testCompile") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-compile", "compile") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-testCompile", "testCompile")) continue;
                    $this$firstOrNull$iv = new LocalQuickFix[]{new FixExecutionPhaseLocalFix(badExecution, "process-sources"), new AddJavaExecutionsLocalFix(module, domFileElement.getFile(), kotlinPlugin)};
                    holder.createProblem(badExecution.getPhase().createStableCopy(), HighlightSeverity.WARNING, KotlinMavenBundle.message("inspection.should.run.before.javac", new Object[0]), $this$firstOrNull$iv);
                }
                $this$forEach$iv = new String[]{"js", "test-js"};
                $this$forEach$iv = pom.findExecutions(kotlinPlugin, (String[])$this$forEach$iv);
                $i$f$forEach = false;
                $i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2 = $this$forEach$iv.iterator();
                while ($i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2.hasNext()) {
                    block32: {
                        element$iv = $i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2.next();
                        badExecution = (MavenDomPluginExecution)element$iv;
                        $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2 = false;
                        javacPlugin /* !! */  = badExecution.getGoals().getGoals();
                        $this$firstOrNull$iv = holder;
                        $i$f$first = false;
                        for (T element$iv : $this$first$iv) {
                            it = (MavenDomGoal)element$iv;
                            $i$a$-first-KotlinMavenPluginPhaseInspection$checkFileElement$2$1 = false;
                            if (!KotlinMavenPluginPhaseInspectionKt.access$isJsGoal((MavenDomGoal)it)) continue;
                            break block32;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    $this$firstOrNull$iv.createProblem(((MavenDomGoal)element$iv).createStableCopy(), HighlightSeverity.WARNING, KotlinMavenBundle.message("inspection.javascript.in.java.module", new Object[0]));
                }
            }
            if (hasJvmExecution && PomFile.findDependencies$default(pom, Holder.INSTANCE.getJVM_STDLIB_IDS(), null, 2, null).isEmpty() && (stdlibDependencies = mavenProject.findDependencies("org.jetbrains.kotlin", "kotlin-stdlib")).isEmpty()) {
                $i$f$forEach = new Object[]{"kotlin-stdlib"};
                v6 = KotlinMavenBundle.message("inspection.jvm.no.stdlib.dependency", $i$f$forEach);
                $i$f$forEach = new LocalQuickFix[]{new FixAddStdlibLocalFix(domFileElement.getFile(), "kotlin-stdlib", kotlinPlugin.getVersion().getRawText())};
                holder.createProblem(kotlinPlugin.getArtifactId().createStableCopy(), HighlightSeverity.WARNING, v6, (LocalQuickFix[])$i$f$forEach);
            }
            if (!hasJsExecution || !PomFile.findDependencies$default(pom, Holder.INSTANCE.getJVM_STDLIB_IDS(), null, 2, null).isEmpty() || !(jsDependencies = mavenProject.findDependencies("org.jetbrains.kotlin", "kotlin-stdlib-js")).isEmpty()) continue;
            $i$f$forEach = new Object[]{"kotlin-stdlib-js"};
            v7 = KotlinMavenBundle.message("inspection.javascript.no.stdlib.dependency", $i$f$forEach);
            $i$f$forEach = new LocalQuickFix[]{new FixAddStdlibLocalFix(domFileElement.getFile(), "kotlin-stdlib-js", kotlinPlugin.getVersion().getRawText())};
            holder.createProblem(kotlinPlugin.getArtifactId().createStableCopy(), HighlightSeverity.WARNING, v7, (LocalQuickFix[])$i$f$forEach);
        }
        jvmStdlibDependencies = PomFile.findDependencies$default(pom, Holder.INSTANCE.getJVM_STDLIB_IDS(), null, 2, null);
        if (!hasJvmExecution && ((Collection)jvmStdlibDependencies).isEmpty() == false) {
            $this$forEach$iv = jvmStdlibDependencies;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                dep = (MavenDomDependency)element$iv;
                $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$3 = false;
                $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2 = new Object[]{dep.getArtifactId()};
                v8 = KotlinMavenBundle.message("inspection.configured.no.execution", $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2);
                $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2 = new LocalQuickFix[]{new ConfigurePluginExecutionLocalFix(module, domFileElement.getFile(), "compile", dep.getVersion().getRawText())};
                holder.createProblem(dep.getArtifactId().createStableCopy(), HighlightSeverity.WARNING, v8, (LocalQuickFix[])$i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2);
            }
        }
        stdlibJsDependencies = PomFile.findDependencies$default(pom, Holder.INSTANCE.getJS_STDLIB_MAVEN_ID(), null, 2, null);
        if (!hasJsExecution && ((Collection)stdlibJsDependencies).isEmpty() == false) {
            $this$forEach$iv = stdlibJsDependencies;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                dep = (MavenDomDependency)element$iv;
                $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$4 = false;
                $this$first$iv = new Object[]{dep.getArtifactId()};
                v9 = KotlinMavenBundle.message("inspection.configured.no.execution", $this$first$iv);
                $this$first$iv = new LocalQuickFix[]{new ConfigurePluginExecutionLocalFix(module, domFileElement.getFile(), "js", dep.getVersion().getRawText())};
                holder.createProblem(dep.getArtifactId().createStableCopy(), HighlightSeverity.WARNING, v9, (LocalQuickFix[])$this$first$iv);
            }
        }
        $this$filter$iv = pom.findKotlinExecutions();
        $i$f$filter = false;
        element$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block34: {
                block33: {
                    it = (MavenDomPluginExecution)element$iv$iv;
                    $i$a$-filter-KotlinMavenPluginPhaseInspection$checkFileElement$5 = false;
                    $this$any$iv = it.getGoals().getGoals();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v10 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            goal = (MavenDomGoal)element$iv;
                            $i$a$-any-KotlinMavenPluginPhaseInspection$checkFileElement$5$1 = false;
                            if (!(Intrinsics.areEqual((Object)goal.getRawText(), (Object)"compile") != false || Intrinsics.areEqual((Object)goal.getRawText(), (Object)"js") != false)) continue;
                            v10 = true;
                            break block33;
                        }
                        v10 = false;
                    }
                }
                if (!v10) ** GOTO lbl-1000
                $this$any$iv = it.getGoals().getGoals();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v11 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        goal = (MavenDomGoal)element$iv;
                        $i$a$-any-KotlinMavenPluginPhaseInspection$checkFileElement$5$2 = false;
                        if (!(Intrinsics.areEqual((Object)goal.getRawText(), (Object)"test-compile") != false || Intrinsics.areEqual((Object)goal.getRawText(), (Object)"test-js") != false)) continue;
                        v11 = true;
                        break block34;
                    }
                    v11 = false;
                }
            }
            if (v11) {
                v12 = true;
            } else lbl-1000:
            // 2 sources

            {
                v12 = false;
            }
            if (!v12) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            badExecution = (MavenDomPluginExecution)element$iv;
            $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$6 = false;
            holder.createProblem(badExecution.getGoals().createStableCopy(), HighlightSeverity.WEAK_WARNING, KotlinMavenBundle.message("inspection.same.execution.compile.test", new Object[0]));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$Holder;", "", "()V", "JS_STDLIB_MAVEN_ID", "Lorg/jetbrains/idea/maven/model/MavenId;", "getJS_STDLIB_MAVEN_ID", "()Lorg/jetbrains/idea/maven/model/MavenId;", "JVM_STDLIB_IDS", "", "getJVM_STDLIB_IDS", "()Ljava/util/List;", "kotlin.maven"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE;
        @NotNull
        private static final List<MavenId> JVM_STDLIB_IDS;
        @NotNull
        private static final MavenId JS_STDLIB_MAVEN_ID;

        private Holder() {
        }

        @NotNull
        public final List<MavenId> getJVM_STDLIB_IDS() {
            return JVM_STDLIB_IDS;
        }

        @NotNull
        public final MavenId getJS_STDLIB_MAVEN_ID() {
            return JS_STDLIB_MAVEN_ID;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void $this$mapTo$iv$iv;
            INSTANCE = new Holder();
            Iterable $this$map$iv = IdePlatformKindToolingKt.getTooling((IdePlatformKind)JvmIdePlatformKind.INSTANCE).getMavenLibraryIds();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new MavenId("org.jetbrains.kotlin", (String)it, null));
            }
            JVM_STDLIB_IDS = (List)var3_3;
            JS_STDLIB_MAVEN_ID = new MavenId("org.jetbrains.kotlin", "kotlin-stdlib-js", null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "file", "Lcom/intellij/psi/xml/XmlFile;", "module", "Lcom/intellij/openapi/module/Module;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "goal", "", "(Lcom/intellij/psi/xml/XmlFile;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;Ljava/lang/String;)V", "getGoal", "()Ljava/lang/String;", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class AddExecutionLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;
        @NotNull
        private final String goal;
        @NotNull
        private final SmartPsiElementPointer<XmlFile> pointer;

        public AddExecutionLocalFix(@NotNull XmlFile file2, @NotNull Module module2, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String goal) {
            this.module = module2;
            this.kotlinPlugin = kotlinPlugin;
            this.goal = goal;
            this.pointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)file2));
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.goal};
            return KotlinMavenBundle.message("fix.add.execution.name", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.add.execution.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            XmlFile xmlFile = (XmlFile)this.pointer.getElement();
            if (xmlFile == null) {
                return;
            }
            XmlFile file2 = xmlFile;
            PomFile pomFile = PomFile.Companion.forFileOrNull(file2);
            if (pomFile != null) {
                pomFile.addKotlinExecution(this.module, this.kotlinPlugin, this.goal, PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixExecutionPhaseLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "execution", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "newPhase", "", "(Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;Ljava/lang/String;)V", "getExecution", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "getNewPhase", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class FixExecutionPhaseLocalFix
    implements LocalQuickFix {
        @NotNull
        private final MavenDomPluginExecution execution;
        @NotNull
        private final String newPhase;

        public FixExecutionPhaseLocalFix(@NotNull MavenDomPluginExecution execution, @NotNull String newPhase) {
            this.execution = execution;
            this.newPhase = newPhase;
        }

        @NotNull
        public final MavenDomPluginExecution getExecution() {
            return this.execution;
        }

        @NotNull
        public final String getNewPhase() {
            return this.newPhase;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.newPhase};
            return KotlinMavenBundle.message("fix.execution.phase.name", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.execution.phase.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            this.execution.getPhase().setValue((Object)this.newPhase);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddJavaExecutionsLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/xml/XmlFile;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;)V", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.maven"})
    private static final class AddJavaExecutionsLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;
        @NotNull
        private final SmartPsiElementPointer<XmlFile> pointer;

        public AddJavaExecutionsLocalFix(@NotNull Module module2, @NotNull XmlFile file2, @NotNull MavenDomPlugin kotlinPlugin) {
            this.module = module2;
            this.kotlinPlugin = kotlinPlugin;
            this.pointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)file2));
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        @NotNull
        public String getName() {
            return KotlinMavenBundle.message("fix.add.java.executions.name", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                XmlFile xmlFile = (XmlFile)this.pointer.getElement();
                if (xmlFile == null) {
                    return;
                }
                XmlFile file2 = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(file2);
                if (pomFile == null) break block1;
                pomFile.addJavacExecutions(this.module, this.kotlinPlugin);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixAddStdlibLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "pomFile", "Lcom/intellij/psi/xml/XmlFile;", "id", "", "version", "(Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getVersion", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class FixAddStdlibLocalFix
    implements LocalQuickFix {
        @NotNull
        private final String id;
        @Nullable
        private final String version;
        @NotNull
        private final SmartPsiElementPointer<XmlFile> pointer;

        public FixAddStdlibLocalFix(@NotNull XmlFile pomFile, @NotNull String id, @Nullable String version2) {
            this.id = id;
            this.version = version2;
            this.pointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)pomFile));
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.id};
            return KotlinMavenBundle.message("fix.add.stdlib.name", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.add.stdlib.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                XmlFile xmlFile = (XmlFile)this.pointer.getElement();
                if (xmlFile == null) {
                    return;
                }
                XmlFile file2 = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(file2);
                if (pomFile == null) break block1;
                PomFile.addDependency$default(pomFile, new MavenId("org.jetbrains.kotlin", this.id, this.version), MavenArtifactScope.COMPILE, null, false, null, 28, null);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$ConfigurePluginExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "goal", "", "version", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getGoal", "()Ljava/lang/String;", "getModule", "()Lcom/intellij/openapi/module/Module;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getVersion", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class ConfigurePluginExecutionLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final String goal;
        @Nullable
        private final String version;
        @NotNull
        private final SmartPsiElementPointer<XmlFile> pointer;

        public ConfigurePluginExecutionLocalFix(@NotNull Module module2, @NotNull XmlFile xmlFile, @NotNull String goal, @Nullable String version2) {
            this.module = module2;
            this.goal = goal;
            this.version = version2;
            this.pointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)xmlFile));
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.goal};
            return KotlinMavenBundle.message("fix.configure.plugin.execution.name", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.configure.plugin.execution.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                XmlFile xmlFile = (XmlFile)this.pointer.getElement();
                if (xmlFile == null) {
                    return;
                }
                XmlFile file2 = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(file2);
                if (pomFile == null) break block1;
                PomFile pom2 = pomFile;
                boolean bl = false;
                MavenDomPlugin plugin = pom2.addKotlinPlugin(this.version);
                pom2.addKotlinExecution(this.module, plugin, "compile", PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
            }
        }
    }
}

