/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/AddMavenDependencyQuickFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "className", "", "smartPsiElementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Ljava/lang/String;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getClassName", "()Ljava/lang/String;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "kotlin.maven"})
public final class AddMavenDependencyQuickFix
implements IntentionAction,
LowPriorityAction {
    @NotNull
    private final String className;
    @NotNull
    private final SmartPsiElementPointer<KtSimpleNameExpression> smartPsiElementPointer;

    public AddMavenDependencyQuickFix(@NotNull String className, @NotNull SmartPsiElementPointer<KtSimpleNameExpression> smartPsiElementPointer) {
        this.className = className;
        this.smartPsiElementPointer = smartPsiElementPointer;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public String getText() {
        return KotlinMavenBundle.message("fix.add.maven.dependency.name", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file2) {
        KtSimpleNameExpression it = (KtSimpleNameExpression)this.smartPsiElementPointer.getElement();
        boolean bl = false;
        return it != null && it.isValid() && file2 != null && MavenDomUtil.findContainingProject((PsiElement)((PsiElement)file2)) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file2) {
        if (editor2 == null || file2 == null) {
            return;
        }
        VirtualFile virtualFile = file2.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        MavenProject mavenProject = MavenDomUtil.findContainingProject((PsiElement)((PsiElement)file2));
        if (mavenProject == null) {
            return;
        }
        MavenProject mavenProject2 = mavenProject;
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(mavenProject2.getFile());
        XmlFile xmlFile = psiFile2 instanceof XmlFile ? (XmlFile)psiFile2 : null;
        if (xmlFile == null) {
            return;
        }
        XmlFile xmlFile2 = xmlFile;
        List ids = MavenArtifactSearchDialog.searchForClass((Project)project, (String)this.className);
        if (ids.isEmpty()) {
            return;
        }
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(project, virtualFile2, xmlFile2, ids){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            final /* synthetic */ XmlFile $xmlFile$inlined;
            final /* synthetic */ List $ids$inlined;
            {
                this.$project$inlined = project;
                this.$virtualFile$inlined = virtualFile;
                this.$xmlFile$inlined = xmlFile;
                this.$ids$inlined = list2;
            }

            public final T compute() {
                Unit unit2;
                boolean bl = false;
                ProjectFileIndex fileIndex2 = ProjectRootManager.getInstance((Project)this.$project$inlined).getFileIndex();
                boolean isTestSource = Intrinsics.areEqual((Object)KotlinProjectStructureUtils.getKotlinSourceRootType((FileIndex)fileIndex2, this.$virtualFile$inlined), (Object)TestSourceKotlinRootType.INSTANCE);
                MavenArtifactScope scope2 = isTestSource ? MavenArtifactScope.TEST : null;
                PomFile pomFile = PomFile.Companion.forFileOrNull(this.$xmlFile$inlined);
                if (pomFile != null) {
                    PomFile pom2 = pomFile;
                    boolean bl2 = false;
                    Iterable $this$forEach$iv = this.$ids$inlined;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        MavenId it = (MavenId)element$iv;
                        boolean bl3 = false;
                        PomFile.addDependency$default(pom2, it, scope2, null, false, null, 28, null);
                    }
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                return (T)unit2;
            }
        });
    }
}

