/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.MavenModulesRelationshipKt;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.PomFileKt;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.projectConfiguration.RepositoryDescription;
import org.jetbrains.kotlin.idea.quickfix.AbstractChangeFeatureSupportLevelFix;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 H2\u00020\u0001:\u0001HB)\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J,\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001f\u001a\u00020\u0003H\u0002J(\u0010 \u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0-H\u0016J(\u0010.\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J(\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0014J8\u00104\u001a\u00020\r2\u0006\u00105\u001a\u0002012\u0006\u00106\u001a\u0002032\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u0005H\u0004J \u0010:\u001a\u00020\r2\u0006\u00105\u001a\u0002012\u0006\u00106\u001a\u0002032\u0006\u0010\u000e\u001a\u00020\u000fH$J\b\u0010;\u001a\u00020\u0003H\u0014J\u0010\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020>H\u0016J\u0018\u0010?\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H$J\u0010\u0010@\u001a\u00020\u00052\u0006\u00100\u001a\u000201H\u0002J\u0010\u0010A\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0010\u0010B\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0003H$J4\u0010C\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010D\u001a\u0004\u0018\u00010\u00032\b\u0010E\u001a\u0004\u0018\u00010\u00032\u0006\u0010F\u001a\u00020G2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "testArtifactId", "", "addJunit", "", "name", "presentableText", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPresentableText", "addLibraryDependency", "", "module", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "library", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "changeGeneralFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "forTests", "changeMavenFeatureConfiguration", "messageTitle", "changePomFile", "file", "Lcom/intellij/psi/PsiFile;", "version", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "checkKotlinPlugin", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "configureModule", "configurePlugin", "pom", "Lorg/jetbrains/kotlin/idea/maven/PomFile;", "plugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "createExecution", "pomFile", "kotlinPlugin", "executionId", "goalName", "isTest", "createExecutions", "getMinimumSupportedVersion", "getStatus", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleSourceRootGroup;", "getStdlibArtifactId", "hasKotlinPlugin", "isKotlinModule", "isRelevantGoal", "updateLanguageVersion", "languageVersion", "apiVersion", "requiredStdlibVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "Companion", "kotlin.maven"})
public abstract class KotlinMavenConfigurator
implements KotlinProjectConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String testArtifactId;
    private final boolean addJunit;
    @NotNull
    private final String name;
    @NotNull
    private final String presentableText;
    @NotNull
    public static final String GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    public static final String MAVEN_PLUGIN_ID = "kotlin-maven-plugin";
    @NotNull
    private static final String KOTLIN_VERSION_PROPERTY = "kotlin.version";

    protected KotlinMavenConfigurator(@Nullable String testArtifactId, boolean addJunit, @NotNull String name2, @NotNull String presentableText) {
        this.testArtifactId = testArtifactId;
        this.addJunit = addJunit;
        this.name = name2;
        this.presentableText = presentableText;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.presentableText;
    }

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        Module module2 = moduleSourceRootGroup.getBaseModule();
        if (BuildSystemTypeKt.getBuildSystemType(module2) != BuildSystemType.Maven) {
            return ConfigureKotlinStatus.NON_APPLICABLE;
        }
        boolean $i$f$runReadAction = false;
        PsiFile psi2 = (PsiFile)ApplicationManager.getApplication().runReadAction(new Computable(module2){
            final /* synthetic */ Module $module$inlined;
            {
                this.$module$inlined = module2;
            }

            public final T compute() {
                boolean bl = false;
                return (T)KotlinMavenConfigurator.Companion.findModulePomFile(this.$module$inlined);
            }
        });
        if (psi2 == null || !psi2.isValid() || !(psi2 instanceof XmlFile) || ((XmlFile)psi2).getVirtualFile() == null) {
            return ConfigureKotlinStatus.BROKEN;
        }
        if (this.isKotlinModule(module2)) {
            $i$f$runReadAction = false;
            return (ConfigureKotlinStatus)((Object)ApplicationManager.getApplication().runReadAction(new Computable(this, module2){
                final /* synthetic */ KotlinMavenConfigurator this$0;
                final /* synthetic */ Module $module$inlined;
                {
                    this.this$0 = kotlinMavenConfigurator;
                    this.$module$inlined = module2;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)((Object)KotlinMavenConfigurator.access$checkKotlinPlugin(this.this$0, this.$module$inlined));
                }
            }));
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    private final ConfigureKotlinStatus checkKotlinPlugin(Module module2) {
        boolean bl;
        block15: {
            Object v3;
            block13: {
                PsiFile psiFile2 = Companion.findModulePomFile(module2);
                XmlFile xmlFile = psiFile2 instanceof XmlFile ? (XmlFile)psiFile2 : null;
                if (xmlFile == null) {
                    return ConfigureKotlinStatus.BROKEN;
                }
                XmlFile psi2 = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(psi2);
                if (pomFile == null) {
                    return ConfigureKotlinStatus.NON_APPLICABLE;
                }
                PomFile pom2 = pomFile;
                if (this.hasKotlinPlugin(pom2)) {
                    return ConfigureKotlinStatus.CONFIGURED;
                }
                MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module2.getProject());
                MavenProject mavenProject = mavenProjectsManager.findProject(module2);
                if (mavenProject == null) {
                    return ConfigureKotlinStatus.BROKEN;
                }
                MavenProject mavenProject2 = mavenProject;
                MavenId kotlinPluginId = PomFileKt.kotlinPluginId(null);
                Iterable iterable = mavenProject2.getPlugins();
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    MavenPlugin it = (MavenPlugin)t;
                    boolean bl2 = false;
                    if (!it.getMavenId().equals(kotlinPluginId.getGroupId(), kotlinPluginId.getArtifactId())) continue;
                    v3 = t;
                    break block13;
                }
                v3 = null;
            }
            MavenPlugin mavenPlugin = v3;
            if (mavenPlugin == null) {
                return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
            }
            MavenPlugin kotlinPlugin = mavenPlugin;
            Iterable $this$any$iv = kotlinPlugin.getExecutions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block14: {
                        MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv;
                        boolean bl4 = false;
                        Iterable $this$any$iv2 = it.getGoals();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String p0 = (String)element$iv2;
                                boolean bl5 = false;
                                if (!this.isRelevantGoal(p0)) continue;
                                bl3 = true;
                                break block14;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            return ConfigureKotlinStatus.CONFIGURED;
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    private final boolean hasKotlinPlugin(PomFile pom2) {
        boolean bl;
        block9: {
            MavenDomPlugin mavenDomPlugin = pom2.findPlugin(PomFileKt.kotlinPluginId(null));
            if (mavenDomPlugin == null) {
                return false;
            }
            MavenDomPlugin plugin = mavenDomPlugin;
            Iterable $this$any$iv = plugin.getExecutions().getExecutions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        MavenDomPluginExecution it = (MavenDomPluginExecution)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = it.getGoals().getGoals();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                MavenDomGoal it2 = (MavenDomGoal)element$iv2;
                                boolean bl4 = false;
                                String string2 = it2.getStringValue();
                                if (string2 == null) {
                                    string2 = "";
                                }
                                if (!this.isRelevantGoal(string2)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void configure(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project, this, excludeModules, this.getMinimumSupportedVersion());
        dialog2.show();
        if (!dialog2.isOK()) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> KotlinMavenConfigurator.configure$lambda$6(project, dialog2, this));
    }

    @NotNull
    protected String getMinimumSupportedVersion() {
        return "1.0.0";
    }

    protected abstract boolean isKotlinModule(@NotNull Module var1);

    protected abstract boolean isRelevantGoal(@NotNull String var1);

    protected abstract void createExecutions(@NotNull PomFile var1, @NotNull MavenDomPlugin var2, @NotNull Module var3);

    @NotNull
    protected abstract String getStdlibArtifactId(@NotNull Module var1, @NotNull IdeKotlinVersion var2);

    public boolean configureModule(@NotNull Module module2, @NotNull PsiFile file2, @NotNull IdeKotlinVersion version2, @NotNull NotificationMessageCollector collector2) {
        return this.changePomFile(module2, file2, version2, collector2);
    }

    private final boolean changePomFile(Module module2, PsiFile file2, IdeKotlinVersion version2, NotificationMessageCollector collector2) {
        RepositoryDescription repositoryDescription;
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(("Virtual file should exists for psi file " + file2.getName()).toString());
        }
        VirtualFile virtualFile2 = virtualFile;
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel((Project)module2.getProject(), (VirtualFile)virtualFile2);
        if (domModel == null) {
            KotlinMavenConfigurator.Companion.showErrorMessage(module2.getProject(), null);
            return false;
        }
        Intrinsics.checkNotNull((Object)file2, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        PomFile pomFile = PomFile.Companion.forFileOrNull((XmlFile)file2);
        if (pomFile == null) {
            return false;
        }
        PomFile pom2 = pomFile;
        pom2.addProperty(KOTLIN_VERSION_PROPERTY, version2.getArtifactVersion());
        pom2.addDependency(new MavenId(GROUP_ID, this.getStdlibArtifactId(module2, version2), "${kotlin.version}"), MavenArtifactScope.COMPILE, null, false, null);
        if (this.testArtifactId != null) {
            pom2.addDependency(new MavenId(GROUP_ID, this.testArtifactId, "${kotlin.version}"), MavenArtifactScope.TEST, null, false, null);
        }
        if (this.addJunit) {
            pom2.addDependency(new MavenId("junit", "junit", "4.12"), MavenArtifactScope.TEST, null, false, null);
        }
        if ((repositoryDescription = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion(version2)) != null) {
            pom2.addLibraryRepository(repositoryDescription);
            pom2.addPluginRepository(repositoryDescription);
        }
        MavenDomPlugin plugin = pom2.addPlugin(new MavenId(GROUP_ID, MAVEN_PLUGIN_ID, "${kotlin.version}"));
        this.createExecutions(pom2, plugin, module2);
        this.configurePlugin(pom2, plugin, module2, version2);
        CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)file2));
        Object[] objectArray = new Object[]{virtualFile2.getPath()};
        collector2.addMessage(KotlinMavenBundle.message("file.was.modified", objectArray));
        return true;
    }

    protected void configurePlugin(@NotNull PomFile pom2, @NotNull MavenDomPlugin plugin, @NotNull Module module2, @NotNull IdeKotlinVersion version2) {
    }

    protected final void createExecution(@NotNull PomFile pomFile, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String executionId, @NotNull String goalName, @NotNull Module module2, boolean isTest) {
        pomFile.addKotlinExecution(module2, kotlinPlugin, executionId, PomFile.Companion.getPhase(false, isTest), isTest, CollectionsKt.listOf((Object)goalName));
        if (KotlinMavenConfigurator.Companion.hasJavaFiles(module2)) {
            pomFile.addJavacExecutions(module2, kotlinPlugin);
        }
    }

    @Override
    public void updateLanguageVersion(@NotNull Module module2, @Nullable String languageVersion, @Nullable String apiVersion2, @NotNull ApiVersion requiredStdlibVersion, boolean forTests) {
        boolean runtimeUpdateRequired;
        IdeKotlinVersion ideKotlinVersion = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module2);
        if (ideKotlinVersion != null && (ideKotlinVersion = ideKotlinVersion.getApiVersion()) != null) {
            IdeKotlinVersion runtimeVersion = ideKotlinVersion;
            boolean bl = false;
            v1 = runtimeVersion.compareTo(requiredStdlibVersion) < 0;
        } else {
            v1 = runtimeUpdateRequired = false;
        }
        if (runtimeUpdateRequired) {
            Object[] objectArray = new Object[]{requiredStdlibVersion};
            Messages.showErrorDialog((Project)module2.getProject(), (String)KotlinMavenBundle.message("update.language.version.feature", objectArray), (String)KotlinMavenBundle.message("update.language.version.title", new Object[0]));
            return;
        }
        PsiElement element3 = KotlinMavenConfigurator.updateLanguageVersion$doUpdateMavenLanguageVersion(module2, languageVersion, apiVersion2);
        if (element3 == null) {
            Messages.showErrorDialog((Project)module2.getProject(), (String)KotlinMavenBundle.message("error.failed.update.pom", new Object[0]), (String)KotlinMavenBundle.message("update.language.version.title", new Object[0]));
        } else {
            new OpenFileDescriptor(module2.getProject(), element3.getContainingFile().getVirtualFile(), element3.getTextRange().getStartOffset()).navigate(true);
        }
    }

    @Override
    public void addLibraryDependency(@NotNull Module module2, @NotNull PsiElement element3, @NotNull ExternalLibraryDescriptor library2, @NotNull LibraryJarDescriptor libraryJarDescriptor, @NotNull DependencyScope scope2) {
        DependencyScope scope3 = OrderEntryFix.suggestScopeByLocation((Module)module2, (PsiElement)element3);
        JavaProjectModelModificationService.getInstance((Project)module2.getProject()).addDependency(module2, library2, scope3);
    }

    @Override
    public void changeGeneralFeatureConfiguration(@NotNull Module module2, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
        ApiVersion sinceVersion = feature.getSinceApiVersion();
        String messageTitle = AbstractChangeFeatureSupportLevelFix.Companion.getFixText(state, feature.getPresentableName());
        if (state != LanguageFeature.State.DISABLED && KotlinVersionInfoProviderKt.getRuntimeLibraryVersionOrDefault(module2).getApiVersion().compareTo(sinceVersion) < 0) {
            Object[] objectArray = new Object[]{feature.getPresentableName(), sinceVersion};
            Messages.showErrorDialog((Project)module2.getProject(), (String)KotlinMavenBundle.message("update.language.version.feature.support", objectArray), (String)messageTitle);
            return;
        }
        PsiElement element3 = this.changeMavenFeatureConfiguration(module2, feature, state, messageTitle);
        if (element3 != null) {
            new OpenFileDescriptor(module2.getProject(), element3.getContainingFile().getVirtualFile(), element3.getTextRange().getStartOffset()).navigate(true);
        }
    }

    private final PsiElement changeMavenFeatureConfiguration(Module module2, LanguageFeature feature, LanguageFeature.State state, @NlsContexts.DialogTitle String messageTitle) {
        PsiFile psiFile2 = Companion.findModulePomFile(module2);
        XmlFile xmlFile = psiFile2 instanceof XmlFile ? (XmlFile)psiFile2 : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psi2 = xmlFile;
        PomFile pomFile = PomFile.Companion.forFileOrNull(psi2);
        if (pomFile == null) {
            return null;
        }
        PomFile pom2 = pomFile;
        PsiElement element3 = PomFileKt.changeFeatureConfiguration(pom2, feature, state);
        if (element3 == null) {
            Messages.showErrorDialog((Project)module2.getProject(), (String)KotlinMavenBundle.message("error.failed.update.pom", new Object[0]), (String)messageTitle);
        }
        return element3;
    }

    private static final void configure$lambda$6(Project $project, ConfigureDialogWithModulesAndVersion $dialog, KotlinMavenConfigurator this$0) {
        NotificationMessageCollector collector2 = NotificationMessageCollector.Companion.create($project);
        for (Module module2 : MavenModulesRelationshipKt.excludeMavenChildrenModules($project, $dialog.getModulesToConfigure())) {
            PsiFile file2 = Companion.findModulePomFile(module2);
            if (file2 != null && KotlinMavenConfigurator.Companion.canConfigureFile(file2)) {
                this$0.configureModule(module2, file2, IdeKotlinVersion.Companion.get($dialog.getKotlinVersion()), collector2);
                OpenFileAction.Companion.openFile(file2.getVirtualFile(), $project);
                continue;
            }
            Object[] objectArray = new Object[]{module2.getName()};
            KotlinMavenConfigurator.Companion.showErrorMessage($project, KotlinMavenBundle.message("error.cant.find.pom.for.module", objectArray));
        }
        collector2.showNotification();
    }

    private static final PsiElement updateLanguageVersion$doUpdateMavenLanguageVersion(Module $module, String $languageVersion, String $apiVersion) {
        PsiFile psiFile2 = Companion.findModulePomFile($module);
        XmlFile xmlFile = psiFile2 instanceof XmlFile ? (XmlFile)psiFile2 : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psi2 = xmlFile;
        PomFile pomFile = PomFile.Companion.forFileOrNull(psi2);
        if (pomFile == null) {
            return null;
        }
        PomFile pom2 = pomFile;
        return PomFileKt.changeLanguageVersion(pom2, $languageVersion, $apiVersion);
    }

    public static final /* synthetic */ ConfigureKotlinStatus access$checkKotlinPlugin(KotlinMavenConfigurator $this, Module module2) {
        return $this.checkKotlinPlugin(module2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator$Companion;", "", "()V", "GROUP_ID", "", "KOTLIN_VERSION_PROPERTY", "MAVEN_PLUGIN_ID", "canConfigureFile", "", "file", "Lcom/intellij/psi/PsiFile;", "findModulePomFile", "module", "Lcom/intellij/openapi/module/Module;", "hasJavaFiles", "showErrorMessage", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "kotlin.maven"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasJavaFiles(Module module2) {
            return !FileTypeIndex.getFiles((FileType)((FileType)JavaFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module2)).isEmpty();
        }

        @Nullable
        public final PsiFile findModulePomFile(@NotNull Module module2) {
            List files2 = MavenProjectsManager.getInstance((Project)module2.getProject()).getProjectsFiles();
            for (VirtualFile file2 : files2) {
                PsiFile psiFile2;
                Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)module2.getProject());
                if (!Intrinsics.areEqual((Object)module2, (Object)fileModule) || PsiManager.getInstance((Project)module2.getProject()).findFile(file2) == null || !MavenDomUtil.isProjectFile((PsiFile)psiFile2)) continue;
                return psiFile2;
            }
            return null;
        }

        private final boolean canConfigureFile(PsiFile file2) {
            return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file2.getVirtualFile(), null);
        }

        private final void showErrorMessage(Project project, @NlsContexts.DialogMessage String message2) {
            String cantConfigureAutomatically = KotlinMavenBundle.message("error.cant.configure.maven.automatically", new Object[0]);
            String seeInstructions = KotlinMavenBundle.message("error.see.installation.instructions", new Object[0]);
            String string2 = message2;
            Messages.showErrorDialog((Project)project, (String)("<html>" + cantConfigureAutomatically + "<br/>" + (String)(string2 != null ? string2 + "</br>" : "") + seeInstructions + "</html>"), (String)KotlinMavenBundle.message("configure.title", new Object[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

