/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.macros;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/macros/KotlinBundledRefresher;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "kotlin.idea"})
public final class KotlinBundledRefresher
implements StartupActivity.DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INSTALLED_KOTLIN_VERSION = "installed.kotlin.plugin.version";

    public KotlinBundledRefresher() {
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    public void runActivity(@NotNull Project project) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String installedKotlinVersion = propertiesComponent.getValue(INSTALLED_KOTLIN_VERSION);
        if (!Intrinsics.areEqual((Object)KotlinIdePlugin.INSTANCE.getVersion(), (Object)installedKotlinVersion)) {
            Companion.requestKotlinDistRefresh(KotlinPluginLayout.getKotlinc().toPath());
            propertiesComponent.setValue(INSTALLED_KOTLIN_VERSION, KotlinIdePlugin.INSTANCE.getVersion());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/macros/KotlinBundledRefresher$Companion;", "", "()V", "INSTALLED_KOTLIN_VERSION", "", "requestFullJarUpdate", "", "jarFilePath", "Ljava/nio/file/Path;", "requestKotlinDistRefresh", "kotlinBundledPath", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        private final void requestFullJarUpdate(Path jarFilePath) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(jarFilePath);
            if (virtualFile == null) {
                return;
            }
            VirtualFile localVirtualFile = virtualFile;
            VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(localVirtualFile);
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile jarFile = virtualFile2;
            VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
            VfsUtilCore.visitChildrenRecursively((VirtualFile)jarFile, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(optionArray){}));
            ((NewVirtualFile)jarFile).markDirtyRecursively();
        }

        /*
         * WARNING - void declaration
         */
        public final void requestKotlinDistRefresh(@NotNull Path kotlinBundledPath) {
            void $this$filterTo$iv$iv;
            Path path2;
            Path it = path2 = kotlinBundledPath.resolve("lib");
            boolean $i$a$-also-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$22 = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean $i$a$-require-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$1$22 = false;
                String $i$a$-require-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$1$22 = "kotlin-dist invalid dir layout";
                throw new IllegalArgumentException($i$a$-require-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$1$22.toString());
            }
            Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)path2, null, (int)1, null);
            boolean $i$f$filter = false;
            Iterable $i$a$-also-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it2 = (Path)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it2), (Object)"jar")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it3 = (Path)element$iv;
                boolean bl = false;
                Companion.requestFullJarUpdate(it3);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

