/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.liveTemplates;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlighter;
import org.jetbrains.kotlin.idea.liveTemplates.KotlinLiveTemplatesBundle;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtScriptInitializer;

public abstract class KotlinTemplateContextType
extends TemplateContextType {
    private KotlinTemplateContextType(@NotNull @NlsContexts.Label String presentableName) {
        super(presentableName);
    }

    public boolean isInContext(@NotNull PsiFile file2, int offset2) {
        PsiElement parent2;
        IElementType elementType;
        if (!PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset2).isKindOf((Language)KotlinLanguage.INSTANCE)) {
            return false;
        }
        PsiElement element3 = file2.findElementAt(offset2);
        if (element3 == null) {
            element3 = file2.findElementAt(offset2 - 1);
        }
        if (element3 instanceof PsiWhiteSpace) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element3, PsiComment.class, (boolean)false) != null) {
            return this.isCommentInContext();
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element3, KtPackageDirective.class) != null || PsiTreeUtil.getParentOfType((PsiElement)element3, KtImportDirective.class) != null) {
            return false;
        }
        if (element3 instanceof LeafPsiElement && (elementType = ((LeafPsiElement)element3).getElementType()) == KtTokens.IDENTIFIER && (parent2 = element3.getParent()) instanceof KtReferenceExpression) {
            PsiElement parentOfParent = parent2.getParent();
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)element3, KtQualifiedExpression.class);
            if (qualifiedExpression != null && qualifiedExpression.getSelectorExpression() == parentOfParent) {
                return false;
            }
        }
        return element3 != null && this.isInContext(element3);
    }

    @Nullable
    public SyntaxHighlighter createHighlighter() {
        return new KotlinHighlighter();
    }

    protected boolean isCommentInContext() {
        return false;
    }

    protected abstract boolean isInContext(@NotNull PsiElement var1);

    private static <T extends PsiElement> T getParentClassOrObject(@NotNull PsiElement element3, @NotNull java.lang.Class<? extends T> klass2) {
        PsiElement e = element3;
        while (e != null && !klass2.isInstance(e)) {
            if (e instanceof KtModifierList) {
                if ((e = e.getParent()) == null) continue;
                e = e.getParent();
                continue;
            }
            if (e instanceof KtProperty || e instanceof KtNamedFunction) {
                return null;
            }
            e = e.getParent();
        }
        return (T)e;
    }

    public static class Comment
    extends KotlinTemplateContextType {
        public Comment() {
            super(KotlinLiveTemplatesBundle.message("template.context.type.comment", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element3) {
            return false;
        }

        @Override
        protected boolean isCommentInContext() {
            return true;
        }
    }

    public static class Expression
    extends KotlinTemplateContextType {
        public Expression() {
            super(KotlinLiveTemplatesBundle.message("template.context.type.expression", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element3) {
            return element3.getParent() instanceof KtExpression && !(element3.getParent() instanceof KtConstantExpression) && !(element3.getParent().getParent() instanceof KtDotQualifiedExpression) && !(element3.getParent() instanceof KtParameter);
        }
    }

    public static class Statement
    extends KotlinTemplateContextType {
        public Statement() {
            super(KotlinLiveTemplatesBundle.message("template.context.type.statement", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element3) {
            PsiElement parentStatement = PsiTreeUtil.findFirstParent((PsiElement)element3, e -> e instanceof KtExpression && KtPsiUtil.isStatementContainer((PsiElement)e.getParent()));
            if (parentStatement == null) {
                return false;
            }
            return element3.getTextOffset() == parentStatement.getTextOffset();
        }
    }

    public static class Class
    extends KotlinTemplateContextType {
        public Class() {
            super(KotlinLiveTemplatesBundle.message("template.context.type.class", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element3) {
            return KotlinTemplateContextType.getParentClassOrObject(element3, KtClassOrObject.class) != null;
        }
    }

    public static class ObjectDeclaration
    extends KotlinTemplateContextType {
        public ObjectDeclaration() {
            super(KotlinLiveTemplatesBundle.message("template.context.type.object", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element3) {
            KtObjectDeclaration objectDeclaration = KotlinTemplateContextType.getParentClassOrObject(element3, KtObjectDeclaration.class);
            return objectDeclaration != null && !objectDeclaration.isObjectLiteral();
        }
    }

    public static class TopLevel
    extends KotlinTemplateContextType {
        public TopLevel() {
            super(KotlinLiveTemplatesBundle.message("template.context.type.top.level", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element3) {
            PsiElement e = element3;
            while (e != null) {
                if (e instanceof KtModifierList) {
                    if ((e = e.getParent()) == null) continue;
                    e = e.getParent();
                    continue;
                }
                if (e instanceof KtProperty || e instanceof KtNamedFunction || e instanceof KtClassOrObject) {
                    return false;
                }
                if (e instanceof KtScriptInitializer) {
                    return false;
                }
                e = e.getParent();
            }
            return true;
        }
    }

    public static class Generic
    extends KotlinTemplateContextType {
        public Generic() {
            super(KotlinLiveTemplatesBundle.message("template.context.type.generic", new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element3) {
            return true;
        }

        @Override
        protected boolean isCommentInContext() {
            return true;
        }
    }
}

