/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.klib;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.idea.klib.FileWithMetadata;
import org.jetbrains.kotlin.idea.klib.KlibMetadataStubBuilderKt;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.serialization.js.DynamicTypeDeserializer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H$J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/klib/KlibMetadataStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "version", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "readFile", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/idea/klib/FileWithMetadata;", "(ILcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "getDecompiledText", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "file", "Lorg/jetbrains/kotlin/idea/klib/FileWithMetadata$Compatible;", "flexibleTypeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "getStubVersion", "kotlin.base.klib"})
public abstract class KlibMetadataStubBuilder
extends ClsStubBuilder {
    private final int version;
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Function0<SerializerExtensionProtocol> serializerProtocol;
    @NotNull
    private final Function1<VirtualFile, FileWithMetadata> readFile;

    public KlibMetadataStubBuilder(int version2, @NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull Function1<? super VirtualFile, ? extends FileWithMetadata> readFile) {
        this.version = version2;
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.readFile = readFile;
    }

    public int getStubVersion() {
        return 27 + this.version;
    }

    @NotNull
    protected abstract DecompiledText getDecompiledText(@NotNull FileWithMetadata.Compatible var1, @NotNull SerializerExtensionProtocol var2, @NotNull FlexibleTypeDeserializer var3);

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        PsiFileStub psiFileStub;
        VirtualFile virtualFile = content2.getFile();
        boolean bl = FileTypeRegistry.getInstance().isFileOfType(virtualFile, this.fileType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Unexpected file type " + virtualFile.getFileType();
            throw new AssertionError((Object)string2);
        }
        FileWithMetadata fileWithMetadata = (FileWithMetadata)this.readFile.invoke((Object)virtualFile);
        if (fileWithMetadata == null) {
            return null;
        }
        FileWithMetadata file2 = fileWithMetadata;
        FileWithMetadata fileWithMetadata2 = file2;
        if (fileWithMetadata2 instanceof FileWithMetadata.Incompatible) {
            psiFileStub = (PsiFileStub)ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        } else if (fileWithMetadata2 instanceof FileWithMetadata.Compatible) {
            DecompiledText ktFileText = this.getDecompiledText((FileWithMetadata.Compatible)file2, (SerializerExtensionProtocol)this.serializerProtocol.invoke(), (FlexibleTypeDeserializer)DynamicTypeDeserializer.INSTANCE);
            psiFileStub = KlibMetadataStubBuilderKt.access$createFileStub(content2.getProject(), ktFileText.getText());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return psiFileStub;
    }
}

