/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.klib;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.KotlinLibraryVersioningKt;
import org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializationUtilsKt;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.library.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0003\u0019\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0002R/\u0010\u0003\u001a#\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\t\u001a#\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u000b\u001a#\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache;", "", "()V", "libraryMetadataVersionCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache$CacheKey;", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache$CacheValue;", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataVersion;", "moduleHeaderCache", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataProtoBuf$Header;", "packageFragmentCache", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "computeLibraryMetadataVersion", "manifestFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "computeModuleHeader", "moduleHeaderFile", "computePackageFragment", "packageFragmentFile", "getCachedModuleHeader", "getCachedPackageFragment", "isMetadataCompatible", "", "libraryRoot", "CacheKey", "CacheValue", "Companion", "kotlin.base.klib"})
public final class KlibLoadingMetadataCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<CacheKey, CacheValue<ProtoBuf.PackageFragment>> packageFragmentCache = ContainerUtil.createConcurrentWeakValueMap();
    @NotNull
    private final ConcurrentMap<CacheKey, CacheValue<KlibMetadataProtoBuf.Header>> moduleHeaderCache = ContainerUtil.createConcurrentWeakValueMap();
    @NotNull
    private final ConcurrentMap<CacheKey, CacheValue<KlibMetadataVersion>> libraryMetadataVersionCache = ContainerUtil.createConcurrentWeakValueMap();

    @Nullable
    public final ProtoBuf.PackageFragment getCachedPackageFragment(@NotNull VirtualFile packageFragmentFile) {
        if (!Intrinsics.areEqual((Object)packageFragmentFile.getExtension(), (Object)"knm")) {
            boolean bl = false;
            String string2 = "Not a package metadata file: " + packageFragmentFile;
            throw new IllegalStateException(string2.toString());
        }
        return (ProtoBuf.PackageFragment)this.packageFragmentCache.computeIfAbsent(new CacheKey(packageFragmentFile), arg_0 -> KlibLoadingMetadataCache.getCachedPackageFragment$lambda$1((Function1)new Function1<CacheKey, CacheValue<ProtoBuf.PackageFragment>>(this, packageFragmentFile){
            final /* synthetic */ KlibLoadingMetadataCache this$0;
            final /* synthetic */ VirtualFile $packageFragmentFile;
            {
                this.this$0 = $receiver;
                this.$packageFragmentFile = $packageFragmentFile;
                super(1);
            }

            public final CacheValue<ProtoBuf.PackageFragment> invoke(CacheKey it) {
                return new CacheValue<ProtoBuf.PackageFragment>(KlibLoadingMetadataCache.access$computePackageFragment(this.this$0, this.$packageFragmentFile));
            }
        }, arg_0)).getValue();
    }

    @Nullable
    public final KlibMetadataProtoBuf.Header getCachedModuleHeader(@NotNull VirtualFile moduleHeaderFile) {
        if (!Intrinsics.areEqual((Object)moduleHeaderFile.getName(), (Object)"module")) {
            boolean bl = false;
            String string2 = "Not a module header file: " + moduleHeaderFile;
            throw new IllegalStateException(string2.toString());
        }
        return (KlibMetadataProtoBuf.Header)this.moduleHeaderCache.computeIfAbsent(new CacheKey(moduleHeaderFile), arg_0 -> KlibLoadingMetadataCache.getCachedModuleHeader$lambda$3((Function1)new Function1<CacheKey, CacheValue<KlibMetadataProtoBuf.Header>>(this, moduleHeaderFile){
            final /* synthetic */ KlibLoadingMetadataCache this$0;
            final /* synthetic */ VirtualFile $moduleHeaderFile;
            {
                this.this$0 = $receiver;
                this.$moduleHeaderFile = $moduleHeaderFile;
                super(1);
            }

            public final CacheValue<KlibMetadataProtoBuf.Header> invoke(CacheKey it) {
                return new CacheValue<KlibMetadataProtoBuf.Header>(KlibLoadingMetadataCache.access$computeModuleHeader(this.this$0, this.$moduleHeaderFile));
            }
        }, arg_0)).getValue();
    }

    private final boolean isMetadataCompatible(VirtualFile libraryRoot) {
        VirtualFile virtualFile = libraryRoot.findChild("manifest");
        if (virtualFile == null) {
            return false;
        }
        VirtualFile manifestFile = virtualFile;
        KlibMetadataVersion klibMetadataVersion = (KlibMetadataVersion)this.libraryMetadataVersionCache.computeIfAbsent(new CacheKey(manifestFile), arg_0 -> KlibLoadingMetadataCache.isMetadataCompatible$lambda$4((Function1)new Function1<CacheKey, CacheValue<KlibMetadataVersion>>(this, manifestFile){
            final /* synthetic */ KlibLoadingMetadataCache this$0;
            final /* synthetic */ VirtualFile $manifestFile;
            {
                this.this$0 = $receiver;
                this.$manifestFile = $manifestFile;
                super(1);
            }

            public final CacheValue<KlibMetadataVersion> invoke(CacheKey it) {
                return new CacheValue<KlibMetadataVersion>(KlibLoadingMetadataCache.access$computeLibraryMetadataVersion(this.this$0, this.$manifestFile));
            }
        }, arg_0)).getValue();
        if (klibMetadataVersion == null) {
            return false;
        }
        KlibMetadataVersion metadataVersion2 = klibMetadataVersion;
        return metadataVersion2.isCompatible();
    }

    private final ProtoBuf.PackageFragment computePackageFragment(VirtualFile packageFragmentFile) {
        ProtoBuf.PackageFragment packageFragment2;
        if (!this.isMetadataCompatible(packageFragmentFile.getParent().getParent().getParent())) {
            return null;
        }
        try {
            packageFragment2 = KlibMetadataDeserializationUtilsKt.parsePackageFragment((byte[])packageFragmentFile.contentsToByteArray(false));
        }
        catch (IOException iOException) {
            packageFragment2 = null;
        }
        return packageFragment2;
    }

    private final KlibMetadataProtoBuf.Header computeModuleHeader(VirtualFile moduleHeaderFile) {
        KlibMetadataProtoBuf.Header header;
        if (!this.isMetadataCompatible(moduleHeaderFile.getParent().getParent())) {
            return null;
        }
        try {
            header = KlibMetadataDeserializationUtilsKt.parseModuleHeader((byte[])moduleHeaderFile.contentsToByteArray(false));
        }
        catch (IOException iOException) {
            header = null;
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KlibMetadataVersion computeLibraryMetadataVersion(VirtualFile manifestFile) {
        try {
            Properties properties2;
            Properties $this$computeLibraryMetadataVersion_u24lambda_u246 = properties2 = new Properties();
            boolean bl = false;
            Closeable closeable = manifestFile.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                $this$computeLibraryMetadataVersion_u24lambda_u246.load(it);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            KotlinLibraryVersioning versioning = KotlinLibraryVersioningKt.readKonanLibraryVersioning((Properties)properties2);
            String string2 = versioning.getMetadataVersion();
            Object object = string2;
            if (string2 == null) return null;
            String string3 = object;
            closeable = BinaryVersion.Companion;
            String p0 = string3;
            boolean bl3 = false;
            int[] nArray = closeable.parseVersionArray(p0);
            object = nArray;
            if (nArray == null) return null;
            Object p02 = object;
            boolean bl4 = false;
            KlibMetadataVersion klibMetadataVersion = new KlibMetadataVersion((int[])p02);
            return klibMetadataVersion;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static final CacheValue getCachedPackageFragment$lambda$1(Function1 $tmp0, Object p0) {
        return (CacheValue)$tmp0.invoke(p0);
    }

    private static final CacheValue getCachedModuleHeader$lambda$3(Function1 $tmp0, Object p0) {
        return (CacheValue)$tmp0.invoke(p0);
    }

    private static final CacheValue isMetadataCompatible$lambda$4(Function1 $tmp0, Object p0) {
        return (CacheValue)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final KlibLoadingMetadataCache getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ ProtoBuf.PackageFragment access$computePackageFragment(KlibLoadingMetadataCache $this, VirtualFile packageFragmentFile) {
        return $this.computePackageFragment(packageFragmentFile);
    }

    public static final /* synthetic */ KlibMetadataProtoBuf.Header access$computeModuleHeader(KlibLoadingMetadataCache $this, VirtualFile moduleHeaderFile) {
        return $this.computeModuleHeader(moduleHeaderFile);
    }

    public static final /* synthetic */ KlibMetadataVersion access$computeLibraryMetadataVersion(KlibLoadingMetadataCache $this, VirtualFile manifestFile) {
        return $this.computeLibraryMetadataVersion(manifestFile);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache$CacheKey;", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "url", "", "modificationStamp", "", "(Ljava/lang/String;J)V", "getModificationStamp", "()J", "getUrl", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.base.klib"})
    private static final class CacheKey {
        @NotNull
        private final String url;
        private final long modificationStamp;

        public CacheKey(@NotNull String url, long modificationStamp) {
            this.url = url;
            this.modificationStamp = modificationStamp;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        public CacheKey(@NotNull VirtualFile virtualFile) {
            this(virtualFile.getUrl(), virtualFile.getModificationStamp());
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        public final long component2() {
            return this.modificationStamp;
        }

        @NotNull
        public final CacheKey copy(@NotNull String url, long modificationStamp) {
            return new CacheKey(url, modificationStamp);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, String string2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = cacheKey.url;
            }
            if ((n & 2) != 0) {
                l = cacheKey.modificationStamp;
            }
            return cacheKey.copy(string2, l);
        }

        @NotNull
        public String toString() {
            return "CacheKey(url=" + this.url + ", modificationStamp=" + this.modificationStamp + ")";
        }

        public int hashCode() {
            int result2 = this.url.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.modificationStamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)cacheKey.url)) {
                return false;
            }
            return this.modificationStamp == cacheKey.modificationStamp;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0004R\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache$CacheValue;", "T", "", "value", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "kotlin.base.klib"})
    private static final class CacheValue<T> {
        @Nullable
        private final T value;

        public CacheValue(@Nullable T value2) {
            this.value = value2;
        }

        @Nullable
        public final T getValue() {
            return this.value;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache;", "kotlin.base.klib"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KlibLoadingMetadataCache getInstance() {
            return (KlibLoadingMetadataCache)ApplicationManager.getApplication().getService(KlibLoadingMetadataCache.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

