/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KDocTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "charTyped", "handleBracketTyped", "", "overwriteClosingBracket", "kotlin.idea"})
public final class KDocTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull FileType fileType) {
        if (this.overwriteClosingBracket(c, editor2, file2)) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor2, (int)1);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        return this.handleBracketTyped(c, project, editor2, file2) ? TypedHandlerDelegate.Result.STOP : TypedHandlerDelegate.Result.CONTINUE;
    }

    private final boolean overwriteClosingBracket(char c, Editor editor2, PsiFile file2) {
        if (c != ']' && c != ')') {
            return false;
        }
        if (!(file2 instanceof KtFile)) {
            return false;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        Document document = editor2.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset2 < document.getTextLength() && chars.charAt(offset2) == c) {
            Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            HighlighterIterator iterator = ((EditorEx)editor2).getHighlighter().createIterator(offset2);
            IElementType elementType = iterator.getTokenType();
            if (iterator.getStart() == 0) {
                return false;
            }
            iterator.retreat();
            IElementType prevElementType = iterator.getTokenType();
            char c2 = c;
            return c2 == ']' ? KDocTokens.KDOC_HIGHLIGHT_TOKENS.contains(prevElementType) && (Intrinsics.areEqual((Object)elementType, (Object)KDocTokens.MARKDOWN_LINK) || offset2 > 0 && chars.charAt(offset2 - 1) == '[') : (c2 == ')' ? Intrinsics.areEqual((Object)elementType, (Object)KDocTokens.MARKDOWN_INLINE_LINK) : false);
        }
        return false;
    }

    private final boolean handleBracketTyped(char c, Project project, Editor editor2, PsiFile file2) {
        if (c != '[' && c != '(') {
            return false;
        }
        if (!(file2 instanceof KtFile)) {
            return false;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        if (offset2 == 0) {
            return false;
        }
        Document document = editor2.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement psiElement2 = file2.findElementAt(offset2 - 1);
        if (psiElement2 == null) {
            return false;
        }
        PsiElement element3 = psiElement2;
        if (!Intrinsics.areEqual((Object)element3.getNode().getElementType(), (Object)KDocTokens.TEXT)) {
            return false;
        }
        char c2 = c;
        if (c2 == '[') {
            document.insertString(offset2, (CharSequence)"]");
            return true;
        }
        if (c2 == '(' && offset2 > 1 && document.getCharsSequence().charAt(offset2 - 2) == ']') {
            document.insertString(offset2, (CharSequence)")");
            return true;
        }
        return false;
    }
}

