/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvmDecompiler;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.jvmDecompiler.DecompileKotlinToJavaActionKt;
import org.jetbrains.kotlin.idea.jvmDecompiler.KotlinJvmDecompilerBundle;
import org.jetbrains.kotlin.idea.jvmDecompiler.KotlinJvmDecompilerFacadeImpl;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/jvmDecompiler/DecompileKotlinToJavaAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getBinaryKotlinFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "update", "kotlin.jvm-decompiler"})
public final class DecompileKotlinToJavaAction
extends AnAction {
    public DecompileKotlinToJavaAction() {
        super(KotlinJvmDecompilerBundle.message("action.decompile.java.name", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        KtFile ktFile = this.getBinaryKotlinFile(e);
        if (ktFile == null) {
            return;
        }
        KtFile binaryFile = ktFile;
        KotlinJvmDecompilerFacadeImpl.INSTANCE.showDecompiledCode(binaryFile);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        if (KotlinPlatformUtils.isCidr()) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabled(this.getBinaryKotlinFile(e) != null);
        }
    }

    private final KtFile getBinaryKotlinFile(AnActionEvent e) {
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        KtFile ktFile = object instanceof KtFile ? (KtFile)object : null;
        if (ktFile == null) {
            return null;
        }
        KtFile file2 = ktFile;
        if (!DecompileKotlinToJavaActionKt.canBeDecompiledToJava(file2)) {
            return null;
        }
        return file2;
    }
}

