/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiJavaFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroupUtils;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.j2k.post.processing.KotlinNJ2KServicesBundle;
import org.jetbrains.kotlin.idea.j2k.post.processing.NewJ2kPostProcessor;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverterServices;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.j2k.WithProgressProcessor;
import org.jetbrains.kotlin.nj2k.NewJ2kWithProgressProcessor;
import org.jetbrains.kotlin.nj2k.NewJavaToKotlinConverter;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J*\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/NewJ2kConverterExtension;", "Lorg/jetbrains/kotlin/j2k/J2kConverterExtension;", "()V", "isNewJ2k", "", "()Z", "checkKotlinIsConfigured", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "createJavaToKotlinConverter", "Lorg/jetbrains/kotlin/j2k/JavaToKotlinConverter;", "targetModule", "settings", "Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "services", "Lorg/jetbrains/kotlin/j2k/JavaToKotlinConverterServices;", "createPostProcessor", "Lorg/jetbrains/kotlin/j2k/PostProcessor;", "formatCode", "createWithProgressProcessor", "Lorg/jetbrains/kotlin/j2k/WithProgressProcessor;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "files", "", "Lcom/intellij/psi/PsiJavaFile;", "phasesCount", "", "doCheckBeforeConversion", "kotlin.j2k.post-processing"})
public final class NewJ2kConverterExtension
extends J2kConverterExtension {
    private final boolean isNewJ2k;

    public NewJ2kConverterExtension() {
        this.isNewJ2k = true;
    }

    @Override
    public boolean isNewJ2k() {
        return this.isNewJ2k;
    }

    @Override
    @NotNull
    public JavaToKotlinConverter createJavaToKotlinConverter(@NotNull Project project, @Nullable Module targetModule, @NotNull ConverterSettings settings2, @NotNull JavaToKotlinConverterServices services) {
        return new NewJavaToKotlinConverter(project, targetModule, settings2, services);
    }

    @Override
    @NotNull
    public PostProcessor createPostProcessor(boolean formatCode) {
        return new NewJ2kPostProcessor();
    }

    @Override
    public boolean doCheckBeforeConversion(@NotNull Project project, @NotNull Module module2) {
        return this.checkKotlinIsConfigured(project, module2);
    }

    @Override
    @NotNull
    public WithProgressProcessor createWithProgressProcessor(@Nullable ProgressIndicator progress, @Nullable List<? extends PsiJavaFile> files2, int phasesCount) {
        return new NewJ2kWithProgressProcessor(progress, files2, phasesCount);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkKotlinIsConfigured(Project project, Module module2) {
        block3: {
            void $this$toTypedArray$iv;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            List configurators;
            Collection destination$iv$iv;
            String title;
            block5: {
                block4: {
                    void $this$filterTo$iv$iv;
                    boolean kotlinIsConfigured;
                    boolean bl = kotlinIsConfigured = ConfigureKotlinInProjectUtilsKt.hasAnyKotlinRuntimeInScope(module2) || ConfigureKotlinInProjectUtilsKt.isModuleConfigured(ModuleSourceRootGroupUtils.toModuleGroup(module2));
                    if (kotlinIsConfigured) {
                        return true;
                    }
                    title = KotlinNJ2KServicesBundle.message("converter.kotlin.not.configured.title", new Object[0]);
                    if (Messages.showOkCancelDialog((Project)project, (String)KotlinNJ2KServicesBundle.message("converter.kotlin.not.configured.message", new Object[0]), (String)title, (String)KotlinNJ2KServicesBundle.message("converter.kotlin.not.configured.configure", new Object[0]), (String)KotlinNJ2KServicesBundle.message("converter.kotlin.not.configured.cancel.conversion", new Object[0]), (Icon)Messages.getWarningIcon()) != 0) break block3;
                    Iterable $this$filter$iv = ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators(module2);
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv$iv;
                        boolean bl2 = false;
                        if (!JvmPlatformKt.isJvm((TargetPlatform)it.getTargetPlatform())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    configurators = (List)destination$iv$iv;
                    if (!configurators.isEmpty()) break block4;
                    String message2 = KotlinNJ2KServicesBundle.message("converter.kotlin.not.configured.no.configurators.available", new Object[0]);
                    Messages.showErrorDialog((String)message2, (String)title);
                    break block3;
                }
                if (configurators.size() != 1) break block5;
                ((KotlinProjectConfigurator)CollectionsKt.single((List)configurators)).configure(project, CollectionsKt.emptyList());
                break block3;
            }
            Iterable $i$f$filter = configurators;
            Icon icon = null;
            String string2 = title;
            String string3 = KotlinNJ2KServicesBundle.message("converter.kotlin.not.configured.choose.configurator", new Object[0]);
            Project project2 = project;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinProjectConfigurator bl2 = (KotlinProjectConfigurator)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getPresentableText());
            }
            collection = (List)destination$iv$iv2;
            $this$map$iv = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            int resultIndex = Messages.showChooseDialog((Project)project2, (String)string3, (String)string2, icon, (String[])thisCollection$iv.toArray(new String[0]), (String)((KotlinProjectConfigurator)CollectionsKt.first((List)configurators)).getPresentableText());
            KotlinProjectConfigurator kotlinProjectConfigurator = (KotlinProjectConfigurator)CollectionsKt.getOrNull((List)configurators, (int)resultIndex);
            if (kotlinProjectConfigurator == null) break block3;
            kotlinProjectConfigurator.configure(project, CollectionsKt.emptyList());
        }
        return false;
    }
}

