/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiElement;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.core.KotlinCompilerIde;
import org.jetbrains.kotlin.idea.internal.BytecodeGenerationResult;
import org.jetbrains.kotlin.idea.internal.DecompileFailedException;
import org.jetbrains.kotlin.idea.internal.KotlinJvmDecompilerFacade;
import org.jetbrains.kotlin.idea.internal.Location;
import org.jetbrains.kotlin.idea.util.InfinitePeriodicalTask;
import org.jetbrains.kotlin.idea.util.LongRunningReadTask;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0002\u001a\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0011H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "myProject", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "decompile", "Ljavax/swing/JButton;", "enableAssertions", "Ljavax/swing/JCheckBox;", "enableInline", "enableOptimization", "ir", "jvmTargets", "Ljavax/swing/JComboBox;", "", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "getMyEditor$annotations", "()V", "dispose", "", "setText", "resultText", "Companion", "UpdateBytecodeToolWindowTask", "kotlin.jvm"})
public final class KotlinBytecodeToolWindow
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final JCheckBox enableInline;
    @NotNull
    private final JCheckBox enableOptimization;
    @NotNull
    private final JCheckBox enableAssertions;
    @NotNull
    private final JButton decompile;
    @NotNull
    private final JComboBox<String> jvmTargets;
    @NotNull
    private final JCheckBox ir;
    @NotNull
    private static final Logger LOG = Logger.getInstance(KotlinBytecodeToolWindow.class);
    private static final int UPDATE_DELAY = 1000;
    @NotNull
    private static final String DEFAULT_TEXT = "/*\nGenerated bytecode for Kotlin source file.\nNo Kotlin source file is opened.\n*/";

    /*
     * WARNING - void declaration
     */
    public KotlinBytecodeToolWindow(@NotNull Project myProject, @NotNull ToolWindow toolWindow) {
        super(new BorderLayout());
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        this.myProject = myProject;
        this.toolWindow = toolWindow;
        this.myEditor = EditorFactory.getInstance().createEditor(EditorFactory.getInstance().createDocument((CharSequence)""), this.myProject, (FileType)JavaFileType.INSTANCE, true);
        this.add(this.myEditor.getComponent());
        JPanel optionPanel = new JPanel(new FlowLayout());
        this.add((Component)optionPanel, "North");
        KotlinJvmDecompilerFacade decompilerFacade = KotlinJvmDecompilerFacade.Companion.getInstance();
        this.decompile = new JButton(KotlinJvmBundle.message("button.text.decompile", new Object[0]));
        if (decompilerFacade != null) {
            optionPanel.add(this.decompile);
            this.decompile.addActionListener(arg_0 -> KotlinBytecodeToolWindow._init_$lambda$0(this, decompilerFacade, arg_0));
        }
        this.enableInline = new JCheckBox(KotlinJvmBundle.message("checkbox.text.inline", new Object[0]), true);
        this.enableOptimization = new JCheckBox(KotlinJvmBundle.message("checkbox.text.optimization", new Object[0]), true);
        this.enableAssertions = new JCheckBox(KotlinJvmBundle.message("checkbox.text.assertions", new Object[0]), true);
        Iterable iterable = JvmTarget.Companion.supportedValues();
        KotlinBytecodeToolWindow kotlinBytecodeToolWindow = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmTarget jvmTarget2 = (JvmTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDescription());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        kotlinBytecodeToolWindow.jvmTargets = (JComboBox)new ComboBox(objectArray);
        String description2 = JvmTarget.DEFAULT.getDescription();
        ((ComboBox)this.jvmTargets).setSelectedItem((Object)description2);
        this.ir = new JCheckBox(KotlinJvmBundle.message("checkbox.text.ir", new Object[0]), false);
        optionPanel.add(this.enableInline);
        optionPanel.add(this.enableOptimization);
        optionPanel.add(this.enableAssertions);
        optionPanel.add(this.ir);
        optionPanel.add(new JLabel(KotlinJvmBundle.message("bytecode.toolwindow.label.target", new Object[0])));
        optionPanel.add(this.jvmTargets);
        new InfinitePeriodicalTask(1000L, Alarm.ThreadToUse.SWING_THREAD, this, (Computable<? extends LongRunningReadTask>)((Computable)() -> KotlinBytecodeToolWindow._init_$lambda$2(this))).start();
        this.setText(DEFAULT_TEXT);
    }

    private static /* synthetic */ void getMyEditor$annotations() {
    }

    private final void setText(String resultText) {
        ApplicationManager.getApplication().runWriteAction(() -> KotlinBytecodeToolWindow.setText$lambda$3(this, resultText));
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    private static final void _init_$lambda$0(KotlinBytecodeToolWindow this$0, KotlinJvmDecompilerFacade $decompilerFacade, ActionEvent it) {
        Location location2 = Location.fromEditor(FileEditorManager.getInstance((Project)this$0.myProject).getSelectedTextEditor(), this$0.myProject);
        KtFile file2 = location2.getKFile();
        if (file2 != null) {
            try {
                $decompilerFacade.showDecompiledCode(file2);
            }
            catch (DecompileFailedException ex) {
                LOG.info((Throwable)ex);
                Object[] objectArray = new Object[]{file2.getName(), ex};
                Messages.showErrorDialog((Project)this$0.myProject, (String)KotlinJvmBundle.message("failed.to.decompile.0.1", objectArray), (String)KotlinJvmBundle.message("kotlin.bytecode.decompiler", new Object[0]));
            }
        }
    }

    private static final LongRunningReadTask _init_$lambda$2(KotlinBytecodeToolWindow this$0) {
        return this$0.new UpdateBytecodeToolWindowTask();
    }

    private static final void setText$lambda$3(KotlinBytecodeToolWindow this$0, String $resultText) {
        this$0.myEditor.getDocument().setText((CharSequence)StringUtil.convertLineSeparators((String)$resultText));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$UpdateBytecodeToolWindowTask;", "Lorg/jetbrains/kotlin/idea/util/LongRunningReadTask;", "Lorg/jetbrains/kotlin/idea/internal/Location;", "Lorg/jetbrains/kotlin/idea/internal/BytecodeGenerationResult;", "(Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow;)V", "cloneRequestInfo", "location", "hideResultOnInvalidLocation", "", "onResultReady", "requestInfo", "result", "prepareRequestInfo", "processRequest", "kotlin.jvm"})
    private final class UpdateBytecodeToolWindowTask
    extends LongRunningReadTask<Location, BytecodeGenerationResult> {
        public UpdateBytecodeToolWindowTask() {
            super(KotlinBytecodeToolWindow.this);
        }

        @Override
        @Nullable
        protected Location prepareRequestInfo() {
            if (!KotlinBytecodeToolWindow.this.toolWindow.isVisible()) {
                return null;
            }
            Location location2 = Location.fromEditor(FileEditorManager.getInstance((Project)KotlinBytecodeToolWindow.this.myProject).getSelectedTextEditor(), KotlinBytecodeToolWindow.this.myProject);
            if (location2.getEditor() == null) {
                return null;
            }
            KtFile file2 = location2.getKFile();
            return file2 == null || !SourceKindFilterUtils.matches(RootKindFilter.projectSources, (PsiElement)file2) ? null : location2;
        }

        @Override
        @NotNull
        protected Location cloneRequestInfo(@NotNull Location location2) {
            Location newLocation = super.cloneRequestInfo(location2);
            boolean bl = Intrinsics.areEqual((Object)location2, (Object)newLocation);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "cloneRequestInfo should generate same location object";
                throw new AssertionError((Object)string2);
            }
            return newLocation;
        }

        @Override
        protected void hideResultOnInvalidLocation() {
            KotlinBytecodeToolWindow.this.setText(KotlinBytecodeToolWindow.DEFAULT_TEXT);
        }

        @Override
        @NotNull
        protected BytecodeGenerationResult processRequest(@NotNull Location location2) {
            KtFile ktFile = location2.getKFile();
            Intrinsics.checkNotNull((Object)ktFile);
            KtFile ktFile2 = ktFile;
            CompilerConfiguration configuration2 = new CompilerConfiguration();
            if (!KotlinBytecodeToolWindow.this.enableInline.isSelected()) {
                configuration2.put(CommonConfigurationKeys.DISABLE_INLINE, (Object)true);
            }
            if (!KotlinBytecodeToolWindow.this.enableAssertions.isSelected()) {
                configuration2.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, (Object)true);
                configuration2.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, (Object)true);
            }
            if (!KotlinBytecodeToolWindow.this.enableOptimization.isSelected()) {
                configuration2.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, (Object)true);
            }
            Object object = KotlinBytecodeToolWindow.this.jvmTargets.getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            JvmTarget jvmTarget2 = JvmTarget.Companion.fromString((String)object);
            Intrinsics.checkNotNull((Object)jvmTarget2);
            configuration2.put(JVMConfigurationKeys.JVM_TARGET, (Object)jvmTarget2);
            if (KotlinBytecodeToolWindow.this.ir.isSelected()) {
                configuration2.put(JVMConfigurationKeys.IR, (Object)true);
            }
            CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)configuration2, (LanguageVersionSettings)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)ktFile2));
            return Companion.getBytecodeForFile(ktFile2, configuration2);
        }

        @Override
        protected void onResultReady(@NotNull Location requestInfo, @Nullable BytecodeGenerationResult result2) {
            Editor editor2 = requestInfo.getEditor();
            Intrinsics.checkNotNull((Object)editor2);
            Editor editor3 = editor2;
            if (result2 == null) {
                return;
            }
            BytecodeGenerationResult bytecodeGenerationResult = result2;
            if (bytecodeGenerationResult instanceof BytecodeGenerationResult.Error) {
                KotlinBytecodeToolWindow.this.decompile.setEnabled(false);
                KotlinBytecodeToolWindow.this.setText(((BytecodeGenerationResult.Error)result2).getText());
            } else if (bytecodeGenerationResult instanceof BytecodeGenerationResult.Bytecode) {
                KotlinBytecodeToolWindow.this.decompile.setEnabled(true);
                KotlinBytecodeToolWindow.this.setText(((BytecodeGenerationResult.Bytecode)result2).getText());
                int fileStartOffset = requestInfo.getStartOffset();
                int fileEndOffset = requestInfo.getEndOffset();
                Document document = editor3.getDocument();
                int startLine = document.getLineNumber(fileStartOffset);
                int endLine = document.getLineNumber(fileEndOffset);
                if (endLine > startLine && fileEndOffset > 0 && document.getCharsSequence().charAt(fileEndOffset - 1) == '\n') {
                    --endLine;
                }
                Document byteCodeDocument = KotlinBytecodeToolWindow.this.myEditor.getDocument();
                Pair linesRange = Companion.mapLines(byteCodeDocument.getText(), startLine, endLine);
                int endSelectionLineIndex = Math.min(((Number)linesRange.second).intValue() + 1, byteCodeDocument.getLineCount());
                int startOffset = byteCodeDocument.getLineStartOffset(((Number)linesRange.first).intValue());
                int endOffset2 = Math.min(byteCodeDocument.getLineStartOffset(endSelectionLineIndex), byteCodeDocument.getTextLength());
                KotlinBytecodeToolWindow.this.myEditor.getCaretModel().moveToOffset(endOffset2);
                KotlinBytecodeToolWindow.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                KotlinBytecodeToolWindow.this.myEditor.getCaretModel().moveToOffset(startOffset);
                KotlinBytecodeToolWindow.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                KotlinBytecodeToolWindow.this.myEditor.getSelectionModel().setSelection(startOffset, endOffset2);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fJ,\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$Companion;", "", "()V", "DEFAULT_TEXT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "UPDATE_DELAY", "", "compileSingleFile", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "initialConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getBytecodeForFile", "Lorg/jetbrains/kotlin/idea/internal/BytecodeGenerationResult;", "configuration", "mapLines", "Lcom/intellij/openapi/util/Pair;", "text", "startLine", "endLine", "printStackTraceToString", "e", "", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BytecodeGenerationResult getBytecodeForFile(@NotNull KtFile ktFile, @NotNull CompilerConfiguration configuration2) {
            GenerationState state = null;
            try {
                GenerationState generationState = this.compileSingleFile(ktFile, configuration2);
                if (generationState == null) {
                    Object[] objectArray = new Object[]{ktFile.getName()};
                    return new BytecodeGenerationResult.Error(KotlinJvmBundle.message("cannot.compile.0.to.bytecode", objectArray));
                }
                state = generationState;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                return new BytecodeGenerationResult.Error(this.printStackTraceToString(e));
            }
            StringBuilder answer = new StringBuilder();
            Collection diagnostics2 = state.getCollectedExtraJvmDiagnostics().all();
            if (!diagnostics2.isEmpty()) {
                answer.append("// Backend Errors: \n");
                answer.append("// ================\n");
                for (Diagnostic diagnostic : diagnostics2) {
                    answer.append("// Error at ").append(diagnostic.getPsiFile().getName()).append(org.jetbrains.kotlin.utils.StringsKt.join((Iterable)diagnostic.getTextRanges(), (String)",")).append(": ").append(DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)diagnostic))).append("\n");
                }
                answer.append("// ================\n\n");
            }
            ClassFileFactory outputFiles = state.getFactory();
            for (OutputFile outputFile : outputFiles.asList()) {
                answer.append("// ================");
                answer.append(outputFile.getRelativePath());
                answer.append(" =================\n");
                answer.append(outputFile.asText()).append("\n\n");
            }
            return new BytecodeGenerationResult.Bytecode(answer.toString());
        }

        @Nullable
        public final GenerationState compileSingleFile(@NotNull KtFile ktFile, @NotNull CompilerConfiguration initialConfiguration) {
            return new KotlinCompilerIde(ktFile, initialConfiguration, ClassBuilderFactories.TEST, null, false, 24, null).compile();
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Integer, Integer> mapLines(String text2, int startLine, int endLine) {
            List list2;
            int ktLineNum;
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            boolean startFound$iv$iv;
            int endIndex$iv$iv;
            int startIndex$iv$iv;
            boolean $i$f$trim;
            CharSequence $this$trim$iv$iv;
            void $this$trim$iv;
            String line2;
            boolean bl;
            Collection collection;
            void $this$mapTo$iv$iv;
            List list3;
            boolean bl2;
            Object iterator$iv;
            int startLine2 = startLine;
            int byteCodeLine = 0;
            int byteCodeStartLine = -1;
            int byteCodeEndLine = -1;
            ArrayList<Integer> lines = new ArrayList<Integer>();
            String[] stringArray = new String[]{"\n"};
            List list4 = StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$dropLastWhile = false;
            if (!list4.isEmpty()) {
                iterator$iv = list4.listIterator(list4.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    bl2 = false;
                    if (((CharSequence)it2).length() == 0) continue;
                    list3 = CollectionsKt.take((Iterable)list4, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            Iterable iterable = list3;
            boolean $i$f$map = false;
            iterator$iv = iterable;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                $this$trim$iv = line2;
                boolean $i$f$trim2 = false;
                $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl22 = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                collection.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
            }
            for (String string3 : (List)destination$iv$iv) {
                if (!StringsKt.startsWith$default((String)string3, (String)"LINENUMBER", (boolean)false, (int)2, null)) continue;
                String string4 = string3.substring(10);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                ktLineNum = new Scanner(string4).nextInt() - 1;
                lines.add(ktLineNum);
            }
            CollectionsKt.sort((List)lines);
            for (Integer n : lines) {
                if (n < startLine2) continue;
                startLine2 = n;
                break;
            }
            String[] stringArray2 = new String[]{"\n"};
            List list5 = StringsKt.split$default((CharSequence)text2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            $i$f$dropLastWhile = false;
            if (!list5.isEmpty()) {
                iterator$iv = list5.listIterator(list5.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    bl2 = false;
                    if (((CharSequence)it2).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)list5, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Iterable iterable2 = list2;
            $i$f$map = false;
            iterator$iv = iterable2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                line2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                $this$trim$iv = line;
                boolean $i$f$trim2 = false;
                $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl4 = false;
                    boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                collection.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
            }
            for (String string5 : (List)destination$iv$iv) {
                if (StringsKt.startsWith$default((String)string5, (String)"LINENUMBER", (boolean)false, (int)2, null)) {
                    String string6 = string5.substring(10);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                    ktLineNum = new Scanner(string6).nextInt() - 1;
                    if (byteCodeStartLine < 0 && ktLineNum == startLine2) {
                        byteCodeStartLine = byteCodeLine;
                    }
                    if (byteCodeStartLine > 0 && ktLineNum > endLine) {
                        byteCodeEndLine = byteCodeLine - 1;
                        break;
                    }
                }
                if (byteCodeStartLine >= 0 && (StringsKt.startsWith$default((String)string5, (String)"MAXSTACK", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string5, (String)"LOCALVARIABLE", (boolean)false, (int)2, null) || ((CharSequence)string5).length() == 0)) {
                    byteCodeEndLine = byteCodeLine - 1;
                    break;
                }
                ++byteCodeLine;
            }
            return byteCodeStartLine == -1 || byteCodeEndLine == -1 ? new Pair((Object)0, (Object)0) : new Pair((Object)byteCodeStartLine, (Object)byteCodeEndLine);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String printStackTraceToString(Throwable e) {
            StringWriter out = new StringWriter(1024);
            Closeable closeable = new PrintWriter(out);
            Throwable throwable = null;
            try {
                PrintWriter printWriter = (PrintWriter)closeable;
                boolean bl = false;
                e.printStackTrace(printWriter);
                String string2 = StringsKt.replace$default((String)out.toString(), (String)"\r", (String)"", (boolean)false, (int)4, null);
                return string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

