/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0014\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\u000b0\u000b*\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ToRawStringLiteralIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "convertContent", "", "hasTrailingSpaces", "", "text", "isApplicableTo", "value", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "kotlin.idea"})
public final class ToRawStringLiteralIntention
extends SelfTargetingOffsetIndependentIntention<KtStringTemplateExpression>
implements LowPriorityAction {
    public ToRawStringLiteralIntention() {
        super(KtStringTemplateExpression.class, KotlinBundle.lazyMessage("to.raw.string.literal", new Object[0]), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isApplicableTo(@NotNull KtStringTemplateExpression element3) {
        void $this$filterIsInstanceTo$iv$iv;
        if (PsiTreeUtil.nextLeaf((PsiElement)((PsiElement)element3)) instanceof PsiErrorElement) {
            return false;
        }
        String text2 = element3.getText();
        if (StringsKt.startsWith$default((String)text2, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            return false;
        }
        KtStringTemplateEntry[] $this$filterIsInstance$iv = element3.getEntries();
        boolean $i$f$filterIsInstance = false;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtEscapeStringTemplateEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List escapeEntries = (List)destination$iv$iv;
        for (KtEscapeStringTemplateEntry entry : escapeEntries) {
            Character c = StringsKt.singleOrNull((CharSequence)entry.getUnescapedValue());
            if (c == null) {
                return false;
            }
            char c2 = c.charValue();
            if (!Character.isISOControl(c2) || c2 == '\n' || c2 == '\r') continue;
            return false;
        }
        String converted = this.convertContent(element3);
        return !StringsKt.contains$default((CharSequence)converted, (CharSequence)"\"\"\"", (boolean)false, (int)2, null) && !this.hasTrailingSpaces(converted);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtStringTemplateExpression element3, @Nullable Editor editor2) {
        block5: {
            int offset2;
            PsiElement psiElement2;
            void $this$replaced$iv;
            int startOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element3));
            int endOffset2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)element3));
            Editor editor3 = editor2;
            int currentOffset = editor3 != null && (editor3 = editor3.getCaretModel()) != null && (editor3 = editor3.getCurrentCaret()) != null ? editor3.getOffset() : startOffset;
            String text2 = this.convertContent(element3);
            PsiElement psiElement3 = (PsiElement)element3;
            PsiElement newElement$iv = (PsiElement)new KtPsiFactory((KtElement)element3, false, 2, null).createExpression("\"\"\"" + text2 + "\"\"\"");
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement2 = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement2 = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement2 = (PsiElement)ktExpression;
                }
            }
            KtExpression replaced2 = (KtExpression)psiElement2;
            int n = offset2 = startOffset == currentOffset ? startOffset : (endOffset2 == currentOffset ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)replaced2)) : Math.min(currentOffset + 2, PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)replaced2))));
            Editor editor4 = editor2;
            if (editor4 == null || (editor4 = editor4.getCaretModel()) == null) break block5;
            editor4.moveToOffset(offset2);
        }
    }

    private final String convertContent(KtStringTemplateExpression element3) {
        StringBuilder stringBuilder;
        StringBuilder $this$convertContent_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        KtStringTemplateEntry[] entries2 = element3.getEntries();
        int n = entries2.length;
        for (int j = 0; j < n; ++j) {
            char nextChar;
            int index = j;
            KtStringTemplateEntry entry = entries2[j];
            String value2 = this.value(entry);
            if (StringsKt.endsWith$default((String)value2, (String)"$", (boolean)false, (int)2, null) && index < entries2.length - 1 && (Character.isJavaIdentifierStart(nextChar = StringsKt.first((CharSequence)this.value(entries2[index + 1]))) || nextChar == '{')) {
                $this$convertContent_u24lambda_u240.append("${\"$\"}");
                continue;
            }
            $this$convertContent_u24lambda_u240.append(value2);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String text2 = string2;
        return StringUtilRt.convertLineSeparators((String)text2, (String)"\n");
    }

    private final boolean hasTrailingSpaces(String text2) {
        boolean afterSpace = false;
        int n = text2.length();
        for (int j = 0; j < n; ++j) {
            char c = text2.charAt(j);
            if ((c == '\n' || c == '\r') && afterSpace) {
                return true;
            }
            afterSpace = c == ' ' || c == '\t';
        }
        return false;
    }

    private final String value(KtStringTemplateEntry $this$value) {
        return $this$value instanceof KtEscapeStringTemplateEntry ? ((KtEscapeStringTemplateEntry)$this$value).getUnescapedValue() : $this$value.getText();
    }
}

