/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.RenameProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RenameFileToMatchClassIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startInWriteAction", "", "kotlin.idea"})
public final class RenameFileToMatchClassIntention
extends SelfTargetingRangeIntention<KtClassOrObject> {
    public RenameFileToMatchClassIntention() {
        super(KtClassOrObject.class, KotlinBundle.lazyMessage("rename.file.to.match.top.level.class.name", new Object[0]), null, 4, null);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClassOrObject element3) {
        if (!element3.isTopLevel()) {
            return null;
        }
        String fileName = element3.getContainingKtFile().getName();
        if (Intrinsics.areEqual((Object)FileUtil.getNameWithoutExtension((String)fileName), (Object)element3.getName())) {
            return null;
        }
        Object[] objectArray = new Object[]{String.valueOf(element3.getName()), FileUtilRt.getExtension((String)fileName)};
        this.setTextGetter(KotlinBundle.lazyMessage("rename.file.to.0.1", objectArray));
        PsiElement psiElement2 = element3.getNameIdentifier();
        return psiElement2 != null ? psiElement2.getTextRange() : null;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtClassOrObject element3, @Nullable Editor editor2) {
        KtFile file2 = element3.getContainingKtFile();
        String extension2 = FileUtilRt.getExtension((String)file2.getName());
        new RenameProcessor(file2.getProject(), (PsiElement)file2, element3.getName() + "." + extension2, RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE, RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE).run();
    }
}

