/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitTypeArgumentsIntention;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitTypeIntention;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/IntentionBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "()V", "additionalFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "RemoveExplicitTypeFix", "kotlin.idea"})
public final class RemoveExplicitTypeArgumentsInspection
extends IntentionBasedInspection<KtTypeArgumentList> {
    public RemoveExplicitTypeArgumentsInspection() {
        super(Reflection.getOrCreateKotlinClass(RemoveExplicitTypeArgumentsIntention.class), null, 2, null);
    }

    @Override
    @Nullable
    public List<LocalQuickFix> additionalFixes(@NotNull KtTypeArgumentList element3) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
        boolean $i$f$getStrictParentOfType = false;
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableDeclaration.class, (boolean)true);
        if (ktCallableDeclaration == null) {
            return null;
        }
        KtCallableDeclaration declaration2 = ktCallableDeclaration;
        if (!RemoveExplicitTypeIntention.Companion.isApplicableTo(declaration2)) {
            return null;
        }
        return CollectionsKt.listOf((Object)new RemoveExplicitTypeFix(declaration2.getNameAsSafeName().asString()));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection$RemoveExplicitTypeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "declarationName", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
    private static final class RemoveExplicitTypeFix
    implements LocalQuickFix {
        @NotNull
        private final String declarationName;

        public RemoveExplicitTypeFix(@NotNull String declarationName) {
            this.declarationName = declarationName;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.declarationName};
            return KotlinBundle.message("remove.explicit.type.specification.from.0", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtTypeArgumentList ktTypeArgumentList = psiElement2 instanceof KtTypeArgumentList ? (KtTypeArgumentList)psiElement2 : null;
            if (ktTypeArgumentList == null) {
                return;
            }
            KtTypeArgumentList element3 = ktTypeArgumentList;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
            boolean $i$f$getStrictParentOfType = false;
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableDeclaration.class, (boolean)true);
            if (ktCallableDeclaration == null) {
                return;
            }
            KtCallableDeclaration declaration2 = ktCallableDeclaration;
            RemoveExplicitTypeIntention.Companion.removeExplicitType(declaration2);
        }
    }
}

