/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.ConvertTrimIndentToTrimMarginIntention;
import org.jetbrains.kotlin.idea.intentions.ConvertTrimMarginToTrimIndentIntentionKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertTrimMarginToTrimIndentIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "kotlin.idea"})
public final class ConvertTrimMarginToTrimIndentIntention
extends SelfTargetingIntention<KtCallExpression> {
    public ConvertTrimMarginToTrimIndentIntention() {
        super(KtCallExpression.class, KotlinBundle.lazyMessage("convert.to.trim.indent", new Object[0]), null, 4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element3, int caretOffset) {
        boolean bl;
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)element3));
        KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        if (!(ktExpression instanceof KtStringTemplateExpression)) return false;
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        if (ktStringTemplateExpression == null) {
            return false;
        }
        KtStringTemplateExpression template2 = ktStringTemplateExpression;
        if (!StringsKt.startsWith$default((String)template2.getText(), (String)"\"\"\"", (boolean)false, (int)2, null)) {
            return false;
        }
        KtExpression ktExpression2 = element3.getCalleeExpression();
        if (ktExpression2 == null) {
            return false;
        }
        KtExpression callee2 = ktExpression2;
        if (!Intrinsics.areEqual((Object)callee2.getText(), (Object)"trimMargin")) return false;
        CallableDescriptor callableDescriptor = UtilsKt.getCallableDescriptor(callee2);
        if (!Intrinsics.areEqual((Object)(callableDescriptor != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor)) : null), (Object)new FqName("kotlin.text.trimMargin"))) {
            return false;
        }
        if (!ConvertTrimIndentToTrimMarginIntention.Companion.isSurroundedByLineBreaksOrBlanks(template2)) {
            return false;
        }
        String string2 = ConvertTrimMarginToTrimIndentIntentionKt.access$marginPrefix(element3);
        if (string2 == null) {
            return false;
        }
        String marginPrefix = string2;
        Iterable $this$all$iv = CollectionsKt.dropLast((List)ArraysKt.drop((Object[])template2.getEntries(), (int)1), (int)1);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            KtStringTemplateEntry stringTemplateEntry = (KtStringTemplateEntry)element$iv;
            boolean bl2 = false;
            String text2 = stringTemplateEntry.getText();
            if (!ConvertTrimIndentToTrimMarginIntention.Companion.isLineBreakOrBlank(text2)) {
                String string3;
                block10: {
                    String $this$dropWhile$iv = text2;
                    boolean $i$f$dropWhile = false;
                    int n = $this$dropWhile$iv.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it = $this$dropWhile$iv.charAt(index$iv);
                        boolean bl3 = false;
                        if (CharsKt.isWhitespace((char)it)) continue;
                        String string4 = $this$dropWhile$iv.substring(index$iv);
                        string3 = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                        break block10;
                    }
                    string3 = "";
                }
                if (!StringsKt.startsWith$default((String)string3, (String)marginPrefix, (boolean)false, (int)2, null)) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtCallExpression element3, @Nullable Editor editor2) {
        StringBuilder stringBuilder;
        KtQualifiedExpression qualifiedExpression;
        KtQualifiedExpression ktQualifiedExpression = qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)element3));
        KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        KtStringTemplateExpression ktStringTemplateExpression = ktExpression instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)ktExpression : null;
        if (ktStringTemplateExpression == null) {
            return;
        }
        KtStringTemplateExpression template2 = ktStringTemplateExpression;
        String string2 = ConvertTrimMarginToTrimIndentIntentionKt.access$marginPrefix(element3);
        if (string2 == null) {
            return;
        }
        String marginPrefix = string2;
        String indent = ConvertTrimIndentToTrimMarginIntention.Companion.calculateIndent(template2);
        StringBuilder $this$applyTo_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        KtStringTemplateEntry[] $this$forEach$iv = template2.getEntries();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            String string3;
            StringBuilder stringBuilder2;
            block5: {
                void $this$dropWhile$iv;
                KtStringTemplateEntry element$iv;
                KtStringTemplateEntry entry = element$iv = $this$forEach$iv[j];
                boolean bl2 = false;
                String text2 = entry.getText();
                if (ConvertTrimIndentToTrimMarginIntention.Companion.isLineBreakOrBlank(text2)) {
                    $this$applyTo_u24lambda_u244.append(text2);
                    continue;
                }
                $this$applyTo_u24lambda_u244.append(indent);
                String string4 = entry.getText();
                stringBuilder2 = $this$applyTo_u24lambda_u244;
                boolean $i$f$dropWhile = false;
                int n2 = $this$dropWhile$iv.length();
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    char it = $this$dropWhile$iv.charAt(index$iv);
                    boolean bl3 = false;
                    if (CharsKt.isWhitespace((char)it)) continue;
                    String string5 = $this$dropWhile$iv.substring(index$iv);
                    string3 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                    break block5;
                }
                string3 = "";
            }
            stringBuilder2.append(StringsKt.replaceFirst$default((String)string3, (String)marginPrefix, (String)"", (boolean)false, (int)4, null));
        }
        String string6 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"StringBuilder().apply(builderAction).toString()");
        String newTemplate = string6;
        qualifiedExpression.replace((PsiElement)new KtPsiFactory((KtElement)element3, false, 2, null).createExpression("\"\"\"" + newTemplate + "\"\"\".trimIndent()"));
    }
}

