/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToStringTemplateIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "Companion", "kotlin.idea"})
public class ConvertToStringTemplateIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ConvertToStringTemplateIntention() {
        super(KtBinaryExpression.class, KotlinBundle.lazyMessage("convert.concatenation.to.template", new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element3) {
        if (!ConvertToStringTemplateIntention.Companion.isApplicableToNoParentCheck(element3)) {
            return false;
        }
        PsiElement parent2 = element3.getParent();
        return !(parent2 instanceof KtBinaryExpression) || !ConvertToStringTemplateIntention.Companion.isApplicableToNoParentCheck((KtBinaryExpression)parent2);
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @Nullable Editor editor2) {
        KtStringTemplateExpression replacement2 = Companion.buildReplacement(element3);
        ApplicationUtilsKt.runWriteActionIfPhysical((PsiElement)element3, (Function0)new Function0<KtStringTemplateExpression>(element3, replacement2){
            final /* synthetic */ KtBinaryExpression $element;
            final /* synthetic */ KtStringTemplateExpression $replacement;
            {
                this.$element = $element;
                this.$replacement = $replacement;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final KtStringTemplateExpression invoke() {
                PsiElement psiElement2;
                void $this$replaced$iv;
                PsiElement psiElement3 = (PsiElement)this.$element;
                PsiElement newElement$iv = (PsiElement)this.$replacement;
                boolean $i$f$replaced = false;
                if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                    psiElement2 = newElement$iv;
                } else {
                    PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                    if (result$iv instanceof KtStringTemplateExpression) {
                        psiElement2 = result$iv;
                    } else {
                        Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                        if (ktExpression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
                        }
                        psiElement2 = (PsiElement)((KtStringTemplateExpression)ktExpression);
                    }
                }
                return (KtStringTemplateExpression)psiElement2;
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final KtStringTemplateExpression buildReplacement(@NotNull KtBinaryExpression expression2) {
        return Companion.buildReplacement(expression2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\nH\u0002J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToStringTemplateIntention$Companion;", "", "()V", "buildReplacement", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "buildText", "", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "forceBraces", "", "fold", "left", "right", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "isApplicableToNoParentCheck", "isSuitable", "shouldSuggestToConvert", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean shouldSuggestToConvert(@NotNull KtBinaryExpression expression2) {
            int n;
            KtStringTemplateEntry[] entries2;
            block4: {
                KtStringTemplateEntry it;
                KtStringTemplateEntry element$iv;
                int n2;
                KtStringTemplateEntry[] $this$none$iv = entries2 = this.buildReplacement(expression2).getEntries();
                boolean $i$f$none = false;
                n = $this$none$iv.length;
                for (n2 = 0; n2 < n; ++n2) {
                    it = element$iv = $this$none$iv[n2];
                    boolean bl = false;
                    if (!(it instanceof KtBlockStringTemplateEntry)) continue;
                    return false;
                }
                boolean bl = true;
                if (!bl) return false;
                KtStringTemplateEntry[] $this$all$iv = entries2;
                boolean $i$f$all = false;
                n2 = 0;
                n = $this$all$iv.length;
                while (n2 < n) {
                    it = element$iv = $this$all$iv[n2];
                    boolean bl2 = false;
                    if (it instanceof KtLiteralStringTemplateEntry || it instanceof KtEscapeStringTemplateEntry) {
                        ++n2;
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            boolean bl = false;
            if (bl) return false;
            KtStringTemplateEntry[] $this$count$iv = entries2;
            boolean $i$f$count = false;
            int count$iv = 0;
            int n3 = $this$count$iv.length;
            for (n = 0; n < n3; ++n) {
                KtStringTemplateEntry element$iv;
                KtStringTemplateEntry it = element$iv = $this$count$iv[n];
                boolean bl3 = false;
                if (!(it instanceof KtLiteralStringTemplateEntry)) continue;
                ++count$iv;
            }
            if (count$iv < true) return false;
            if (expression2.textContains('\n')) return false;
            return true;
        }

        @JvmStatic
        @NotNull
        public final KtStringTemplateExpression buildReplacement(@NotNull KtBinaryExpression expression2) {
            String rightText = this.buildText(expression2.getRight(), false);
            return this.fold(expression2.getLeft(), rightText, new KtPsiFactory((KtElement)expression2, false, 2, null));
        }

        private final KtStringTemplateExpression fold(KtExpression left, String right2, KtPsiFactory factory2) {
            KtStringTemplateExpression ktStringTemplateExpression;
            boolean forceBraces;
            boolean bl = forceBraces = ((CharSequence)right2).length() > 0 && StringsKt.first((CharSequence)right2) != '$' && Character.isJavaIdentifierPart(StringsKt.first((CharSequence)right2));
            if (left instanceof KtBinaryExpression && this.isApplicableToNoParentCheck((KtBinaryExpression)left)) {
                String leftRight = this.buildText(((KtBinaryExpression)left).getRight(), forceBraces);
                ktStringTemplateExpression = this.fold(((KtBinaryExpression)left).getLeft(), leftRight + right2, factory2);
            } else {
                String leftText = this.buildText(left, forceBraces);
                KtExpression ktExpression = factory2.createExpression("\"" + leftText + right2 + "\"");
                Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
                ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
            }
            return ktStringTemplateExpression;
        }

        @NotNull
        public final String buildText(@Nullable KtExpression expr, boolean forceBraces) {
            if (expr == null) {
                return "";
            }
            KtExpression it = KtPsiUtil.safeDeparenthesize((KtExpression)expr);
            boolean bl = false;
            KtDotQualifiedExpression ktDotQualifiedExpression = it instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)it : null;
            KtExpression expression2 = (ktDotQualifiedExpression != null ? UtilsKt.isToString(ktDotQualifiedExpression) : false) && !(((KtDotQualifiedExpression)it).getReceiverExpression() instanceof KtSuperExpression) ? ((KtDotQualifiedExpression)it).getReceiverExpression() : (it instanceof KtLambdaExpression && ((KtLambdaExpression)it).getParent() instanceof KtLabeledExpression ? expr : it);
            String expressionText2 = expression2.getText();
            KtExpression ktExpression = expression2;
            if (ktExpression instanceof KtConstantExpression) {
                BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL);
                KotlinType kotlinType = bindingContext2.getType(expression2);
                Intrinsics.checkNotNull((Object)kotlinType);
                KotlinType type2 = kotlinType;
                CompileTimeConstant constant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext2);
                if (constant != null) {
                    String stringValue = String.valueOf(constant.getValue(type2));
                    if (KotlinBuiltIns.isChar((KotlinType)type2) || Intrinsics.areEqual((Object)stringValue, (Object)expressionText2)) {
                        StringBuilder stringBuilder;
                        StringBuilder $this$buildText_u24lambda_u244 = stringBuilder = new StringBuilder();
                        boolean bl2 = false;
                        StringUtil.escapeStringCharacters((int)stringValue.length(), (String)stringValue, (String)(forceBraces ? "\"$" : "\""), (StringBuilder)$this$buildText_u24lambda_u244);
                        String string2 = stringBuilder.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                        return string2;
                    }
                }
            } else {
                if (ktExpression instanceof KtStringTemplateExpression) {
                    String base;
                    if (StringsKt.startsWith$default((String)expressionText2, (String)"\"\"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)expressionText2, (String)"\"\"\"", (boolean)false, (int)2, null)) {
                        String string3 = expressionText2.substring(3, expressionText2.length() - 3);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        String unquoted = string3;
                        v4 = StringUtil.escapeStringCharacters((String)unquoted);
                    } else {
                        v4 = base = StringUtil.unquoteString((String)expressionText2);
                    }
                    if (forceBraces) {
                        if (StringsKt.endsWith$default((CharSequence)base, (char)'$', (boolean)false, (int)2, null)) {
                            return StringsKt.dropLast((String)base, (int)1) + "\\$";
                        }
                        PsiElement lastPart = (PsiElement)ArraysKt.lastOrNull((Object[])((KtStringTemplateExpression)expression2).getChildren());
                        if (lastPart instanceof KtSimpleNameStringTemplateEntry) {
                            return StringsKt.dropLast((String)base, (int)((KtSimpleNameStringTemplateEntry)lastPart).getTextLength()) + "${" + StringsKt.drop((String)((KtSimpleNameStringTemplateEntry)lastPart).getText(), (int)1) + "}";
                        }
                    }
                    return base;
                }
                if (ktExpression instanceof KtNameReferenceExpression) {
                    return "$" + (String)(forceBraces ? "{" + expressionText2 + "}" : expressionText2);
                }
                if (ktExpression instanceof KtThisExpression) {
                    return "$" + (String)(forceBraces || ((KtThisExpression)expression2).getLabelQualifier() != null ? "{" + expressionText2 + "}" : expressionText2);
                }
            }
            return "${" + expressionText2 + "}";
        }

        private final boolean isApplicableToNoParentCheck(KtBinaryExpression expression2) {
            if (!Intrinsics.areEqual((Object)expression2.getOperationToken(), (Object)KtTokens.PLUS)) {
                return false;
            }
            KotlinType expressionType2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)expression2, BodyResolveMode.PARTIAL).getType((KtExpression)expression2);
            if (!KotlinBuiltIns.isString((KotlinType)expressionType2)) {
                return false;
            }
            return this.isSuitable((KtExpression)expression2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSuitable(KtExpression expression2) {
            if (expression2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)expression2).getOperationToken(), (Object)KtTokens.PLUS)) {
                KtExpression ktExpression = ((KtBinaryExpression)expression2).getLeft();
                if (ktExpression == null) {
                    return false;
                }
                if (!this.isSuitable(ktExpression)) return false;
                KtExpression ktExpression2 = ((KtBinaryExpression)expression2).getRight();
                if (ktExpression2 == null) {
                    return false;
                }
                if (!this.isSuitable(ktExpression2)) return false;
                return true;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)((PsiElement)expression2))) {
                return false;
            }
            if (!expression2.textContains('\n')) return true;
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

