/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.intentions.ConvertToScopeIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchParameters;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003/01B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J*\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000fH\u0002J\u000e\u0010!\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0002J\"\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0#*\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0011H\u0002J*\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010(*\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0011H\u0002J\u0014\u0010*\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010,*\u00020\u0002H\u0002J\u001a\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020%\u0018\u00010(*\u00020\u0002H\u0002J\u0016\u0010.\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u00042345\u00a8\u00066\u00b2\u0006\n\u00107\u001a\u00020\u0002X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "scopeFunction", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention$ScopeFunction;", "(Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention$ScopeFunction;)V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "createScopeFunctionCall", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention$ScopedFunctionCallAndBlock;", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lcom/intellij/psi/PsiElement;", "isApplicableTo", "", "caretOffset", "", "removeRedundantThisQualifiers", "block", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "replaceReference", "firstTarget", "lastTarget", "psiFactory", "tryApplyTo", "dryRun", "tryGetFirstElementToRefactoring", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention$RefactoringTargetAndItsValueExpression;", "expressionToApply", "referenceElement", "childOfBlock", "collectTargetElements", "Lkotlin/sequences/Sequence;", "referenceName", "", "forward", "collectTargetElementsRange", "Lkotlin/Pair;", "greedy", "isTarget", "prevProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "tryExtractReferenceName", "tryGetExpressionToApply", "RefactoringTargetAndItsValueExpression", "ScopeFunction", "ScopedFunctionCallAndBlock", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToAlsoIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToApplyIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToRunIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToWithIntention;", "kotlin.idea", "replacement"})
public abstract class ConvertToScopeIntention
extends SelfTargetingIntention<KtExpression> {
    @NotNull
    private final ScopeFunction scopeFunction;

    private ConvertToScopeIntention(ScopeFunction scopeFunction) {
        Object[] objectArray = new Object[]{scopeFunction.getFunctionName()};
        super(KtExpression.class, KotlinBundle.lazyMessage("convert.to.0", objectArray), null, 4, null);
        this.scopeFunction = scopeFunction;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtExpression element3, int caretOffset) {
        return this.tryApplyTo(element3, true);
    }

    @Override
    public void applyTo(@NotNull KtExpression element3, @Nullable Editor editor2) {
        if (!this.tryApplyTo(element3, false)) {
            Object[] objectArray = new Object[]{this.getText()};
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"refactoring.is.not.supported.in.the.current.context", (Object[])objectArray));
            CommonRefactoringUtil.showErrorHint((Project)element3.getProject(), (Editor)editor2, (String)message2, (String)this.getText(), null);
        }
    }

    private final KtExpression childOfBlock(KtExpression $this$childOfBlock) {
        PsiElement psiElement2 = PsiTreeUtil.findFirstParent((PsiElement)((PsiElement)$this$childOfBlock), arg_0 -> ConvertToScopeIntention.childOfBlock$lambda$0(childOfBlock.1.INSTANCE, arg_0));
        return psiElement2 instanceof KtExpression ? (KtExpression)psiElement2 : null;
    }

    private final KtExpression tryGetExpressionToApply(KtExpression $this$tryGetExpressionToApply, String referenceName) {
        KtExpression ktExpression = this.childOfBlock($this$tryGetExpressionToApply);
        if (ktExpression == null) {
            return null;
        }
        KtExpression childOfBlock2 = ktExpression;
        return childOfBlock2 instanceof KtProperty || this.isTarget((PsiElement)childOfBlock2, referenceName) ? childOfBlock2 : null;
    }

    private final boolean tryApplyTo(KtExpression element3, boolean dryRun) {
        boolean invalidElementToRefactoring;
        Pair<PsiElement, String> pair = element3;
        boolean bl = pair instanceof KtProperty ? !((KtProperty)element3).isLocal() : (pair instanceof KtCallExpression ? false : (invalidElementToRefactoring = !(pair instanceof KtDotQualifiedExpression)));
        if (invalidElementToRefactoring) {
            return false;
        }
        Pair<PsiElement, String> pair2 = this.tryExtractReferenceName((KtExpression)element3);
        if (pair2 == null) {
            return false;
        }
        pair = pair2;
        PsiElement referenceElement = (PsiElement)pair.component1();
        String referenceName = (String)pair.component2();
        KtExpression ktExpression = this.tryGetExpressionToApply((KtExpression)element3, referenceName);
        if (ktExpression == null) {
            return false;
        }
        KtExpression expressionToApply = ktExpression;
        Pair<PsiElement, PsiElement> pair3 = this.collectTargetElementsRange(expressionToApply, referenceName, !dryRun);
        if (pair3 == null) {
            return false;
        }
        Pair<PsiElement, PsiElement> pair4 = pair3;
        PsiElement firstTarget = (PsiElement)pair4.component1();
        PsiElement lastTarget = (PsiElement)pair4.component2();
        RefactoringTargetAndItsValueExpression refactoringTargetAndItsValueExpression = this.tryGetFirstElementToRefactoring(expressionToApply, firstTarget, lastTarget, referenceElement);
        if (refactoringTargetAndItsValueExpression == null) {
            return false;
        }
        RefactoringTargetAndItsValueExpression refactoringTarget = refactoringTargetAndItsValueExpression;
        if (dryRun) {
            return true;
        }
        KtPsiFactory psiFactory = new KtPsiFactory((KtElement)expressionToApply, false, 2, null);
        ScopedFunctionCallAndBlock scopedFunctionCallAndBlock = this.createScopeFunctionCall(psiFactory, refactoringTarget.getTargetElement());
        if (scopedFunctionCallAndBlock == null) {
            return false;
        }
        ScopedFunctionCallAndBlock scopedFunctionCallAndBlock2 = scopedFunctionCallAndBlock;
        KtExpression scopeFunctionCall = scopedFunctionCallAndBlock2.component1();
        KtBlockExpression block2 = scopedFunctionCallAndBlock2.component2();
        this.replaceReference(referenceElement, refactoringTarget.getTargetElementValue(), lastTarget, psiFactory);
        block2.addRange(refactoringTarget.getTargetElementValue(), lastTarget);
        if (!this.scopeFunction.isParameterScope()) {
            this.removeRedundantThisQualifiers(block2);
        }
        PsiElement $this$tryApplyTo_u24lambda_u241 = firstTarget;
        boolean bl2 = false;
        $this$tryApplyTo_u24lambda_u241.getParent().addBefore((PsiElement)scopeFunctionCall, $this$tryApplyTo_u24lambda_u241);
        $this$tryApplyTo_u24lambda_u241.getParent().deleteChildRange($this$tryApplyTo_u24lambda_u241, lastTarget);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeRedundantThisQualifiers(KtBlockExpression block2) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        PsiElement psiElement2 = (PsiElement)block2;
        Function1 predicate$iv = removeRedundantThisQualifiers.thisDotSomethingExpressions.1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var8_10 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var11_14 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtDotQualifiedExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
                if (element3 instanceof KtDotQualifiedExpression) {
                    this.$action.invoke((Object)element3);
                }
            }
        });
        List thisDotSomethingExpressions2 = (List)to$iv$iv$iv;
        Iterable $this$forEach$iv = thisDotSomethingExpressions2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression selector2;
            KtDotQualifiedExpression thisDotSomethingExpression = (KtDotQualifiedExpression)element$iv;
            boolean bl = false;
            if (thisDotSomethingExpression.getSelectorExpression() == null) continue;
            boolean bl2 = false;
            thisDotSomethingExpression.replace((PsiElement)selector2);
        }
    }

    private final RefactoringTargetAndItsValueExpression tryGetFirstElementToRefactoring(KtExpression expressionToApply, PsiElement firstTarget, PsiElement lastTarget, PsiElement referenceElement) {
        Object object;
        PsiElement propertyOrFirst;
        block16: {
            block15: {
                KtProperty ktProperty;
                KtProperty property2 = this.prevProperty(expressionToApply);
                PsiElement psiElement2 = switch (WhenMappings.$EnumSwitchMapping$0[this.scopeFunction.ordinal()]) {
                    case 1, 2 -> (PsiElement)property2;
                    case 3, 4 -> firstTarget;
                    default -> throw new NoWhenBranchMatchedException();
                };
                if (psiElement2 == null) {
                    return null;
                }
                propertyOrFirst = psiElement2;
                boolean isCorrectFirstOrProperty = switch (WhenMappings.$EnumSwitchMapping$0[this.scopeFunction.ordinal()]) {
                    case 1, 2 -> {
                        if (propertyOrFirst instanceof KtProperty && ((KtProperty)propertyOrFirst).getName() != null && ((KtProperty)propertyOrFirst).getInitializer() != null) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3 -> propertyOrFirst instanceof KtDotQualifiedExpression;
                    case 4 -> propertyOrFirst instanceof KtDotQualifiedExpression;
                    default -> throw new NoWhenBranchMatchedException();
                };
                if (!isCorrectFirstOrProperty) {
                    return null;
                }
                object = property2;
                if (object == null || (object = object.getNextSibling()) == null) break block15;
                KtProperty it = ktProperty = object;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it.getParent(), (Object)referenceElement.getParent()) && it.getTextOffset() < lastTarget.getTextOffset() ? ktProperty : null;
                if (object != null) break block16;
            }
            object = firstTarget;
        }
        KtProperty targetElementValue = object;
        return new RefactoringTargetAndItsValueExpression(propertyOrFirst, (PsiElement)targetElementValue);
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceReference(PsiElement element3, PsiElement firstTarget, PsiElement lastTarget, KtPsiFactory psiFactory) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Lazy replacement$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<KtExpression>(this, psiFactory){
            final /* synthetic */ ConvertToScopeIntention this$0;
            final /* synthetic */ KtPsiFactory $psiFactory;
            {
                this.this$0 = $receiver;
                this.$psiFactory = $psiFactory;
                super(0);
            }

            @NotNull
            public final KtExpression invoke() {
                return ConvertToScopeIntention.access$getScopeFunction$p(this.this$0).isParameterScope() ? (KtExpression)this.$psiFactory.createSimpleName(ConvertToScopeIntention.access$getScopeFunction$p(this.this$0).getReceiver()) : (KtExpression)this.$psiFactory.createThisExpression();
            }
        }));
        KotlinReferencesSearchParameters searchParameters2 = new KotlinReferencesSearchParameters(element3, KotlinScopeUtils.useScope(element3), false, null, null, 24, null);
        List range2 = PsiTreeUtil.getElementsOfRange((PsiElement)firstTarget, (PsiElement)lastTarget);
        Iterable iterable = (Iterable)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters2);
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtNameReferenceExpression it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PsiReference it = (PsiReference)element$iv$iv;
            boolean bl2 = false;
            PsiElement psiElement2 = it.getElement();
            if ((psiElement2 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)psiElement2 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block6: {
                KtNameReferenceExpression reference2 = (KtNameReferenceExpression)element$iv$iv;
                boolean bl4 = false;
                Iterable $this$any$iv = range2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiElement rangeElement = (PsiElement)element$iv;
                        boolean bl5 = false;
                        if (!PsiTreeUtil.isAncestor((PsiElement)rangeElement, (PsiElement)((PsiElement)reference2), (boolean)true)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            KtNameReferenceExpression referenceInRange = (KtNameReferenceExpression)element$iv;
            boolean bl = false;
            referenceInRange.replace((PsiElement)ConvertToScopeIntention.replaceReference$lambda$5((Lazy<? extends KtExpression>)replacement$delegate));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Pair<PsiElement, String> tryExtractReferenceName(KtExpression $this$tryExtractReferenceName) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.scopeFunction.ordinal()]) {
            case 1: 
            case 2: {
                String string2;
                KtProperty property2;
                KtProperty ktProperty = property2 = this.prevProperty($this$tryExtractReferenceName);
                if (ktProperty == null) return null;
                String string4 = ktProperty.getName();
                string4 = string2 = string4;
                if (string4 == null) return null;
                Pair pair = TuplesKt.to((Object)property2, (Object)string4);
                return pair;
            }
            case 3: 
            case 4: {
                KtNameReferenceExpression selector2;
                KtNameReferenceExpression ktNameReferenceExpression;
                KtCallExpression ktCallExpression;
                KtNameReferenceExpression ktNameReferenceExpression2;
                KtNameReferenceExpression receiver2;
                KtExpression $this$safeAs$iv = $this$tryExtractReferenceName;
                boolean $i$f$safeAs = false;
                KtExpression ktExpression = $this$safeAs$iv;
                if (!(ktExpression instanceof KtDotQualifiedExpression)) {
                    ktExpression = null;
                }
                KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression;
                KtExpression ktExpression2 = ktDotQualifiedExpression != null ? KotlinPsiUtilsKt.getLeftMostReceiverExpression(ktDotQualifiedExpression) : null;
                if (!(ktExpression2 instanceof KtNameReferenceExpression)) return null;
                KtNameReferenceExpression ktNameReferenceExpression5 = (KtNameReferenceExpression)ktExpression2;
                ktNameReferenceExpression5 = receiver2 = ktNameReferenceExpression5;
                ktNameReferenceExpression5 = ktNameReferenceExpression5;
                if (ktNameReferenceExpression4 == null) return null;
                KtSimpleNameReference ktSimpleNameReference = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)ktNameReferenceExpression5));
                ktNameReferenceExpression5 = ktSimpleNameReference;
                if (ktSimpleNameReference == null) return null;
                PsiElement psiElement2 = ktNameReferenceExpression5.resolve();
                ktNameReferenceExpression5 = psiElement2;
                if (psiElement2 == null) return null;
                KtNameReferenceExpression it = ktNameReferenceExpression2 = ktNameReferenceExpression5;
                boolean bl = false;
                if (it instanceof PsiPackage) return null;
                KtNameReferenceExpression ktNameReferenceExpression5 = ktNameReferenceExpression2;
                ktNameReferenceExpression5 = ktNameReferenceExpression5;
                if (ktNameReferenceExpression6 == null) {
                    return null;
                }
                KtNameReferenceExpression ktNameReferenceExpression7 = ktNameReferenceExpression5;
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)receiver2));
                if (ktQualifiedExpression != null && (ktNameReferenceExpression2 = ktQualifiedExpression.getSelectorExpression()) != null) {
                    KtNameReferenceExpression it2 = ktNameReferenceExpression2;
                    boolean bl2 = false;
                    KtNameReferenceExpression $this$safeAs$iv2 = it2;
                    boolean $i$f$safeAs2 = false;
                    KtNameReferenceExpression ktNameReferenceExpression8 = $this$safeAs$iv2;
                    if (!(ktNameReferenceExpression8 instanceof KtCallExpression)) {
                        ktNameReferenceExpression8 = null;
                    }
                    if ((v13 = (KtCallExpression)ktNameReferenceExpression8) == null || (v13 = v13.getCalleeExpression()) == null) {
                        v13 = it2;
                    }
                } else {
                    v13 = ktCallExpression = null;
                }
                if (((ktNameReferenceExpression = (selector2 = ktCallExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktCallExpression : null)) != null && (ktNameReferenceExpression = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)ktNameReferenceExpression))) != null ? ktNameReferenceExpression.resolve() : null) instanceof KtClassOrObject) {
                    return null;
                }
                Pair pair = TuplesKt.to((Object)ktNameReferenceExpression7, (Object)receiver2.getReferencedName());
                return pair;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<PsiElement, PsiElement> collectTargetElementsRange(KtExpression $this$collectTargetElementsRange, String referenceName, boolean greedy) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.scopeFunction.ordinal()]) {
            case 1: 
            case 2: {
                v0 = $this$collectTargetElementsRange instanceof KtProperty != false ? (KtProperty)$this$collectTargetElementsRange : null;
                if (v0 != null) {
                    v1 = (KtExpression)v0;
                } else {
                    v2 = this.prevProperty($this$collectTargetElementsRange);
                    v1 = v2 != null ? (KtExpression)v2 : $this$collectTargetElementsRange;
                }
                firstTarget = v1;
                lastTargetSequence = this.collectTargetElements(firstTarget, referenceName, true);
                if (firstTarget != $this$collectTargetElementsRange) ** GOTO lbl14
                v3 = greedy ? (PsiElement)SequencesKt.lastOrNull(lastTargetSequence) : (PsiElement)SequencesKt.firstOrNull(lastTargetSequence);
                ** GOTO lbl27
lbl14:
                // 1 sources

                if (!greedy) ** GOTO lbl17
                v3 = UtilsKt.lastWithPersistedElementOrNull(lastTargetSequence, $this$collectTargetElementsRange);
                ** GOTO lbl27
lbl17:
                // 1 sources

                $this$firstOrNull$iv = lastTargetSequence;
                $i$f$firstOrNull = false;
                for (E element$iv : $this$firstOrNull$iv) {
                    it = (PsiElement)element$iv;
                    $i$a$-firstOrNull-ConvertToScopeIntention$collectTargetElementsRange$lastTarget$1 = false;
                    if (!($this$collectTargetElementsRange == it)) continue;
                    v4 = element$iv;
                    ** GOTO lbl26
                }
                v4 = null;
lbl26:
                // 2 sources

                v3 = v4;
lbl27:
                // 3 sources

                v5 = lastTarget = v3;
                if (v5 != null) {
                    v6 = TuplesKt.to((Object)firstTarget, (Object)v5);
                    break;
                }
                v6 = null;
                break;
            }
            case 3: 
            case 4: {
                v7 = (PsiElement)SequencesKt.lastOrNull(this.collectTargetElements($this$collectTargetElementsRange, referenceName, false));
                if (v7 == null) {
                    v7 = firstTarget = (PsiElement)$this$collectTargetElementsRange;
                }
                if (greedy) {
                    v8 = (PsiElement)SequencesKt.lastOrNull(this.collectTargetElements($this$collectTargetElementsRange, referenceName, true));
                    if (v8 == null) {
                        v8 = (PsiElement)$this$collectTargetElementsRange;
                    }
                } else {
                    v8 = (PsiElement)$this$collectTargetElementsRange;
                }
                lastTarget = v8;
                v6 = TuplesKt.to((Object)firstTarget, (Object)lastTarget);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v6;
    }

    private final Sequence<PsiElement> collectTargetElements(KtExpression $this$collectTargetElements, String referenceName, boolean forward) {
        return SequencesKt.takeWhile((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)$this$collectTargetElements), (boolean)forward, (boolean)false), (Function1)collectTargetElements.1.INSTANCE), (Function1)((Function1)new Function1<PsiElement, Boolean>(this, referenceName){
            final /* synthetic */ ConvertToScopeIntention this$0;
            final /* synthetic */ String $referenceName;
            {
                this.this$0 = $receiver;
                this.$referenceName = $referenceName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiElement it) {
                return ConvertToScopeIntention.access$isTarget(this.this$0, it, this.$referenceName);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isTarget(PsiElement $this$isTarget, String referenceName) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement2;
        block34: {
            block35: {
                block36: {
                    boolean bl;
                    block30: {
                        KtValueArgument it;
                        boolean bl2;
                        List valueArguments2;
                        boolean $i$f$any;
                        block29: {
                            block31: {
                                block33: {
                                    block32: {
                                        boolean bl3;
                                        block28: {
                                            psiElement2 = $this$isTarget;
                                            if (!(psiElement2 instanceof KtDotQualifiedExpression)) break block31;
                                            KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)$this$isTarget);
                                            if (ktCallExpression == null) {
                                                return false;
                                            }
                                            KtCallExpression callExpr = ktCallExpression;
                                            if (!((Collection)callExpr.getLambdaArguments()).isEmpty()) break block32;
                                            Iterable $this$any$iv = callExpr.getValueArguments();
                                            $i$f$any = false;
                                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                bl3 = false;
                                            } else {
                                                for (Object element$iv : $this$any$iv) {
                                                    KtValueArgument it2 = (KtValueArgument)element$iv;
                                                    boolean bl4 = false;
                                                    if (!Intrinsics.areEqual((Object)it2.getText(), (Object)this.scopeFunction.getReceiver())) continue;
                                                    bl3 = true;
                                                    break block28;
                                                }
                                                bl3 = false;
                                            }
                                        }
                                        if (!bl3) break block33;
                                    }
                                    return false;
                                }
                                KtExpression leftMostReceiver = KotlinPsiUtilsKt.getLeftMostReceiverExpression((KtDotQualifiedExpression)$this$isTarget);
                                if (!Intrinsics.areEqual((Object)leftMostReceiver.getText(), (Object)referenceName)) {
                                    return false;
                                }
                                KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)leftMostReceiver));
                                if ((ktReference != null ? ktReference.resolve() : null) instanceof PsiClass) {
                                    return false;
                                }
                                break block34;
                            }
                            if (!(psiElement2 instanceof KtCallExpression)) break block35;
                            valueArguments2 = ((KtCallExpression)$this$isTarget).getValueArguments();
                            Iterable $this$none$iv = valueArguments2;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$none$iv) {
                                    it = (KtValueArgument)element$iv;
                                    boolean bl5 = false;
                                    KtExpression ktExpression = it.getArgumentExpression();
                                    if (!Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)referenceName)) continue;
                                    bl2 = false;
                                    break block29;
                                }
                                bl2 = true;
                            }
                        }
                        if (bl2) {
                            return false;
                        }
                        if (!((Collection)((KtCallExpression)$this$isTarget).getLambdaArguments()).isEmpty()) break block36;
                        Iterable $this$any$iv = valueArguments2;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (KtValueArgument)element$iv;
                                boolean bl6 = false;
                                if (!Intrinsics.areEqual((Object)it.getText(), (Object)this.scopeFunction.getReceiver())) continue;
                                bl = true;
                                break block30;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block34;
                }
                return false;
            }
            if (psiElement2 instanceof KtBinaryExpression) {
                KtExpression ktExpression = ((KtBinaryExpression)$this$isTarget).getLeft();
                if (ktExpression == null) {
                    return false;
                }
                KtExpression left = ktExpression;
                KtExpression ktExpression2 = ((KtBinaryExpression)$this$isTarget).getRight();
                if (ktExpression2 == null) {
                    return false;
                }
                KtExpression right2 = ktExpression2;
                if (!(left instanceof KtDotQualifiedExpression || left instanceof KtCallExpression || right2 instanceof KtDotQualifiedExpression || right2 instanceof KtCallExpression)) {
                    return false;
                }
                if ((left instanceof KtDotQualifiedExpression || left instanceof KtCallExpression) && !this.isTarget((PsiElement)left, referenceName)) {
                    return false;
                }
                if ((right2 instanceof KtDotQualifiedExpression || right2 instanceof KtCallExpression) && !this.isTarget((PsiElement)right2, referenceName)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        psiElement2 = $this$isTarget;
        Function1 predicate$iv = (Function1)new Function1<KtNameReferenceExpression, Boolean>(this){
            final /* synthetic */ ConvertToScopeIntention this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtNameReferenceExpression it) {
                return Intrinsics.areEqual((Object)it.getText(), (Object)ConvertToScopeIntention.access$getScopeFunction$p(this.this$0).getReceiver());
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3 instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
            }
        });
        return !((PsiElement)result$iv$iv$iv.element != null);
    }

    /*
     * WARNING - void declaration
     */
    private final KtProperty prevProperty(KtExpression $this$prevProperty) {
        PsiElement psiElement2;
        Sequence sequence2;
        KtExpression ktExpression = this.childOfBlock($this$prevProperty);
        if (ktExpression != null && (sequence2 = PsiUtilsKt.siblings((PsiElement)((PsiElement)ktExpression), (boolean)false, (boolean)true)) != null) {
            Object v0;
            block3: {
                void $this$firstOrNull$iv;
                Sequence sequence3 = sequence2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it instanceof KtProperty && ((KtProperty)it).isLocal())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            psiElement2 = v0;
        } else {
            psiElement2 = null;
        }
        PsiElement psiElement3 = psiElement2;
        return psiElement3 instanceof KtProperty ? (KtProperty)psiElement3 : null;
    }

    private final ScopedFunctionCallAndBlock createScopeFunctionCall(KtPsiFactory factory2, PsiElement element3) {
        KtExpression ktExpression;
        Pair pair;
        Object[] objectArray;
        String scopeFunctionName = this.scopeFunction.getFunctionName();
        switch (WhenMappings.$EnumSwitchMapping$0[this.scopeFunction.ordinal()]) {
            case 1: 
            case 2: {
                if (!(element3 instanceof KtProperty)) {
                    return null;
                }
                String string2 = ((KtProperty)element3).getName();
                if (string2 == null) {
                    return null;
                }
                String propertyName = string2;
                Object[] objectArray2 = ((KtProperty)element3).getInitializer();
                if (objectArray2 == null) {
                    return null;
                }
                Object[] initializer2 = objectArray2;
                objectArray = initializer2;
                Object initializerPattern = (((objectArray instanceof KtDotQualifiedExpression ? true : objectArray instanceof KtCallExpression) ? true : objectArray instanceof KtConstantExpression) ? true : objectArray instanceof KtParenthesizedExpression) ? initializer2.getText() : "(" + initializer2.getText() + ")";
                KtTypeReference ktTypeReference = ((KtProperty)element3).getTypeReference();
                KtProperty property2 = factory2.createProperty(propertyName, ktTypeReference != null ? ktTypeReference.getText() : null, ((KtProperty)element3).isVar(), (String)initializerPattern + "." + scopeFunctionName + " {}");
                KtExpression ktExpression2 = property2.getInitializer();
                KtDotQualifiedExpression ktDotQualifiedExpression = ktExpression2 instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression2 : null;
                if (ktDotQualifiedExpression == null || (ktDotQualifiedExpression = UtilsKt.getCallExpression((KtQualifiedExpression)ktDotQualifiedExpression)) == null) {
                    return null;
                }
                KtDotQualifiedExpression callExpression2 = ktDotQualifiedExpression;
                pair = TuplesKt.to((Object)property2, (Object)callExpression2);
                break;
            }
            case 3: {
                if (!(element3 instanceof KtDotQualifiedExpression)) {
                    return null;
                }
                objectArray = new KtExpression[]{KotlinPsiUtilsKt.getLeftMostReceiverExpression((KtDotQualifiedExpression)element3)};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)("$0." + scopeFunctionName + " {}"), (Object[])objectArray, (boolean)false, (int)4, null);
                KtQualifiedExpression ktQualifiedExpression = ktExpression instanceof KtQualifiedExpression ? (KtQualifiedExpression)ktExpression : null;
                if (ktQualifiedExpression == null) {
                    return null;
                }
                KtQualifiedExpression scopeFunctionCall = ktQualifiedExpression;
                KtCallExpression ktCallExpression = UtilsKt.getCallExpression(scopeFunctionCall);
                if (ktCallExpression == null) {
                    return null;
                }
                KtCallExpression callExpression3 = ktCallExpression;
                pair = TuplesKt.to((Object)scopeFunctionCall, (Object)callExpression3);
                break;
            }
            case 4: {
                if (!(element3 instanceof KtDotQualifiedExpression)) {
                    return null;
                }
                objectArray = new Object[]{KotlinPsiUtilsKt.getLeftMostReceiverExpression((KtDotQualifiedExpression)element3)};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)(scopeFunctionName + "($0) {}"), (Object[])objectArray, (boolean)false, (int)4, null);
                KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
                if (ktCallExpression == null) {
                    return null;
                }
                KtQualifiedExpression scopeFunctionCall = ktCallExpression;
                pair = TuplesKt.to((Object)scopeFunctionCall, (Object)scopeFunctionCall);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair2 = pair;
        KtExpression scopeFunctionCall = (KtExpression)pair2.component1();
        KtCallExpression callExpression4 = (KtCallExpression)pair2.component2();
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)callExpression4.getLambdaArguments());
        if (ktLambdaArgument == null || (ktExpression = ktLambdaArgument.getLambdaExpression()) == null || (objectArray = ktExpression.getBodyExpression()) == null) {
            return null;
        }
        Object[] body2 = objectArray;
        return new ScopedFunctionCallAndBlock(scopeFunctionCall, (KtBlockExpression)body2);
    }

    private static final boolean childOfBlock$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final KtExpression replaceReference$lambda$5(Lazy<? extends KtExpression> $replacement$delegate) {
        Lazy<? extends KtExpression> lazy = $replacement$delegate;
        return (KtExpression)lazy.getValue();
    }

    public /* synthetic */ ConvertToScopeIntention(ScopeFunction scopeFunction, DefaultConstructorMarker $constructor_marker) {
        this(scopeFunction);
    }

    public static final /* synthetic */ ScopeFunction access$getScopeFunction$p(ConvertToScopeIntention $this) {
        return $this.scopeFunction;
    }

    public static final /* synthetic */ boolean access$isTarget(ConvertToScopeIntention $this, PsiElement $receiver, String referenceName) {
        return $this.isTarget($receiver, referenceName);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention$ScopeFunction;", "", "functionName", "", "isParameterScope", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getFunctionName", "()Ljava/lang/String;", "()Z", "receiver", "getReceiver", "ALSO", "APPLY", "RUN", "WITH", "kotlin.idea"})
    public static final class ScopeFunction
    extends Enum<ScopeFunction> {
        @NotNull
        private final String functionName;
        private final boolean isParameterScope;
        @NotNull
        private final String receiver;
        public static final /* enum */ ScopeFunction ALSO = new ScopeFunction("also", true);
        public static final /* enum */ ScopeFunction APPLY = new ScopeFunction("apply", false);
        public static final /* enum */ ScopeFunction RUN = new ScopeFunction("run", false);
        public static final /* enum */ ScopeFunction WITH = new ScopeFunction("with", false);
        private static final /* synthetic */ ScopeFunction[] $VALUES;

        private ScopeFunction(String functionName, boolean isParameterScope) {
            this.functionName = functionName;
            this.isParameterScope = isParameterScope;
            this.receiver = this.isParameterScope ? "it" : "this";
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        public final boolean isParameterScope() {
            return this.isParameterScope;
        }

        @NotNull
        public final String getReceiver() {
            return this.receiver;
        }

        public static ScopeFunction[] values() {
            return (ScopeFunction[])$VALUES.clone();
        }

        public static ScopeFunction valueOf(String value2) {
            return Enum.valueOf(ScopeFunction.class, value2);
        }

        static {
            $VALUES = scopeFunctionArray = new ScopeFunction[]{ScopeFunction.ALSO, ScopeFunction.APPLY, ScopeFunction.RUN, ScopeFunction.WITH};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention$RefactoringTargetAndItsValueExpression;", "", "targetElement", "Lcom/intellij/psi/PsiElement;", "targetElementValue", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "getTargetElement", "()Lcom/intellij/psi/PsiElement;", "getTargetElementValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    private static final class RefactoringTargetAndItsValueExpression {
        @NotNull
        private final PsiElement targetElement;
        @NotNull
        private final PsiElement targetElementValue;

        public RefactoringTargetAndItsValueExpression(@NotNull PsiElement targetElement, @NotNull PsiElement targetElementValue) {
            this.targetElement = targetElement;
            this.targetElementValue = targetElementValue;
        }

        @NotNull
        public final PsiElement getTargetElement() {
            return this.targetElement;
        }

        @NotNull
        public final PsiElement getTargetElementValue() {
            return this.targetElementValue;
        }

        @NotNull
        public final PsiElement component1() {
            return this.targetElement;
        }

        @NotNull
        public final PsiElement component2() {
            return this.targetElementValue;
        }

        @NotNull
        public final RefactoringTargetAndItsValueExpression copy(@NotNull PsiElement targetElement, @NotNull PsiElement targetElementValue) {
            return new RefactoringTargetAndItsValueExpression(targetElement, targetElementValue);
        }

        public static /* synthetic */ RefactoringTargetAndItsValueExpression copy$default(RefactoringTargetAndItsValueExpression refactoringTargetAndItsValueExpression, PsiElement psiElement2, PsiElement psiElement3, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement2 = refactoringTargetAndItsValueExpression.targetElement;
            }
            if ((n & 2) != 0) {
                psiElement3 = refactoringTargetAndItsValueExpression.targetElementValue;
            }
            return refactoringTargetAndItsValueExpression.copy(psiElement2, psiElement3);
        }

        @NotNull
        public String toString() {
            return "RefactoringTargetAndItsValueExpression(targetElement=" + this.targetElement + ", targetElementValue=" + this.targetElementValue + ")";
        }

        public int hashCode() {
            int result2 = this.targetElement.hashCode();
            result2 = result2 * 31 + this.targetElementValue.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RefactoringTargetAndItsValueExpression)) {
                return false;
            }
            RefactoringTargetAndItsValueExpression refactoringTargetAndItsValueExpression = (RefactoringTargetAndItsValueExpression)other;
            if (!Intrinsics.areEqual((Object)this.targetElement, (Object)refactoringTargetAndItsValueExpression.targetElement)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.targetElementValue, (Object)refactoringTargetAndItsValueExpression.targetElementValue);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention$ScopedFunctionCallAndBlock;", "", "scopeFunctionCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "block", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtBlockExpression;)V", "getBlock", "()Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "getScopeFunctionCall", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    private static final class ScopedFunctionCallAndBlock {
        @NotNull
        private final KtExpression scopeFunctionCall;
        @NotNull
        private final KtBlockExpression block;

        public ScopedFunctionCallAndBlock(@NotNull KtExpression scopeFunctionCall, @NotNull KtBlockExpression block2) {
            this.scopeFunctionCall = scopeFunctionCall;
            this.block = block2;
        }

        @NotNull
        public final KtExpression getScopeFunctionCall() {
            return this.scopeFunctionCall;
        }

        @NotNull
        public final KtBlockExpression getBlock() {
            return this.block;
        }

        @NotNull
        public final KtExpression component1() {
            return this.scopeFunctionCall;
        }

        @NotNull
        public final KtBlockExpression component2() {
            return this.block;
        }

        @NotNull
        public final ScopedFunctionCallAndBlock copy(@NotNull KtExpression scopeFunctionCall, @NotNull KtBlockExpression block2) {
            return new ScopedFunctionCallAndBlock(scopeFunctionCall, block2);
        }

        public static /* synthetic */ ScopedFunctionCallAndBlock copy$default(ScopedFunctionCallAndBlock scopedFunctionCallAndBlock, KtExpression ktExpression, KtBlockExpression ktBlockExpression, int n, Object object) {
            if ((n & 1) != 0) {
                ktExpression = scopedFunctionCallAndBlock.scopeFunctionCall;
            }
            if ((n & 2) != 0) {
                ktBlockExpression = scopedFunctionCallAndBlock.block;
            }
            return scopedFunctionCallAndBlock.copy(ktExpression, ktBlockExpression);
        }

        @NotNull
        public String toString() {
            return "ScopedFunctionCallAndBlock(scopeFunctionCall=" + this.scopeFunctionCall + ", block=" + this.block + ")";
        }

        public int hashCode() {
            int result2 = this.scopeFunctionCall.hashCode();
            result2 = result2 * 31 + this.block.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScopedFunctionCallAndBlock)) {
                return false;
            }
            ScopedFunctionCallAndBlock scopedFunctionCallAndBlock = (ScopedFunctionCallAndBlock)other;
            if (!Intrinsics.areEqual((Object)this.scopeFunctionCall, (Object)scopedFunctionCallAndBlock.scopeFunctionCall)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.block, (Object)scopedFunctionCallAndBlock.block);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScopeFunction.values().length];
            try {
                nArray[ScopeFunction.ALSO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeFunction.APPLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeFunction.RUN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeFunction.WITH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

