/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.GeneralPsiUtilsKt;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToBlockBodyIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "skipProcessingFurtherElementsAfter", "Lcom/intellij/psi/PsiElement;", "Companion", "kotlin.idea"})
public final class ConvertToBlockBodyIntention
extends SelfTargetingIntention<KtDeclarationWithBody> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ConvertToBlockBodyIntention() {
        super(KtDeclarationWithBody.class, KotlinBundle.lazyMessage("convert.to.block.body", new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtDeclarationWithBody element3, int caretOffset) {
        if (element3 instanceof KtFunctionLiteral || element3.hasBlockBody() || !element3.hasBody()) {
            return false;
        }
        KtDeclarationWithBody ktDeclarationWithBody = element3;
        if (ktDeclarationWithBody instanceof KtNamedFunction) {
            KotlinType kotlinType = ConvertToBlockBodyIntention.Companion.returnType((KtNamedFunction)element3);
            if (kotlinType == null) {
                return false;
            }
            KotlinType returnType2 = kotlinType;
            return element3.hasDeclaredReturnType() || !KotlinTypeKt.isError((KotlinType)returnType2);
        }
        if (ktDeclarationWithBody instanceof KtPropertyAccessor) {
            return true;
        }
        throw new IllegalStateException(("Unknown declaration type: " + element3).toString());
    }

    @Override
    protected boolean skipProcessingFurtherElementsAfter(@NotNull PsiElement element3) {
        return element3 instanceof KtDeclaration || super.skipProcessingFurtherElementsAfter(element3);
    }

    @Override
    public void applyTo(@NotNull KtDeclarationWithBody element3, @Nullable Editor editor2) {
        Companion.convert(element3, true);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToBlockBodyIntention$Companion;", "", "()V", "convert", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "declaration", "withReformat", "", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KtDeclarationWithBody convert(@NotNull KtDeclarationWithBody declaration2, boolean withReformat) {
            KtExpression ktExpression;
            KtExpression ktExpression2 = declaration2.getBodyExpression();
            Intrinsics.checkNotNull((Object)ktExpression2);
            KtExpression body2 = ktExpression2;
            KtDeclarationWithBody ktDeclarationWithBody = declaration2;
            if (ktDeclarationWithBody instanceof KtNamedFunction) {
                KotlinType kotlinType = this.returnType((KtNamedFunction)declaration2);
                Intrinsics.checkNotNull((Object)kotlinType);
                KotlinType returnType2 = kotlinType;
                if (!declaration2.hasDeclaredReturnType() && !TypeUtilsKt.isUnit((KotlinType)returnType2)) {
                    PsiModificationUtilsKt.setType$default((KtCallableDeclaration)declaration2, returnType2, false, 2, null);
                }
                ktExpression = org.jetbrains.kotlin.idea.intentions.ConvertToBlockBodyIntention$Companion.convert$generateBody(body2, declaration2, !TypeUtilsKt.isUnit((KotlinType)returnType2) && !TypeUtilsKt.isNothing((KotlinType)returnType2));
            } else if (ktDeclarationWithBody instanceof KtPropertyAccessor) {
                PsiElement parent2 = ((KtPropertyAccessor)declaration2).getParent();
                if (parent2 instanceof KtProperty && ((KtProperty)parent2).getTypeReference() == null) {
                    VariableDescriptor descriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default((KtProperty)parent2, null, 1, null);
                    CallableDescriptor callableDescriptor = descriptor2 instanceof CallableDescriptor ? (CallableDescriptor)descriptor2 : null;
                    if (callableDescriptor != null && (callableDescriptor = callableDescriptor.getReturnType()) != null) {
                        CallableDescriptor it = callableDescriptor;
                        boolean bl = false;
                        PsiModificationUtilsKt.setType$default((KtCallableDeclaration)parent2, (KotlinType)it, false, 2, null);
                    }
                }
                ktExpression = org.jetbrains.kotlin.idea.intentions.ConvertToBlockBodyIntention$Companion.convert$generateBody(body2, declaration2, ((KtPropertyAccessor)declaration2).isGetter());
            } else {
                throw new RuntimeException("Unknown declaration type: " + declaration2);
            }
            KtExpression newBody = ktExpression;
            PsiElement psiElement2 = declaration2.getEqualsToken();
            Intrinsics.checkNotNull((Object)psiElement2);
            psiElement2.delete();
            PsiElement replaced2 = body2.replace((PsiElement)newBody);
            if (withReformat) {
                GeneralPsiUtilsKt.adjustLineIndent((PsiFile)declaration2.getContainingKtFile(), PsiUtilsKt.getStartOffset((PsiElement)replaced2), PsiUtilsKt.getEndOffset((PsiElement)replaced2));
            }
            return declaration2;
        }

        public static /* synthetic */ KtDeclarationWithBody convert$default(Companion companion, KtDeclarationWithBody ktDeclarationWithBody, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.convert(ktDeclarationWithBody, bl);
        }

        private final KotlinType returnType(KtNamedFunction $this$returnType) {
            FunctionDescriptor descriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default($this$returnType, null, 1, null);
            FunctionDescriptor functionDescriptor2 = descriptor2;
            if (functionDescriptor2 == null || (functionDescriptor2 = functionDescriptor2.getReturnType()) == null) {
                return null;
            }
            FunctionDescriptor returnType2 = functionDescriptor2;
            if (FlexibleTypesKt.isNullabilityFlexible((KotlinType)returnType2)) {
                FunctionDescriptor functionDescriptor3 = (FunctionDescriptor)CollectionsKt.firstOrNull((Iterable)descriptor2.getOverriddenDescriptors());
                boolean bl = functionDescriptor3 != null && (functionDescriptor3 = functionDescriptor3.getReturnType()) != null ? !functionDescriptor3.isMarkedNullable() : false;
                if (bl) {
                    return TypeUtilsKt.makeNotNullable((KotlinType)returnType2);
                }
            }
            return returnType2;
        }

        private static final KtExpression convert$generateBody(KtExpression body2, KtDeclarationWithBody $declaration, boolean returnsValue) {
            KtExpression ktExpression;
            boolean needReturn;
            KotlinType bodyType = ResolutionUtils.analyze$default((KtElement)body2, null, 1, null).getType(body2);
            KtPsiFactory factory2 = new KtPsiFactory((KtElement)$declaration, false, 2, null);
            if (bodyType != null && TypeUtilsKt.isUnit((KotlinType)bodyType) && body2 instanceof KtNameReferenceExpression) {
                return (KtExpression)factory2.createEmptyBody();
            }
            boolean unitWhenAsResult = (bodyType == null || TypeUtilsKt.isUnit((KotlinType)bodyType)) && !((Collection)org.jetbrains.kotlin.idea.util.PsiUtilsKt.resultingWhens(body2)).isEmpty();
            boolean bl = needReturn = returnsValue && (bodyType == null || !TypeUtilsKt.isUnit((KotlinType)bodyType) && !TypeUtilsKt.isNothing((KotlinType)bodyType));
            if (needReturn || unitWhenAsResult) {
                KtAnnotatedExpression annotatedExpr = body2 instanceof KtAnnotatedExpression ? (KtAnnotatedExpression)body2 : null;
                KtAnnotatedExpression ktAnnotatedExpression = annotatedExpr;
                if (ktAnnotatedExpression == null || (ktAnnotatedExpression = ktAnnotatedExpression.getBaseExpression()) == null) {
                    ktAnnotatedExpression = body2;
                }
                KtAnnotatedExpression returnedExpr = ktAnnotatedExpression;
                Object[] objectArray = new Object[]{returnedExpr};
                KtBlockExpression block2 = KtPsiFactory.createSingleStatementBlock$default((KtPsiFactory)factory2, (KtExpression)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"return $0", (Object[])objectArray, (boolean)false, (int)4, null), null, null, (int)6, null);
                KtExpression statement2 = block2.getFirstStatement();
                Object object = annotatedExpr;
                if (object != null && (object = object.getAnnotationEntries()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl2 = false;
                        block2.addBefore((PsiElement)it, (PsiElement)statement2);
                        block2.addBefore(factory2.createNewLine(), (PsiElement)statement2);
                    }
                }
                ktExpression = (KtExpression)block2;
            } else {
                ktExpression = (KtExpression)KtPsiFactory.createSingleStatementBlock$default((KtPsiFactory)factory2, (KtExpression)body2, null, null, (int)6, null);
            }
            return ktExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

