/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.ChooseStringExpression;
import org.jetbrains.kotlin.idea.intentions.AddForLoopIndicesIntention;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddForLoopIndicesIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "createWithIndexExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "originalExpression", "reformat", "", "runTemplate", "forExpression", "indexVariable", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "Companion", "kotlin.idea"})
public final class AddForLoopIndicesIntention
extends SelfTargetingRangeIntention<KtForExpression>
implements LowPriorityAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String WITH_INDEX_NAME = "withIndex";
    @NotNull
    private static final Lazy<Set<String>> WITH_INDEX_FQ_NAMES$delegate = LazyKt.lazy((Function0)Companion.WITH_INDEX_FQ_NAMES.2.INSTANCE);

    public AddForLoopIndicesIntention() {
        super(KtForExpression.class, KotlinBundle.lazyMessage("add.indices.to.for.loop", new Object[0]), null, 4, null);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtForExpression element3) {
        ResolvedCall resolvedCall2;
        if (element3.getLoopParameter() == null) {
            return null;
        }
        KtParameter ktParameter = element3.getLoopParameter();
        if ((ktParameter != null ? ktParameter.getDestructuringDeclaration() : null) != null) {
            return null;
        }
        KtExpression ktExpression = element3.getLoopRange();
        if (ktExpression == null) {
            return null;
        }
        KtExpression loopRange = ktExpression;
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)element3, BodyResolveMode.PARTIAL_WITH_CFA);
        ResolvedCall resolvedCall3 = CallUtilKt.getResolvedCall((KtElement)((KtElement)loopRange), (BindingContext)bindingContext2);
        if (CollectionsKt.contains((Iterable)AddForLoopIndicesIntention.Companion.getWITH_INDEX_FQ_NAMES(), (resolvedCall2 = resolvedCall3) != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null && (resolvedCall2 = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2))) != null ? resolvedCall2.asString() : null)) {
            return null;
        }
        KtExpression potentialExpression = this.createWithIndexExpression(loopRange, false);
        BindingContext newBindingContext = ExtendedResolutionApiKt.analyzeAsReplacement$default(potentialExpression, loopRange, bindingContext2, null, null, null, 28, null);
        ResolvedCall resolvedCall4 = CallUtilKt.getResolvedCall((KtElement)((KtElement)potentialExpression), (BindingContext)newBindingContext);
        if (resolvedCall4 == null) {
            return null;
        }
        ResolvedCall newResolvedCall = resolvedCall4;
        if (!AddForLoopIndicesIntention.Companion.getWITH_INDEX_FQ_NAMES().contains(DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)newResolvedCall.getResultingDescriptor())).asString())) {
            return null;
        }
        KtExpression ktExpression2 = element3.getBody();
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element3)), ktExpression2 != null ? PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktExpression2)) : PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)element3)));
    }

    @Override
    public void applyTo(@NotNull KtForExpression element3, @Nullable Editor editor2) {
        PsiElement psiElement2;
        if (editor2 == null) {
            throw new IllegalArgumentException("This intention requires an editor");
        }
        KtExpression ktExpression = element3.getLoopRange();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression loopRange = ktExpression;
        KtParameter ktParameter = element3.getLoopParameter();
        Intrinsics.checkNotNull((Object)ktParameter);
        KtParameter loopParameter = ktParameter;
        KtPsiFactory psiFactory = new KtPsiFactory((KtElement)element3, false, 2, null);
        loopRange.replace((PsiElement)this.createWithIndexExpression(loopRange, true));
        Object[] objectArray = new Object[]{loopParameter.getText()};
        KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"for((index, $0) in x){}", (Object[])objectArray, (boolean)false, (int)4, null);
        Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
        KtDestructuringDeclaration ktDestructuringDeclaration = ((KtForExpression)ktExpression2).getDestructuringDeclaration();
        Intrinsics.checkNotNull((Object)ktDestructuringDeclaration);
        KtDestructuringDeclaration multiParameter = ktDestructuringDeclaration;
        PsiElement $this$replaced$iv = (PsiElement)loopParameter;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)multiParameter))) {
            psiElement2 = (PsiElement)multiParameter;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)multiParameter);
            if (result$iv instanceof KtDestructuringDeclaration) {
                psiElement2 = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDestructuringDeclaration");
                }
                psiElement2 = (PsiElement)((KtDestructuringDeclaration)ktExpression3);
            }
        }
        multiParameter = (KtDestructuringDeclaration)psiElement2;
        KtDestructuringDeclarationEntry indexVariable = (KtDestructuringDeclarationEntry)multiParameter.getEntries().get(0);
        editor2.getCaretModel().moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)indexVariable)));
        this.runTemplate(editor2, element3, indexVariable);
    }

    private final void runTemplate(Editor editor2, KtForExpression forExpression, KtDestructuringDeclarationEntry indexVariable) {
        PsiDocumentManager.getInstance((Project)forExpression.getProject()).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)forExpression);
        Object[] objectArray = new String[]{"index", "i"};
        templateBuilder.replaceElement((PsiElement)indexVariable, (Expression)new ChooseStringExpression((Collection)CollectionsKt.listOf((Object[])objectArray), null, null, 6, null));
        KtExpression body2 = forExpression.getBody();
        if (body2 instanceof KtBlockExpression) {
            KtExpression statement2 = (KtExpression)CollectionsKt.firstOrNull((List)((KtBlockExpression)body2).getStatements());
            if (statement2 != null) {
                templateBuilder.setEndVariableBefore((PsiElement)statement2);
            } else {
                templateBuilder.setEndVariableAfter(((KtBlockExpression)body2).getLBrace());
            }
        } else if (body2 == null) {
            PsiElement it = forExpression.getRightParenthesis();
            boolean bl = false;
            templateBuilder.setEndVariableAfter(it);
        } else {
            templateBuilder.setEndVariableBefore((PsiElement)body2);
        }
        templateBuilder.run(editor2, true);
    }

    private final KtExpression createWithIndexExpression(KtExpression originalExpression, boolean reformat) {
        Object[] objectArray = new Object[]{originalExpression};
        return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)new KtPsiFactory((KtElement)originalExpression, false, 2, null), (String)("$0." + WITH_INDEX_NAME + "()"), (Object[])objectArray, (boolean)reformat);
    }

    public static final /* synthetic */ String access$getWITH_INDEX_NAME$cp() {
        return WITH_INDEX_NAME;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddForLoopIndicesIntention$Companion;", "", "()V", "WITH_INDEX_FQ_NAMES", "", "", "getWITH_INDEX_FQ_NAMES", "()Ljava/util/Set;", "WITH_INDEX_FQ_NAMES$delegate", "Lkotlin/Lazy;", "WITH_INDEX_NAME", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<String> getWITH_INDEX_FQ_NAMES() {
            Lazy lazy = WITH_INDEX_FQ_NAMES$delegate;
            return (Set)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

