/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.logging;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.logging.KotlinPlaceholderCountMatchesArgumentCountInspectionKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001f\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0016J(\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/logging/KotlinPlaceholderCountMatchesArgumentCountInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkProblem", "", "loggerType", "Lorg/jetbrains/kotlin/idea/inspections/logging/KotlinPlaceholderCountMatchesArgumentCountInspection$LoggerType;", "lastArgumentIsException", "argumentsCount", "", "placeholderCount", "patternArgument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "countPlaceHolders", "pattern", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/idea/inspections/logging/KotlinPlaceholderCountMatchesArgumentCountInspection$LoggerType;)Ljava/lang/Integer;", "registerProblem", "Companion", "LoggerType", "kotlin.idea"})
public final class KotlinPlaceholderCountMatchesArgumentCountInspection
extends AbstractKotlinInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> LOGGING_METHODS;
    @NotNull
    private static final Map<String, LoggerType> LOGGER_CLASSES;

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return VisitorWrappersKt.callExpressionVisitor((Function1)((Function1)new Function1<KtCallExpression, Unit>(this, holder){
            final /* synthetic */ KotlinPlaceholderCountMatchesArgumentCountInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtCallExpression call) {
                int patternIndex;
                LoggerType loggerType;
                block20: {
                    block22: {
                        block21: {
                            List valueParameters2;
                            block19: {
                                String name2;
                                KtExpression $this$safeAs$iv = call.getCalleeExpression();
                                boolean $i$f$safeAs = false;
                                KtExpression ktExpression = $this$safeAs$iv;
                                if (!(ktExpression instanceof KtSimpleNameExpression)) {
                                    ktExpression = null;
                                }
                                KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
                                String string2 = name2 = ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedName() : null;
                                if (name2 == null || !KotlinPlaceholderCountMatchesArgumentCountInspection.access$getLOGGING_METHODS$cp().contains(name2)) {
                                    return;
                                }
                                ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)call, null, 1, null);
                                if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
                                    return;
                                }
                                ResolvedCall method = resolvedCall2;
                                Set parents2 = KotlinPlaceholderCountMatchesArgumentCountInspectionKt.access$findParents(UtilsKt.receiverType((CallableDescriptor)method), KotlinPlaceholderCountMatchesArgumentCountInspection.access$getLOGGER_CLASSES$cp().keySet());
                                if (parents2.isEmpty()) {
                                    return;
                                }
                                LoggerType loggerType2 = (LoggerType)((Object)KotlinPlaceholderCountMatchesArgumentCountInspection.access$getLOGGER_CLASSES$cp().get(CollectionsKt.first((Iterable)parents2)));
                                if (loggerType2 == null) {
                                    return;
                                }
                                loggerType = loggerType2;
                                valueParameters2 = method.getValueParameters();
                                if (valueParameters2.isEmpty()) {
                                    return;
                                }
                                patternIndex = 0;
                                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)valueParameters2.get(0);
                                if (!KotlinBuiltIns.isString((KotlinType)(valueParameterDescriptor != null ? valueParameterDescriptor.getType() : null))) break block19;
                                patternIndex = 0;
                                break block20;
                            }
                            if (valueParameters2.size() < 2) break block21;
                            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)valueParameters2.get(1);
                            if (KotlinBuiltIns.isString((KotlinType)(valueParameterDescriptor != null ? valueParameterDescriptor.getType() : null))) break block22;
                        }
                        return;
                    }
                    patternIndex = 1;
                }
                List valueArguments2 = call.getValueArguments();
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull((List)valueArguments2, (int)patternIndex);
                if (ktValueArgument == null) {
                    return;
                }
                KtValueArgument patternArgument2 = ktValueArgument;
                KtExpression ktExpression = patternArgument2.getArgumentExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression pattern2 = ktExpression;
                int argumentsCount = valueArguments2.size() - 1 - patternIndex;
                KtValueArgument ktValueArgument2 = (KtValueArgument)CollectionsKt.lastOrNull((List)valueArguments2);
                boolean lastArgumentIsException = KotlinPlaceholderCountMatchesArgumentCountInspectionKt.access$isThrowable(ktValueArgument2 != null && (ktValueArgument2 = ktValueArgument2.getArgumentExpression()) != null ? org.jetbrains.kotlin.idea.core.UtilsKt.resolveType$default((KtExpression)ktValueArgument2, null, 1, null) : null);
                if (argumentsCount == 1) {
                    KotlinType singleArgumentType;
                    KtExpression singleArgument;
                    KtValueArgument ktValueArgument3 = (KtValueArgument)CollectionsKt.getOrNull((List)valueArguments2, (int)(patternIndex + 1));
                    if (ktValueArgument3 == null) {
                        return;
                    }
                    KtValueArgument ktValueOneArgument = ktValueArgument3;
                    KtExpression ktExpression2 = singleArgument = ktValueOneArgument.getArgumentExpression();
                    KotlinType kotlinType = singleArgumentType = ktExpression2 != null ? org.jetbrains.kotlin.idea.core.UtilsKt.resolveType$default(ktExpression2, null, 1, null) : null;
                    if (singleArgumentType != null && KotlinBuiltIns.isArray((KotlinType)singleArgumentType) && ktValueOneArgument.isSpread()) {
                        KtExpression $this$safeAs$iv = singleArgument;
                        boolean $i$f$safeAs = false;
                        KtExpression ktExpression3 = $this$safeAs$iv;
                        if (!(ktExpression3 instanceof KtCallExpression)) {
                            ktExpression3 = null;
                        }
                        KtCallExpression ktCallExpression = (KtCallExpression)ktExpression3;
                        if (ktCallExpression == null) {
                            return;
                        }
                        KtCallExpression callExpression2 = ktCallExpression;
                        ResolvedCall resolvedCall3 = ResolutionUtils.resolveToCall$default((KtElement)callExpression2, null, 1, null);
                        if (Intrinsics.areEqual(resolvedCall3 != null && (resolvedCall3 = resolvedCall3.getResultingDescriptor()) != null && (resolvedCall3 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall3))) != null ? resolvedCall3.asString() : null, (Object)"kotlin.arrayOf")) {
                            KtValueArgument ktValueArgument4;
                            List arrayArguments = callExpression2.getValueArguments();
                            argumentsCount = arrayArguments.size();
                            lastArgumentIsException = argumentsCount > 0 && KotlinPlaceholderCountMatchesArgumentCountInspectionKt.access$isThrowable((ktValueArgument4 = (KtValueArgument)CollectionsKt.lastOrNull((List)arrayArguments)) != null && (ktValueArgument4 = ktValueArgument4.getArgumentExpression()) != null ? org.jetbrains.kotlin.idea.core.UtilsKt.resolveType$default((KtExpression)ktValueArgument4, null, 1, null) : null);
                        } else {
                            return;
                        }
                    }
                }
                Integer n = KotlinPlaceholderCountMatchesArgumentCountInspection.access$countPlaceHolders(this.this$0, pattern2, loggerType);
                if (n == null) {
                    return;
                }
                int placeholderCount = n;
                KotlinPlaceholderCountMatchesArgumentCountInspection.access$checkProblem(this.this$0, loggerType, lastArgumentIsException, argumentsCount, placeholderCount, this.$holder, patternArgument2);
            }
        }));
    }

    private final void checkProblem(LoggerType loggerType, boolean lastArgumentIsException, int argumentsCount, int placeholderCount, ProblemsHolder holder, KtValueArgument patternArgument2) {
        int actualArgumentsCount = argumentsCount;
        if (lastArgumentIsException) {
            --actualArgumentsCount;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[loggerType.ordinal()]) {
            case 1: {
                if (placeholderCount != actualArgumentsCount) break;
                return;
            }
            case 2: {
                if (placeholderCount != argumentsCount && (placeholderCount != argumentsCount - 1 || !lastArgumentIsException)) break;
                return;
            }
            case 3: {
                if ((placeholderCount != argumentsCount || lastArgumentIsException && argumentsCount <= 1) && (placeholderCount != argumentsCount - 1 || !lastArgumentIsException)) break;
                return;
            }
        }
        this.registerProblem(placeholderCount, actualArgumentsCount, holder, patternArgument2);
    }

    private final void registerProblem(int placeholderCount, int argumentsCount, ProblemsHolder holder, KtValueArgument patternArgument2) {
        if (placeholderCount < argumentsCount) {
            Object[] objectArray = new Object[]{argumentsCount, placeholderCount};
            holder.registerProblem((PsiElement)patternArgument2, KotlinBundle.message("placeholder.count.matches.argument.count.more.problem.descriptor", objectArray), new LocalQuickFix[0]);
        } else {
            Object[] objectArray = new Object[]{argumentsCount, placeholderCount};
            holder.registerProblem((PsiElement)patternArgument2, KotlinBundle.message("placeholder.count.matches.argument.count.fewer.problem.descriptor", objectArray), new LocalQuickFix[0]);
        }
    }

    private final Integer countPlaceHolders(KtExpression pattern2, LoggerType loggerType) {
        ConstantValue constantValue;
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)pattern2, BodyResolveMode.PARTIAL);
        CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(pattern2, bindingContext2);
        if (compileTimeConstant == null || (constantValue = compileTimeConstant.toConstantValue((KotlinType)DefaultBuiltIns.Companion.getInstance().getStringType())) == null) {
            return null;
        }
        ConstantValue constant = constantValue;
        Object object = constant.getValue();
        if (object == null || (object = object.toString()) == null) {
            return null;
        }
        Object text2 = object;
        int count = 0;
        boolean placeHolder2 = false;
        boolean escaped = false;
        int n = ((String)text2).length();
        for (int j = 0; j < n; ++j) {
            char c = ((String)text2).charAt(j);
            if (c == '\\' && loggerType == LoggerType.SLF4J_LOGGER) {
                escaped = !escaped;
                continue;
            }
            if (c == '{') {
                if (escaped) continue;
                placeHolder2 = true;
                continue;
            }
            if (c == '}') {
                if (placeHolder2) {
                    ++count;
                }
                placeHolder2 = false;
                escaped = false;
                continue;
            }
            placeHolder2 = false;
            escaped = false;
        }
        return count;
    }

    public static final /* synthetic */ Set access$getLOGGING_METHODS$cp() {
        return LOGGING_METHODS;
    }

    public static final /* synthetic */ Map access$getLOGGER_CLASSES$cp() {
        return LOGGER_CLASSES;
    }

    public static final /* synthetic */ Integer access$countPlaceHolders(KotlinPlaceholderCountMatchesArgumentCountInspection $this, KtExpression pattern2, LoggerType loggerType) {
        return $this.countPlaceHolders(pattern2, loggerType);
    }

    public static final /* synthetic */ void access$checkProblem(KotlinPlaceholderCountMatchesArgumentCountInspection $this, LoggerType loggerType, boolean lastArgumentIsException, int argumentsCount, int placeholderCount, ProblemsHolder holder, KtValueArgument patternArgument2) {
        $this.checkProblem(loggerType, lastArgumentIsException, argumentsCount, placeholderCount, holder, patternArgument2);
    }

    static {
        Object[] objectArray = new String[]{"log", "trace", "debug", "info", "warn", "error", "fatal"};
        LOGGING_METHODS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"org.slf4j.Logger", (Object)((Object)LoggerType.SLF4J_LOGGER)), TuplesKt.to((Object)"org.apache.logging.log4j.Logger", (Object)((Object)LoggerType.LOG4J_LOGGER)), TuplesKt.to((Object)"org.apache.logging.log4j.LogBuilder", (Object)((Object)LoggerType.LOG4J_BUILDER))};
        LOGGER_CLASSES = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/logging/KotlinPlaceholderCountMatchesArgumentCountInspection$LoggerType;", "", "(Ljava/lang/String;I)V", "SLF4J_LOGGER", "LOG4J_LOGGER", "LOG4J_BUILDER", "kotlin.idea"})
    private static final class LoggerType
    extends Enum<LoggerType> {
        public static final /* enum */ LoggerType SLF4J_LOGGER = new LoggerType();
        public static final /* enum */ LoggerType LOG4J_LOGGER = new LoggerType();
        public static final /* enum */ LoggerType LOG4J_BUILDER = new LoggerType();
        private static final /* synthetic */ LoggerType[] $VALUES;

        public static LoggerType[] values() {
            return (LoggerType[])$VALUES.clone();
        }

        public static LoggerType valueOf(String value2) {
            return Enum.valueOf(LoggerType.class, value2);
        }

        static {
            $VALUES = loggerTypeArray = new LoggerType[]{LoggerType.SLF4J_LOGGER, LoggerType.LOG4J_LOGGER, LoggerType.LOG4J_BUILDER};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/logging/KotlinPlaceholderCountMatchesArgumentCountInspection$Companion;", "", "()V", "LOGGER_CLASSES", "", "", "Lorg/jetbrains/kotlin/idea/inspections/logging/KotlinPlaceholderCountMatchesArgumentCountInspection$LoggerType;", "LOGGING_METHODS", "", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoggerType.values().length];
            try {
                nArray[LoggerType.SLF4J_LOGGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggerType.LOG4J_BUILDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggerType.LOG4J_LOGGER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

