/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.jvm.JvmDfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DataFlowIRProvider;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinAnchor;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinConstantConditionsInspection;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinConstantConditionsInspection$reportProblems$lambda$3$;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinProblem;
import org.jetbrains.kotlin.idea.inspections.dfa.KtDfaHelpersKt;
import org.jetbrains.kotlin.idea.inspections.dfa.SmartCastHelpersKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0003 !\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isLastCondition", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "logicalChain", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "processDataflowAnalysis", "", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "body", "states", "", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "reportProblems", "listener", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$KotlinDfaListener;", "shouldReportAsValue", "shouldSuppressForCondition", "loopRange", "shouldSuppressWhenCondition", "cv", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "Companion", "ConstantValue", "KotlinDfaListener", "kotlin.idea"})
public final class KotlinConstantConditionsInspection
extends AbstractKotlinInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Module module2 = GenericPsiUtils.getModule((PsiElement)holder.getFile());
        if (!(module2 != null && (module2 = TargetPlatformDetectorUtils.getPlatform(module2)) != null ? JvmPlatformKt.isJvm((TargetPlatform)module2) : false)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return (PsiElementVisitor)new KtVisitorVoid(holder, this){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ KotlinConstantConditionsInspection this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
            }

            public void visitProperty(@NotNull KtProperty property2) {
                if (this.shouldAnalyzeProperty(property2)) {
                    KtExpression ktExpression = property2.getDelegateExpressionOrInitializer();
                    if (ktExpression == null) {
                        return;
                    }
                    KtExpression initializer2 = ktExpression;
                    this.analyze(initializer2);
                }
            }

            public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
                if (this.shouldAnalyzeProperty(accessor.getProperty())) {
                    KtExpression ktExpression = accessor.getBodyExpression();
                    if (ktExpression == null) {
                        KtBlockExpression ktBlockExpression = accessor.getBodyBlockExpression();
                        if (ktBlockExpression != null) {
                            ktExpression = (KtExpression)ktBlockExpression;
                        } else {
                            return;
                        }
                    }
                    KtExpression bodyExpression = ktExpression;
                    this.analyze(bodyExpression);
                }
            }

            public void visitParameter(@NotNull KtParameter parameter2) {
                KtExpression ktExpression = parameter2.getDefaultValue();
                if (ktExpression == null) {
                    return;
                }
                this.analyze(ktExpression);
            }

            private final boolean shouldAnalyzeProperty(KtProperty property2) {
                return property2.isTopLevel() || property2.getParent() instanceof KtClassBody;
            }

            public void visitClassInitializer(@NotNull KtClassInitializer initializer2) {
                KtExpression ktExpression = initializer2.getBody();
                if (ktExpression == null) {
                    return;
                }
                this.analyze(ktExpression);
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                KtExpression ktExpression = function2.getBodyExpression();
                if (ktExpression == null) {
                    KtBlockExpression ktBlockExpression = function2.getBodyBlockExpression();
                    if (ktBlockExpression != null) {
                        ktExpression = (KtExpression)ktBlockExpression;
                    } else {
                        return;
                    }
                }
                KtExpression body2 = ktExpression;
                this.analyze(body2);
            }

            private final void analyze(KtExpression body2) {
                DfaValueFactory factory2 = new DfaValueFactory(this.$holder.getProject());
                KotlinConstantConditionsInspection.access$processDataflowAnalysis(this.this$0, factory2, body2, this.$holder, CollectionsKt.listOf((Object)new JvmDfaMemoryStateImpl(factory2)));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void processDataflowAnalysis(DfaValueFactory factory2, KtExpression body2, ProblemsHolder holder, Collection<? extends DfaMemoryState> states) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ControlFlow controlFlow = DataFlowIRProvider.forElement((PsiElement)((PsiElement)body2), (DfaValueFactory)factory2);
        if (controlFlow == null) {
            return;
        }
        ControlFlow flow = controlFlow;
        KotlinDfaListener listener2 = new KotlinDfaListener();
        StandardDataFlowInterpreter interpreter = new StandardDataFlowInterpreter(flow, (DfaListener)listener2);
        Iterable iterable = states;
        StandardDataFlowInterpreter standardDataFlowInterpreter = interpreter;
        boolean $i$f$map = false;
        void var10_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void s;
            DfaMemoryState dfaMemoryState = (DfaMemoryState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DfaInstructionState(flow.getInstruction(0), (DfaMemoryState)s));
        }
        if (standardDataFlowInterpreter.interpret((List)destination$iv$iv) != RunnerResult.OK) {
            return;
        }
        this.reportProblems(listener2, holder);
        for (Map.Entry entry : interpreter.getClosures().entrySet()) {
            PsiElement closure = (PsiElement)entry.getKey();
            Collection closureStates = (Collection)entry.getValue();
            if (!(closure instanceof KtExpression)) continue;
            this.processDataflowAnalysis(factory2, (KtExpression)closure, holder, closureStates);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportProblems(KotlinDfaListener listener2, ProblemsHolder holder) {
        KtExpression expr;
        Object object;
        Map.Entry entry;
        Map.Entry element$iv;
        Map $this$forEach$iv = listener2.getConstantConditions();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            KtExpression loopRange;
            String message2;
            ProblemHighlightType highlightType;
            entry = element$iv = iterator.next();
            boolean bl = false;
            KotlinAnchor anchor = (KotlinAnchor)entry.getKey();
            ConstantValue cv = (ConstantValue)((Object)entry.getValue());
            if (cv == ConstantValue.UNKNOWN) continue;
            object = anchor;
            if (object instanceof KotlinAnchor.KotlinExpressionAnchor) {
                expr = ((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression();
                if (KotlinConstantConditionsInspection.Companion.shouldSuppress(cv, expr)) continue;
                String key = switch (WhenMappings.$EnumSwitchMapping$0[cv.ordinal()]) {
                    case 1 -> {
                        if (this.shouldReportAsValue(expr)) {
                            yield "inspection.message.value.always.true";
                        }
                        if (this.logicalChain(expr)) {
                            yield "inspection.message.condition.always.true.when.reached";
                        }
                        yield "inspection.message.condition.always.true";
                    }
                    case 2 -> {
                        if (this.shouldReportAsValue(expr)) {
                            yield "inspection.message.value.always.false";
                        }
                        if (this.logicalChain(expr)) {
                            yield "inspection.message.condition.always.false.when.reached";
                        }
                        yield "inspection.message.condition.always.false";
                    }
                    case 3 -> "inspection.message.value.always.null";
                    case 4 -> "inspection.message.value.always.zero";
                    default -> throw new IllegalStateException("Unexpected constant: " + cv);
                };
                highlightType = this.shouldReportAsValue(expr) ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                Object[] objectArray = new Object[]{expr.getText()};
                holder.registerProblem((PsiElement)expr, KotlinBundle.message(key, objectArray), highlightType, new LocalQuickFix[0]);
                continue;
            }
            if (object instanceof KotlinAnchor.KotlinWhenConditionAnchor) {
                void $this$forEach$iv2;
                Sequence $this$filterIsInstance$iv;
                KtWhenEntry nextEntry;
                void $this$forEach$iv3;
                Sequence $this$filterIsInstance$iv2;
                KtWhenCondition condition2 = ((KotlinAnchor.KotlinWhenConditionAnchor)anchor).getCondition();
                if (this.shouldSuppressWhenCondition(cv, condition2)) continue;
                message2 = KotlinBundle.message("inspection.message.when.condition.always.false", new Object[0]);
                if (cv == ConstantValue.FALSE) {
                    holder.registerProblem((PsiElement)condition2, message2, new LocalQuickFix[0]);
                    continue;
                }
                if (cv != ConstantValue.TRUE) continue;
                highlightType = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)condition2), (boolean)true, (boolean)false);
                boolean $i$f$filterIsInstance = false;
                Intrinsics.checkNotNull((Object)SequencesKt.filter((Sequence)$this$filterIsInstance$iv2, (Function1)reportProblems$lambda$3$$inlined$filterIsInstance$1.INSTANCE), (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                boolean $i$f$forEach22 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    KtWhenCondition cond = (KtWhenCondition)element$iv2;
                    boolean bl2 = false;
                    holder.registerProblem((PsiElement)cond, message2, new LocalQuickFix[0]);
                }
                Iterator iterator2 = condition2.getParent();
                if ((iterator2 instanceof KtWhenEntry ? (KtWhenEntry)iterator2 : null) == null) continue;
                nextEntry = nextEntry;
                Sequence $i$f$forEach22 = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)nextEntry), (boolean)true, (boolean)false);
                boolean $i$f$filterIsInstance2 = false;
                Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)reportProblems$lambda$3$$inlined$filterIsInstance$2.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv = SequencesKt.flatMap((Sequence)SequencesKt.filterNot((Sequence)sequence2, (Function1)reportProblems.1.2.INSTANCE), (Function1)reportProblems.1.3.INSTANCE);
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    KtWhenCondition cond = (KtWhenCondition)element$iv3;
                    boolean bl3 = false;
                    holder.registerProblem((PsiElement)cond, message2, new LocalQuickFix[0]);
                }
                continue;
            }
            if (!(object instanceof KotlinAnchor.KotlinForVisitedAnchor)) continue;
            Intrinsics.checkNotNull((Object)((KotlinAnchor.KotlinForVisitedAnchor)anchor).getForExpression().getLoopRange());
            if (cv != ConstantValue.FALSE || this.shouldSuppressForCondition(loopRange)) continue;
            message2 = KotlinBundle.message("inspection.message.for.never.visited", new Object[0]);
            holder.registerProblem((PsiElement)loopRange, message2, new LocalQuickFix[0]);
        }
        $this$forEach$iv = listener2.getProblems();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            KtBinaryExpressionWithTypeRHS ktBinaryExpressionWithTypeRHS;
            KtBinaryExpressionWithTypeRHS ktBinaryExpressionWithTypeRHS2;
            KtExpression anchor;
            entry = element$iv = iterator.next();
            boolean bl = false;
            KotlinProblem problem = (KotlinProblem)entry.getKey();
            ThreeState state = (ThreeState)entry.getValue();
            if (state != ThreeState.YES) continue;
            object = problem;
            if (object instanceof KotlinProblem.KotlinArrayIndexProblem) {
                holder.registerProblem((PsiElement)((KotlinProblem.KotlinArrayIndexProblem)problem).getIndex(), KotlinBundle.message("inspection.message.index.out.of.bounds", new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            if (object instanceof KotlinProblem.KotlinNullCheckProblem) {
                expr = ((KotlinProblem.KotlinNullCheckProblem)problem).getExpr();
                KtExpression ktExpression = expr.getBaseExpression();
                if (ktExpression != null ? PsiUtilsKt.isNull((KtExpression)ktExpression) : false) continue;
                holder.registerProblem((PsiElement)expr.getOperationReference(), KotlinBundle.message("inspection.message.nonnull.cast.will.always.fail", new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            if (!(object instanceof KotlinProblem.KotlinCastProblem) || KotlinConstantConditionsInspection.Companion.isCompilationWarning((KtElement)(anchor = (ktBinaryExpressionWithTypeRHS2 = (ktBinaryExpressionWithTypeRHS = ((KotlinProblem.KotlinCastProblem)problem).getCast()) instanceof KtBinaryExpressionWithTypeRHS ? ktBinaryExpressionWithTypeRHS : null) != null && (ktBinaryExpressionWithTypeRHS2 = ktBinaryExpressionWithTypeRHS2.getOperationReference()) != null ? (KtExpression)ktBinaryExpressionWithTypeRHS2 : (KtExpression)((KotlinProblem.KotlinCastProblem)problem).getCast()))) continue;
            holder.registerProblem((PsiElement)anchor, KotlinBundle.message("inspection.message.cast.will.always.fail", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private final boolean shouldSuppressForCondition(KtExpression loopRange) {
        if (loopRange instanceof KtBinaryExpression) {
            KtExpression left = ((KtBinaryExpression)loopRange).getLeft();
            KtExpression right2 = ((KtBinaryExpression)loopRange).getRight();
            return left != null && right2 != null && CommonUtilsKt.isConstant(left) && CommonUtilsKt.isConstant(right2);
        }
        return false;
    }

    private final boolean shouldReportAsValue(KtExpression expr) {
        return expr instanceof KtSimpleNameExpression || expr instanceof KtQualifiedExpression && ((KtQualifiedExpression)expr).getSelectorExpression() instanceof KtSimpleNameExpression;
    }

    private final boolean logicalChain(KtExpression expr) {
        KtExpression context2 = expr;
        PsiElement parent2 = context2.getParent();
        while (parent2 instanceof KtParenthesizedExpression) {
            context2 = (KtExpression)parent2;
            parent2 = ((KtParenthesizedExpression)context2).getParent();
        }
        if (parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getRight(), (Object)context2)) {
            IElementType token = ((KtBinaryExpression)parent2).getOperationToken();
            return Intrinsics.areEqual((Object)token, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)token, (Object)KtTokens.OROR);
        }
        return false;
    }

    private final boolean shouldSuppressWhenCondition(ConstantValue cv, KtWhenCondition condition2) {
        if (cv != ConstantValue.FALSE && cv != ConstantValue.TRUE) {
            return true;
        }
        if (cv == ConstantValue.TRUE && this.isLastCondition(condition2)) {
            return true;
        }
        if (condition2.getTextLength() == 0) {
            return true;
        }
        return KotlinConstantConditionsInspection.Companion.isCompilationWarning((KtElement)condition2);
    }

    private final boolean isLastCondition(KtWhenCondition condition2) {
        PsiElement psiElement2 = condition2.getParent();
        KtWhenEntry ktWhenEntry = psiElement2 instanceof KtWhenEntry ? (KtWhenEntry)psiElement2 : null;
        if (ktWhenEntry == null) {
            return false;
        }
        KtWhenEntry entry = ktWhenEntry;
        PsiElement psiElement3 = entry.getParent();
        KtWhenExpression ktWhenExpression = psiElement3 instanceof KtWhenExpression ? (KtWhenExpression)psiElement3 : null;
        if (ktWhenExpression == null) {
            return false;
        }
        KtWhenExpression whenExpr = ktWhenExpression;
        if (Intrinsics.areEqual((Object)ArraysKt.last((Object[])entry.getConditions()), (Object)condition2)) {
            List entries2 = whenExpr.getEntries();
            KtWhenEntry lastEntry = (KtWhenEntry)CollectionsKt.last((List)entries2);
            if (Intrinsics.areEqual((Object)lastEntry, (Object)entry)) {
                return true;
            }
            int size = entries2.size();
            if (lastEntry.isElse() && size > 1 && Intrinsics.areEqual(entries2.get(size - 2), (Object)entry)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void access$processDataflowAnalysis(KotlinConstantConditionsInspection $this, DfaValueFactory factory2, KtExpression body2, ProblemsHolder holder, Collection states) {
        $this.processDataflowAnalysis(factory2, body2, holder, states);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "", "(Ljava/lang/String;I)V", "TRUE", "FALSE", "NULL", "ZERO", "UNKNOWN", "kotlin.idea"})
    private static final class ConstantValue
    extends Enum<ConstantValue> {
        public static final /* enum */ ConstantValue TRUE = new ConstantValue();
        public static final /* enum */ ConstantValue FALSE = new ConstantValue();
        public static final /* enum */ ConstantValue NULL = new ConstantValue();
        public static final /* enum */ ConstantValue ZERO = new ConstantValue();
        public static final /* enum */ ConstantValue UNKNOWN = new ConstantValue();
        private static final /* synthetic */ ConstantValue[] $VALUES;

        public static ConstantValue[] values() {
            return (ConstantValue[])$VALUES.clone();
        }

        public static ConstantValue valueOf(String value2) {
            return Enum.valueOf(ConstantValue.class, value2);
        }

        static {
            $VALUES = constantValueArray = new ConstantValue[]{ConstantValue.TRUE, ConstantValue.FALSE, ConstantValue.NULL, ConstantValue.ZERO, ConstantValue.UNKNOWN};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J(\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR-\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$KotlinDfaListener;", "Lcom/intellij/codeInspection/dataFlow/lang/DfaListener;", "()V", "constantConditions", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinAnchor;", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "Lkotlin/collections/HashMap;", "getConstantConditions", "()Ljava/util/HashMap;", "problems", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinProblem;", "Lcom/intellij/util/ThreeState;", "getProblems", "beforePush", "", "args", "", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "value", "anchor", "Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "([Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)V", "onCondition", "problem", "Lcom/intellij/codeInspection/dataFlow/lang/UnsatisfiedConditionProblem;", "failed", "recordExpressionValue", "kotlin.idea"})
    private static final class KotlinDfaListener
    implements DfaListener {
        @NotNull
        private final HashMap<KotlinAnchor, ConstantValue> constantConditions = new HashMap();
        @NotNull
        private final HashMap<KotlinProblem, ThreeState> problems = new HashMap();

        @NotNull
        public final HashMap<KotlinAnchor, ConstantValue> getConstantConditions() {
            return this.constantConditions;
        }

        @NotNull
        public final HashMap<KotlinProblem, ThreeState> getProblems() {
            return this.problems;
        }

        public void beforePush(@NotNull DfaValue[] args, @NotNull DfaValue value2, @NotNull DfaAnchor anchor, @NotNull DfaMemoryState state) {
            if (anchor instanceof KotlinAnchor) {
                this.recordExpressionValue((KotlinAnchor)anchor, state, value2);
            }
        }

        public void onCondition(@NotNull UnsatisfiedConditionProblem problem, @NotNull DfaValue value2, @NotNull ThreeState failed, @NotNull DfaMemoryState state) {
            if (problem instanceof KotlinProblem) {
                this.problems.merge((KotlinProblem)problem, failed, (arg_0, arg_1) -> KotlinDfaListener.onCondition$lambda$0(onCondition.1.INSTANCE, arg_0, arg_1));
            }
        }

        private final void recordExpressionValue(KotlinAnchor anchor, DfaMemoryState state, DfaValue value2) {
            Number constVal;
            ConstantValue newVal;
            ConstantValue oldVal = this.constantConditions.get(anchor);
            if (oldVal == ConstantValue.UNKNOWN) {
                return;
            }
            DfType dfType = state.getDfType(value2);
            ConstantValue constantValue = Intrinsics.areEqual((Object)dfType, (Object)DfTypes.TRUE) ? ConstantValue.TRUE : (Intrinsics.areEqual((Object)dfType, (Object)DfTypes.FALSE) ? ConstantValue.FALSE : (Intrinsics.areEqual((Object)dfType, (Object)DfTypes.NULL) ? ConstantValue.NULL : (newVal = (constVal = (Number)dfType.getConstantOfType(Number.class)) != null && (Intrinsics.areEqual((Object)constVal, (Object)0) || Intrinsics.areEqual((Object)constVal, (Object)0L)) ? ConstantValue.ZERO : ConstantValue.UNKNOWN)));
            if (oldVal != null && oldVal != newVal) {
                newVal = ConstantValue.UNKNOWN;
            }
            ((Map)this.constantConditions).put(anchor, newVal);
        }

        private static final ThreeState onCondition$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            return (ThreeState)$tmp0.invoke(p0, p1);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J \u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001a\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001a\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J \u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\fH\u0002J#\u0010!\u001a\u00020\u00042\b\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020\fH\u0082\u0010J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0002J\u0016\u0010'\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020(2\u0006\u0010\r\u001a\u00020\fJ\u0018\u0010'\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020)2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$Companion;", "", "()V", "areEquivalent", "", "e1", "Lorg/jetbrains/kotlin/psi/KtElement;", "e2", "hasOppositeCondition", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "topCondition", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "hasWritesTo", "block", "Lcom/intellij/psi/PsiElement;", "variable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isAlsoChain", "expr", "isAssertion", "parent", "value", "isCallToMethod", "call", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "packageName", "", "methodName", "isCompilationWarning", "anchor", "isLetConstant", "isOppositeCondition", "candidate", "template", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isPairingConditionInWhen", "isUpdateChain", "shouldSuppress", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean areEquivalent(KtElement e1, KtElement e2) {
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)e1), (PsiElement)((PsiElement)e2), (arg_0, arg_1) -> Companion.areEquivalent$lambda$0(areEquivalent.1.INSTANCE, arg_0, arg_1), null, null, (boolean)false);
        }

        private final boolean isOppositeCondition(KtExpression candidate2, KtBinaryExpression template2, KtExpression expression2) {
            while (candidate2 instanceof KtBinaryExpression && ((KtBinaryExpression)candidate2).getOperationToken() == KtTokens.ANDAND) {
                KtExpression left = ((KtBinaryExpression)candidate2).getLeft();
                KtExpression right2 = ((KtBinaryExpression)candidate2).getRight();
                if (left == null || right2 == null) {
                    return false;
                }
                KtExpression templateLeft = template2.getLeft();
                KtExpression templateRight = template2.getRight();
                if (templateLeft == null || templateRight == null) {
                    return false;
                }
                if (templateRight == expression2) {
                    return this_.areEquivalent((KtElement)left, (KtElement)templateLeft) && this_.areEquivalent((KtElement)UtilsKt.negate(right2, false), (KtElement)templateRight);
                }
                if (!this_.areEquivalent((KtElement)right2, (KtElement)templateRight)) {
                    return false;
                }
                if (templateLeft == expression2) {
                    return this_.areEquivalent((KtElement)UtilsKt.negate(left, false), (KtElement)templateLeft);
                }
                if (!(templateLeft instanceof KtBinaryExpression) || ((KtBinaryExpression)templateLeft).getOperationToken() != KtTokens.ANDAND) {
                    return false;
                }
                Companion companion = this_;
                KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)templateLeft;
                KtExpression ktExpression = expression2;
                Companion this_ = companion;
                candidate2 = left;
                template2 = ktBinaryExpression;
                expression2 = ktExpression;
            }
            return false;
        }

        private final boolean hasOppositeCondition(KtWhenExpression whenExpression2, KtExpression topCondition, KtExpression expression2) {
            for (KtWhenEntry entry : whenExpression2.getEntries()) {
                for (KtWhenCondition condition2 : entry.getConditions()) {
                    if (!(condition2 instanceof KtWhenConditionWithExpression)) continue;
                    KtExpression candidate2 = ((KtWhenConditionWithExpression)condition2).getExpression();
                    if (candidate2 == topCondition) {
                        return false;
                    }
                    if (topCondition instanceof KtBinaryExpression && this.isOppositeCondition(candidate2, (KtBinaryExpression)topCondition, expression2)) {
                        return true;
                    }
                    if (candidate2 == null || !this.areEquivalent((KtElement)UtilsKt.negate(expression2, false), (KtElement)candidate2)) continue;
                    return true;
                }
            }
            return false;
        }

        private final boolean isPairingConditionInWhen(KtExpression expression2) {
            PsiElement psiElement2;
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.ANDAND)) {
                PsiElement nextParent;
                KtBinaryExpression topAnd = (KtBinaryExpression)parent2;
                while ((nextParent = topAnd.getParent()) instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)nextParent).getOperationToken(), (Object)KtTokens.ANDAND)) {
                    topAnd = (KtBinaryExpression)nextParent;
                }
                PsiElement topAndParent = topAnd.getParent();
                if (topAndParent instanceof KtWhenConditionWithExpression) {
                    KtWhenExpression whenExpression2;
                    PsiElement psiElement3 = ((KtWhenConditionWithExpression)topAndParent).getParent();
                    KtWhenEntry ktWhenEntry = psiElement3 instanceof KtWhenEntry ? (KtWhenEntry)psiElement3 : null;
                    psiElement2 = ktWhenEntry != null ? ktWhenEntry.getParent() : null;
                    KtWhenExpression ktWhenExpression = whenExpression2 = psiElement2 instanceof KtWhenExpression ? (KtWhenExpression)psiElement2 : null;
                    if (whenExpression2 != null && this.hasOppositeCondition(whenExpression2, (KtExpression)topAnd, expression2)) {
                        return true;
                    }
                }
            }
            if (parent2 instanceof KtWhenConditionWithExpression) {
                KtWhenExpression whenExpression3;
                psiElement2 = ((KtWhenConditionWithExpression)parent2).getParent();
                KtWhenEntry ktWhenEntry = psiElement2 instanceof KtWhenEntry ? (KtWhenEntry)psiElement2 : null;
                PsiElement psiElement4 = ktWhenEntry != null ? ktWhenEntry.getParent() : null;
                KtWhenExpression ktWhenExpression = whenExpression3 = psiElement4 instanceof KtWhenExpression ? (KtWhenExpression)psiElement4 : null;
                if (whenExpression3 != null && this.hasOppositeCondition(whenExpression3, expression2, expression2)) {
                    return true;
                }
            }
            return false;
        }

        private final boolean isCompilationWarning(KtElement anchor) {
            boolean bl;
            block4: {
                BindingContext context2 = ResolutionUtils.analyze(anchor, BodyResolveMode.FULL);
                Iterable $this$any$iv = context2.getDiagnostics().forElement((PsiElement)anchor);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Diagnostic it = (Diagnostic)element$iv;
                        boolean bl2 = false;
                        boolean bl3 = Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.CAST_NEVER_SUCCEEDS) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.SENSELESS_COMPARISON) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.SENSELESS_NULL_IN_WHEN) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.USELESS_IS_CHECK) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.DUPLICATE_LABEL_IN_WHEN);
                        if (!bl3) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            PsiFile rootElement = anchor.getContainingFile();
            KotlinSuppressCache suppressionCache = KotlinCacheService.Companion.getInstance(anchor.getProject()).getSuppressionCache();
            return suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "CAST_NEVER_SUCCEEDS", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "SENSELESS_COMPARISON", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "SENSELESS_NULL_IN_WHEN", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "USELESS_IS_CHECK", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "DUPLICATE_LABEL_IN_WHEN", Severity.WARNING);
        }

        private final boolean isCallToMethod(KtCallExpression call, String packageName2, String methodName2) {
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)call, null, 1, null);
            if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
                return false;
            }
            ResolvedCall descriptor2 = resolvedCall2;
            if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)methodName2)) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
            if (packageFragmentDescriptor == null) {
                return false;
            }
            PackageFragmentDescriptor packageFragment2 = packageFragmentDescriptor;
            return Intrinsics.areEqual((Object)packageFragment2.getFqName().asString(), (Object)packageName2);
        }

        private final boolean isLetConstant(KtExpression expr) {
            KtQualifiedExpression ktQualifiedExpression = expr instanceof KtQualifiedExpression ? (KtQualifiedExpression)expr : null;
            KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
            KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression call = ktCallExpression;
            if (!this.isCallToMethod(call, "kotlin", "let")) {
                return false;
            }
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)call.getLambdaArguments());
            if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
                return false;
            }
            KtLambdaArgument lambda2 = ktLambdaArgument;
            Object object = lambda2.getBodyExpression();
            return (object != null && (object = object.getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : null) instanceof KtConstantExpression;
        }

        private final boolean isAlsoChain(KtExpression expr) {
            KtQualifiedExpression ktQualifiedExpression = expr instanceof KtQualifiedExpression ? (KtQualifiedExpression)expr : null;
            KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
            KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression call = ktCallExpression;
            return this.isCallToMethod(call, "kotlin", "also");
        }

        private final boolean isAssertion(PsiElement parent2, boolean value2) {
            boolean bl;
            PsiElement psiElement2 = parent2;
            if (psiElement2 instanceof KtBinaryExpression) {
                bl = (Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.OROR)) && this.isAssertion(((KtBinaryExpression)parent2).getParent(), value2);
            } else if (psiElement2 instanceof KtParenthesizedExpression) {
                bl = this.isAssertion(((KtParenthesizedExpression)parent2).getParent(), value2);
            } else if (psiElement2 instanceof KtPrefixExpression) {
                bl = Intrinsics.areEqual((Object)((KtPrefixExpression)parent2).getOperationToken(), (Object)KtTokens.EXCL) && this.isAssertion(((KtPrefixExpression)parent2).getParent(), !value2);
            } else {
                if (psiElement2 instanceof KtValueArgument) {
                    if (!value2) {
                        return false;
                    }
                    PsiElement psiElement3 = ((KtValueArgument)parent2).getParent();
                    KtValueArgumentList ktValueArgumentList = psiElement3 instanceof KtValueArgumentList ? (KtValueArgumentList)psiElement3 : null;
                    if (ktValueArgumentList == null) {
                        return false;
                    }
                    KtValueArgumentList valueArgList = ktValueArgumentList;
                    PsiElement psiElement4 = valueArgList.getParent();
                    KtCallExpression ktCallExpression = psiElement4 instanceof KtCallExpression ? (KtCallExpression)psiElement4 : null;
                    if (ktCallExpression == null) {
                        return false;
                    }
                    KtCallExpression call = ktCallExpression;
                    ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)call, null, 1, null);
                    if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
                        return false;
                    }
                    ResolvedCall descriptor2 = resolvedCall2;
                    String name2 = descriptor2.getName().asString();
                    if (!(Intrinsics.areEqual((Object)name2, (Object)"assert") || Intrinsics.areEqual((Object)name2, (Object)"require") || Intrinsics.areEqual((Object)name2, (Object)"check"))) {
                        return false;
                    }
                    DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
                    PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
                    if (packageFragmentDescriptor == null) {
                        return false;
                    }
                    PackageFragmentDescriptor pkg = packageFragmentDescriptor;
                    return Intrinsics.areEqual((Object)pkg.getFqName().asString(), (Object)"kotlin");
                }
                bl = false;
            }
            return bl;
        }

        private final boolean hasWritesTo(PsiElement block2, KtProperty variable2) {
            return !PsiTreeUtil.processElements((PsiElement)block2, KtSimpleNameExpression.class, (PsiElementProcessor)new PsiElementProcessor(variable2){
                final /* synthetic */ KtProperty $variable;
                {
                    this.$variable = $variable;
                }

                public final boolean execute(@NotNull KtSimpleNameExpression ref) {
                    boolean write2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ref).isReferenceTo((PsiElement)this.$variable) && ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)((KtExpression)ref), (boolean)false).isWrite();
                    return !write2;
                }
            });
        }

        private final boolean isUpdateChain(KtExpression expression2) {
            if (!(expression2 instanceof KtSimpleNameExpression)) {
                return false;
            }
            PsiElement psiElement2 = ((KtSimpleNameExpression)expression2).getParent();
            KtBinaryExpression ktBinaryExpression = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
            if (ktBinaryExpression == null) {
                return false;
            }
            KtBinaryExpression binOp = ktBinaryExpression;
            String op = binOp.getOperationReference().getText();
            if (!(Intrinsics.areEqual((Object)op, (Object)"or") || Intrinsics.areEqual((Object)op, (Object)"and") || Intrinsics.areEqual((Object)op, (Object)"xor") || Intrinsics.areEqual((Object)op, (Object)"||") || Intrinsics.areEqual((Object)op, (Object)"&&"))) {
                return false;
            }
            PsiElement psiElement3 = binOp.getParent();
            KtBinaryExpression ktBinaryExpression2 = psiElement3 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement3 : null;
            if (ktBinaryExpression2 == null) {
                return false;
            }
            KtBinaryExpression assignment2 = ktBinaryExpression2;
            if (!Intrinsics.areEqual((Object)assignment2.getOperationToken(), (Object)KtTokens.EQ)) {
                return false;
            }
            KtExpression left = assignment2.getLeft();
            if (!(left instanceof KtSimpleNameExpression) || !((KtSimpleNameExpression)left).textMatches((CharSequence)((KtSimpleNameExpression)expression2).getText())) {
                return false;
            }
            PsiElement psiElement4 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)expression2)).resolve();
            KtProperty ktProperty = psiElement4 instanceof KtProperty ? (KtProperty)psiElement4 : null;
            if (ktProperty == null) {
                return false;
            }
            KtProperty variable2 = ktProperty;
            PsiElement psiElement5 = variable2.getParent();
            KtBlockExpression ktBlockExpression = psiElement5 instanceof KtBlockExpression ? (KtBlockExpression)psiElement5 : null;
            if (ktBlockExpression == null) {
                return false;
            }
            KtBlockExpression varParent = ktBlockExpression;
            PsiElement context2 = (PsiElement)assignment2;
            PsiElement block2 = context2.getParent();
            while (true) {
                if (!(block2 instanceof KtContainerNode || block2 instanceof KtBlockExpression && Intrinsics.areEqual((Object)CollectionsKt.first((List)((KtBlockExpression)block2).getStatements()), (Object)context2))) {
                    if (!(block2 instanceof KtIfExpression)) break;
                    KtExpression ktExpression = ((KtIfExpression)block2).getThen();
                    if (!Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getParent() : null), (Object)context2) || ((KtIfExpression)block2).getElse() != null || this.hasWritesTo((PsiElement)((KtIfExpression)block2).getCondition(), variable2)) break;
                }
                context2 = block2;
                block2 = context2.getParent();
            }
            if (block2 != varParent) {
                return false;
            }
            PsiElement curExpression = variable2.getNextSibling();
            while (!Intrinsics.areEqual((Object)curExpression, (Object)context2)) {
                if (this.hasWritesTo(curExpression, variable2)) {
                    return false;
                }
                curExpression = curExpression.getNextSibling();
            }
            return true;
        }

        public final boolean shouldSuppress(@NotNull DfType value2, @NotNull KtExpression expression2) {
            DfType dfType = value2;
            ConstantValue constant = Intrinsics.areEqual((Object)dfType, (Object)DfTypes.NULL) ? ConstantValue.NULL : (Intrinsics.areEqual((Object)dfType, (Object)DfTypes.TRUE) ? ConstantValue.TRUE : (Intrinsics.areEqual((Object)dfType, (Object)DfTypes.FALSE) ? ConstantValue.FALSE : ((Intrinsics.areEqual((Object)dfType, (Object)DfTypes.intValue((int)0)) ? true : Intrinsics.areEqual((Object)dfType, (Object)DfTypes.longValue((long)0L))) ? ConstantValue.ZERO : ConstantValue.UNKNOWN)));
            return this.shouldSuppress(constant, expression2);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean shouldSuppress(ConstantValue value2, KtExpression expression2) {
            PsiElement target2;
            PsiElement psiElement2;
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)parent2).getSelectorExpression(), (Object)expression2)) {
                return true;
            }
            while (parent2 instanceof KtParenthesizedExpression) {
                parent2 = ((KtParenthesizedExpression)parent2).getParent();
            }
            if (expression2 instanceof KtConstantExpression) return true;
            if (expression2 instanceof KtProperty) return true;
            if (expression2 instanceof KtBinaryExpression) {
                if (Intrinsics.areEqual((Object)((KtBinaryExpression)expression2).getOperationToken(), (Object)KtTokens.EQ)) return true;
            }
            KtPrefixExpression ktPrefixExpression = (psiElement2 = parent2) instanceof KtPrefixExpression ? (KtPrefixExpression)psiElement2 : null;
            if (Intrinsics.areEqual((Object)(ktPrefixExpression != null ? ktPrefixExpression.getOperationToken() : null), (Object)KtTokens.EXCL)) {
                return true;
            }
            if (expression2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)expression2).getOperationToken(), (Object)KtTokens.ELVIS)) {
                boolean bl;
                KtExpression ktExpression = ((KtBinaryExpression)expression2).getLeft();
                if (ktExpression != null && (ktExpression = KtDfaHelpersKt.getKotlinType(ktExpression)) != null) {
                    if (TypeUtilsKt.isNullableNothing((KotlinType)ktExpression)) {
                        return true;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
                if (bl) {
                    return true;
                }
            }
            if (this.isAlsoChain(expression2)) return true;
            if (this.isLetConstant(expression2)) return true;
            if (this.isUpdateChain(expression2)) {
                return true;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[value2.ordinal()]) {
                case 1: {
                    if (SmartCastHelpersKt.isSmartCastNecessary(expression2, true)) {
                        return true;
                    }
                    if (this.isPairingConditionInWhen(expression2)) {
                        return true;
                    }
                    if (!this.isAssertion(parent2, true)) break;
                    return true;
                }
                case 2: {
                    if (SmartCastHelpersKt.isSmartCastNecessary(expression2, false)) {
                        return true;
                    }
                    if (!this.isAssertion(parent2, false)) break;
                    return true;
                }
                case 3: {
                    BindingContext bindingContext2;
                    if (ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)expression2, (boolean)false).isWrite()) {
                        return true;
                    }
                    if (expression2 instanceof KtDotQualifiedExpression) {
                        KtExpression ktExpression = ((KtDotQualifiedExpression)expression2).getSelectorExpression();
                        boolean bl = ktExpression != null ? ktExpression.textMatches((CharSequence)"ordinal") : false;
                        if (bl) {
                            KtExpression receiver2 = ((KtDotQualifiedExpression)expression2).getReceiverExpression();
                            if (receiver2 instanceof KtQualifiedExpression) {
                                receiver2 = ((KtQualifiedExpression)receiver2).getSelectorExpression();
                            }
                            if (receiver2 instanceof KtSimpleNameExpression) {
                                boolean bl2;
                                void $this$any$iv;
                                Iterable iterable = ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)receiver2);
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        DeclarationDescriptor desc2 = (DeclarationDescriptor)element$iv;
                                        boolean bl3 = false;
                                        if (desc2 instanceof ClassDescriptor && ((ClassDescriptor)desc2).getKind() == ClassKind.ENUM_ENTRY) {
                                            return true;
                                        }
                                        boolean bl4 = false;
                                        if (!bl4) continue;
                                        return true;
                                    }
                                    bl2 = false;
                                }
                                if (bl2) {
                                    return true;
                                }
                            }
                        }
                    }
                    if (ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext2 = ResolutionUtils.analyze$default((KtElement)expression2, null, 1, null)) != null) {
                        return true;
                    }
                    if (!(expression2 instanceof KtSimpleNameExpression)) break;
                    if (parent2 instanceof KtValueArgument) return true;
                    if (!(parent2 instanceof KtContainerNode) || !(((KtContainerNode)parent2).getParent() instanceof KtArrayAccessExpression)) break;
                    return true;
                }
                case 4: {
                    KotlinType kotlinType;
                    IElementType token;
                    if (parent2 instanceof KtProperty && ((KtProperty)parent2).getTypeReference() == null && expression2 instanceof KtSimpleNameExpression) {
                        return true;
                    }
                    if (expression2 instanceof KtBinaryExpressionWithTypeRHS && PsiUtilsKt.isNull((KtExpression)((KtBinaryExpressionWithTypeRHS)expression2).getLeft())) {
                        return true;
                    }
                    if (parent2 instanceof KtBinaryExpression && ((token = ((KtBinaryExpression)parent2).getOperationToken()) == KtTokens.EQEQ || token == KtTokens.EXCLEQ || token == KtTokens.EQEQEQ || token == KtTokens.EXCLEQEQEQ)) {
                        boolean bl;
                        boolean bl5;
                        KtExpression ktExpression = ((KtBinaryExpression)parent2).getLeft();
                        if (ktExpression != null) {
                            if (PsiUtilsKt.isNull((KtExpression)ktExpression)) {
                                return true;
                            }
                            bl5 = false;
                        } else {
                            bl5 = false;
                        }
                        if (bl5) return true;
                        KtExpression ktExpression2 = ((KtBinaryExpression)parent2).getRight();
                        if (ktExpression2 != null) {
                            if (PsiUtilsKt.isNull((KtExpression)ktExpression2)) {
                                return true;
                            }
                            bl = false;
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            return true;
                        }
                    }
                    if (!Intrinsics.areEqual((Object)KtDfaHelpersKt.toDfType(kotlinType = KtDfaHelpersKt.getKotlinType(expression2)), (Object)DfTypes.NULL)) break;
                    return true;
                }
            }
            if (expression2 instanceof KtSimpleNameExpression && (target2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)expression2)).resolve()) instanceof KtProperty && !((KtProperty)target2).isVar() && ((KtProperty)target2).getInitializer() instanceof KtConstantExpression) {
                return true;
            }
            if (!this.isCompilationWarning((KtElement)expression2)) return BindingContextUtilsKt.isUsedAsStatement((KtExpression)expression2, (BindingContext)ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.FULL));
            return true;
        }

        private static final int areEquivalent$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConstantValue.values().length];
                try {
                    nArray[ConstantValue.TRUE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValue.FALSE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValue.ZERO.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValue.NULL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstantValue.values().length];
            try {
                nArray[ConstantValue.TRUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantValue.FALSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantValue.NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantValue.ZERO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

